/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.bidi.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.ruiyun.jvppeteer.api.core.Keyboard;
import com.ruiyun.jvppeteer.bidi.core.BidiFrame;
import com.ruiyun.jvppeteer.bidi.core.BidiPage;
import com.ruiyun.jvppeteer.bidi.entities.InputId;
import com.ruiyun.jvppeteer.bidi.entities.SourceActions;
import com.ruiyun.jvppeteer.bidi.entities.SourceActionsType;
import com.ruiyun.jvppeteer.cdp.entities.KeyDownOptions;
import com.ruiyun.jvppeteer.cdp.entities.KeyPressOptions;
import com.ruiyun.jvppeteer.cdp.entities.KeyboardTypeOptions;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import java.util.ArrayList;
import java.util.Collections;

public class BidiKeyboard
extends Keyboard {
    private final BidiPage page;

    public BidiKeyboard(BidiPage page) {
        this.page = page;
    }

    @Override
    public void down(String key, KeyDownOptions options) {
        SourceActions sourceActions = new SourceActions();
        sourceActions.setType(SourceActionsType.Key);
        sourceActions.setId(InputId.Keyboard.getId());
        ArrayList<SourceActions> actions = new ArrayList<SourceActions>();
        SourceActions actions1 = new SourceActions();
        actions1.setType(SourceActionsType.KeyDown);
        actions1.setValue(BidiKeyboard.getBidiKeyValue(key));
        actions.add(actions1);
        sourceActions.setActions(actions);
        this.page.mainFrame().browsingContext.performActions(Collections.singletonList(sourceActions));
    }

    @Override
    public void up(String key) {
        SourceActions sourceActions = new SourceActions();
        sourceActions.setType(SourceActionsType.Key);
        sourceActions.setId(InputId.Keyboard.getId());
        ArrayList<SourceActions> actions = new ArrayList<SourceActions>();
        SourceActions actions1 = new SourceActions();
        actions1.setType(SourceActionsType.KeyUp);
        actions1.setValue(BidiKeyboard.getBidiKeyValue(key));
        actions.add(actions1);
        sourceActions.setActions(actions);
        this.page.mainFrame().browsingContext.performActions(Collections.singletonList(sourceActions));
    }

    @Override
    public void sendCharacter(String cha) throws JsonProcessingException {
        if (cha.length() > 1) {
            throw new JvppeteerException("Cannot send more than 1 character.");
        }
        BidiFrame frame = this.page.focusedFrame();
        frame.isolatedRealm().evaluate("async char => {\n      document.execCommand('insertText', false, char);\n    }", Collections.singletonList(cha));
    }

    @Override
    public void type(String text, KeyboardTypeOptions options) {
        ArrayList<String> values = new ArrayList<String>();
        for (char character : text.toCharArray()) {
            values.add(BidiKeyboard.getBidiKeyValue(String.valueOf(character)));
        }
        ArrayList<SourceActions> actions = new ArrayList<SourceActions>();
        if (options.getDelay() <= 0L) {
            for (String value : values) {
                SourceActions downActions = new SourceActions();
                downActions.setType(SourceActionsType.KeyDown);
                downActions.setValue(value);
                actions.add(downActions);
                SourceActions upActions = new SourceActions();
                upActions.setType(SourceActionsType.KeyUp);
                upActions.setValue(value);
                actions.add(upActions);
            }
        } else {
            for (String value : values) {
                SourceActions downActions = new SourceActions();
                downActions.setType(SourceActionsType.KeyDown);
                downActions.setValue(value);
                actions.add(downActions);
                SourceActions delayAction = new SourceActions();
                delayAction.setType(SourceActionsType.Pause);
                delayAction.setDuration(options.getDelay());
                actions.add(delayAction);
                SourceActions upActions = new SourceActions();
                upActions.setType(SourceActionsType.KeyUp);
                upActions.setValue(value);
                actions.add(upActions);
            }
        }
        SourceActions sourceActions = new SourceActions();
        sourceActions.setType(SourceActionsType.Key);
        sourceActions.setId(InputId.Keyboard.getId());
        sourceActions.setActions(actions);
        this.page.mainFrame().browsingContext.performActions(Collections.singletonList(sourceActions));
    }

    @Override
    public void press(String key, KeyPressOptions options) {
        ArrayList<SourceActions> actions = new ArrayList<SourceActions>();
        SourceActions downActions = new SourceActions();
        downActions.setType(SourceActionsType.KeyDown);
        downActions.setValue(BidiKeyboard.getBidiKeyValue(key));
        actions.add(downActions);
        if (options.getDelay() > 0L) {
            SourceActions delayAction = new SourceActions();
            delayAction.setType(SourceActionsType.Pause);
            delayAction.setDuration(options.getDelay());
            actions.add(delayAction);
        }
        SourceActions upActions = new SourceActions();
        upActions.setType(SourceActionsType.KeyUp);
        upActions.setValue(BidiKeyboard.getBidiKeyValue(key));
        actions.add(upActions);
        SourceActions sourceActions = new SourceActions();
        sourceActions.setType(SourceActionsType.Key);
        sourceActions.setId(InputId.Keyboard.getId());
        sourceActions.setActions(actions);
        this.page.mainFrame().browsingContext.performActions(Collections.singletonList(sourceActions));
    }

    public static String getBidiKeyValue(String key) {
        switch (key) {
            case "\r": 
            case "\n": {
                key = "Enter";
            }
        }
        if (key.codePoints().count() == 1L) {
            return key;
        }
        switch (key) {
            case "Cancel": {
                return "\ue001";
            }
            case "Help": {
                return "\ue002";
            }
            case "Backspace": {
                return "\ue003";
            }
            case "Tab": {
                return "\ue004";
            }
            case "Clear": {
                return "\ue005";
            }
            case "Enter": {
                return "\ue007";
            }
            case "Shift": 
            case "ShiftLeft": {
                return "\ue008";
            }
            case "Control": 
            case "ControlLeft": {
                return "\ue009";
            }
            case "Alt": 
            case "AltLeft": {
                return "\ue00a";
            }
            case "Pause": {
                return "\ue00b";
            }
            case "Escape": {
                return "\ue00c";
            }
            case "PageUp": {
                return "\ue00e";
            }
            case "PageDown": {
                return "\ue00f";
            }
            case "End": {
                return "\ue010";
            }
            case "Home": {
                return "\ue011";
            }
            case "ArrowLeft": {
                return "\ue012";
            }
            case "ArrowUp": {
                return "\ue013";
            }
            case "ArrowRight": {
                return "\ue014";
            }
            case "ArrowDown": {
                return "\ue015";
            }
            case "Insert": {
                return "\ue016";
            }
            case "Delete": {
                return "\ue017";
            }
            case "NumpadEqual": {
                return "\ue019";
            }
            case "Numpad0": {
                return "\ue01a";
            }
            case "Numpad1": {
                return "\ue01b";
            }
            case "Numpad2": {
                return "\ue01c";
            }
            case "Numpad3": {
                return "\ue01d";
            }
            case "Numpad4": {
                return "\ue01e";
            }
            case "Numpad5": {
                return "\ue01f";
            }
            case "Numpad6": {
                return "\ue020";
            }
            case "Numpad7": {
                return "\ue021";
            }
            case "Numpad8": {
                return "\ue022";
            }
            case "Numpad9": {
                return "\ue023";
            }
            case "NumpadMultiply": {
                return "\ue024";
            }
            case "NumpadAdd": {
                return "\ue025";
            }
            case "NumpadSubtract": {
                return "\ue027";
            }
            case "NumpadDecimal": {
                return "\ue028";
            }
            case "NumpadDivide": {
                return "\ue029";
            }
            case "F1": {
                return "\ue031";
            }
            case "F2": {
                return "\ue032";
            }
            case "F3": {
                return "\ue033";
            }
            case "F4": {
                return "\ue034";
            }
            case "F5": {
                return "\ue035";
            }
            case "F6": {
                return "\ue036";
            }
            case "F7": {
                return "\ue037";
            }
            case "F8": {
                return "\ue038";
            }
            case "F9": {
                return "\ue039";
            }
            case "F10": {
                return "\ue03a";
            }
            case "F11": {
                return "\ue03b";
            }
            case "F12": {
                return "\ue03c";
            }
            case "Meta": 
            case "MetaLeft": {
                return "\ue03d";
            }
            case "ShiftRight": {
                return "\ue050";
            }
            case "ControlRight": {
                return "\ue051";
            }
            case "AltRight": {
                return "\ue052";
            }
            case "MetaRight": {
                return "\ue053";
            }
            case "Digit0": {
                return "0";
            }
            case "Digit1": {
                return "1";
            }
            case "Digit2": {
                return "2";
            }
            case "Digit3": {
                return "3";
            }
            case "Digit4": {
                return "4";
            }
            case "Digit5": {
                return "5";
            }
            case "Digit6": {
                return "6";
            }
            case "Digit7": {
                return "7";
            }
            case "Digit8": {
                return "8";
            }
            case "Digit9": {
                return "9";
            }
            case "KeyA": {
                return "a";
            }
            case "KeyB": {
                return "b";
            }
            case "KeyC": {
                return "c";
            }
            case "KeyD": {
                return "d";
            }
            case "KeyE": {
                return "e";
            }
            case "KeyF": {
                return "f";
            }
            case "KeyG": {
                return "g";
            }
            case "KeyH": {
                return "h";
            }
            case "KeyI": {
                return "i";
            }
            case "KeyJ": {
                return "j";
            }
            case "KeyK": {
                return "k";
            }
            case "KeyL": {
                return "l";
            }
            case "KeyM": {
                return "m";
            }
            case "KeyN": {
                return "n";
            }
            case "KeyO": {
                return "o";
            }
            case "KeyP": {
                return "p";
            }
            case "KeyQ": {
                return "q";
            }
            case "KeyR": {
                return "r";
            }
            case "KeyS": {
                return "s";
            }
            case "KeyT": {
                return "t";
            }
            case "KeyU": {
                return "u";
            }
            case "KeyV": {
                return "v";
            }
            case "KeyW": {
                return "w";
            }
            case "KeyX": {
                return "x";
            }
            case "KeyY": {
                return "y";
            }
            case "KeyZ": {
                return "z";
            }
            case "Semicolon": {
                return ";";
            }
            case "Equal": {
                return "=";
            }
            case "Comma": {
                return ",";
            }
            case "Minus": {
                return "-";
            }
            case "Period": {
                return ".";
            }
            case "Slash": {
                return "/";
            }
            case "Backquote": {
                return "`";
            }
            case "BracketLeft": {
                return "[";
            }
            case "Backslash": {
                return "\\";
            }
            case "BracketRight": {
                return "]";
            }
            case "Quote": {
                return "\"";
            }
        }
        throw new JvppeteerException("Unknown key: \"" + key + "\"");
    }
}

