/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.bidi.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ruiyun.jvppeteer.api.core.CDPSession;
import com.ruiyun.jvppeteer.api.core.Connection;
import com.ruiyun.jvppeteer.api.core.EventEmitter;
import com.ruiyun.jvppeteer.api.events.ConnectionEvents;
import com.ruiyun.jvppeteer.bidi.core.BidiCdpSession;
import com.ruiyun.jvppeteer.cdp.entities.TargetInfo;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.exception.ProtocolException;
import com.ruiyun.jvppeteer.transport.Callback;
import com.ruiyun.jvppeteer.transport.CallbackRegistry;
import com.ruiyun.jvppeteer.transport.ConnectionTransport;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BidiConnection
extends Connection {
    private final List<EventEmitter<ConnectionEvents>> emitters = new ArrayList<EventEmitter<ConnectionEvents>>();

    public BidiConnection(String url, ConnectionTransport transport, int delay, int timeout) {
        super(url, transport, delay, timeout);
    }

    public static Connection fromSession(CDPSession session) {
        return session.connection();
    }

    @Override
    public JsonNode rawSend(String method, Object params, String sessionId, Integer timeout, boolean isBlocking) {
        ValidateUtil.assertArg(!this.closed, "Protocol error: Connection closed.");
        if (Objects.isNull(timeout)) {
            timeout = this.timeout;
        }
        Callback callback = new Callback(this.id.getAndIncrement(), method, timeout);
        return this.callbacks.create(callback, id -> {
            String stringifiedMessage;
            ObjectNode paramsNode = Constant.OBJECTMAPPER.createObjectNode();
            paramsNode.put("method", method);
            if (params != null) {
                paramsNode.putPOJO("params", params);
            }
            paramsNode.put("id", id);
            try {
                stringifiedMessage = Constant.OBJECTMAPPER.writeValueAsString((Object)paramsNode);
            }
            catch (JsonProcessingException e) {
                throw new JvppeteerException(e);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("jvppeteer:webDriverBiDi:SEND \u25ba {}", (Object)stringifiedMessage);
            }
            this.transport.send(stringifiedMessage);
        }, isBlocking);
    }

    @Override
    public void onMessage(String message) {
        try {
            JsonNode readTree;
            if (StringUtil.isEmpty(message)) {
                return;
            }
            if (this.delay > 0) {
                Helper.justWait(this.delay);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("jvppeteer:webDriverBiDi:RECV \u25c0{}", (Object)message);
            }
            if ((readTree = Constant.OBJECTMAPPER.readTree(message)).hasNonNull("id")) {
                long id = readTree.get("id").asLong();
                BidiConnection.handleCallback(this.callbacks, readTree, id, true);
            }
            this.handleMessageExecutorService.submit(this.handleMessageRunnable(readTree));
        }
        catch (Exception e) {
            LOGGER.error("jvppeteer error:", (Throwable)e);
        }
    }

    private static void handleCallback(CallbackRegistry callbacks, JsonNode response, long id, boolean handleListenerThread) {
        if (response.hasNonNull("error")) {
            callbacks.reject(id, BidiConnection.createProtocolError(response), response.hasNonNull("code") ? response.get("code").asInt() : 0, handleListenerThread);
        } else {
            callbacks.resolve(id, response, handleListenerThread);
        }
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public void dispose() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.handleMessageExecutorService.shutdown();
        this.callbacks.clear();
    }

    @Override
    public void onClose() {
        this.dispose();
        this.transport.close();
    }

    @Override
    public boolean closed() {
        return this.closed;
    }

    public void pipeTo(EventEmitter<ConnectionEvents> emitter) {
        this.emitters.add(emitter);
    }

    @Override
    public <T> void emit(ConnectionEvents event, T param) {
        for (EventEmitter<ConnectionEvents> emitter : this.emitters) {
            try {
                emitter.emit(event, param);
            }
            catch (Exception e) {
                LOGGER.error("jvppeteer error", (Throwable)e);
            }
        }
        super.emit(event, param);
    }

    @Override
    public List<ProtocolException> getPendingProtocolErrors() {
        return this.callbacks.getPendingProtocolErrors();
    }

    @Override
    public CDPSession session(String sessionId) {
        return BidiCdpSession.sessions.get(sessionId);
    }

    @Override
    public boolean isAutoAttached(String targetId) {
        throw new JvppeteerException("Not supported");
    }

    @Override
    public CDPSession _createSession(TargetInfo targetInfo, boolean isAutoAttachEmulated) {
        throw new JvppeteerException("Not supported");
    }

    private static String createProtocolError(JsonNode errorResponse) {
        String message = errorResponse.get("error").asText() + ", " + errorResponse.get("message").asText();
        if (errorResponse.hasNonNull("stacktrace")) {
            message = message + "\n" + errorResponse.get("stacktrace").asText();
        }
        return message;
    }

    @Override
    protected Runnable handleMessageRunnable(JsonNode response) {
        return () -> {
            try {
                if (response.hasNonNull("type")) {
                    switch (response.get("type").asText()) {
                        case "success": {
                            this.callbacks.resolve(response.get("id").asLong(), response, false);
                            return;
                        }
                        case "error": {
                            if (!response.hasNonNull("id")) break;
                            this.callbacks.reject(response.get("id").asLong(), BidiConnection.createProtocolError(response), 0, false);
                            return;
                        }
                        case "event": {
                            if (this.isCdpEvent(response)) {
                                String event;
                                boolean match;
                                BidiCdpSession session = (BidiCdpSession)this.session(response.at("/params/session").asText());
                                if (Objects.nonNull(session) && (match = Constant.EVENTS.contains(event = response.get("params").get("event").asText()))) {
                                    session.emit(ConnectionEvents.valueOf(event.replace(".", "_")), Objects.isNull(Constant.LISTENER_CLASSES.get(event)) ? Boolean.valueOf(true) : Constant.OBJECTMAPPER.treeToValue((TreeNode)response.get("params").get("params"), Constant.LISTENER_CLASSES.get(event)));
                                }
                                return;
                            }
                            String method = response.get("method").asText();
                            this.emit(ConnectionEvents.valueOf(method.replace(".", "_")), Objects.isNull(Constant.LISTENER_CLASSES.get(method)) ? Boolean.valueOf(true) : Constant.OBJECTMAPPER.treeToValue((TreeNode)response.get("params"), Constant.LISTENER_CLASSES.get(method)));
                            return;
                        }
                    }
                }
                if (response.hasNonNull("id")) {
                    this.callbacks.reject(response.get("id").asLong(), "Protocol Error. Message is not in BiDi protocol format: " + response.asText(), 0, false);
                }
                LOGGER.error("jvppeteer error: {}", (Object)response.asText());
            }
            catch (Exception e) {
                LOGGER.error("jvppeteer error: ", (Throwable)e);
            }
        };
    }

    private boolean isCdpEvent(JsonNode event) {
        return event.get("method").asText().startsWith("goog:cdp.");
    }
}

