/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.bidi.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.api.core.CDPSession;
import com.ruiyun.jvppeteer.api.core.Connection;
import com.ruiyun.jvppeteer.bidi.core.BidiFrame;
import com.ruiyun.jvppeteer.common.AwaitableResult;
import com.ruiyun.jvppeteer.common.ParamsFactory;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.transport.CdpConnection;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class BidiCdpSession
extends CDPSession {
    static Map<String, BidiCdpSession> sessions = new ConcurrentHashMap<String, BidiCdpSession>();
    final BidiFrame frame;
    private Connection connection;
    private volatile boolean detached;
    AwaitableResult<String> sessionIdResult = new AwaitableResult();

    public BidiCdpSession(BidiFrame frame, String sessionId) {
        Connection connection;
        this.frame = frame;
        if (!this.frame.page().browser().cdpSupported()) {
            return;
        }
        this.connection = connection = this.frame.page().browser().connection();
        if (StringUtil.isEmpty(sessionId)) {
            this.sessionIdResult.complete(sessionId);
            sessions.put(sessionId, this);
        } else {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("context", frame.id());
                JsonNode res = connection.send("goog:cdp.getSession", params);
                String session_id = res.get("result").get("session").asText();
                this.sessionIdResult.complete(session_id);
                sessions.put(session_id, this);
            }
            catch (Exception e) {
                this.sessionIdResult.complete("error " + e.getMessage());
            }
        }
    }

    @Override
    public CdpConnection connection() {
        return null;
    }

    @Override
    public boolean detached() {
        return this.detached;
    }

    @Override
    public String id() {
        String sessionId = this.sessionIdResult.get();
        if (StringUtil.isEmpty(sessionId) && !sessionId.startsWith("error ")) {
            return sessionId;
        }
        return "";
    }

    @Override
    public void detach() {
        if (Objects.isNull(this.connection) || this.connection.closed() || this.detached) {
            return;
        }
        Map<String, Object> params = ParamsFactory.create();
        params.put("sessionId", this.id());
        try {
            this.frame.client().send("Target.detachFromTarget", params);
        }
        finally {
            this.onClosed();
        }
    }

    @Override
    public void onClosed() {
        sessions.remove(this.sessionIdResult.get());
        this.detached = true;
    }

    @Override
    public JsonNode send(String method, Object params, Integer timeout, boolean isBlocking) {
        Objects.requireNonNull(this.connection, "CDP support is required for this feature. The current browser does not support CDP.");
        ValidateUtil.assertArg(!this.detached, "Protocol error (" + method + "): Session closed. Most likely the page has been closed.");
        String session_id = this.sessionIdResult.waitingGetResult();
        if (session_id.startsWith("error")) {
            throw new JvppeteerException(session_id.replace("error ", ""));
        }
        Map<String, Object> paramsMap = ParamsFactory.create();
        paramsMap.put("method", method);
        paramsMap.put("params", params);
        paramsMap.put("session", session_id);
        return this.connection.send("goog:cdp.sendCommand", paramsMap, timeout, true);
    }
}

