/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.api.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.ruiyun.jvppeteer.api.core.CDPSession;
import com.ruiyun.jvppeteer.api.core.JSHandle;
import com.ruiyun.jvppeteer.api.core.Realm;
import com.ruiyun.jvppeteer.common.TimeoutSettings;
import com.ruiyun.jvppeteer.exception.EvaluateException;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.util.Helper;
import java.util.List;

public abstract class WebWorker {
    public TimeoutSettings timeoutSettings = new TimeoutSettings();
    protected String url;

    public WebWorker(String url) {
        this.url = url;
    }

    public abstract Realm mainRealm();

    public String url() {
        return this.url;
    }

    public abstract CDPSession client();

    public Object evaluate(String pptrFunction) throws EvaluateException, JsonProcessingException {
        return this.evaluate(pptrFunction, null);
    }

    public JSHandle evaluateHandle(String pptrFunction) throws EvaluateException, JsonProcessingException {
        return this.evaluateHandle(pptrFunction, null);
    }

    public JSHandle evaluateHandle(String pptrFunction, List<Object> args) throws EvaluateException, JsonProcessingException {
        pptrFunction = Helper.withSourcePuppeteerURLIfNone("evaluateHandle", pptrFunction);
        return this.mainRealm().evaluateHandle(pptrFunction, args);
    }

    public Object evaluate(String pptrFunction, List<Object> args) throws EvaluateException, JsonProcessingException {
        pptrFunction = Helper.withSourcePuppeteerURLIfNone("evaluate", pptrFunction);
        return this.mainRealm().evaluate(pptrFunction, args);
    }

    public void close() throws EvaluateException, JsonProcessingException {
        throw new JvppeteerException("WebWorker.close() is not supported");
    }
}

