/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.api.core;

import com.ruiyun.jvppeteer.api.core.CDPSession;
import com.ruiyun.jvppeteer.api.core.Frame;
import com.ruiyun.jvppeteer.api.core.Response;
import com.ruiyun.jvppeteer.cdp.core.CdpResponse;
import com.ruiyun.jvppeteer.cdp.entities.ContinueRequestOverrides;
import com.ruiyun.jvppeteer.cdp.entities.ErrorReasons;
import com.ruiyun.jvppeteer.cdp.entities.HeaderEntry;
import com.ruiyun.jvppeteer.cdp.entities.Initiator;
import com.ruiyun.jvppeteer.cdp.entities.InterceptResolutionAction;
import com.ruiyun.jvppeteer.cdp.entities.InterceptResolutionState;
import com.ruiyun.jvppeteer.cdp.entities.Interception;
import com.ruiyun.jvppeteer.cdp.entities.ResourceType;
import com.ruiyun.jvppeteer.cdp.entities.ResponseForRequest;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.exception.ProtocolException;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Request {
    private static final Logger LOGGER = LoggerFactory.getLogger(Request.class);
    protected volatile String interceptionId;
    protected volatile String failureText;
    protected volatile CdpResponse response;
    protected volatile boolean fromMemoryCache;
    protected volatile List<Request> redirectChain;
    protected final Interception interception = new Interception();
    protected static final Map<Integer, String> STATUS_TEXTS = new HashMap<Integer, String>();

    public abstract CDPSession client();

    public abstract String id();

    public abstract String url();

    public ContinueRequestOverrides continueRequestOverrides() {
        ValidateUtil.assertArg(this.interception.getEnabled(), "Request Interception is not enabled!");
        return this.interception.getRequestOverrides();
    }

    public ResponseForRequest responseForRequest() {
        ValidateUtil.assertArg(this.interception.getEnabled(), "Request Interception is not enabled!");
        return this.interception.getResponse();
    }

    public ErrorReasons abortErrorReason() {
        ValidateUtil.assertArg(this.interception.getEnabled(), "Request Interception is not enabled!");
        return this.interception.getAbortReason();
    }

    public InterceptResolutionState interceptResolutionState() {
        InterceptResolutionState state = new InterceptResolutionState();
        if (!this.interception.getEnabled()) {
            state.setAction(InterceptResolutionAction.DISABLED);
            return state;
        }
        if (this.interception.getHandled()) {
            state.setAction(InterceptResolutionAction.ALREADY_HANDLED);
            return state;
        }
        return this.interception.getResolutionState();
    }

    public boolean isInterceptResolutionHandled() {
        return this.interception.getHandled();
    }

    public void enqueueInterceptAction(Runnable pendingHandler) {
        this.interception.getHandlers().add(pendingHandler);
    }

    protected abstract void _abort(ErrorReasons var1);

    public abstract void _respond(ResponseForRequest var1);

    public abstract void _continue(ContinueRequestOverrides var1);

    public void finalizeInterceptions() {
        this.interception.getHandlers().forEach(Runnable::run);
        this.interception.setHandlers(new ArrayList<Runnable>());
        InterceptResolutionAction action = this.interceptResolutionState().getAction();
        switch (action) {
            case ABORT: {
                this._abort(this.interception.getAbortReason());
                break;
            }
            case CONTINUE: {
                this._continue(this.interception.getRequestOverrides());
                break;
            }
            case RESPOND: {
                if (this.interception.getResponse() == null) {
                    throw new JvppeteerException("Response is missing for the interception");
                }
                this._respond(this.interception.getResponse());
            }
        }
    }

    public abstract ResourceType resourceType();

    public abstract String method();

    public abstract String postData();

    public abstract boolean hasPostData();

    public abstract String fetchPostData();

    public abstract List<HeaderEntry> headers();

    public abstract Response response();

    public abstract Frame frame();

    public abstract boolean isNavigationRequest();

    public abstract Initiator initiator();

    public abstract <T extends Request> List<T> redirectChain();

    public abstract String failure();

    protected boolean canBeIntercepted() {
        return !this.url().startsWith("data:") && !this.fromMemoryCache;
    }

    public void continueRequest() {
        this.continueRequest(new ContinueRequestOverrides(), null);
    }

    public void continueRequest(ContinueRequestOverrides overrides) {
        this.continueRequest(overrides, null);
    }

    public void continueRequest(ContinueRequestOverrides overrides, Integer priority) {
        if (!this.canBeIntercepted()) {
            return;
        }
        ValidateUtil.assertArg(this.interception.getEnabled(), "Request Interception is not enabled!");
        ValidateUtil.assertArg(!this.interception.getHandled(), "Request is already handled!");
        if (priority == null) {
            this._continue(overrides);
            return;
        }
        this.interception.setRequestOverrides(overrides);
        if (this.interception.getResolutionState().getPriority() == null || priority > this.interception.getResolutionState().getPriority()) {
            this.interception.setResolutionState(new InterceptResolutionState(InterceptResolutionAction.CONTINUE, priority));
            return;
        }
        if (priority.equals(this.interception.getResolutionState().getPriority())) {
            if (this.interception.getResolutionState().getAction() == InterceptResolutionAction.ABORT || this.interception.getResolutionState().getAction() == InterceptResolutionAction.RESPOND) {
                return;
            }
            this.interception.getResolutionState().setAction(InterceptResolutionAction.CONTINUE);
        }
    }

    public void respond(ResponseForRequest response) {
        this.respond(response, null);
    }

    public void respond(ResponseForRequest response, Integer priority) {
        if (!this.canBeIntercepted()) {
            return;
        }
        ValidateUtil.assertArg(this.interception.getEnabled(), "Request Interception is not enabled!");
        ValidateUtil.assertArg(!this.interception.getHandled(), "Request is already handled!");
        if (priority == null) {
            this._respond(response);
            return;
        }
        this.interception.setResponse(response);
        if (this.interception.getResolutionState().getPriority() == null || priority > this.interception.getResolutionState().getPriority()) {
            this.interception.setResolutionState(new InterceptResolutionState(InterceptResolutionAction.RESPOND, priority));
            return;
        }
        if (priority.equals(this.interception.getResolutionState().getPriority())) {
            if (this.interception.getResolutionState().getAction() == InterceptResolutionAction.ABORT) {
                return;
            }
            this.interception.getResolutionState().setAction(InterceptResolutionAction.RESPOND);
        }
    }

    public void abort() {
        this.abort(ErrorReasons.FAILED, null);
    }

    public void abort(ErrorReasons errorCode, Integer priority) {
        if (!this.canBeIntercepted()) {
            return;
        }
        ValidateUtil.assertArg(this.interception.getEnabled(), "Request Interception is not enabled!");
        ValidateUtil.assertArg(!this.interception.getHandled(), "Request is already handled!");
        if (priority == null) {
            this._abort(errorCode);
            return;
        }
        this.interception.setAbortReason(errorCode);
        if (this.interception.getResolutionState().getPriority() == null || priority >= this.interception.getResolutionState().getPriority()) {
            this.interception.setResolutionState(new InterceptResolutionState(InterceptResolutionAction.ABORT, priority));
        }
    }

    protected void handleError(Exception e) {
        if (e instanceof ProtocolException) {
            boolean flag;
            boolean bl = flag = e.getMessage().contains("Invalid header") || e.getMessage().contains("Unsafe header") || e.getMessage().contains("Expected \"header\"") || e.getMessage().contains("invalid argument");
            if (flag) {
                throw (ProtocolException)e;
            }
        }
        LOGGER.error("request error:", (Throwable)e);
    }

    public void setFromMemoryCache(boolean fromMemoryCache) {
        this.fromMemoryCache = fromMemoryCache;
    }

    static {
        STATUS_TEXTS.put(100, "Continue");
        STATUS_TEXTS.put(101, "Switching Protocols");
        STATUS_TEXTS.put(102, "Processing");
        STATUS_TEXTS.put(103, "Early Hints");
        STATUS_TEXTS.put(200, "OK");
        STATUS_TEXTS.put(201, "Created");
        STATUS_TEXTS.put(202, "Accepted");
        STATUS_TEXTS.put(203, "Non-Authoritative Information");
        STATUS_TEXTS.put(204, "No Content");
        STATUS_TEXTS.put(205, "Reset Content");
        STATUS_TEXTS.put(206, "Partial Content");
        STATUS_TEXTS.put(207, "Multi-Status");
        STATUS_TEXTS.put(208, "Already Reported");
        STATUS_TEXTS.put(226, "IM Used");
        STATUS_TEXTS.put(300, "Multiple Choices");
        STATUS_TEXTS.put(301, "Moved Permanently");
        STATUS_TEXTS.put(302, "Found");
        STATUS_TEXTS.put(303, "See Other");
        STATUS_TEXTS.put(304, "Not Modified");
        STATUS_TEXTS.put(305, "Use Proxy");
        STATUS_TEXTS.put(306, "Switch Proxy");
        STATUS_TEXTS.put(307, "Temporary Redirect");
        STATUS_TEXTS.put(308, "Permanent Redirect");
        STATUS_TEXTS.put(400, "Bad Request");
        STATUS_TEXTS.put(401, "Unauthorized");
        STATUS_TEXTS.put(402, "Payment Required");
        STATUS_TEXTS.put(403, "Forbidden");
        STATUS_TEXTS.put(404, "Not Found");
        STATUS_TEXTS.put(405, "Method Not Allowed");
        STATUS_TEXTS.put(406, "Not Acceptable");
        STATUS_TEXTS.put(407, "Proxy Authentication Required");
        STATUS_TEXTS.put(408, "Request Timeout");
        STATUS_TEXTS.put(409, "Conflict");
        STATUS_TEXTS.put(410, "Gone");
        STATUS_TEXTS.put(411, "Length Required");
        STATUS_TEXTS.put(412, "Precondition Failed");
        STATUS_TEXTS.put(413, "Payload Too Large");
        STATUS_TEXTS.put(414, "URI Too Long");
        STATUS_TEXTS.put(415, "Unsupported Media Type");
        STATUS_TEXTS.put(416, "Range Not Satisfiable");
        STATUS_TEXTS.put(417, "Expectation Failed");
        STATUS_TEXTS.put(418, "I'm a teapot");
        STATUS_TEXTS.put(421, "Misdirected Request");
        STATUS_TEXTS.put(422, "Unprocessable Entity");
        STATUS_TEXTS.put(423, "Locked");
        STATUS_TEXTS.put(424, "Failed Dependency");
        STATUS_TEXTS.put(425, "Too Early");
        STATUS_TEXTS.put(426, "Upgrade Required");
        STATUS_TEXTS.put(428, "Precondition Required");
        STATUS_TEXTS.put(429, "Too Many Requests");
        STATUS_TEXTS.put(431, "Request Header Fields Too Large");
        STATUS_TEXTS.put(451, "Unavailable For Legal Reasons");
        STATUS_TEXTS.put(500, "Internal Server Error");
        STATUS_TEXTS.put(501, "Not Implemented");
        STATUS_TEXTS.put(502, "Bad Gateway");
        STATUS_TEXTS.put(503, "Service Unavailable");
        STATUS_TEXTS.put(504, "Gateway Timeout");
        STATUS_TEXTS.put(505, "HTTP Version Not Supported");
        STATUS_TEXTS.put(506, "Variant Also Negotiates");
        STATUS_TEXTS.put(507, "Insufficient Storage");
        STATUS_TEXTS.put(508, "Loop Detected");
        STATUS_TEXTS.put(510, "Not Extended");
        STATUS_TEXTS.put(511, "Network Authentication Required");
    }
}

