/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.api.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.ruiyun.jvppeteer.api.core.Browser;
import com.ruiyun.jvppeteer.api.core.BrowserContext;
import com.ruiyun.jvppeteer.api.core.CDPSession;
import com.ruiyun.jvppeteer.api.core.ElementHandle;
import com.ruiyun.jvppeteer.api.core.EventEmitter;
import com.ruiyun.jvppeteer.api.core.Frame;
import com.ruiyun.jvppeteer.api.core.JSHandle;
import com.ruiyun.jvppeteer.api.core.Keyboard;
import com.ruiyun.jvppeteer.api.core.Mouse;
import com.ruiyun.jvppeteer.api.core.Request;
import com.ruiyun.jvppeteer.api.core.Response;
import com.ruiyun.jvppeteer.api.core.Target;
import com.ruiyun.jvppeteer.api.core.Touchscreen;
import com.ruiyun.jvppeteer.api.core.WebWorker;
import com.ruiyun.jvppeteer.api.events.ConnectionEvents;
import com.ruiyun.jvppeteer.api.events.PageEvents;
import com.ruiyun.jvppeteer.cdp.core.Accessibility;
import com.ruiyun.jvppeteer.cdp.core.Coverage;
import com.ruiyun.jvppeteer.cdp.core.FileChooser;
import com.ruiyun.jvppeteer.cdp.core.Tracing;
import com.ruiyun.jvppeteer.cdp.entities.BoundingBox;
import com.ruiyun.jvppeteer.cdp.entities.ClickOptions;
import com.ruiyun.jvppeteer.cdp.entities.Cookie;
import com.ruiyun.jvppeteer.cdp.entities.CookieParam;
import com.ruiyun.jvppeteer.cdp.entities.Credentials;
import com.ruiyun.jvppeteer.cdp.entities.DeleteCookiesRequest;
import com.ruiyun.jvppeteer.cdp.entities.Device;
import com.ruiyun.jvppeteer.cdp.entities.EvaluateType;
import com.ruiyun.jvppeteer.cdp.entities.FrameAddScriptTagOptions;
import com.ruiyun.jvppeteer.cdp.entities.FrameAddStyleTagOptions;
import com.ruiyun.jvppeteer.cdp.entities.GeolocationOptions;
import com.ruiyun.jvppeteer.cdp.entities.GoToOptions;
import com.ruiyun.jvppeteer.cdp.entities.IdleOverridesState;
import com.ruiyun.jvppeteer.cdp.entities.ImageType;
import com.ruiyun.jvppeteer.cdp.entities.LengthUnit;
import com.ruiyun.jvppeteer.cdp.entities.MediaFeature;
import com.ruiyun.jvppeteer.cdp.entities.Metrics;
import com.ruiyun.jvppeteer.cdp.entities.NetworkConditions;
import com.ruiyun.jvppeteer.cdp.entities.NewDocumentScriptEvaluation;
import com.ruiyun.jvppeteer.cdp.entities.PDFOptions;
import com.ruiyun.jvppeteer.cdp.entities.ScreenRecorderOptions;
import com.ruiyun.jvppeteer.cdp.entities.ScreencastOptions;
import com.ruiyun.jvppeteer.cdp.entities.ScreenshotClip;
import com.ruiyun.jvppeteer.cdp.entities.ScreenshotOptions;
import com.ruiyun.jvppeteer.cdp.entities.UserAgentMetadata;
import com.ruiyun.jvppeteer.cdp.entities.Viewport;
import com.ruiyun.jvppeteer.cdp.entities.VisionDeficiency;
import com.ruiyun.jvppeteer.cdp.entities.WaitForNetworkIdleOptions;
import com.ruiyun.jvppeteer.cdp.entities.WaitForOptions;
import com.ruiyun.jvppeteer.cdp.entities.WaitForSelectorOptions;
import com.ruiyun.jvppeteer.common.AwaitableResult;
import com.ruiyun.jvppeteer.common.BindingFunction;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.DeviceRequestPrompt;
import com.ruiyun.jvppeteer.common.MediaType;
import com.ruiyun.jvppeteer.common.ParamsFactory;
import com.ruiyun.jvppeteer.common.ScreenRecorder;
import com.ruiyun.jvppeteer.common.TimeoutSettings;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.exception.TargetCloseException;
import com.ruiyun.jvppeteer.exception.TimeoutException;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Page
extends EventEmitter<PageEvents> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(Page.class);
    public final TimeoutSettings _timeoutSettings = new TimeoutSettings();
    protected final Map<Consumer<Request>, Consumer<Request>> requestHandlers = new WeakHashMap<Consumer<Request>, Consumer<Request>>();
    protected boolean isDragging;
    protected List<String> inflight = new ArrayList<String>();
    AtomicLong screencastSessionCount = new AtomicLong(0L);
    private volatile boolean startScreencasted = false;
    private static final Map<String, Double> unitToPixels = new HashMap<String, Double>(){
        private static final long serialVersionUID = -4861220887908575532L;
        {
            this.put("px", 1.0);
            this.put("in", 96.0);
            this.put("cm", 37.8);
            this.put("mm", 3.78);
        }
    };

    public Page() {
        this.on(PageEvents.Request, (? request) -> this.inflight.add(request.id()));
        this.on(PageEvents.RequestFinished, (? request) -> this.inflight.remove(request.id()));
        this.on(PageEvents.RequestFailed, (? request) -> this.inflight.remove(request.id()));
        this.on(PageEvents.Response, (? response) -> this.inflight.remove(response.request().id()));
    }

    public abstract boolean isServiceWorkerBypassed();

    @Deprecated
    public abstract boolean isDragInterceptionEnabled();

    public abstract boolean isJavaScriptEnabled();

    @Override
    public EventEmitter<PageEvents> on(PageEvents type, Consumer<?> handler) {
        if (type != PageEvents.Request) {
            return super.on(type, handler);
        }
        Consumer<Request> wrapper = this.requestHandlers.get(handler);
        Consumer<?> handlerWrapper = handler;
        if (wrapper == null) {
            wrapper = event -> event.enqueueInterceptAction(() -> handlerWrapper.accept(event));
        }
        this.requestHandlers.put(handlerWrapper, wrapper);
        return super.on(type, wrapper);
    }

    @Override
    public void off(PageEvents type, Consumer<?> handler) {
        if (type == PageEvents.Request) {
            handler = this.requestHandlers.get(handler);
        }
        super.off(type, handler);
    }

    public abstract AwaitableResult<FileChooser> fileChooserWaitFor();

    public void setGeolocation(GeolocationOptions options) {
        if (options.getLongitude() < -180.0 || options.getLongitude() > 180.0) {
            throw new IllegalArgumentException("Invalid longitude " + options.getLongitude() + ": precondition -180 <= LONGITUDE <= 180 failed.");
        }
        if (options.getLatitude() < -90.0 || options.getLatitude() > 90.0) {
            throw new IllegalArgumentException("Invalid latitude " + options.getLatitude() + ": precondition -90 <= LATITUDE <= 90 failed.");
        }
        if (options.getAccuracy() < 0.0) {
            throw new IllegalArgumentException("Invalid accuracy " + options.getAccuracy() + ": precondition 0 <= ACCURACY failed.");
        }
    }

    public abstract Target target();

    public abstract Browser browser();

    public abstract BrowserContext browserContext();

    public abstract Frame mainFrame();

    public abstract CDPSession createCDPSession();

    public abstract Keyboard keyboard();

    public abstract Touchscreen touchscreen();

    public abstract Coverage coverage();

    public abstract Tracing tracing();

    public abstract Accessibility accessibility();

    public abstract <T extends Frame> List<T> frames();

    public abstract List<WebWorker> workers();

    public abstract void setRequestInterception(boolean var1);

    public abstract void setBypassServiceWorker(boolean var1);

    @Deprecated
    public abstract void setDragInterception(boolean var1);

    public abstract void setOfflineMode(boolean var1);

    public abstract void emulateNetworkConditions(NetworkConditions var1);

    public abstract void setDefaultNavigationTimeout(int var1);

    public abstract void setDefaultTimeout(int var1);

    public abstract int getDefaultTimeout();

    public abstract int getDefaultNavigationTimeout();

    public ElementHandle $(String selector) throws JsonProcessingException {
        return this.mainFrame().$(selector);
    }

    public List<ElementHandle> $$(String selector) throws JsonProcessingException {
        return this.mainFrame().$$(selector);
    }

    public JSHandle evaluateHandle(String pptrFunction, List<Object> args) throws JsonProcessingException {
        pptrFunction = Helper.withSourcePuppeteerURLIfNone("evaluateHandle", pptrFunction);
        return this.mainFrame().evaluateHandle(pptrFunction, args);
    }

    public JSHandle evaluateHandle(String pptrFunction) throws JsonProcessingException {
        return this.evaluateHandle(pptrFunction, null);
    }

    public abstract JSHandle queryObjects(JSHandle var1) throws JsonProcessingException;

    public Object $eval(String selector, String pptrFunction, List<Object> args) throws JsonProcessingException {
        pptrFunction = Helper.withSourcePuppeteerURLIfNone("$eval", pptrFunction);
        return this.mainFrame().$eval(selector, pptrFunction, args);
    }

    public Object $eval(String selector, String pptrFunction) throws JsonProcessingException {
        return this.$eval(selector, pptrFunction, null);
    }

    public Object $$eval(String selector, String pptrFunction) throws JsonProcessingException {
        return this.$$eval(selector, pptrFunction, new ArrayList<Object>());
    }

    public Object $$eval(String selector, String pptrFunction, List<Object> args) throws JsonProcessingException {
        pptrFunction = Helper.withSourcePuppeteerURLIfNone("$$eval", pptrFunction);
        return this.mainFrame().$$eval(selector, pptrFunction, args);
    }

    public List<Cookie> cookies() throws JsonProcessingException {
        return this.cookies(this.url());
    }

    public abstract List<Cookie> cookies(String ... var1);

    public void deleteCookie(String ... names) {
        ArrayList<DeleteCookiesRequest> cookies = new ArrayList<DeleteCookiesRequest>();
        for (String name : names) {
            cookies.add(new DeleteCookiesRequest(name));
        }
        this.deleteCookie(cookies.toArray(new DeleteCookiesRequest[0]));
    }

    public abstract void deleteCookie(DeleteCookiesRequest ... var1);

    public abstract void setCookie(CookieParam ... var1);

    public ElementHandle addScriptTag(FrameAddScriptTagOptions options) throws IOException {
        return this.mainFrame().addScriptTag(options);
    }

    public ElementHandle addStyleTag(FrameAddStyleTagOptions options) throws IOException {
        return this.mainFrame().addStyleTag(options);
    }

    public abstract void exposeFunction(String var1, BindingFunction var2) throws JsonProcessingException;

    public abstract void removeExposedFunction(String var1) throws JsonProcessingException;

    public abstract void authenticate(Credentials var1);

    public abstract void setExtraHTTPHeaders(Map<String, String> var1);

    public void setUserAgent(String userAgent) {
        this.setUserAgent(userAgent, null);
    }

    public abstract void setUserAgent(String var1, UserAgentMetadata var2);

    public abstract Metrics metrics() throws JsonProcessingException;

    public String url() {
        return this.mainFrame().url();
    }

    public String content() throws JsonProcessingException {
        return this.mainFrame().content();
    }

    public void setContent(String html) throws JsonProcessingException, InterruptedException, ExecutionException {
        this.setContent(html, new WaitForOptions());
    }

    public void setContent(String html, WaitForOptions options) throws JsonProcessingException, InterruptedException, ExecutionException {
        this.mainFrame().setContent(html, options);
    }

    public Response goTo(String url) throws ExecutionException, InterruptedException {
        return this.goTo(url, new GoToOptions());
    }

    public Response goTo(String url, GoToOptions options) throws ExecutionException, InterruptedException {
        return this.mainFrame().goTo(url, options);
    }

    public Response reload() {
        WaitForOptions options = new WaitForOptions();
        options.setIgnoreSameDocumentNavigation(true);
        return this.reload(options);
    }

    public abstract Response reload(WaitForOptions var1);

    public Response waitForNavigation() {
        return this.waitForNavigation(new WaitForOptions());
    }

    public Response waitForNavigation(WaitForOptions options, Runnable navigateRunner) {
        return this.mainFrame().waitForNavigation(options, navigateRunner);
    }

    public Response waitForNavigation(WaitForOptions options) {
        return this.waitForNavigation(options, null);
    }

    public Request waitForRequest(String url) {
        ValidateUtil.assertArg(StringUtil.isNotEmpty(url), "waitForRequest url must not be empty");
        return this.waitForRequest(url, null, this._timeoutSettings.timeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request waitForRequest(String url, Predicate<Request> predicate, Integer timeout) {
        if (Objects.isNull(timeout)) {
            timeout = this._timeoutSettings.timeout();
        }
        AwaitableResult result = AwaitableResult.create();
        Predicate<Request> requestPredicate = request -> {
            if (StringUtil.isNotEmpty(url)) {
                return url.equals(request.url());
            }
            if (predicate != null) {
                return predicate.test((Request)request);
            }
            return false;
        };
        AwaitableResult targetCloseException = AwaitableResult.create();
        Consumer<Object> targetCloseListener = ignore -> {
            targetCloseException.complete(new TargetCloseException("Page closed!"));
            result.complete();
        };
        this.once(PageEvents.Close, targetCloseListener);
        Consumer<Request> requestListener = request -> {
            if (requestPredicate.test((Request)request)) {
                result.complete(request);
            }
        };
        this.on(PageEvents.Request, requestListener);
        boolean waiting = result.waiting(timeout, TimeUnit.MILLISECONDS);
        if (!waiting) {
            throw new TimeoutException("WaitForRequest timeout of " + timeout + " ms exceeded");
        }
        try {
            if (targetCloseException.isDone() && Objects.nonNull(targetCloseException.get()) && Objects.isNull(result.get())) {
                throw (TargetCloseException)targetCloseException.get();
            }
            Request request2 = (Request)result.get();
            return request2;
        }
        finally {
            this.off(PageEvents.Request, requestListener);
            this.off(PageEvents.Close, targetCloseListener);
        }
    }

    public Response waitForResponse(Predicate<Response> predicate) {
        return this.waitForResponse(null, predicate);
    }

    public Response waitForResponse(String url) {
        return this.waitForResponse(url, null, this._timeoutSettings.timeout());
    }

    public Response waitForResponse(String url, Predicate<Response> predicate) {
        return this.waitForResponse(url, predicate, this._timeoutSettings.timeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response waitForResponse(String url, Predicate<Response> predicate, Integer timeout) {
        if (Objects.isNull(timeout)) {
            timeout = this._timeoutSettings.timeout();
        }
        Predicate<Response> waitForResponsePredicate = response -> {
            if (StringUtil.isNotEmpty(url)) {
                return url.equals(response.url());
            }
            if (predicate != null) {
                return predicate.test((Response)response);
            }
            return false;
        };
        AwaitableResult result = AwaitableResult.create();
        Consumer<Response> responseListener = response -> {
            if (waitForResponsePredicate.test((Response)response)) {
                result.complete(response);
            }
        };
        this.on(PageEvents.Response, responseListener);
        AwaitableResult targetCloseException = AwaitableResult.create();
        Consumer<Object> closeListener = ignore -> {
            targetCloseException.complete(new TargetCloseException("Page closed!"));
            result.complete();
        };
        this.once(PageEvents.Close, closeListener);
        try {
            boolean waiting = result.waiting(timeout, TimeUnit.MILLISECONDS);
            if (!waiting) {
                throw new TimeoutException("WaitForResponse timeout of " + timeout + " ms exceeded");
            }
            if (targetCloseException.isDone() && Objects.nonNull(targetCloseException.get()) && Objects.isNull(result.get())) {
                throw (TargetCloseException)targetCloseException.get();
            }
            Response response2 = (Response)result.get();
            return response2;
        }
        finally {
            this.off(PageEvents.Response, responseListener);
            this.off(PageEvents.Close, closeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForNetworkIdle(WaitForNetworkIdleOptions options) {
        AwaitableResult closeResult = new AwaitableResult();
        Consumer<Object> closeConsumer = ignore -> closeResult.complete(true);
        try {
            Integer timeout = options.getTimeout();
            if (Objects.isNull(timeout)) {
                timeout = this._timeoutSettings.timeout();
            }
            this.on(PageEvents.Close, closeConsumer);
            if (timeout == 0) {
                while (!closeResult.isDone() && this.inflight.size() > options.getConcurrency()) {
                }
                return;
            }
            Supplier<Boolean> conditionCheck = () -> {
                if (closeResult.isDone() || this.inflight.size() <= options.getConcurrency()) {
                    return true;
                }
                Helper.justWait(options.getIdleTime());
                return null;
            };
            Helper.waitForCondition(conditionCheck, timeout.intValue(), "WaitForNetworkIdle timeout of " + timeout + " ms exceeded");
        }
        finally {
            this.inflight.clear();
            this.off(PageEvents.Close, closeConsumer);
        }
    }

    public Frame waitForFrame(String url) {
        return this.waitForFrame(url, null, 30000);
    }

    public Frame waitForFrame(Predicate<Frame> framePredicate) {
        return this.waitForFrame(null, framePredicate, 30000);
    }

    public Frame waitForFrame(String url, Predicate<Frame> framePredicate, int timeout) {
        if (timeout <= 0) {
            timeout = this._timeoutSettings.timeout();
        }
        Predicate<Frame> predicate = frame -> {
            if (StringUtil.isNotEmpty(url)) {
                return url.equals(frame.url());
            }
            if (framePredicate != null) {
                return framePredicate.test((Frame)frame);
            }
            return false;
        };
        AtomicReference targetCloseException = new AtomicReference();
        this.once(PageEvents.Close, s -> targetCloseException.set(new TargetCloseException("Page closed!")));
        Supplier<Frame> conditionChecker = () -> {
            if (targetCloseException.get() != null) {
                throw (TargetCloseException)targetCloseException.get();
            }
            return (Frame)Helper.filter(this.frames(), predicate);
        };
        return Helper.waitForCondition(conditionChecker, timeout, "WaitForFrame timeout of " + timeout + " ms exceeded");
    }

    public Response goBack() throws JsonProcessingException {
        return this.goBack(new WaitForOptions());
    }

    public abstract Response goBack(WaitForOptions var1) throws JsonProcessingException;

    public Response goForward() throws JsonProcessingException {
        return this.goForward(new WaitForOptions());
    }

    public abstract Response goForward(WaitForOptions var1) throws JsonProcessingException;

    public abstract void bringToFront();

    public void emulate(Device device) throws ExecutionException, InterruptedException {
        this.setUserAgent(device.getUserAgent());
        this.setViewport(device.getViewport());
    }

    public abstract void setJavaScriptEnabled(boolean var1);

    public abstract void setBypassCSP(boolean var1);

    public abstract void emulateMediaType(MediaType var1);

    public abstract void emulateCPUThrottling(double var1);

    public abstract void emulateMediaFeatures(List<MediaFeature> var1);

    public abstract void emulateTimezone(String var1);

    public abstract void emulateIdleState(IdleOverridesState.Overrides var1);

    public abstract void emulateVisionDeficiency(VisionDeficiency var1);

    public abstract void setViewport(Viewport var1) throws ExecutionException, InterruptedException;

    public abstract Viewport viewport();

    public Object evaluate(String pptrFunction, Object ... args) throws JsonProcessingException {
        pptrFunction = Helper.withSourcePuppeteerURLIfNone("evaluate", pptrFunction);
        if (Objects.isNull(args)) {
            return this.mainFrame().evaluate(pptrFunction);
        }
        return this.mainFrame().evaluate(pptrFunction, Arrays.asList(args));
    }

    public NewDocumentScriptEvaluation evaluateOnNewDocument(String pptrFunction, Object ... args) throws JsonProcessingException {
        return this.evaluateOnNewDocument(pptrFunction, null, args);
    }

    public abstract NewDocumentScriptEvaluation evaluateOnNewDocument(String var1, EvaluateType var2, Object ... var3) throws JsonProcessingException;

    public abstract void removeScriptToEvaluateOnNewDocument(String var1);

    public abstract void setCacheEnabled(boolean var1);

    public ScreenRecorder screencast(ScreencastOptions options) throws IOException, ExecutionException, InterruptedException {
        ValidateUtil.assertArg(StringUtil.isNotBlank(options.getPath()), "Path must be specified");
        if (options.getFormat() != null) {
            ValidateUtil.assertArg(options.getPath().endsWith(options.getFormat().getFormat()), "Extension of Path (" + options.getPath() + ")+ has to match the used output format (" + options.getFormat().getFormat() + ").");
        }
        Viewport defaultViewport = this.viewport();
        Viewport tempViewport = null;
        if (defaultViewport != null && defaultViewport.getDeviceScaleFactor() != 0.0) {
            tempViewport = new Viewport(defaultViewport.getWidth(), defaultViewport.getHeight(), 0.0, defaultViewport.getIsMobile(), defaultViewport.getHasTouch(), defaultViewport.getIsLandscape());
            this.setViewport(tempViewport);
        }
        ArrayList response = (ArrayList)this.mainFrame().isolatedRealm().evaluate("() => {\n                    return [\n                      window.visualViewport.width * window.devicePixelRatio,\n                      window.visualViewport.height * window.devicePixelRatio,\n                      window.devicePixelRatio,\n                    ]\n                }", null);
        double width = Double.parseDouble(response.get(0) + "");
        double height = Double.parseDouble(response.get(1) + "");
        double devicePixelRatio = Double.parseDouble(response.get(2) + "");
        BoundingBox crop = null;
        if (Objects.nonNull(options.getCrop())) {
            ScreenshotClip boundingBox = this.roundRectangle(this.normalizeRectangle(new ScreenshotClip(options.getCrop().getX(), options.getCrop().getY(), options.getCrop().getWidth(), options.getCrop().getHeight())));
            if (boundingBox.getX() < 0.0 || boundingBox.getY() < 0.0) {
                throw new JvppeteerException("crop.x and crop.y must be greater than or equal to 0.");
            }
            if (boundingBox.getWidth() <= 0.0 || boundingBox.getHeight() <= 0.0) {
                throw new JvppeteerException("crop.width and crop.height must be greater than 0.");
            }
            double viewportWidth = width / devicePixelRatio;
            double viewportHeight = height / devicePixelRatio;
            if (boundingBox.getX() + boundingBox.getWidth() > viewportWidth) {
                throw new JvppeteerException("crop.width cannot be larger than the viewport width(" + viewportWidth + ")");
            }
            if (boundingBox.getY() + boundingBox.getHeight() > viewportHeight) {
                throw new JvppeteerException("crop.height cannot be larger than the viewport width(" + viewportHeight + ")");
            }
            crop = new BoundingBox(boundingBox.getX() * devicePixelRatio, boundingBox.getY() * devicePixelRatio, boundingBox.getWidth() * devicePixelRatio, boundingBox.getHeight() * devicePixelRatio);
        }
        if (options.getSpeed() <= 0.0) {
            throw new JvppeteerException("speed must be greater than 0.");
        }
        if (options.getScale() <= 0.0) {
            throw new JvppeteerException("scale must be greater than 0.");
        }
        ScreenRecorder recorder = new ScreenRecorder(this, width, height, new ScreenRecorderOptions(options.getSpeed(), crop, options.getPath(), options.getFormat(), options.getScale(), options.getFfmpegPath(), options.getFps(), options.getLoop(), options.getDelay(), options.getQuality(), options.getColors()), defaultViewport, tempViewport);
        try {
            this.startScreencast();
        }
        catch (Exception e) {
            recorder.stop();
            LOGGER.error("startScreencast error: ", (Throwable)e);
            return null;
        }
        return recorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startScreencast() {
        this.screencastSessionCount.incrementAndGet();
        if (!this.startScreencasted) {
            Page page = this;
            synchronized (page) {
                if (!this.startScreencasted) {
                    AwaitableResult awaitableResult = AwaitableResult.create();
                    this.mainFrame().client().on(ConnectionEvents.Page_screencastFrame, (? event) -> awaitableResult.complete());
                    Map<String, Object> params = ParamsFactory.create();
                    params.put("format", "png");
                    this.mainFrame().client().send("Page.startScreencast", params);
                    awaitableResult.waiting();
                    this.startScreencasted = true;
                }
            }
        }
    }

    public void stopScreencast() {
        long count = this.screencastSessionCount.decrementAndGet();
        if (!this.startScreencasted) {
            return;
        }
        this.startScreencasted = false;
        if (count == 0L) {
            this.mainFrame().client().send("Page.stopScreencast");
        }
    }

    protected ScreenshotClip roundRectangle(ScreenshotClip clip) {
        double x = Math.round(clip.getX());
        double y = Math.round(clip.getY());
        double width = Math.round(clip.getWidth() + clip.getX() - x);
        double height = Math.round(clip.getHeight() + clip.getY() - y);
        ScreenshotClip screenshotClip = new ScreenshotClip(x, y, width, height);
        screenshotClip.setScale(clip.getScale());
        return screenshotClip;
    }

    protected ScreenshotClip normalizeRectangle(ScreenshotClip clip) {
        double height;
        double y;
        double width;
        double x;
        if (clip.getWidth() < 0.0) {
            x = clip.getX() + clip.getWidth();
            width = -clip.getWidth();
        } else {
            x = clip.getX();
            width = clip.getWidth();
        }
        if (clip.getHeight() < 0.0) {
            y = clip.getY() + clip.getHeight();
            height = -clip.getHeight();
        } else {
            y = clip.getY();
            height = clip.getHeight();
        }
        ScreenshotClip copy = clip.copy(x, y, width, height);
        copy.setScale(clip.getScale());
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String screenshot(ScreenshotOptions options) throws ExecutionException, InterruptedException {
        BrowserContext browserContext = this.browserContext();
        synchronized (browserContext) {
            if (StringUtil.isNotEmpty(options.getPath())) {
                String filePath = options.getPath();
                String path = filePath.substring(0, filePath.lastIndexOf(46) + 1);
                options.setPath(path + options.getType().toString());
            }
            if (options.getType().equals((Object)ImageType.JPG)) {
                options.setType(ImageType.JPEG);
            }
            if (options.getQuality() != null) {
                ValidateUtil.assertArg(options.getQuality() > 0.0 && options.getQuality() <= 100.0, "Expected quality (" + options.getQuality() + ") to be between 0 and 100 ,inclusive).");
                ValidateUtil.assertArg(Arrays.asList("jpeg", "webp").contains(options.getType().name().toLowerCase()), options.getType().toString() + "screenshots do not support quality.");
            }
            if (options.getClip() != null) {
                ValidateUtil.assertArg(options.getClip().getWidth() > 0.0, "'width' in 'clip' must be positive.");
                ValidateUtil.assertArg(options.getClip().getHeight() > 0.0, "'height' in 'clip' must be positive.");
            }
            Viewport fullViewport = null;
            try {
                Object response;
                if (options.getClip() != null) {
                    ValidateUtil.assertArg(!options.getFullPage(), "'clip' and 'fullPage' are mutually exclusive");
                    options.setClip(this.roundRectangle(this.normalizeRectangle(options.getClip())));
                } else if (options.getFullPage()) {
                    if (!options.getCaptureBeyondViewport()) {
                        response = this.mainFrame().isolatedRealm().evaluate("() => {\n              const element = document.documentElement;\n              return {\n                width: element.scrollWidth,\n                height: element.scrollHeight,\n              };\n            }");
                        BoundingBox scrollDimensions = (BoundingBox)Constant.OBJECTMAPPER.convertValue(response, BoundingBox.class);
                        fullViewport = new Viewport((int)scrollDimensions.getWidth(), (int)scrollDimensions.getHeight(), this.viewport().getDeviceScaleFactor(), this.viewport().getIsMobile(), this.viewport().getHasTouch(), this.viewport().getIsLandscape());
                        this.setViewport(fullViewport);
                    }
                } else {
                    options.setCaptureBeyondViewport(false);
                }
                response = this._screenshot(options);
                return response;
            }
            catch (Exception e) {
                LOGGER.error("_screenshot error: ", (Throwable)e);
            }
            finally {
                if (fullViewport != null) {
                    this.setViewport(this.viewport());
                }
            }
            return "";
        }
    }

    public String screenshot(String path) throws ExecutionException, InterruptedException {
        return this.screenshot(new ScreenshotOptions(path));
    }

    protected abstract String _screenshot(ScreenshotOptions var1) throws IOException;

    public byte[] pdf(PDFOptions options) throws IOException {
        return this.pdf(options, LengthUnit.IN);
    }

    public void pdf(String path) throws IOException {
        this.pdf(new PDFOptions(path), LengthUnit.IN);
    }

    public abstract byte[] pdf(PDFOptions var1, LengthUnit var2) throws IOException;

    public String title() throws JsonProcessingException {
        return this.mainFrame().title();
    }

    public abstract boolean isClosed();

    public abstract Mouse mouse();

    public void click(String selector) throws JsonProcessingException {
        this.click(selector, new ClickOptions());
    }

    public void click(String selector, ClickOptions options) throws JsonProcessingException {
        this.mainFrame().click(selector, options);
    }

    public void focus(String selector) throws JsonProcessingException {
        this.mainFrame().focus(selector);
    }

    public void hover(String selector) throws JsonProcessingException {
        this.mainFrame().hover(selector);
    }

    public List<String> select(String selector, List<String> values) throws JsonProcessingException {
        return this.mainFrame().select(selector, values);
    }

    public void tap(String selector) throws JsonProcessingException {
        this.mainFrame().tap(selector);
    }

    public void type(String selector, String text) throws JsonProcessingException {
        this.mainFrame().type(selector, text, 0L);
    }

    public void type(String selector, String text, long delay) throws JsonProcessingException {
        this.mainFrame().type(selector, text, delay);
    }

    public ElementHandle waitForSelector(String selector) throws JsonProcessingException {
        return this.waitForSelector(selector, new WaitForSelectorOptions());
    }

    public ElementHandle waitForSelector(String selector, WaitForSelectorOptions options) throws JsonProcessingException {
        return this.mainFrame().waitForSelector(selector, options);
    }

    public JSHandle waitForFunction(String pptrFunction) throws ExecutionException, InterruptedException, java.util.concurrent.TimeoutException {
        return this.waitForFunction(pptrFunction, new WaitForSelectorOptions(), new Object[0]);
    }

    public JSHandle waitForFunction(String pptrFunction, Object ... args) throws ExecutionException, InterruptedException, java.util.concurrent.TimeoutException {
        return this.waitForFunction(pptrFunction, new WaitForSelectorOptions(), args);
    }

    public JSHandle waitForFunction(String pptrFunction, WaitForSelectorOptions options, Object ... args) throws ExecutionException, InterruptedException, java.util.concurrent.TimeoutException {
        return this.waitForFunction(pptrFunction, options, Helper.isFunction(pptrFunction) ? EvaluateType.FUNCTION : EvaluateType.STRING, args);
    }

    public JSHandle waitForFunction(String pptrFunction, WaitForSelectorOptions options, EvaluateType type, Object ... args) throws ExecutionException, InterruptedException, java.util.concurrent.TimeoutException {
        return this.mainFrame().waitForFunction(pptrFunction, options, type, args);
    }

    public DeviceRequestPrompt waitForDevicePrompt() {
        return this.waitForDevicePrompt(this._timeoutSettings.timeout());
    }

    public DeviceRequestPrompt waitForDevicePrompt(int timeout) {
        return this.mainFrame().waitForDevicePrompt(timeout);
    }

    public void close() {
        this.close(false);
    }

    public abstract void close(boolean var1);

    public void setDragging(boolean dragging) {
        this.isDragging = dragging;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    protected Double convertPrintParameterToInches(String parameter, LengthUnit lengthUnit) {
        double pixels;
        if (StringUtil.isEmpty(parameter)) {
            return null;
        }
        if (Helper.isNumber(parameter)) {
            pixels = Double.parseDouble(parameter);
        } else if (parameter.endsWith("px") || parameter.endsWith("in") || parameter.endsWith("cm") || parameter.endsWith("mm")) {
            String valueText;
            String unit = parameter.substring(parameter.length() - 2).toLowerCase();
            if (unitToPixels.containsKey(unit)) {
                valueText = parameter.substring(0, parameter.length() - 2);
            } else {
                unit = "px";
                valueText = parameter;
            }
            double value = Double.parseDouble(valueText);
            ValidateUtil.assertArg(!Double.isNaN(value), "Failed to parse parameter value: " + parameter);
            pixels = value * unitToPixels.get(unit);
        } else {
            throw new IllegalArgumentException("page.pdf() Cannot handle parameter type: " + parameter);
        }
        return pixels / unitToPixels.get(lengthUnit.getValue());
    }
}

