/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.api.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.ruiyun.jvppeteer.api.core.ElementHandle;
import com.ruiyun.jvppeteer.api.core.Realm;
import com.ruiyun.jvppeteer.cdp.entities.RemoteObject;
import com.ruiyun.jvppeteer.exception.EvaluateException;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class JSHandle {
    public abstract Realm realm();

    public abstract boolean disposed();

    public Object evaluate(String pptrFunction) throws JsonProcessingException, EvaluateException {
        return this.evaluate(pptrFunction, null);
    }

    public Object evaluate(String pptrFunction, List<Object> args) throws JsonProcessingException, EvaluateException {
        pptrFunction = Helper.withSourcePuppeteerURLIfNone("evaluate", pptrFunction);
        ArrayList<Object> argsArray = new ArrayList<Object>();
        argsArray.add(this);
        if (Objects.nonNull(args)) {
            argsArray.addAll(args);
        }
        return this.realm().evaluate(pptrFunction, argsArray);
    }

    public JSHandle evaluateHandle(String pptrFunction) throws JsonProcessingException, EvaluateException {
        return this.evaluateHandle(pptrFunction, null);
    }

    public JSHandle evaluateHandle(String pptrFunction, List<Object> args) throws JsonProcessingException, EvaluateException {
        pptrFunction = Helper.withSourcePuppeteerURLIfNone("evaluateHandle", pptrFunction);
        ArrayList<Object> argsArray = new ArrayList<Object>();
        argsArray.add(this);
        if (ValidateUtil.isNotEmpty(args)) {
            argsArray.addAll(args);
        }
        return this.realm().evaluateHandle(pptrFunction, argsArray);
    }

    public JSHandle getProperty(String propertyName) throws JsonProcessingException, EvaluateException {
        String pptrFunction = "(object, propertyName) => {\n      return object[propertyName];\n    }";
        return this.evaluateHandle(pptrFunction, Collections.singletonList(propertyName));
    }

    public Map<String, JSHandle> getProperties() throws JsonProcessingException {
        List propertyNames = (List)this.evaluate("object => {\n      const enumerableProperties = [];\n      const descriptors = Object.getOwnPropertyDescriptors(object);\n      for (const propertyName in descriptors) {\n        if (descriptors[propertyName]?.enumerable) {\n          enumerableProperties.push(propertyName);\n        }\n      }\n      return enumerableProperties;\n    }");
        LinkedHashMap<String, JSHandle> map = new LinkedHashMap<String, JSHandle>(propertyNames.size());
        for (String propertyName : propertyNames) {
            JSHandle handle = this.getProperty(propertyName);
            if (!Objects.nonNull(handle)) continue;
            map.put(propertyName, handle);
        }
        return map;
    }

    public abstract Object jsonValue() throws JsonProcessingException;

    public abstract ElementHandle asElement();

    public abstract void dispose();

    public abstract String toString();

    public abstract String id();

    public abstract RemoteObject remoteObject();
}

