/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.api.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.api.core.Frame;
import com.ruiyun.jvppeteer.api.core.JSHandle;
import com.ruiyun.jvppeteer.api.core.Page;
import com.ruiyun.jvppeteer.bidi.entities.PrintMarginParameters;
import com.ruiyun.jvppeteer.cdp.entities.AutofillData;
import com.ruiyun.jvppeteer.cdp.entities.BoundingBox;
import com.ruiyun.jvppeteer.cdp.entities.BoxModel;
import com.ruiyun.jvppeteer.cdp.entities.ClickOptions;
import com.ruiyun.jvppeteer.cdp.entities.DragData;
import com.ruiyun.jvppeteer.cdp.entities.ElementScreenshotOptions;
import com.ruiyun.jvppeteer.cdp.entities.KeyPressOptions;
import com.ruiyun.jvppeteer.cdp.entities.KeyboardTypeOptions;
import com.ruiyun.jvppeteer.cdp.entities.Offset;
import com.ruiyun.jvppeteer.cdp.entities.Point;
import com.ruiyun.jvppeteer.cdp.entities.RemoteObject;
import com.ruiyun.jvppeteer.cdp.entities.ScreenshotClip;
import com.ruiyun.jvppeteer.cdp.entities.WaitForSelectorOptions;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.LazyArg;
import com.ruiyun.jvppeteer.common.QuerySelector;
import com.ruiyun.jvppeteer.exception.EvaluateException;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.util.GetQueryHandler;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ElementHandle
extends JSHandle {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ElementHandle.class);
    protected volatile ElementHandle isolatedHandle;
    protected final JSHandle handle;

    public ElementHandle(JSHandle handle) {
        this.handle = handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ElementHandle adoptIsolatedHandle() throws JsonProcessingException {
        if (this.realm() == this.frame().isolatedRealm()) {
            return this;
        }
        if (this.isolatedHandle == null) {
            ElementHandle elementHandle = this;
            synchronized (elementHandle) {
                if (this.isolatedHandle == null) {
                    this.isolatedHandle = this.frame().isolatedRealm().adoptHandle(this).asElement();
                }
            }
        }
        return this.isolatedHandle;
    }

    public <T> T adoptResult(T isolatedResult) throws JsonProcessingException {
        if (isolatedResult == null) {
            return null;
        }
        if (isolatedResult == this.isolatedHandle) {
            return (T)this;
        }
        if (isolatedResult instanceof JSHandle) {
            return (T)this.realm().transferHandle((JSHandle)isolatedResult);
        }
        if (isolatedResult.getClass().isArray()) {
            Object[] resultArray = new Object[Array.getLength(isolatedResult)];
            for (int i = 0; i < Array.getLength(isolatedResult); ++i) {
                Object item = Array.get(isolatedResult, i);
                if (item instanceof JSHandle) {
                    try {
                        resultArray[i] = this.realm().transferHandle((JSHandle)item);
                    }
                    catch (JsonProcessingException e) {
                        resultArray[i] = item;
                    }
                    continue;
                }
                resultArray[i] = item;
            }
            return (T)resultArray;
        }
        if (isolatedResult instanceof Collection) {
            ArrayList<JSHandle> resultList = new ArrayList<JSHandle>();
            for (Object item : (Collection)isolatedResult) {
                if (item instanceof JSHandle) {
                    try {
                        resultList.add(this.realm().transferHandle((JSHandle)item));
                    }
                    catch (JsonProcessingException e) {
                        resultList.add((JSHandle)item);
                    }
                    continue;
                }
                resultList.add((JSHandle)item);
            }
            return (T)resultList;
        }
        if (isolatedResult instanceof Map) {
            HashMap resultMap = new HashMap();
            for (Map.Entry entry : ((Map)isolatedResult).entrySet()) {
                Object value = entry.getValue();
                if (value instanceof JSHandle) {
                    try {
                        value = this.realm().transferHandle((JSHandle)value);
                    }
                    catch (JsonProcessingException e) {
                        LOGGER.error("jvppeteer error: ", (Throwable)e);
                    }
                }
                resultMap.put(entry.getKey(), value);
            }
            return (T)resultMap;
        }
        return isolatedResult;
    }

    @Override
    public String id() {
        return this.handle.id();
    }

    @Override
    public boolean disposed() {
        return this.handle.disposed();
    }

    @Override
    public JSHandle getProperty(String propertyName) throws JsonProcessingException, EvaluateException {
        return this.adoptResult(this.adoptIsolatedHandle().handle().getProperty(propertyName));
    }

    @Override
    public Map<String, JSHandle> getProperties() throws JsonProcessingException {
        return this.adoptResult(this.adoptIsolatedHandle().handle().getProperties());
    }

    @Override
    public Object evaluate(String pptrFunction) throws JsonProcessingException, EvaluateException {
        return this.evaluate(pptrFunction, null);
    }

    @Override
    public Object evaluate(String pptrFunction, List<Object> args) throws JsonProcessingException, EvaluateException {
        pptrFunction = Helper.withSourcePuppeteerURLIfNone("evaluate", pptrFunction);
        return this.handle.evaluate(pptrFunction, args);
    }

    @Override
    public JSHandle evaluateHandle(String pptrFunction) throws JsonProcessingException, EvaluateException {
        return this.evaluateHandle(pptrFunction, null);
    }

    @Override
    public JSHandle evaluateHandle(String pptrFunction, List<Object> args) throws JsonProcessingException, EvaluateException {
        pptrFunction = Helper.withSourcePuppeteerURLIfNone("evaluateHandle", pptrFunction);
        return this.handle.evaluateHandle(pptrFunction, args);
    }

    @Override
    public Object jsonValue() throws JsonProcessingException, EvaluateException {
        return this.adoptResult(this.adoptIsolatedHandle().handle().jsonValue());
    }

    @Override
    public String toString() {
        return this.handle.toString();
    }

    @Override
    public RemoteObject remoteObject() {
        return this.handle.remoteObject();
    }

    @Override
    public void dispose() {
        this.handle.dispose();
        if (Objects.nonNull(this.isolatedHandle)) {
            this.isolatedHandle.dispose();
        }
    }

    @Override
    public ElementHandle asElement() {
        return this;
    }

    public abstract Frame frame();

    public ElementHandle $(String selector) throws JsonProcessingException, EvaluateException {
        QuerySelector queryHandlerAndSelector = GetQueryHandler.getQueryHandlerAndSelector(selector, this.frame());
        ElementHandle element = queryHandlerAndSelector.getQueryHandler().queryOne(this.adoptIsolatedHandle(), queryHandlerAndSelector.getUpdatedSelector());
        if (Objects.nonNull(element)) {
            return this.adoptResult(element);
        }
        return null;
    }

    public List<ElementHandle> $$(String selector) throws JsonProcessingException, EvaluateException {
        QuerySelector queryHandlerAndSelector = GetQueryHandler.getQueryHandlerAndSelector(selector, this.frame());
        return this.adoptResult(queryHandlerAndSelector.getQueryHandler().queryAll(this.adoptIsolatedHandle(), queryHandlerAndSelector.getUpdatedSelector()));
    }

    public Object $eval(String selector, String pptrFunction) throws JsonProcessingException, EvaluateException {
        return this.$eval(selector, pptrFunction, null);
    }

    public Object $eval(String selector, String pptrFunction, List<Object> args) throws JsonProcessingException, EvaluateException {
        pptrFunction = Helper.withSourcePuppeteerURLIfNone("$eval", pptrFunction);
        ElementHandle elementHandle = this.$(selector);
        if (elementHandle == null) {
            throw new JvppeteerException("Error: failed to find element matching selector " + selector);
        }
        Object result = elementHandle.evaluate(pptrFunction, args);
        elementHandle.dispose();
        return result;
    }

    public Object $$eval(String selector, String pptrFunction) throws JsonProcessingException, EvaluateException {
        return this.$$eval(selector, pptrFunction, null);
    }

    public Object $$eval(String selector, String pptrFunction, List<Object> args) throws JsonProcessingException, EvaluateException {
        pptrFunction = Helper.withSourcePuppeteerURLIfNone("$$eval", pptrFunction);
        List<ElementHandle> results = this.$$(selector);
        JSHandle elements = this.evaluateHandle("(_, ...elements) => {\n        return elements;\n      }", new ArrayList<Object>(results));
        Object result = elements.evaluate(pptrFunction, args);
        results.forEach(ElementHandle::dispose);
        elements.dispose();
        return result;
    }

    private boolean checkVisibility(boolean visibility) throws JsonProcessingException, EvaluateException {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(new LazyArg());
        args.add(visibility);
        return (Boolean)this.evaluate("async (element, PuppeteerUtil, visibility) => {\n        return Boolean(PuppeteerUtil.checkVisibility(element, visibility));\n      }", args);
    }

    public boolean isVisible() throws JsonProcessingException, EvaluateException {
        return this.adoptIsolatedHandle().checkVisibility(true);
    }

    public boolean isHidden() throws JsonProcessingException, EvaluateException {
        return this.adoptIsolatedHandle().checkVisibility(false);
    }

    public ElementHandle toElement(String tagName) throws JsonProcessingException, EvaluateException {
        boolean isMatchingTagName = (Boolean)this.adoptIsolatedHandle().evaluate("(node, tagName) => {\n      return node.nodeName === tagName.toUpperCase();\n    }", Collections.singletonList(tagName));
        if (!isMatchingTagName) {
            throw new JvppeteerException("Element is not a(n) " + tagName + " element");
        }
        return this;
    }

    public abstract Frame contentFrame() throws JsonProcessingException;

    public Point clickablePoint() throws JsonProcessingException, EvaluateException {
        return this.clickablePoint(null);
    }

    public Point clickablePoint(Offset offset) throws JsonProcessingException, EvaluateException {
        BoundingBox box = this.adoptIsolatedHandle().clickableBox();
        if (box == null) {
            throw new JvppeteerException("Node is either not clickable or not an Element");
        }
        if (offset != null) {
            return new Point(box.getX() + offset.getX(), box.getY() + offset.getY());
        }
        return new Point(box.getX() + box.getWidth() / 2.0, box.getY() + box.getHeight() / 2.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BoundingBox clickableBox() throws JsonProcessingException, EvaluateException {
        Frame parentFrame;
        Object boxes = this.evaluate("element => {\n      if (!(element instanceof Element)) {\n        return null;\n      }\n      return [...element.getClientRects()].map(rect => {\n        return {x: rect.x, y: rect.y, width: rect.width, height: rect.height};\n      });\n    }");
        if (boxes == null) {
            return null;
        }
        ArrayList boundingBoxes = (ArrayList)Constant.OBJECTMAPPER.readValue(Constant.OBJECTMAPPER.writeValueAsString(boxes), (TypeReference)new TypeReference<ArrayList<BoundingBox>>(){});
        if (boundingBoxes.isEmpty()) {
            return null;
        }
        this.intersectBoundingBoxesWithFrame(boundingBoxes);
        Frame frame = this.frame();
        while ((parentFrame = frame.parentFrame()) != null) {
            ElementHandle elementHandle = frame.frameElement();
            if (elementHandle == null) {
                throw new JvppeteerException("Unsupported frame type");
            }
            try {
                Object response = elementHandle.evaluate("element => {\n        // Element is not visible.\n        if (element.getClientRects().length === 0) {\n          return null;\n        }\n        const rect = element.getBoundingClientRect();\n        const style = window.getComputedStyle(element);\n        return {\n          left:\n            rect.left +\n            parseInt(style.paddingLeft, 10) +\n            parseInt(style.borderLeftWidth, 10),\n          top:\n            rect.top +\n            parseInt(style.paddingTop, 10) +\n            parseInt(style.borderTopWidth, 10),\n        };\n      }");
                if (response == null) {
                    BoundingBox boundingBox2 = null;
                    return boundingBox2;
                }
                PrintMarginParameters parentBox = (PrintMarginParameters)Constant.OBJECTMAPPER.convertValue(response, PrintMarginParameters.class);
                for (BoundingBox box2 : boundingBoxes) {
                    box2.setX(box2.getX() + parentBox.getLeft());
                    box2.setY(box2.getY() + parentBox.getTop());
                }
                elementHandle.intersectBoundingBoxesWithFrame(boundingBoxes);
                frame = parentFrame;
            }
            finally {
                elementHandle.dispose();
            }
        }
        Optional<BoundingBox> result = boundingBoxes.stream().filter(box -> box.getWidth() >= 1.0 && box.getHeight() >= 1.0).findFirst();
        return result.map(boundingBox -> new BoundingBox(boundingBox.getX(), boundingBox.getY(), boundingBox.getWidth(), boundingBox.getHeight())).orElse(null);
    }

    private void intersectBoundingBoxesWithFrame(List<BoundingBox> boundingBoxes) throws JsonProcessingException, EvaluateException {
        Object response = this.frame().isolatedRealm().evaluate("() => {\n        return {\n          documentWidth: document.documentElement.clientWidth,\n          documentHeight: document.documentElement.clientHeight,\n        };\n      }", null);
        JsonNode responseNode = Constant.OBJECTMAPPER.readTree(Constant.OBJECTMAPPER.writeValueAsString(response));
        for (BoundingBox box : boundingBoxes) {
            this.intersectBoundingBox(box, responseNode.get("documentWidth").asDouble(), responseNode.get("documentHeight").asDouble());
        }
    }

    private void intersectBoundingBox(BoundingBox box, double width, double height) {
        box.setWidth(Math.max(box.getX() >= 0.0 ? Math.min(width - box.getX(), box.getWidth()) : Math.min(width, box.getWidth() + box.getX()), 0.0));
        box.setHeight(Math.max(box.getY() >= 0.0 ? Math.min(height - box.getY(), box.getHeight()) : Math.min(height, box.getHeight() + box.getY()), 0.0));
    }

    public void hover() throws JsonProcessingException, EvaluateException {
        ElementHandle wrapThis = this.adoptIsolatedHandle();
        wrapThis.scrollIntoViewIfNeeded();
        Point clickablePoint = wrapThis.clickablePoint();
        wrapThis.frame().page().mouse().move(clickablePoint.getX(), clickablePoint.getY());
    }

    public void click() throws JsonProcessingException, EvaluateException {
        this.click(new ClickOptions());
    }

    public void click(ClickOptions options) throws JsonProcessingException, EvaluateException {
        ElementHandle wrapThis = this.adoptIsolatedHandle();
        wrapThis.scrollIntoViewIfNeeded();
        Point point = wrapThis.clickablePoint(options.getOffset());
        wrapThis.frame().page().mouse().click(point.getX(), point.getY(), options);
    }

    public DragData drag(ElementHandle target) throws JsonProcessingException {
        ElementHandle wrapThis = this.adoptIsolatedHandle();
        wrapThis.scrollIntoViewIfNeeded();
        Page page = wrapThis.frame().page();
        if (page.isDragInterceptionEnabled()) {
            Point source = wrapThis.clickablePoint();
            Point point = target.clickablePoint();
            return page.mouse().drag(source, point);
        }
        try {
            if (!page.isDragging()) {
                page.setDragging(true);
                wrapThis.hover();
                page.mouse().down();
            }
            target.hover();
        }
        catch (JsonProcessingException | EvaluateException e) {
            page.setDragging(false);
            throw e;
        }
        return null;
    }

    public DragData drag(Point point) throws JsonProcessingException {
        ElementHandle wrapThis = this.adoptIsolatedHandle();
        Page page = wrapThis.frame().page();
        if (page.isDragInterceptionEnabled()) {
            Point source = wrapThis.clickablePoint();
            return page.mouse().drag(source, point);
        }
        try {
            if (!page.isDragging()) {
                page.setDragging(true);
                wrapThis.hover();
                page.mouse().down();
            }
            page.mouse().move(point.getX(), point.getY());
        }
        catch (JsonProcessingException | EvaluateException e) {
            page.setDragging(false);
            throw e;
        }
        return null;
    }

    public List<String> select(List<String> values) throws JsonProcessingException, EvaluateException {
        String pptrFunction = "(element, vals) => {\n      const values = new Set(vals);\n      if (!(element instanceof HTMLSelectElement)) {\n        throw new Error('Element is not a <select> element.');\n      }\n\n      const selectedValues = new Set();\n      if (!element.multiple) {\n        for (const option of element.options) {\n          option.selected = false;\n        }\n        for (const option of element.options) {\n          if (values.has(option.value)) {\n            option.selected = true;\n            selectedValues.add(option.value);\n            break;\n          }\n        }\n      } else {\n        for (const option of element.options) {\n          option.selected = values.has(option.value);\n          if (option.selected) {\n            selectedValues.add(option.value);\n          }\n        }\n      }\n      element.dispatchEvent(new Event('input', {bubbles: true}));\n      element.dispatchEvent(new Event('change', {bubbles: true}));\n      return [...selectedValues.values()];\n    }";
        return (List)this.adoptIsolatedHandle().evaluate(pptrFunction, Collections.singletonList(values));
    }

    public abstract void uploadFile(List<String> var1) throws JsonProcessingException, EvaluateException;

    public abstract List<ElementHandle> queryAXTree(String var1, String var2) throws JsonProcessingException;

    protected void scrollIntoViewIfNeeded() throws JsonProcessingException, EvaluateException {
        if (this.isIntersectingViewport(1)) {
            return;
        }
        this.scrollIntoView();
    }

    public void tap() throws JsonProcessingException, EvaluateException {
        ElementHandle wrapThis = this.adoptIsolatedHandle();
        wrapThis.scrollIntoViewIfNeeded();
        Point point = wrapThis.clickablePoint();
        wrapThis.frame().page().touchscreen().tap(point.getX(), point.getY());
    }

    public void touchStart() throws JsonProcessingException, EvaluateException {
        ElementHandle wrapThis = this.adoptIsolatedHandle();
        wrapThis.scrollIntoViewIfNeeded();
        Point point = wrapThis.clickablePoint();
        wrapThis.frame().page().touchscreen().touchStart(point.getX(), point.getY(), null);
    }

    public void touchMove() throws JsonProcessingException, EvaluateException {
        ElementHandle wrapThis = this.adoptIsolatedHandle();
        wrapThis.scrollIntoViewIfNeeded();
        Point point = wrapThis.clickablePoint();
        wrapThis.frame().page().touchscreen().touchMove(point.getX(), point.getY());
    }

    public void touchEnd() throws JsonProcessingException, EvaluateException {
        ElementHandle wrapThis = this.adoptIsolatedHandle();
        wrapThis.scrollIntoViewIfNeeded();
        wrapThis.frame().page().touchscreen().touchEnd();
    }

    public void focus() throws JsonProcessingException, EvaluateException {
        this.adoptIsolatedHandle().evaluate("element => {\n      if (!(element instanceof HTMLElement)) {\n        throw new Error('Cannot focus non-HTMLElement');\n      }\n      return element.focus();\n    }");
    }

    public void type(String text) throws JsonProcessingException, EvaluateException {
        this.type(text, 0L);
    }

    public void type(String text, long delay) throws JsonProcessingException, EvaluateException {
        ElementHandle wrapThis = this.adoptIsolatedHandle();
        wrapThis.focus();
        KeyboardTypeOptions options = new KeyboardTypeOptions();
        options.setDelay(delay);
        wrapThis.frame().page().keyboard().type(text, options);
    }

    public void press(String key) throws JsonProcessingException, EvaluateException {
        this.press(key, new KeyPressOptions());
    }

    public void press(String key, KeyPressOptions options) throws JsonProcessingException, EvaluateException {
        this.adoptIsolatedHandle().focus();
        this.adoptIsolatedHandle().frame().page().keyboard().press(key, options);
    }

    public void scrollIntoView() throws JsonProcessingException, EvaluateException {
        ElementHandle wrapThis = this.adoptIsolatedHandle();
        wrapThis.assertConnectedElement();
        wrapThis.evaluate("async (element) => {\n      element.scrollIntoView({\n        block: 'center',\n        inline: 'center',\n        behavior: 'instant',\n      });\n    }");
    }

    protected void assertConnectedElement() throws JsonProcessingException, EvaluateException {
        Object error = this.evaluate("async element => {\n      if (!element.isConnected) {\n        return 'Node is detached from document';\n      }\n      if (element.nodeType !== Node.ELEMENT_NODE) {\n        return 'Node is not of type HTMLElement';\n      }\n      return;\n    }");
        if (error != null) {
            throw new JvppeteerException((String)error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIntersectingViewport(int threshold) throws JsonProcessingException, EvaluateException {
        ElementHandle wrapThis = this.adoptIsolatedHandle();
        wrapThis.assertConnectedElement();
        ElementHandle svgelEmentHandle = wrapThis.asSVGElementHandle();
        ElementHandle target = null;
        try {
            if (svgelEmentHandle != null) {
                target = svgelEmentHandle.getOwnerSVGElement();
            }
            String pptrFunction = "async (element, threshold) => {\n        const visibleRatio = await new Promise(resolve => {\n          const observer = new IntersectionObserver(entries => {\n            resolve(entries[0].intersectionRatio);\n            observer.disconnect();\n          });\n          observer.observe(element);\n        });\n        return threshold === 1 ? visibleRatio === 1 : visibleRatio > threshold;\n      }";
            if (target == null) {
                boolean bl = (Boolean)wrapThis.evaluate(pptrFunction, Collections.singletonList(threshold));
                return bl;
            }
            boolean bl = (Boolean)target.evaluate(pptrFunction, Collections.singletonList(threshold));
            return bl;
        }
        finally {
            if (target != null) {
                target.dispose();
            }
        }
    }

    public boolean isIntersectingViewport() throws JsonProcessingException, EvaluateException {
        return this.isIntersectingViewport(0);
    }

    private ElementHandle getOwnerSVGElement() throws JsonProcessingException, EvaluateException {
        JSHandle handle = this.evaluateHandle("element => {\n      if (element instanceof SVGSVGElement) {\n        return element;\n      }\n      return element.ownerSVGElement;\n    }");
        return handle.asElement();
    }

    private ElementHandle asSVGElementHandle() throws JsonProcessingException, EvaluateException {
        boolean response = (Boolean)this.evaluate("element => {\n        return element instanceof SVGElement;\n      }");
        if (response) {
            return this;
        }
        return null;
    }

    public abstract void autofill(AutofillData var1);

    public BoundingBox boundingBox() throws JsonProcessingException, EvaluateException {
        ElementHandle wrapThis = this.adoptIsolatedHandle();
        Object box = wrapThis.evaluate("element => {\n      if (!(element instanceof Element)) {\n        return null;\n      }\n      // Element is not visible.\n      if (element.getClientRects().length === 0) {\n        return null;\n      }\n      const rect = element.getBoundingClientRect();\n      return {x: rect.x, y: rect.y, width: rect.width, height: rect.height};\n    }");
        if (box == null) {
            return null;
        }
        Offset offset = wrapThis.getTopLeftCornerOfFrame();
        if (offset == null) {
            return null;
        }
        JsonNode boxNode = Constant.OBJECTMAPPER.readTree(Constant.OBJECTMAPPER.writeValueAsString(box));
        return new BoundingBox(boxNode.get("x").asDouble() + offset.getX(), boxNode.get("y").asDouble() + offset.getY(), boxNode.get("width").asDouble(), boxNode.get("height").asDouble());
    }

    private Offset getTopLeftCornerOfFrame() throws JsonProcessingException, EvaluateException {
        Frame parentFrame;
        Offset point = new Offset();
        Frame frame = this.frame();
        while (frame != null && (parentFrame = frame.parentFrame()) != null) {
            ElementHandle elementHandle = frame.frameElement();
            if (elementHandle == null) {
                throw new JvppeteerException("Unsupported frame type");
            }
            LinkedHashMap parentBox = (LinkedHashMap)elementHandle.evaluate("element => {\n                            // Element is not visible.\n                            if (element.getClientRects().length === 0) {\n                              return null;\n                            }\n                            const rect = element.getBoundingClientRect();\n                            const style = window.getComputedStyle(element);\n                            return {\n                              left:\n                                rect.left +\n                                parseInt(style.paddingLeft, 10) +\n                                parseInt(style.borderLeftWidth, 10),\n                              top:\n                                rect.top +\n                                parseInt(style.paddingTop, 10) +\n                                parseInt(style.borderTopWidth, 10),\n                            };\n                          }");
            if (parentBox == null) {
                return null;
            }
            point.setX(point.getX() + (double)((Integer)parentBox.get("left")).intValue());
            point.setY(point.getY() + (double)((Integer)parentBox.get("top")).intValue());
            frame = parentFrame;
        }
        return point;
    }

    public BoxModel boxModel() throws JsonProcessingException, EvaluateException {
        ElementHandle wrapThis = this.adoptIsolatedHandle();
        Object response = wrapThis.evaluate("element => {\n  if (!(element instanceof Element)) {\n    return null;\n  }\n  // Element is not visible.\n  if (element.getClientRects().length === 0) {\n    return null;\n  }\n  const rect = element.getBoundingClientRect();\n  const style = window.getComputedStyle(element);\n  const offsets = {\n    padding: {\n      left: parseInt(style.paddingLeft, 10),\n      top: parseInt(style.paddingTop, 10),\n      right: parseInt(style.paddingRight, 10),\n      bottom: parseInt(style.paddingBottom, 10),\n    },\n    margin: {\n      left: -parseInt(style.marginLeft, 10),\n      top: -parseInt(style.marginTop, 10),\n      right: -parseInt(style.marginRight, 10),\n      bottom: -parseInt(style.marginBottom, 10),\n    },\n    border: {\n      left: parseInt(style.borderLeft, 10),\n      top: parseInt(style.borderTop, 10),\n      right: parseInt(style.borderRight, 10),\n      bottom: parseInt(style.borderBottom, 10),\n    },\n  };\n  const border = [\n    {x: rect.left, y: rect.top},\n    {x: rect.left + rect.width, y: rect.top},\n    {x: rect.left + rect.width, y: rect.top + rect.bottom},\n    {x: rect.left, y: rect.top + rect.bottom},\n  ];\n  const padding = transformQuadWithOffsets(border, offsets.border);\n  const content = transformQuadWithOffsets(padding, offsets.padding);\n  const margin = transformQuadWithOffsets(border, offsets.margin);\n  return {\n    content,\n    padding,\n    border,\n    margin,\n    width: rect.width,\n    height: rect.height,\n  };\n\n  function transformQuadWithOffsets(\n    quad,\n    offsets\n  ) {\n    return [\n      {\n        x: quad[0].x + offsets.left,\n        y: quad[0].y + offsets.top,\n      },\n      {\n        x: quad[1].x - offsets.right,\n        y: quad[1].y + offsets.top,\n      },\n      {\n        x: quad[2].x - offsets.right,\n        y: quad[2].y - offsets.bottom,\n      },\n      {\n        x: quad[3].x + offsets.left,\n        y: quad[3].y - offsets.bottom,\n      },\n    ];\n  }\n}");
        if (response == null) {
            return null;
        }
        Offset offset = wrapThis.getTopLeftCornerOfFrame();
        if (offset == null) {
            return null;
        }
        BoxModel model = (BoxModel)Constant.OBJECTMAPPER.readValue(Constant.OBJECTMAPPER.writeValueAsString(response), BoxModel.class);
        model.getContent().forEach(point -> {
            point.setX(point.getX() + offset.getX());
            point.setY(point.getY() + offset.getY());
        });
        model.getPadding().forEach(point -> {
            point.setX(point.getX() + offset.getX());
            point.setY(point.getY() + offset.getY());
        });
        model.getBorder().forEach(point -> {
            point.setX(point.getX() + offset.getX());
            point.setY(point.getY() + offset.getY());
        });
        model.getMargin().forEach(point -> {
            point.setX(point.getX() + offset.getX());
            point.setY(point.getY() + offset.getY());
        });
        return model;
    }

    public String screenshot(String path) throws IOException, EvaluateException, ExecutionException, InterruptedException {
        ElementScreenshotOptions options = new ElementScreenshotOptions();
        options.setPath(path);
        return this.screenshot(options);
    }

    public String screenshot(ElementScreenshotOptions options) throws IOException, EvaluateException, ExecutionException, InterruptedException {
        ElementHandle wrapThis = this.adoptIsolatedHandle();
        Page page = wrapThis.frame().page();
        if (options.getScrollIntoView()) {
            this.scrollIntoViewIfNeeded();
        }
        BoundingBox elementClip = wrapThis.nonEmptyVisibleBoundingBox();
        Object arr = wrapThis.evaluate("() => {\n      if (!window.visualViewport) {\n        throw new Error('window.visualViewport is not supported.');\n      }\n      return [\n        window.visualViewport.pageLeft,\n        window.visualViewport.pageTop,\n      ];\n    }");
        JsonNode arrNode = Constant.OBJECTMAPPER.readTree(Constant.OBJECTMAPPER.writeValueAsString(arr));
        elementClip.setX(elementClip.getX() + arrNode.get(0).asDouble());
        elementClip.setY(elementClip.getY() + arrNode.get(1).asDouble());
        if (options.getClip() != null) {
            elementClip.setX(elementClip.getX() + options.getClip().getX());
            elementClip.setY(elementClip.getY() + options.getClip().getY());
            elementClip.setWidth(options.getClip().getWidth());
            elementClip.setHeight(options.getClip().getHeight());
        }
        options.setClip(new ScreenshotClip(elementClip.getX(), elementClip.getY(), elementClip.getWidth(), elementClip.getHeight(), 1.0));
        return page.screenshot(options);
    }

    public ElementHandle waitForSelector(String selector, WaitForSelectorOptions options) throws JsonProcessingException {
        QuerySelector querySelector = GetQueryHandler.getQueryHandlerAndSelector(selector, this.frame());
        options.setPolling(querySelector.getPolling());
        return querySelector.getQueryHandler().waitFor(this.adoptIsolatedHandle(), querySelector.getUpdatedSelector(), options);
    }

    private BoundingBox nonEmptyVisibleBoundingBox() throws JsonProcessingException, EvaluateException {
        BoundingBox box = this.boundingBox();
        Objects.requireNonNull(box, "Node is either not visible or not an HTMLElement");
        ValidateUtil.assertArg(box.getWidth() != 0.0, "Node has 0 width.");
        ValidateUtil.assertArg(box.getHeight() != 0.0, "Node has 0 height.");
        return box;
    }

    private JSHandle handle() {
        return this.handle;
    }

    public abstract int backendNodeId();
}

