/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.datatrack.buriedpoint.osw;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.tplink.smb.omada.device.manage.message.body.osw.OswInformBody;
import com.tplink.smb.omada.device.manage.message.inform.osw.InformOswPort;
import com.tplink.smb.omada.monitor.datatrack.buriedpoint.DeviceBuriedPointInfoDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

@JsonPropertyOrder
public class OswPortInfoDTO
extends DeviceBuriedPointInfoDTO {
    @JsonProperty(value="records")
    private List<OswPortRecordDTO> recordDTO;

    public static OswPortInfoDTO fromInform(String siteId, String mac, OswInformBody informBody) {
        if (Objects.nonNull(informBody.getPort())) {
            OswPortInfoDTO oswPortInfoDTO = new OswPortInfoDTO();
            oswPortInfoDTO.setMac(mac);
            oswPortInfoDTO.setSiteId(siteId);
            InformOswPort port = informBody.getPort();
            List ports = port.getPorts();
            List rates = port.getRates();
            if (Objects.nonNull(ports) && Objects.nonNull(rates)) {
                ArrayList<OswPortRecordDTO> oswPortRecordDTOs = new ArrayList<OswPortRecordDTO>(ports.size());
                ports.forEach(oswPortStatus -> {
                    OswPortRecordDTO oswPortRecordDTO = new OswPortRecordDTO();
                    oswPortRecordDTO.setPort(oswPortStatus.getPort());
                    oswPortRecordDTO.setTxErrorPkts(oswPortStatus.getTxErrorPkts());
                    oswPortRecordDTO.setRxErrorPkts(oswPortStatus.getRxErrorPkts());
                    oswPortRecordDTOs.add(oswPortRecordDTO);
                });
                rates.forEach(oswPortRate -> oswPortRecordDTOs.forEach(oswPortRecordDTO -> {
                    if (Objects.equals(oswPortRate.getPort(), oswPortRecordDTO.getPort())) {
                        oswPortRecordDTO.setTxRate(oswPortRate.getTxRate());
                        oswPortRecordDTO.setRxRate(oswPortRate.getRxRate());
                        oswPortRecordDTO.setRxRA(oswPortRate.getRxRA());
                        oswPortRecordDTO.setTxDR(oswPortRate.getTxDR());
                    }
                }));
                oswPortInfoDTO.setRecordDTO(oswPortRecordDTOs);
            }
            return oswPortInfoDTO;
        }
        return null;
    }

    @Generated
    public List<OswPortRecordDTO> getRecordDTO() {
        return this.recordDTO;
    }

    @JsonProperty(value="records")
    @Generated
    public OswPortInfoDTO setRecordDTO(List<OswPortRecordDTO> recordDTO) {
        this.recordDTO = recordDTO;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "OswPortInfoDTO(super=" + super.toString() + ", recordDTO=" + this.getRecordDTO() + ")";
    }

    @Generated
    public OswPortInfoDTO(List<OswPortRecordDTO> recordDTO) {
        this.recordDTO = recordDTO;
    }

    @Generated
    public OswPortInfoDTO() {
    }

    @Override
    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof OswPortInfoDTO)) {
            return false;
        }
        OswPortInfoDTO other = (OswPortInfoDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        List<OswPortRecordDTO> this$recordDTO = this.getRecordDTO();
        List<OswPortRecordDTO> other$recordDTO = other.getRecordDTO();
        return !(this$recordDTO == null ? other$recordDTO != null : !((Object)this$recordDTO).equals(other$recordDTO));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OswPortInfoDTO;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<OswPortRecordDTO> $recordDTO = this.getRecordDTO();
        result = result * 59 + ($recordDTO == null ? 43 : ((Object)$recordDTO).hashCode());
        return result;
    }

    @JsonPropertyOrder
    private static class OswPortRecordDTO {
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="txEP")
        private Long txErrorPkts;
        @JsonProperty(value="rxEP")
        private Long rxErrorPkts;
        @JsonProperty(value="txDR")
        private List<Integer> txDR;
        @JsonProperty(value="txR")
        private Long txRate;
        @JsonProperty(value="rxR")
        private Long rxRate;
        @JsonProperty(value="rxRA")
        private List<Long> rxRA;

        @Generated
        public Integer getPort() {
            return this.port;
        }

        @Generated
        public Long getTxErrorPkts() {
            return this.txErrorPkts;
        }

        @Generated
        public Long getRxErrorPkts() {
            return this.rxErrorPkts;
        }

        @Generated
        public List<Integer> getTxDR() {
            return this.txDR;
        }

        @Generated
        public Long getTxRate() {
            return this.txRate;
        }

        @Generated
        public Long getRxRate() {
            return this.rxRate;
        }

        @Generated
        public List<Long> getRxRA() {
            return this.rxRA;
        }

        @JsonProperty(value="port")
        @Generated
        public OswPortRecordDTO setPort(Integer port) {
            this.port = port;
            return this;
        }

        @JsonProperty(value="txEP")
        @Generated
        public OswPortRecordDTO setTxErrorPkts(Long txErrorPkts) {
            this.txErrorPkts = txErrorPkts;
            return this;
        }

        @JsonProperty(value="rxEP")
        @Generated
        public OswPortRecordDTO setRxErrorPkts(Long rxErrorPkts) {
            this.rxErrorPkts = rxErrorPkts;
            return this;
        }

        @JsonProperty(value="txDR")
        @Generated
        public OswPortRecordDTO setTxDR(List<Integer> txDR) {
            this.txDR = txDR;
            return this;
        }

        @JsonProperty(value="txR")
        @Generated
        public OswPortRecordDTO setTxRate(Long txRate) {
            this.txRate = txRate;
            return this;
        }

        @JsonProperty(value="rxR")
        @Generated
        public OswPortRecordDTO setRxRate(Long rxRate) {
            this.rxRate = rxRate;
            return this;
        }

        @JsonProperty(value="rxRA")
        @Generated
        public OswPortRecordDTO setRxRA(List<Long> rxRA) {
            this.rxRA = rxRA;
            return this;
        }

        @Generated
        public String toString() {
            return "OswPortInfoDTO.OswPortRecordDTO(super=" + super.toString() + ", port=" + this.getPort() + ", txErrorPkts=" + this.getTxErrorPkts() + ", rxErrorPkts=" + this.getRxErrorPkts() + ", txDR=" + this.getTxDR() + ", txRate=" + this.getTxRate() + ", rxRate=" + this.getRxRate() + ", rxRA=" + this.getRxRA() + ")";
        }

        @Generated
        public OswPortRecordDTO(Integer port, Long txErrorPkts, Long rxErrorPkts, List<Integer> txDR, Long txRate, Long rxRate, List<Long> rxRA) {
            this.port = port;
            this.txErrorPkts = txErrorPkts;
            this.rxErrorPkts = rxErrorPkts;
            this.txDR = txDR;
            this.txRate = txRate;
            this.rxRate = rxRate;
            this.rxRA = rxRA;
        }

        @Generated
        public OswPortRecordDTO() {
        }
    }
}

