/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.datatrack.buriedpoint.osw;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.tplink.smb.omada.device.manage.message.body.osw.OswInformBody;
import com.tplink.smb.omada.monitor.datatrack.buriedpoint.DeviceBuriedPointInfoDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

@JsonPropertyOrder
public class OswPoeInfoDTO
extends DeviceBuriedPointInfoDTO {
    @JsonProperty(value="total")
    private Double total;
    @JsonProperty(value="remain")
    private Double remain;
    @JsonProperty(value="percent")
    private Double percent;
    @JsonProperty(value="poePortInfo")
    private List<OswPoePortInfoDTO> poePortInfo;

    public static OswPoeInfoDTO fromInform(String siteId, String mac, OswInformBody informBody) {
        if (Objects.nonNull(informBody.getPoe())) {
            OswPoeInfoDTO oswPoeInfoDTO = new OswPoeInfoDTO();
            oswPoeInfoDTO.setMac(mac);
            oswPoeInfoDTO.setSiteId(siteId);
            if (Objects.nonNull(informBody.getPoe()) && Objects.nonNull(informBody.getPoe().getPorts())) {
                ArrayList<OswPoePortInfoDTO> oswPoePortInfoDTOs = new ArrayList<OswPoePortInfoDTO>(informBody.getPoe().getPorts().size());
                oswPoeInfoDTO.setTotal(informBody.getPoe().getTotal());
                oswPoeInfoDTO.setPercent(informBody.getPoe().getRemainPercent());
                oswPoeInfoDTO.setRemain(informBody.getPoe().getRemain());
                informBody.getPoe().getPorts().forEach(oswPortPoeStatus -> {
                    OswPoePortInfoDTO oswPoePortInfoDTO = new OswPoePortInfoDTO();
                    oswPoePortInfoDTO.setPort(oswPortPoeStatus.getPortId());
                    oswPoePortInfoDTO.setPeriodPower(oswPortPoeStatus.getPeriodPower());
                    oswPoePortInfoDTOs.add(oswPoePortInfoDTO);
                });
                oswPoeInfoDTO.setPoePortInfo(oswPoePortInfoDTOs);
            }
            return oswPoeInfoDTO;
        }
        return null;
    }

    @Generated
    public Double getTotal() {
        return this.total;
    }

    @Generated
    public Double getRemain() {
        return this.remain;
    }

    @Generated
    public Double getPercent() {
        return this.percent;
    }

    @Generated
    public List<OswPoePortInfoDTO> getPoePortInfo() {
        return this.poePortInfo;
    }

    @JsonProperty(value="total")
    @Generated
    public OswPoeInfoDTO setTotal(Double total) {
        this.total = total;
        return this;
    }

    @JsonProperty(value="remain")
    @Generated
    public OswPoeInfoDTO setRemain(Double remain) {
        this.remain = remain;
        return this;
    }

    @JsonProperty(value="percent")
    @Generated
    public OswPoeInfoDTO setPercent(Double percent) {
        this.percent = percent;
        return this;
    }

    @JsonProperty(value="poePortInfo")
    @Generated
    public OswPoeInfoDTO setPoePortInfo(List<OswPoePortInfoDTO> poePortInfo) {
        this.poePortInfo = poePortInfo;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "OswPoeInfoDTO(super=" + super.toString() + ", total=" + this.getTotal() + ", remain=" + this.getRemain() + ", percent=" + this.getPercent() + ", poePortInfo=" + this.getPoePortInfo() + ")";
    }

    @Generated
    public OswPoeInfoDTO(Double total, Double remain, Double percent, List<OswPoePortInfoDTO> poePortInfo) {
        this.total = total;
        this.remain = remain;
        this.percent = percent;
        this.poePortInfo = poePortInfo;
    }

    @Generated
    public OswPoeInfoDTO() {
    }

    @Override
    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof OswPoeInfoDTO)) {
            return false;
        }
        OswPoeInfoDTO other = (OswPoeInfoDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Double this$total = this.getTotal();
        Double other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        Double this$remain = this.getRemain();
        Double other$remain = other.getRemain();
        if (this$remain == null ? other$remain != null : !((Object)this$remain).equals(other$remain)) {
            return false;
        }
        Double this$percent = this.getPercent();
        Double other$percent = other.getPercent();
        if (this$percent == null ? other$percent != null : !((Object)this$percent).equals(other$percent)) {
            return false;
        }
        List<OswPoePortInfoDTO> this$poePortInfo = this.getPoePortInfo();
        List<OswPoePortInfoDTO> other$poePortInfo = other.getPoePortInfo();
        return !(this$poePortInfo == null ? other$poePortInfo != null : !((Object)this$poePortInfo).equals(other$poePortInfo));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OswPoeInfoDTO;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Double $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        Double $remain = this.getRemain();
        result = result * 59 + ($remain == null ? 43 : ((Object)$remain).hashCode());
        Double $percent = this.getPercent();
        result = result * 59 + ($percent == null ? 43 : ((Object)$percent).hashCode());
        List<OswPoePortInfoDTO> $poePortInfo = this.getPoePortInfo();
        result = result * 59 + ($poePortInfo == null ? 43 : ((Object)$poePortInfo).hashCode());
        return result;
    }

    @JsonPropertyOrder
    private static class OswPoePortInfoDTO {
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="pp")
        private List<Double> periodPower;

        @Generated
        public Integer getPort() {
            return this.port;
        }

        @Generated
        public List<Double> getPeriodPower() {
            return this.periodPower;
        }

        @JsonProperty(value="port")
        @Generated
        public OswPoePortInfoDTO setPort(Integer port) {
            this.port = port;
            return this;
        }

        @JsonProperty(value="pp")
        @Generated
        public OswPoePortInfoDTO setPeriodPower(List<Double> periodPower) {
            this.periodPower = periodPower;
            return this;
        }

        @Generated
        public String toString() {
            return "OswPoeInfoDTO.OswPoePortInfoDTO(super=" + super.toString() + ", port=" + this.getPort() + ", periodPower=" + this.getPeriodPower() + ")";
        }

        @Generated
        public OswPoePortInfoDTO(Integer port, List<Double> periodPower) {
            this.port = port;
            this.periodPower = periodPower;
        }

        @Generated
        public OswPoePortInfoDTO() {
        }
    }
}

