/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.datatrack.buriedpoint.osw;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.tplink.smb.omada.device.manage.message.body.osw.OswInformBody;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswDhcpServer;
import com.tplink.smb.omada.monitor.datatrack.buriedpoint.DeviceBuriedPointInfoDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

@JsonPropertyOrder
public class OswDhcpServerInfoDTO
extends DeviceBuriedPointInfoDTO {
    @JsonProperty(value="rxPkt")
    private OswRxPktInfoDTO rxPkt;
    @JsonProperty(value="txPkt")
    private OswTxPktInfoDTO txPkt;
    @JsonProperty(value="pools")
    private List<OswDhcpPoolInfoDTO> pools;

    public static OswDhcpServerInfoDTO fromInform(String siteId, String mac, OswInformBody informBody) {
        if (Objects.nonNull(informBody.getDhcpInfo())) {
            OswDhcpServerInfoDTO dhcpServerInfoDTO = new OswDhcpServerInfoDTO();
            dhcpServerInfoDTO.setSiteId(siteId);
            dhcpServerInfoDTO.setMac(mac);
            if (Objects.nonNull(informBody.getDhcpInfo()) && Objects.nonNull(informBody.getDhcpInfo().getDhcpServer())) {
                OswDhcpServer dhcpServer = informBody.getDhcpInfo().getDhcpServer();
                ArrayList<OswDhcpPoolInfoDTO> oswDhcpPoolInfoDTOS = new ArrayList<OswDhcpPoolInfoDTO>();
                dhcpServer.getPools().forEach(dhcpPoolInfo -> {
                    OswDhcpPoolInfoDTO oswDhcpPoolInfoDTO = new OswDhcpPoolInfoDTO();
                    oswDhcpPoolInfoDTO.setAckPktNum(dhcpPoolInfo.getAckPktNum());
                    oswDhcpPoolInfoDTO.setAllocCnt(dhcpPoolInfo.getAllocCnt());
                    oswDhcpPoolInfoDTO.setInformPktNum(dhcpPoolInfo.getInformPktNum());
                    oswDhcpPoolInfoDTO.setPoolSize(dhcpPoolInfo.getPoolSize());
                    oswDhcpPoolInfoDTO.setBootpReplyPktNum(dhcpPoolInfo.getBootpReplyPktNum());
                    oswDhcpPoolInfoDTO.setBootpRequestPktNum(dhcpPoolInfo.getBootpRequestPktNum());
                    oswDhcpPoolInfoDTO.setDeclinePktNum(dhcpPoolInfo.getDeclinePktNum());
                    oswDhcpPoolInfoDTO.setRequestPktNum(dhcpPoolInfo.getRequestPktNum());
                    oswDhcpPoolInfoDTO.setTxErrPktNum(dhcpPoolInfo.getTxErrPktNum());
                    oswDhcpPoolInfoDTO.setRxErrPktNum(dhcpPoolInfo.getRxErrPktNum());
                    oswDhcpPoolInfoDTO.setReleasePktNum(dhcpPoolInfo.getReleasePktNum());
                    oswDhcpPoolInfoDTO.setName(dhcpPoolInfo.getName());
                    oswDhcpPoolInfoDTO.setNakPktNum(dhcpPoolInfo.getNakPktNum());
                    oswDhcpPoolInfoDTO.setDiscoverPktNum(dhcpPoolInfo.getDiscoverPktNum());
                    oswDhcpPoolInfoDTO.setOfferPktNum(dhcpPoolInfo.getOfferPktNum());
                    oswDhcpPoolInfoDTO.setServerIp(dhcpPoolInfo.getServerIp());
                    oswDhcpPoolInfoDTOS.add(oswDhcpPoolInfoDTO);
                });
                dhcpServerInfoDTO.setPools(oswDhcpPoolInfoDTOS);
                if (Objects.nonNull(dhcpServer.getTxPkt())) {
                    OswTxPktInfoDTO oswTxPktInfoDTO = new OswTxPktInfoDTO();
                    oswTxPktInfoDTO.setNakPktNum(dhcpServer.getTxPkt().getNakPktNum());
                    oswTxPktInfoDTO.setOfferPktNum(dhcpServer.getTxPkt().getOfferPktNum());
                    oswTxPktInfoDTO.setErrPktNum(dhcpServer.getTxPkt().getErrPktNum());
                    oswTxPktInfoDTO.setBootpReplyPktNum(dhcpServer.getTxPkt().getBootpReplyPktNum());
                    oswTxPktInfoDTO.setAckPktNum(dhcpServer.getTxPkt().getAckPktNum());
                    dhcpServerInfoDTO.setTxPkt(oswTxPktInfoDTO);
                }
                if (Objects.nonNull(dhcpServer.getRxPkt())) {
                    OswRxPktInfoDTO oswRxPktInfoDTO = new OswRxPktInfoDTO();
                    oswRxPktInfoDTO.setInformPktNum(dhcpServer.getRxPkt().getInformPktNum());
                    oswRxPktInfoDTO.setDeclinePktNum(dhcpServer.getRxPkt().getDeclinePktNum());
                    oswRxPktInfoDTO.setErrPktNum(dhcpServer.getRxPkt().getErrPktNum());
                    oswRxPktInfoDTO.setReleasePktNum(dhcpServer.getRxPkt().getReleasePktNum());
                    oswRxPktInfoDTO.setRequestPktNum(dhcpServer.getRxPkt().getRequestPktNum());
                    oswRxPktInfoDTO.setDiscoverPktNum(dhcpServer.getRxPkt().getDiscoverPktNum());
                    oswRxPktInfoDTO.setBootpRequestPktNum(dhcpServer.getRxPkt().getBootpRequestPktNum());
                    dhcpServerInfoDTO.setRxPkt(oswRxPktInfoDTO);
                }
            }
            return dhcpServerInfoDTO;
        }
        return null;
    }

    @Generated
    public OswRxPktInfoDTO getRxPkt() {
        return this.rxPkt;
    }

    @Generated
    public OswTxPktInfoDTO getTxPkt() {
        return this.txPkt;
    }

    @Generated
    public List<OswDhcpPoolInfoDTO> getPools() {
        return this.pools;
    }

    @JsonProperty(value="rxPkt")
    @Generated
    public OswDhcpServerInfoDTO setRxPkt(OswRxPktInfoDTO rxPkt) {
        this.rxPkt = rxPkt;
        return this;
    }

    @JsonProperty(value="txPkt")
    @Generated
    public OswDhcpServerInfoDTO setTxPkt(OswTxPktInfoDTO txPkt) {
        this.txPkt = txPkt;
        return this;
    }

    @JsonProperty(value="pools")
    @Generated
    public OswDhcpServerInfoDTO setPools(List<OswDhcpPoolInfoDTO> pools) {
        this.pools = pools;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "OswDhcpServerInfoDTO(super=" + super.toString() + ", rxPkt=" + this.getRxPkt() + ", txPkt=" + this.getTxPkt() + ", pools=" + this.getPools() + ")";
    }

    @Generated
    public OswDhcpServerInfoDTO(OswRxPktInfoDTO rxPkt, OswTxPktInfoDTO txPkt, List<OswDhcpPoolInfoDTO> pools) {
        this.rxPkt = rxPkt;
        this.txPkt = txPkt;
        this.pools = pools;
    }

    @Generated
    public OswDhcpServerInfoDTO() {
    }

    @Override
    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof OswDhcpServerInfoDTO)) {
            return false;
        }
        OswDhcpServerInfoDTO other = (OswDhcpServerInfoDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        OswRxPktInfoDTO this$rxPkt = this.getRxPkt();
        OswRxPktInfoDTO other$rxPkt = other.getRxPkt();
        if (this$rxPkt == null ? other$rxPkt != null : !this$rxPkt.equals(other$rxPkt)) {
            return false;
        }
        OswTxPktInfoDTO this$txPkt = this.getTxPkt();
        OswTxPktInfoDTO other$txPkt = other.getTxPkt();
        if (this$txPkt == null ? other$txPkt != null : !this$txPkt.equals(other$txPkt)) {
            return false;
        }
        List<OswDhcpPoolInfoDTO> this$pools = this.getPools();
        List<OswDhcpPoolInfoDTO> other$pools = other.getPools();
        return !(this$pools == null ? other$pools != null : !((Object)this$pools).equals(other$pools));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OswDhcpServerInfoDTO;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OswRxPktInfoDTO $rxPkt = this.getRxPkt();
        result = result * 59 + ($rxPkt == null ? 43 : $rxPkt.hashCode());
        OswTxPktInfoDTO $txPkt = this.getTxPkt();
        result = result * 59 + ($txPkt == null ? 43 : $txPkt.hashCode());
        List<OswDhcpPoolInfoDTO> $pools = this.getPools();
        result = result * 59 + ($pools == null ? 43 : ((Object)$pools).hashCode());
        return result;
    }

    public static class OswTxPktInfoDTO {
        @JsonProperty(value="offPkt")
        private Long offerPktNum;
        @JsonProperty(value="ackPkt")
        private Long ackPktNum;
        @JsonProperty(value="nakPkt")
        private Long nakPktNum;
        @JsonProperty(value="bootpPkt")
        private Long bootpReplyPktNum;
        @JsonProperty(value="errPkt")
        private Long errPktNum;

        @Generated
        public Long getOfferPktNum() {
            return this.offerPktNum;
        }

        @Generated
        public Long getAckPktNum() {
            return this.ackPktNum;
        }

        @Generated
        public Long getNakPktNum() {
            return this.nakPktNum;
        }

        @Generated
        public Long getBootpReplyPktNum() {
            return this.bootpReplyPktNum;
        }

        @Generated
        public Long getErrPktNum() {
            return this.errPktNum;
        }

        @JsonProperty(value="offPkt")
        @Generated
        public OswTxPktInfoDTO setOfferPktNum(Long offerPktNum) {
            this.offerPktNum = offerPktNum;
            return this;
        }

        @JsonProperty(value="ackPkt")
        @Generated
        public OswTxPktInfoDTO setAckPktNum(Long ackPktNum) {
            this.ackPktNum = ackPktNum;
            return this;
        }

        @JsonProperty(value="nakPkt")
        @Generated
        public OswTxPktInfoDTO setNakPktNum(Long nakPktNum) {
            this.nakPktNum = nakPktNum;
            return this;
        }

        @JsonProperty(value="bootpPkt")
        @Generated
        public OswTxPktInfoDTO setBootpReplyPktNum(Long bootpReplyPktNum) {
            this.bootpReplyPktNum = bootpReplyPktNum;
            return this;
        }

        @JsonProperty(value="errPkt")
        @Generated
        public OswTxPktInfoDTO setErrPktNum(Long errPktNum) {
            this.errPktNum = errPktNum;
            return this;
        }

        @Generated
        public String toString() {
            return "OswDhcpServerInfoDTO.OswTxPktInfoDTO(offerPktNum=" + this.getOfferPktNum() + ", ackPktNum=" + this.getAckPktNum() + ", nakPktNum=" + this.getNakPktNum() + ", bootpReplyPktNum=" + this.getBootpReplyPktNum() + ", errPktNum=" + this.getErrPktNum() + ")";
        }
    }

    public static class OswRxPktInfoDTO {
        @JsonProperty(value="disPkt")
        private Long discoverPktNum;
        @JsonProperty(value="reqPkt")
        private Long requestPktNum;
        @JsonProperty(value="decPkt")
        private Long declinePktNum;
        @JsonProperty(value="relPkt")
        private Long releasePktNum;
        @JsonProperty(value="infPkt")
        private Long informPktNum;
        @JsonProperty(value="errPkt")
        private Long errPktNum;
        @JsonProperty(value="bootpPkt")
        private Long bootpRequestPktNum;

        @Generated
        public Long getDiscoverPktNum() {
            return this.discoverPktNum;
        }

        @Generated
        public Long getRequestPktNum() {
            return this.requestPktNum;
        }

        @Generated
        public Long getDeclinePktNum() {
            return this.declinePktNum;
        }

        @Generated
        public Long getReleasePktNum() {
            return this.releasePktNum;
        }

        @Generated
        public Long getInformPktNum() {
            return this.informPktNum;
        }

        @Generated
        public Long getErrPktNum() {
            return this.errPktNum;
        }

        @Generated
        public Long getBootpRequestPktNum() {
            return this.bootpRequestPktNum;
        }

        @JsonProperty(value="disPkt")
        @Generated
        public OswRxPktInfoDTO setDiscoverPktNum(Long discoverPktNum) {
            this.discoverPktNum = discoverPktNum;
            return this;
        }

        @JsonProperty(value="reqPkt")
        @Generated
        public OswRxPktInfoDTO setRequestPktNum(Long requestPktNum) {
            this.requestPktNum = requestPktNum;
            return this;
        }

        @JsonProperty(value="decPkt")
        @Generated
        public OswRxPktInfoDTO setDeclinePktNum(Long declinePktNum) {
            this.declinePktNum = declinePktNum;
            return this;
        }

        @JsonProperty(value="relPkt")
        @Generated
        public OswRxPktInfoDTO setReleasePktNum(Long releasePktNum) {
            this.releasePktNum = releasePktNum;
            return this;
        }

        @JsonProperty(value="infPkt")
        @Generated
        public OswRxPktInfoDTO setInformPktNum(Long informPktNum) {
            this.informPktNum = informPktNum;
            return this;
        }

        @JsonProperty(value="errPkt")
        @Generated
        public OswRxPktInfoDTO setErrPktNum(Long errPktNum) {
            this.errPktNum = errPktNum;
            return this;
        }

        @JsonProperty(value="bootpPkt")
        @Generated
        public OswRxPktInfoDTO setBootpRequestPktNum(Long bootpRequestPktNum) {
            this.bootpRequestPktNum = bootpRequestPktNum;
            return this;
        }

        @Generated
        public String toString() {
            return "OswDhcpServerInfoDTO.OswRxPktInfoDTO(discoverPktNum=" + this.getDiscoverPktNum() + ", requestPktNum=" + this.getRequestPktNum() + ", declinePktNum=" + this.getDeclinePktNum() + ", releasePktNum=" + this.getReleasePktNum() + ", informPktNum=" + this.getInformPktNum() + ", errPktNum=" + this.getErrPktNum() + ", bootpRequestPktNum=" + this.getBootpRequestPktNum() + ")";
        }
    }

    public static class OswDhcpPoolInfoDTO {
        @JsonProperty(value="srvIp")
        private String serverIp;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="poolSize")
        private Integer poolSize;
        @JsonProperty(value="allocCnt")
        private Integer allocCnt;
        @JsonProperty(value="rxDisPkt")
        private Long discoverPktNum;
        @JsonProperty(value="rxReqPkt")
        private Long requestPktNum;
        @JsonProperty(value="rxDecPkt")
        private Long declinePktNum;
        @JsonProperty(value="rxRelPkt")
        private Long releasePktNum;
        @JsonProperty(value="rxInfPkt")
        private Long informPktNum;
        @JsonProperty(value="rxErrPkt")
        private Long rxErrPktNum;
        @JsonProperty(value="rxBootpPkt")
        private Long bootpRequestPktNum;
        @JsonProperty(value="txOffPkt")
        private Long offerPktNum;
        @JsonProperty(value="txAckPkt")
        private Long ackPktNum;
        @JsonProperty(value="txNakPkt")
        private Long nakPktNum;
        @JsonProperty(value="txBootpPkt")
        private Long bootpReplyPktNum;
        @JsonProperty(value="txErrPkt")
        private Long txErrPktNum;

        @Generated
        public String getServerIp() {
            return this.serverIp;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Integer getPoolSize() {
            return this.poolSize;
        }

        @Generated
        public Integer getAllocCnt() {
            return this.allocCnt;
        }

        @Generated
        public Long getDiscoverPktNum() {
            return this.discoverPktNum;
        }

        @Generated
        public Long getRequestPktNum() {
            return this.requestPktNum;
        }

        @Generated
        public Long getDeclinePktNum() {
            return this.declinePktNum;
        }

        @Generated
        public Long getReleasePktNum() {
            return this.releasePktNum;
        }

        @Generated
        public Long getInformPktNum() {
            return this.informPktNum;
        }

        @Generated
        public Long getRxErrPktNum() {
            return this.rxErrPktNum;
        }

        @Generated
        public Long getBootpRequestPktNum() {
            return this.bootpRequestPktNum;
        }

        @Generated
        public Long getOfferPktNum() {
            return this.offerPktNum;
        }

        @Generated
        public Long getAckPktNum() {
            return this.ackPktNum;
        }

        @Generated
        public Long getNakPktNum() {
            return this.nakPktNum;
        }

        @Generated
        public Long getBootpReplyPktNum() {
            return this.bootpReplyPktNum;
        }

        @Generated
        public Long getTxErrPktNum() {
            return this.txErrPktNum;
        }

        @JsonProperty(value="srvIp")
        @Generated
        public OswDhcpPoolInfoDTO setServerIp(String serverIp) {
            this.serverIp = serverIp;
            return this;
        }

        @JsonProperty(value="name")
        @Generated
        public OswDhcpPoolInfoDTO setName(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="poolSize")
        @Generated
        public OswDhcpPoolInfoDTO setPoolSize(Integer poolSize) {
            this.poolSize = poolSize;
            return this;
        }

        @JsonProperty(value="allocCnt")
        @Generated
        public OswDhcpPoolInfoDTO setAllocCnt(Integer allocCnt) {
            this.allocCnt = allocCnt;
            return this;
        }

        @JsonProperty(value="rxDisPkt")
        @Generated
        public OswDhcpPoolInfoDTO setDiscoverPktNum(Long discoverPktNum) {
            this.discoverPktNum = discoverPktNum;
            return this;
        }

        @JsonProperty(value="rxReqPkt")
        @Generated
        public OswDhcpPoolInfoDTO setRequestPktNum(Long requestPktNum) {
            this.requestPktNum = requestPktNum;
            return this;
        }

        @JsonProperty(value="rxDecPkt")
        @Generated
        public OswDhcpPoolInfoDTO setDeclinePktNum(Long declinePktNum) {
            this.declinePktNum = declinePktNum;
            return this;
        }

        @JsonProperty(value="rxRelPkt")
        @Generated
        public OswDhcpPoolInfoDTO setReleasePktNum(Long releasePktNum) {
            this.releasePktNum = releasePktNum;
            return this;
        }

        @JsonProperty(value="rxInfPkt")
        @Generated
        public OswDhcpPoolInfoDTO setInformPktNum(Long informPktNum) {
            this.informPktNum = informPktNum;
            return this;
        }

        @JsonProperty(value="rxErrPkt")
        @Generated
        public OswDhcpPoolInfoDTO setRxErrPktNum(Long rxErrPktNum) {
            this.rxErrPktNum = rxErrPktNum;
            return this;
        }

        @JsonProperty(value="rxBootpPkt")
        @Generated
        public OswDhcpPoolInfoDTO setBootpRequestPktNum(Long bootpRequestPktNum) {
            this.bootpRequestPktNum = bootpRequestPktNum;
            return this;
        }

        @JsonProperty(value="txOffPkt")
        @Generated
        public OswDhcpPoolInfoDTO setOfferPktNum(Long offerPktNum) {
            this.offerPktNum = offerPktNum;
            return this;
        }

        @JsonProperty(value="txAckPkt")
        @Generated
        public OswDhcpPoolInfoDTO setAckPktNum(Long ackPktNum) {
            this.ackPktNum = ackPktNum;
            return this;
        }

        @JsonProperty(value="txNakPkt")
        @Generated
        public OswDhcpPoolInfoDTO setNakPktNum(Long nakPktNum) {
            this.nakPktNum = nakPktNum;
            return this;
        }

        @JsonProperty(value="txBootpPkt")
        @Generated
        public OswDhcpPoolInfoDTO setBootpReplyPktNum(Long bootpReplyPktNum) {
            this.bootpReplyPktNum = bootpReplyPktNum;
            return this;
        }

        @JsonProperty(value="txErrPkt")
        @Generated
        public OswDhcpPoolInfoDTO setTxErrPktNum(Long txErrPktNum) {
            this.txErrPktNum = txErrPktNum;
            return this;
        }

        @Generated
        public String toString() {
            return "OswDhcpServerInfoDTO.OswDhcpPoolInfoDTO(serverIp=" + this.getServerIp() + ", name=" + this.getName() + ", poolSize=" + this.getPoolSize() + ", allocCnt=" + this.getAllocCnt() + ", discoverPktNum=" + this.getDiscoverPktNum() + ", requestPktNum=" + this.getRequestPktNum() + ", declinePktNum=" + this.getDeclinePktNum() + ", releasePktNum=" + this.getReleasePktNum() + ", informPktNum=" + this.getInformPktNum() + ", rxErrPktNum=" + this.getRxErrPktNum() + ", bootpRequestPktNum=" + this.getBootpRequestPktNum() + ", offerPktNum=" + this.getOfferPktNum() + ", ackPktNum=" + this.getAckPktNum() + ", nakPktNum=" + this.getNakPktNum() + ", bootpReplyPktNum=" + this.getBootpReplyPktNum() + ", txErrPktNum=" + this.getTxErrPktNum() + ")";
        }
    }
}

