/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.datatrack.buriedpoint.osg;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.tplink.smb.omada.monitor.api.shared.datatrack.OsgPortStatDTO;
import com.tplink.smb.omada.monitor.datatrack.buriedpoint.DeviceBuriedPointInfoDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

@JsonPropertyOrder
public class OsgTrafficStatsInfoDTO
extends DeviceBuriedPointInfoDTO {
    @JsonProperty(value="records")
    private List<OsgPortTrafficStatInfoDTO> records;

    public static OsgTrafficStatsInfoDTO fromStatistic(OsgPortStatDTO osgPortStatDTO) {
        if (Objects.nonNull(osgPortStatDTO) && !CollectionUtils.isEmpty((Collection)osgPortStatDTO.getTrafficStats())) {
            OsgTrafficStatsInfoDTO osgTrafficStatsInfoDTO = new OsgTrafficStatsInfoDTO();
            osgTrafficStatsInfoDTO.setSiteId(osgPortStatDTO.getSiteId());
            osgTrafficStatsInfoDTO.setMac(osgPortStatDTO.getMac());
            ArrayList<OsgPortTrafficStatInfoDTO> osgPortTrafficStatInfoDTOS = new ArrayList<OsgPortTrafficStatInfoDTO>();
            osgPortStatDTO.getTrafficStats().forEach(trafficStat -> {
                OsgPortTrafficStatInfoDTO osgPortTrafficStatInfoDTO = new OsgPortTrafficStatInfoDTO();
                osgPortTrafficStatInfoDTO.setPort(trafficStat.getPort());
                osgPortTrafficStatInfoDTO.setTxRate(trafficStat.getTxRate());
                osgPortTrafficStatInfoDTO.setRxRate(trafficStat.getRxRate());
                osgPortTrafficStatInfoDTO.setErrorPackets(trafficStat.getErrorPackets());
                osgPortTrafficStatInfoDTO.setLossPackets(trafficStat.getLossPackets());
                osgPortTrafficStatInfoDTO.setLoss(trafficStat.getLoss());
                osgPortTrafficStatInfoDTOS.add(osgPortTrafficStatInfoDTO);
            });
            osgTrafficStatsInfoDTO.setRecords(osgPortTrafficStatInfoDTOS);
            return osgTrafficStatsInfoDTO;
        }
        return null;
    }

    @Generated
    public List<OsgPortTrafficStatInfoDTO> getRecords() {
        return this.records;
    }

    @JsonProperty(value="records")
    @Generated
    public OsgTrafficStatsInfoDTO setRecords(List<OsgPortTrafficStatInfoDTO> records) {
        this.records = records;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "OsgTrafficStatsInfoDTO(super=" + super.toString() + ", records=" + this.getRecords() + ")";
    }

    @Generated
    public OsgTrafficStatsInfoDTO(List<OsgPortTrafficStatInfoDTO> records) {
        this.records = records;
    }

    @Generated
    public OsgTrafficStatsInfoDTO() {
    }

    @Override
    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof OsgTrafficStatsInfoDTO)) {
            return false;
        }
        OsgTrafficStatsInfoDTO other = (OsgTrafficStatsInfoDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        List<OsgPortTrafficStatInfoDTO> this$records = this.getRecords();
        List<OsgPortTrafficStatInfoDTO> other$records = other.getRecords();
        return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OsgTrafficStatsInfoDTO;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<OsgPortTrafficStatInfoDTO> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        return result;
    }

    @JsonPropertyOrder
    private static class OsgPortTrafficStatInfoDTO {
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="txR")
        private Long txRate;
        @JsonProperty(value="rxR")
        private Long rxRate;
        @JsonProperty(value="errPkt")
        private Long errorPackets;
        @JsonProperty(value="lossPkt")
        private Long lossPackets;
        @JsonProperty(value="loss")
        private Double loss;

        @Generated
        public Integer getPort() {
            return this.port;
        }

        @Generated
        public Long getTxRate() {
            return this.txRate;
        }

        @Generated
        public Long getRxRate() {
            return this.rxRate;
        }

        @Generated
        public Long getErrorPackets() {
            return this.errorPackets;
        }

        @Generated
        public Long getLossPackets() {
            return this.lossPackets;
        }

        @Generated
        public Double getLoss() {
            return this.loss;
        }

        @JsonProperty(value="port")
        @Generated
        public OsgPortTrafficStatInfoDTO setPort(Integer port) {
            this.port = port;
            return this;
        }

        @JsonProperty(value="txR")
        @Generated
        public OsgPortTrafficStatInfoDTO setTxRate(Long txRate) {
            this.txRate = txRate;
            return this;
        }

        @JsonProperty(value="rxR")
        @Generated
        public OsgPortTrafficStatInfoDTO setRxRate(Long rxRate) {
            this.rxRate = rxRate;
            return this;
        }

        @JsonProperty(value="errPkt")
        @Generated
        public OsgPortTrafficStatInfoDTO setErrorPackets(Long errorPackets) {
            this.errorPackets = errorPackets;
            return this;
        }

        @JsonProperty(value="lossPkt")
        @Generated
        public OsgPortTrafficStatInfoDTO setLossPackets(Long lossPackets) {
            this.lossPackets = lossPackets;
            return this;
        }

        @JsonProperty(value="loss")
        @Generated
        public OsgPortTrafficStatInfoDTO setLoss(Double loss) {
            this.loss = loss;
            return this;
        }

        @Generated
        public String toString() {
            return "OsgTrafficStatsInfoDTO.OsgPortTrafficStatInfoDTO(super=" + super.toString() + ", port=" + this.getPort() + ", txRate=" + this.getTxRate() + ", rxRate=" + this.getRxRate() + ", errorPackets=" + this.getErrorPackets() + ", lossPackets=" + this.getLossPackets() + ", loss=" + this.getLoss() + ")";
        }

        @Generated
        public OsgPortTrafficStatInfoDTO(Integer port, Long txRate, Long rxRate, Long errorPackets, Long lossPackets, Double loss) {
            this.port = port;
            this.txRate = txRate;
            this.rxRate = rxRate;
            this.errorPackets = errorPackets;
            this.lossPackets = lossPackets;
            this.loss = loss;
        }

        @Generated
        public OsgPortTrafficStatInfoDTO() {
        }
    }
}

