/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.datatrack.buriedpoint.osg;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.tplink.smb.omada.device.manage.message.body.osg.OsgInformBody;
import com.tplink.smb.omada.monitor.datatrack.buriedpoint.DeviceBuriedPointInfoDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

@JsonPropertyOrder
public class OsgPortInfoDTO
extends DeviceBuriedPointInfoDTO {
    @JsonProperty(value="records")
    private List<OsgPortRecordDTO> recordDTO;

    public static OsgPortInfoDTO fromInform(String siteId, String mac, OsgInformBody informBody) {
        if (Objects.nonNull(informBody.getPortInfo())) {
            OsgPortInfoDTO portInfoDTO = new OsgPortInfoDTO();
            portInfoDTO.setMac(mac);
            portInfoDTO.setSiteId(siteId);
            if (!CollectionUtils.isEmpty((Collection)informBody.getPortInfo().getPortStatusList())) {
                ArrayList<OsgPortRecordDTO> osgPortRecordDTOs = new ArrayList<OsgPortRecordDTO>(informBody.getPortInfo().getPortStatusList().size());
                informBody.getPortInfo().getPortStatusList().forEach(osgPortInfo -> {
                    OsgPortRecordDTO osgPortRecordDTO = new OsgPortRecordDTO();
                    osgPortRecordDTO.setPort(osgPortInfo.getPort());
                    osgPortRecordDTO.setLatency(osgPortInfo.getLatency());
                    osgPortRecordDTOs.add(osgPortRecordDTO);
                });
                portInfoDTO.setRecordDTO(osgPortRecordDTOs);
                return portInfoDTO;
            }
            return null;
        }
        return null;
    }

    @Generated
    public List<OsgPortRecordDTO> getRecordDTO() {
        return this.recordDTO;
    }

    @JsonProperty(value="records")
    @Generated
    public OsgPortInfoDTO setRecordDTO(List<OsgPortRecordDTO> recordDTO) {
        this.recordDTO = recordDTO;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "OsgPortInfoDTO(super=" + super.toString() + ", recordDTO=" + this.getRecordDTO() + ")";
    }

    @Generated
    public OsgPortInfoDTO(List<OsgPortRecordDTO> recordDTO) {
        this.recordDTO = recordDTO;
    }

    @Generated
    public OsgPortInfoDTO() {
    }

    @Override
    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof OsgPortInfoDTO)) {
            return false;
        }
        OsgPortInfoDTO other = (OsgPortInfoDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        List<OsgPortRecordDTO> this$recordDTO = this.getRecordDTO();
        List<OsgPortRecordDTO> other$recordDTO = other.getRecordDTO();
        return !(this$recordDTO == null ? other$recordDTO != null : !((Object)this$recordDTO).equals(other$recordDTO));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OsgPortInfoDTO;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<OsgPortRecordDTO> $recordDTO = this.getRecordDTO();
        result = result * 59 + ($recordDTO == null ? 43 : ((Object)$recordDTO).hashCode());
        return result;
    }

    @JsonPropertyOrder
    private static class OsgPortRecordDTO {
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="latency")
        private Integer latency;

        @Generated
        public Integer getPort() {
            return this.port;
        }

        @Generated
        public Integer getLatency() {
            return this.latency;
        }

        @JsonProperty(value="port")
        @Generated
        public OsgPortRecordDTO setPort(Integer port) {
            this.port = port;
            return this;
        }

        @JsonProperty(value="latency")
        @Generated
        public OsgPortRecordDTO setLatency(Integer latency) {
            this.latency = latency;
            return this;
        }

        @Generated
        public String toString() {
            return "OsgPortInfoDTO.OsgPortRecordDTO(super=" + super.toString() + ", port=" + this.getPort() + ", latency=" + this.getLatency() + ")";
        }

        @Generated
        public OsgPortRecordDTO(Integer port, Integer latency) {
            this.port = port;
            this.latency = latency;
        }

        @Generated
        public OsgPortRecordDTO() {
        }
    }
}

