/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.datatrack.buriedpoint.osg;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.tplink.smb.omada.device.manage.message.body.osg.OsgInformBody;
import com.tplink.smb.omada.monitor.datatrack.buriedpoint.DeviceBuriedPointInfoDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

@JsonPropertyOrder
public class OsgNetworkTrafficInfoDTO
extends DeviceBuriedPointInfoDTO {
    @JsonProperty(value="records")
    private List<OsgDhcpInfoDTO> records;

    public static OsgNetworkTrafficInfoDTO fromInform(String siteId, String mac, OsgInformBody informBody) {
        if (Objects.nonNull(informBody.getNetTraffic())) {
            OsgNetworkTrafficInfoDTO networkTrafficInfoDTO = new OsgNetworkTrafficInfoDTO();
            networkTrafficInfoDTO.setSiteId(siteId);
            networkTrafficInfoDTO.setMac(mac);
            if (Objects.nonNull(informBody.getNetTraffic().getNetTrafficList())) {
                ArrayList<OsgDhcpInfoDTO> osgDhcpInfoDTOs = new ArrayList<OsgDhcpInfoDTO>();
                informBody.getNetTraffic().getNetTrafficList().forEach(osgNetworkTraffic -> {
                    OsgDhcpInfoDTO osgDhcpInfoDTO = new OsgDhcpInfoDTO();
                    osgDhcpInfoDTO.setDhcps6Offer(osgNetworkTraffic.getDhcps6Offer());
                    osgDhcpInfoDTO.setDhcpsOffer(osgNetworkTraffic.getDhcpsOffer());
                    osgDhcpInfoDTO.setDhcps6Util(osgNetworkTraffic.getDhcps6Util());
                    osgDhcpInfoDTO.setDhcpsUtil(osgNetworkTraffic.getDhcpsUtil());
                    osgDhcpInfoDTOs.add(osgDhcpInfoDTO);
                });
                networkTrafficInfoDTO.setRecords(osgDhcpInfoDTOs);
            }
            return networkTrafficInfoDTO;
        }
        return null;
    }

    @Generated
    public List<OsgDhcpInfoDTO> getRecords() {
        return this.records;
    }

    @JsonProperty(value="records")
    @Generated
    public OsgNetworkTrafficInfoDTO setRecords(List<OsgDhcpInfoDTO> records) {
        this.records = records;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "OsgNetworkTrafficInfoDTO(super=" + super.toString() + ", records=" + this.getRecords() + ")";
    }

    @Generated
    public OsgNetworkTrafficInfoDTO(List<OsgDhcpInfoDTO> records) {
        this.records = records;
    }

    @Generated
    public OsgNetworkTrafficInfoDTO() {
    }

    @Override
    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof OsgNetworkTrafficInfoDTO)) {
            return false;
        }
        OsgNetworkTrafficInfoDTO other = (OsgNetworkTrafficInfoDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        List<OsgDhcpInfoDTO> this$records = this.getRecords();
        List<OsgDhcpInfoDTO> other$records = other.getRecords();
        return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OsgNetworkTrafficInfoDTO;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<OsgDhcpInfoDTO> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        return result;
    }

    @JsonPropertyOrder
    private static class OsgDhcpInfoDTO {
        @JsonProperty(value="dhcpsUtil")
        private Integer dhcpsUtil;
        @JsonProperty(value="dhcpsOffer")
        private Integer dhcpsOffer;
        @JsonProperty(value="dhcp6sUtil")
        private Integer dhcps6Util;
        @JsonProperty(value="dhcp6sOffer")
        private Integer dhcps6Offer;

        @Generated
        public Integer getDhcpsUtil() {
            return this.dhcpsUtil;
        }

        @Generated
        public Integer getDhcpsOffer() {
            return this.dhcpsOffer;
        }

        @Generated
        public Integer getDhcps6Util() {
            return this.dhcps6Util;
        }

        @Generated
        public Integer getDhcps6Offer() {
            return this.dhcps6Offer;
        }

        @JsonProperty(value="dhcpsUtil")
        @Generated
        public OsgDhcpInfoDTO setDhcpsUtil(Integer dhcpsUtil) {
            this.dhcpsUtil = dhcpsUtil;
            return this;
        }

        @JsonProperty(value="dhcpsOffer")
        @Generated
        public OsgDhcpInfoDTO setDhcpsOffer(Integer dhcpsOffer) {
            this.dhcpsOffer = dhcpsOffer;
            return this;
        }

        @JsonProperty(value="dhcp6sUtil")
        @Generated
        public OsgDhcpInfoDTO setDhcps6Util(Integer dhcps6Util) {
            this.dhcps6Util = dhcps6Util;
            return this;
        }

        @JsonProperty(value="dhcp6sOffer")
        @Generated
        public OsgDhcpInfoDTO setDhcps6Offer(Integer dhcps6Offer) {
            this.dhcps6Offer = dhcps6Offer;
            return this;
        }

        @Generated
        public String toString() {
            return "OsgNetworkTrafficInfoDTO.OsgDhcpInfoDTO(super=" + super.toString() + ", dhcpsUtil=" + this.getDhcpsUtil() + ", dhcpsOffer=" + this.getDhcpsOffer() + ", dhcps6Util=" + this.getDhcps6Util() + ", dhcps6Offer=" + this.getDhcps6Offer() + ")";
        }

        @Generated
        public OsgDhcpInfoDTO(Integer dhcpsUtil, Integer dhcpsOffer, Integer dhcps6Util, Integer dhcps6Offer) {
            this.dhcpsUtil = dhcpsUtil;
            this.dhcpsOffer = dhcpsOffer;
            this.dhcps6Util = dhcps6Util;
            this.dhcps6Offer = dhcps6Offer;
        }

        @Generated
        public OsgDhcpInfoDTO() {
        }
    }
}

