/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.datatrack.buriedpoint.ap;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.tplink.smb.omada.device.manage.message.body.eap.EapInformBody;
import com.tplink.smb.omada.device.manage.message.inform.ap.WirelessInfo;
import com.tplink.smb.omada.monitor.api.shared.a.c;
import com.tplink.smb.omada.monitor.datatrack.buriedpoint.DeviceBuriedPointInfoDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

@JsonPropertyOrder
public class ApWlanChannelUtilizationInfoDTO
extends DeviceBuriedPointInfoDTO {
    @JsonProperty(value="wSettingsInfos")
    private List<ChannelInfoDTO> wSettingsInfos;

    public static ApWlanChannelUtilizationInfoDTO fromInform(String siteId, String mac, EapInformBody informBody) {
        ArrayList<ChannelInfoDTO> channelInfoDTOList = new ArrayList<ChannelInfoDTO>(4);
        if (Objects.nonNull(informBody.getWSettings2G())) {
            WirelessInfo wSettings2G = informBody.getWSettings2G();
            ChannelInfoDTO channelInfoDTO2G = ApWlanChannelUtilizationInfoDTO.getChannelInfoDTO(wSettings2G, c.a.a());
            channelInfoDTOList.add(channelInfoDTO2G);
        }
        if (Objects.nonNull(informBody.getWSettings5G())) {
            WirelessInfo wSettings5G = informBody.getWSettings5G();
            ChannelInfoDTO channelInfoDTO5G = ApWlanChannelUtilizationInfoDTO.getChannelInfoDTO(wSettings5G, c.b.a());
            channelInfoDTOList.add(channelInfoDTO5G);
        }
        if (Objects.nonNull(informBody.getWSettings5G2())) {
            WirelessInfo wSettings5G2 = informBody.getWSettings5G2();
            ChannelInfoDTO channelInfoDTO5G2 = ApWlanChannelUtilizationInfoDTO.getChannelInfoDTO(wSettings5G2, c.c.a());
            channelInfoDTOList.add(channelInfoDTO5G2);
        }
        if (Objects.nonNull(informBody.getWSettings6G())) {
            WirelessInfo wSettings6G = informBody.getWSettings6G();
            ChannelInfoDTO channelInfoDTO6G = ApWlanChannelUtilizationInfoDTO.getChannelInfoDTO(wSettings6G, c.d.a());
            channelInfoDTOList.add(channelInfoDTO6G);
        }
        if (!CollectionUtils.isEmpty(channelInfoDTOList)) {
            ApWlanChannelUtilizationInfoDTO apWlanChannelUtilizationInfo = new ApWlanChannelUtilizationInfoDTO();
            apWlanChannelUtilizationInfo.setMac(mac);
            apWlanChannelUtilizationInfo.setSiteId(siteId);
            apWlanChannelUtilizationInfo.setWSettingsInfos(channelInfoDTOList);
            return apWlanChannelUtilizationInfo;
        }
        return null;
    }

    private static ChannelInfoDTO getChannelInfoDTO(WirelessInfo wirelessInfo, Integer rid) {
        ChannelInfoDTO channelInfoDTO = new ChannelInfoDTO();
        channelInfoDTO.setRid(rid);
        channelInfoDTO.setChannel(wirelessInfo.getChannel());
        channelInfoDTO.setRdMode(wirelessInfo.getRdMode());
        channelInfoDTO.setBandWidth(wirelessInfo.getBandWidth());
        channelInfoDTO.setTxPower(wirelessInfo.getTxPower());
        channelInfoDTO.setTxRate(wirelessInfo.getTxRate());
        if (wirelessInfo.getInterUtil() != null) {
            channelInfoDTO.setInterUti(wirelessInfo.getInterUtil());
            channelInfoDTO.setTxUti(wirelessInfo.getTxUtil());
            channelInfoDTO.setRxUti(wirelessInfo.getRxUtil());
        } else {
            channelInfoDTO.setBusyUti(wirelessInfo.getBusyUtil());
        }
        return channelInfoDTO;
    }

    @Generated
    public List<ChannelInfoDTO> getWSettingsInfos() {
        return this.wSettingsInfos;
    }

    @JsonProperty(value="wSettingsInfos")
    @Generated
    public ApWlanChannelUtilizationInfoDTO setWSettingsInfos(List<ChannelInfoDTO> wSettingsInfos) {
        this.wSettingsInfos = wSettingsInfos;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "ApWlanChannelUtilizationInfoDTO(super=" + super.toString() + ", wSettingsInfos=" + this.getWSettingsInfos() + ")";
    }

    @Generated
    public ApWlanChannelUtilizationInfoDTO(List<ChannelInfoDTO> wSettingsInfos) {
        this.wSettingsInfos = wSettingsInfos;
    }

    @Generated
    public ApWlanChannelUtilizationInfoDTO() {
    }

    @Override
    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof ApWlanChannelUtilizationInfoDTO)) {
            return false;
        }
        ApWlanChannelUtilizationInfoDTO other = (ApWlanChannelUtilizationInfoDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        List<ChannelInfoDTO> this$wSettingsInfos = this.getWSettingsInfos();
        List<ChannelInfoDTO> other$wSettingsInfos = other.getWSettingsInfos();
        return !(this$wSettingsInfos == null ? other$wSettingsInfos != null : !((Object)this$wSettingsInfos).equals(other$wSettingsInfos));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApWlanChannelUtilizationInfoDTO;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<ChannelInfoDTO> $wSettingsInfos = this.getWSettingsInfos();
        result = result * 59 + ($wSettingsInfos == null ? 43 : ((Object)$wSettingsInfos).hashCode());
        return result;
    }

    @JsonPropertyOrder
    public static class ChannelInfoDTO {
        @JsonProperty(value="rid")
        private Integer rid;
        @JsonProperty(value="ch")
        private String channel;
        @JsonProperty(value="txUti")
        private Integer txUti;
        @JsonProperty(value="rxUti")
        private Integer rxUti;
        @JsonProperty(value="interUti")
        private Integer interUti;
        @JsonProperty(value="busyUti")
        private Integer busyUti;
        @JsonProperty(value="bw")
        private String bandWidth;
        @JsonProperty(value="rdMode")
        private String rdMode;
        @JsonProperty(value="txR")
        private String txRate;
        @JsonProperty(value="txPower")
        private String txPower;

        @Generated
        public Integer getRid() {
            return this.rid;
        }

        @Generated
        public String getChannel() {
            return this.channel;
        }

        @Generated
        public Integer getTxUti() {
            return this.txUti;
        }

        @Generated
        public Integer getRxUti() {
            return this.rxUti;
        }

        @Generated
        public Integer getInterUti() {
            return this.interUti;
        }

        @Generated
        public Integer getBusyUti() {
            return this.busyUti;
        }

        @Generated
        public String getBandWidth() {
            return this.bandWidth;
        }

        @Generated
        public String getRdMode() {
            return this.rdMode;
        }

        @Generated
        public String getTxRate() {
            return this.txRate;
        }

        @Generated
        public String getTxPower() {
            return this.txPower;
        }

        @JsonProperty(value="rid")
        @Generated
        public ChannelInfoDTO setRid(Integer rid) {
            this.rid = rid;
            return this;
        }

        @JsonProperty(value="ch")
        @Generated
        public ChannelInfoDTO setChannel(String channel) {
            this.channel = channel;
            return this;
        }

        @JsonProperty(value="txUti")
        @Generated
        public ChannelInfoDTO setTxUti(Integer txUti) {
            this.txUti = txUti;
            return this;
        }

        @JsonProperty(value="rxUti")
        @Generated
        public ChannelInfoDTO setRxUti(Integer rxUti) {
            this.rxUti = rxUti;
            return this;
        }

        @JsonProperty(value="interUti")
        @Generated
        public ChannelInfoDTO setInterUti(Integer interUti) {
            this.interUti = interUti;
            return this;
        }

        @JsonProperty(value="busyUti")
        @Generated
        public ChannelInfoDTO setBusyUti(Integer busyUti) {
            this.busyUti = busyUti;
            return this;
        }

        @JsonProperty(value="bw")
        @Generated
        public ChannelInfoDTO setBandWidth(String bandWidth) {
            this.bandWidth = bandWidth;
            return this;
        }

        @JsonProperty(value="rdMode")
        @Generated
        public ChannelInfoDTO setRdMode(String rdMode) {
            this.rdMode = rdMode;
            return this;
        }

        @JsonProperty(value="txR")
        @Generated
        public ChannelInfoDTO setTxRate(String txRate) {
            this.txRate = txRate;
            return this;
        }

        @JsonProperty(value="txPower")
        @Generated
        public ChannelInfoDTO setTxPower(String txPower) {
            this.txPower = txPower;
            return this;
        }

        @Generated
        public String toString() {
            return "ApWlanChannelUtilizationInfoDTO.ChannelInfoDTO(super=" + super.toString() + ", rid=" + this.getRid() + ", channel=" + this.getChannel() + ", txUti=" + this.getTxUti() + ", rxUti=" + this.getRxUti() + ", interUti=" + this.getInterUti() + ", busyUti=" + this.getBusyUti() + ", bandWidth=" + this.getBandWidth() + ", rdMode=" + this.getRdMode() + ", txRate=" + this.getTxRate() + ", txPower=" + this.getTxPower() + ")";
        }

        @Generated
        public ChannelInfoDTO(Integer rid, String channel, Integer txUti, Integer rxUti, Integer interUti, Integer busyUti, String bandWidth, String rdMode, String txRate, String txPower) {
            this.rid = rid;
            this.channel = channel;
            this.txUti = txUti;
            this.rxUti = rxUti;
            this.interUti = interUti;
            this.busyUti = busyUti;
            this.bandWidth = bandWidth;
            this.rdMode = rdMode;
            this.txRate = txRate;
            this.txPower = txPower;
        }

        @Generated
        public ChannelInfoDTO() {
        }
    }
}

