/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.datatrack.buriedpoint.ap;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.device.manage.message.body.eap.EapInformBody;
import com.tplink.smb.omada.monitor.datatrack.buriedpoint.DeviceBuriedPointInfoDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

@JsonPropertyOrder
public class ApMeshInfoDTO
extends DeviceBuriedPointInfoDTO {
    @JsonProperty(value="childApInfos")
    private List<ChildApInfoDTO> childApInfos;
    @JsonProperty(value="childAPRec")
    private List<ChildApRecDTO> childAPRec;
    @JsonProperty(value="status")
    private Integer status;
    @JsonProperty(value="meshRid")
    private Integer meshRid;

    public static ApMeshInfoDTO fromInform(String siteId, String mac, EapInformBody informBody) {
        if (Objects.nonNull(informBody.getMeshInfo())) {
            ApMeshInfoDTO apMeshInfo = new ApMeshInfoDTO();
            apMeshInfo.setMac(mac);
            apMeshInfo.setSiteId(siteId);
            apMeshInfo.setStatus(informBody.getMeshInfo().getStatus());
            apMeshInfo.setMeshRid(informBody.getMeshInfo().getMeshRid());
            if (Objects.nonNull(informBody.getMeshInfo().getChildAPs())) {
                ArrayList<ChildApInfoDTO> childApInfoDTOList = new ArrayList<ChildApInfoDTO>();
                informBody.getMeshInfo().getChildAPs().forEach(childAp -> {
                    ChildApInfoDTO childApInfoDTO = new ChildApInfoDTO();
                    childApInfoDTO.setChildApMac(childAp.getMac());
                    childApInfoDTO.setRssi(childAp.getRssi());
                    childApInfoDTOList.add(childApInfoDTO);
                });
                apMeshInfo.setChildApInfos(childApInfoDTOList);
            }
            if (!CollectionUtils.isEmpty((Collection)informBody.getMeshInfo().getChildApRec())) {
                ArrayList<ChildApRecDTO> childApRecDTOList = new ArrayList<ChildApRecDTO>();
                informBody.getMeshInfo().getChildApRec().forEach(childApRec -> {
                    ChildApRecDTO childApRecDTO = new ChildApRecDTO();
                    childApRecDTO.setMac(childApRec.getMac());
                    childApRecDTO.setAdoptErrCode(childApRec.getAdoptErrCode());
                    childApRecDTOList.add(childApRecDTO);
                });
                apMeshInfo.setChildAPRec(childApRecDTOList);
            }
            if (CollectionUtils.isEmpty(apMeshInfo.childApInfos) && CollectionUtils.isEmpty(apMeshInfo.childAPRec)) {
                return null;
            }
            return apMeshInfo;
        }
        return null;
    }

    @Generated
    public List<ChildApInfoDTO> getChildApInfos() {
        return this.childApInfos;
    }

    @Generated
    public List<ChildApRecDTO> getChildAPRec() {
        return this.childAPRec;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public Integer getMeshRid() {
        return this.meshRid;
    }

    @JsonProperty(value="childApInfos")
    @Generated
    public ApMeshInfoDTO setChildApInfos(List<ChildApInfoDTO> childApInfos) {
        this.childApInfos = childApInfos;
        return this;
    }

    @JsonProperty(value="childAPRec")
    @Generated
    public ApMeshInfoDTO setChildAPRec(List<ChildApRecDTO> childAPRec) {
        this.childAPRec = childAPRec;
        return this;
    }

    @JsonProperty(value="status")
    @Generated
    public ApMeshInfoDTO setStatus(Integer status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="meshRid")
    @Generated
    public ApMeshInfoDTO setMeshRid(Integer meshRid) {
        this.meshRid = meshRid;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "ApMeshInfoDTO(super=" + super.toString() + ", childApInfos=" + this.getChildApInfos() + ", childAPRec=" + this.getChildAPRec() + ", status=" + this.getStatus() + ", meshRid=" + this.getMeshRid() + ")";
    }

    @Generated
    public ApMeshInfoDTO(List<ChildApInfoDTO> childApInfos, List<ChildApRecDTO> childAPRec, Integer status, Integer meshRid) {
        this.childApInfos = childApInfos;
        this.childAPRec = childAPRec;
        this.status = status;
        this.meshRid = meshRid;
    }

    @Generated
    public ApMeshInfoDTO() {
    }

    @Override
    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof ApMeshInfoDTO)) {
            return false;
        }
        ApMeshInfoDTO other = (ApMeshInfoDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$meshRid = this.getMeshRid();
        Integer other$meshRid = other.getMeshRid();
        if (this$meshRid == null ? other$meshRid != null : !((Object)this$meshRid).equals(other$meshRid)) {
            return false;
        }
        List<ChildApInfoDTO> this$childApInfos = this.getChildApInfos();
        List<ChildApInfoDTO> other$childApInfos = other.getChildApInfos();
        if (this$childApInfos == null ? other$childApInfos != null : !((Object)this$childApInfos).equals(other$childApInfos)) {
            return false;
        }
        List<ChildApRecDTO> this$childAPRec = this.getChildAPRec();
        List<ChildApRecDTO> other$childAPRec = other.getChildAPRec();
        return !(this$childAPRec == null ? other$childAPRec != null : !((Object)this$childAPRec).equals(other$childAPRec));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApMeshInfoDTO;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $meshRid = this.getMeshRid();
        result = result * 59 + ($meshRid == null ? 43 : ((Object)$meshRid).hashCode());
        List<ChildApInfoDTO> $childApInfos = this.getChildApInfos();
        result = result * 59 + ($childApInfos == null ? 43 : ((Object)$childApInfos).hashCode());
        List<ChildApRecDTO> $childAPRec = this.getChildAPRec();
        result = result * 59 + ($childAPRec == null ? 43 : ((Object)$childAPRec).hashCode());
        return result;
    }

    @JsonPropertyOrder
    private static class ChildApRecDTO {
        @JsonProperty(value="mac")
        @a
        private String mac;
        @JsonProperty(value="adoptErrCode")
        private Integer adoptErrCode;

        @Generated
        public String getMac() {
            return this.mac;
        }

        @Generated
        public Integer getAdoptErrCode() {
            return this.adoptErrCode;
        }

        @JsonProperty(value="mac")
        @Generated
        public ChildApRecDTO setMac(String mac) {
            this.mac = mac;
            return this;
        }

        @JsonProperty(value="adoptErrCode")
        @Generated
        public ChildApRecDTO setAdoptErrCode(Integer adoptErrCode) {
            this.adoptErrCode = adoptErrCode;
            return this;
        }

        @Generated
        public String toString() {
            return "ApMeshInfoDTO.ChildApRecDTO(super=" + super.toString() + ", mac=" + this.getMac() + ", adoptErrCode=" + this.getAdoptErrCode() + ")";
        }

        @Generated
        public ChildApRecDTO(String mac, Integer adoptErrCode) {
            this.mac = mac;
            this.adoptErrCode = adoptErrCode;
        }

        @Generated
        public ChildApRecDTO() {
        }
    }

    @JsonPropertyOrder
    private static class ChildApInfoDTO {
        @JsonProperty(value="childApMac")
        @a
        private String childApMac;
        @JsonProperty(value="rssi")
        private Integer rssi;

        @Generated
        public String getChildApMac() {
            return this.childApMac;
        }

        @Generated
        public Integer getRssi() {
            return this.rssi;
        }

        @JsonProperty(value="childApMac")
        @Generated
        public ChildApInfoDTO setChildApMac(String childApMac) {
            this.childApMac = childApMac;
            return this;
        }

        @JsonProperty(value="rssi")
        @Generated
        public ChildApInfoDTO setRssi(Integer rssi) {
            this.rssi = rssi;
            return this;
        }

        @Generated
        public String toString() {
            return "ApMeshInfoDTO.ChildApInfoDTO(super=" + super.toString() + ", childApMac=" + this.getChildApMac() + ", rssi=" + this.getRssi() + ")";
        }

        @Generated
        public ChildApInfoDTO(String childApMac, Integer rssi) {
            this.childApMac = childApMac;
            this.rssi = rssi;
        }

        @Generated
        public ChildApInfoDTO() {
        }
    }
}

