/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.datatrack.buriedpoint.ap;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.tplink.smb.omada.device.manage.message.body.eap.EapInformBody;
import com.tplink.smb.omada.monitor.datatrack.buriedpoint.DeviceBuriedPointInfoDTO;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

@JsonPropertyOrder
public class ApDeviceInfoDTO
extends DeviceBuriedPointInfoDTO {
    @JsonProperty(value="cpuUti")
    private Integer cpuUti;
    @JsonProperty(value="memUti")
    private Integer memUti;
    @JsonProperty(value="temp")
    private List<Integer> temp;
    @JsonProperty(value="nf")
    private List<Integer> noiseFloor;
    @JsonProperty(value="cpuDetail")
    private CpuDetail cpuDetail;
    @JsonProperty(value="uptime")
    private String uptime;
    @JsonProperty(value="loopBack")
    private Integer loopBack;
    @JsonProperty(value="powerMode")
    private Integer powerMode;
    @JsonProperty(value="powerModeArray")
    private List<Integer> powerModeArray;
    @JsonProperty(value="p2p")
    private Boolean p2p;

    public static ApDeviceInfoDTO fromInform(String siteId, String mac, EapInformBody informBody) {
        if (Objects.nonNull(informBody.getDeviceInfo())) {
            ApDeviceInfoDTO apDeviceInfo = new ApDeviceInfoDTO();
            apDeviceInfo.setMac(mac);
            apDeviceInfo.setSiteId(siteId);
            apDeviceInfo.setCpuUti(informBody.getDeviceInfo().getCpuUtil());
            apDeviceInfo.setMemUti(informBody.getDeviceInfo().getMemUtil());
            apDeviceInfo.setTemp(informBody.getDeviceInfo().getTemp());
            apDeviceInfo.setNoiseFloor(informBody.getDeviceInfo().getNoiseFloor());
            apDeviceInfo.setCpuDetail(ApDeviceInfoDTO.transformFromInform(informBody.getDeviceInfo().getCpuDetail()));
            apDeviceInfo.setUptime(informBody.getDeviceInfo().getUpTime());
            apDeviceInfo.setLoopBack(informBody.getDeviceInfo().getLoopBack());
            apDeviceInfo.setPowerMode(informBody.getDeviceInfo().getPowerMode());
            apDeviceInfo.setPowerModeArray(informBody.getDeviceInfo().getPowerModeArray());
            apDeviceInfo.setP2p(informBody.getDeviceInfo().getP2p());
            return apDeviceInfo;
        }
        return null;
    }

    private static CpuDetail transformFromInform(com.tplink.smb.omada.device.manage.message.inform.ap.CpuDetail cpuDetail) {
        if (Objects.nonNull(cpuDetail)) {
            CpuDetail transformedCpuDetail = new CpuDetail();
            if (Objects.equals(cpuDetail.getCpuNum(), 2)) {
                transformedCpuDetail.setCpuNum(cpuDetail.getCpuNum());
                transformedCpuDetail.setCpuUtiArray1((Integer)cpuDetail.getCpuUtiArray().get(0));
                transformedCpuDetail.setCpuUtiArray2((Integer)cpuDetail.getCpuUtiArray().get(1));
            }
            if (Objects.equals(cpuDetail.getCpuNum(), 4)) {
                transformedCpuDetail.setCpuNum(cpuDetail.getCpuNum());
                transformedCpuDetail.setCpuUtiArray1((Integer)cpuDetail.getCpuUtiArray().get(0));
                transformedCpuDetail.setCpuUtiArray2((Integer)cpuDetail.getCpuUtiArray().get(1));
                transformedCpuDetail.setCpuUtiArray3((Integer)cpuDetail.getCpuUtiArray().get(2));
                transformedCpuDetail.setCpuUtiArray4((Integer)cpuDetail.getCpuUtiArray().get(3));
            }
            return transformedCpuDetail;
        }
        return null;
    }

    @Generated
    public Integer getCpuUti() {
        return this.cpuUti;
    }

    @Generated
    public Integer getMemUti() {
        return this.memUti;
    }

    @Generated
    public List<Integer> getTemp() {
        return this.temp;
    }

    @Generated
    public List<Integer> getNoiseFloor() {
        return this.noiseFloor;
    }

    @Generated
    public CpuDetail getCpuDetail() {
        return this.cpuDetail;
    }

    @Generated
    public String getUptime() {
        return this.uptime;
    }

    @Generated
    public Integer getLoopBack() {
        return this.loopBack;
    }

    @Generated
    public Integer getPowerMode() {
        return this.powerMode;
    }

    @Generated
    public List<Integer> getPowerModeArray() {
        return this.powerModeArray;
    }

    @Generated
    public Boolean getP2p() {
        return this.p2p;
    }

    @JsonProperty(value="cpuUti")
    @Generated
    public ApDeviceInfoDTO setCpuUti(Integer cpuUti) {
        this.cpuUti = cpuUti;
        return this;
    }

    @JsonProperty(value="memUti")
    @Generated
    public ApDeviceInfoDTO setMemUti(Integer memUti) {
        this.memUti = memUti;
        return this;
    }

    @JsonProperty(value="temp")
    @Generated
    public ApDeviceInfoDTO setTemp(List<Integer> temp) {
        this.temp = temp;
        return this;
    }

    @JsonProperty(value="nf")
    @Generated
    public ApDeviceInfoDTO setNoiseFloor(List<Integer> noiseFloor) {
        this.noiseFloor = noiseFloor;
        return this;
    }

    @JsonProperty(value="cpuDetail")
    @Generated
    public ApDeviceInfoDTO setCpuDetail(CpuDetail cpuDetail) {
        this.cpuDetail = cpuDetail;
        return this;
    }

    @JsonProperty(value="uptime")
    @Generated
    public ApDeviceInfoDTO setUptime(String uptime) {
        this.uptime = uptime;
        return this;
    }

    @JsonProperty(value="loopBack")
    @Generated
    public ApDeviceInfoDTO setLoopBack(Integer loopBack) {
        this.loopBack = loopBack;
        return this;
    }

    @JsonProperty(value="powerMode")
    @Generated
    public ApDeviceInfoDTO setPowerMode(Integer powerMode) {
        this.powerMode = powerMode;
        return this;
    }

    @JsonProperty(value="powerModeArray")
    @Generated
    public ApDeviceInfoDTO setPowerModeArray(List<Integer> powerModeArray) {
        this.powerModeArray = powerModeArray;
        return this;
    }

    @JsonProperty(value="p2p")
    @Generated
    public ApDeviceInfoDTO setP2p(Boolean p2p) {
        this.p2p = p2p;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "ApDeviceInfoDTO(super=" + super.toString() + ", cpuUti=" + this.getCpuUti() + ", memUti=" + this.getMemUti() + ", temp=" + this.getTemp() + ", noiseFloor=" + this.getNoiseFloor() + ", cpuDetail=" + this.getCpuDetail() + ", uptime=" + this.getUptime() + ", loopBack=" + this.getLoopBack() + ", powerMode=" + this.getPowerMode() + ", powerModeArray=" + this.getPowerModeArray() + ", p2p=" + this.getP2p() + ")";
    }

    @Generated
    public ApDeviceInfoDTO(Integer cpuUti, Integer memUti, List<Integer> temp, List<Integer> noiseFloor, CpuDetail cpuDetail, String uptime, Integer loopBack, Integer powerMode, List<Integer> powerModeArray, Boolean p2p) {
        this.cpuUti = cpuUti;
        this.memUti = memUti;
        this.temp = temp;
        this.noiseFloor = noiseFloor;
        this.cpuDetail = cpuDetail;
        this.uptime = uptime;
        this.loopBack = loopBack;
        this.powerMode = powerMode;
        this.powerModeArray = powerModeArray;
        this.p2p = p2p;
    }

    @Generated
    public ApDeviceInfoDTO() {
    }

    @Override
    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof ApDeviceInfoDTO)) {
            return false;
        }
        ApDeviceInfoDTO other = (ApDeviceInfoDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$cpuUti = this.getCpuUti();
        Integer other$cpuUti = other.getCpuUti();
        if (this$cpuUti == null ? other$cpuUti != null : !((Object)this$cpuUti).equals(other$cpuUti)) {
            return false;
        }
        Integer this$memUti = this.getMemUti();
        Integer other$memUti = other.getMemUti();
        if (this$memUti == null ? other$memUti != null : !((Object)this$memUti).equals(other$memUti)) {
            return false;
        }
        Integer this$loopBack = this.getLoopBack();
        Integer other$loopBack = other.getLoopBack();
        if (this$loopBack == null ? other$loopBack != null : !((Object)this$loopBack).equals(other$loopBack)) {
            return false;
        }
        Integer this$powerMode = this.getPowerMode();
        Integer other$powerMode = other.getPowerMode();
        if (this$powerMode == null ? other$powerMode != null : !((Object)this$powerMode).equals(other$powerMode)) {
            return false;
        }
        Boolean this$p2p = this.getP2p();
        Boolean other$p2p = other.getP2p();
        if (this$p2p == null ? other$p2p != null : !((Object)this$p2p).equals(other$p2p)) {
            return false;
        }
        List<Integer> this$temp = this.getTemp();
        List<Integer> other$temp = other.getTemp();
        if (this$temp == null ? other$temp != null : !((Object)this$temp).equals(other$temp)) {
            return false;
        }
        List<Integer> this$noiseFloor = this.getNoiseFloor();
        List<Integer> other$noiseFloor = other.getNoiseFloor();
        if (this$noiseFloor == null ? other$noiseFloor != null : !((Object)this$noiseFloor).equals(other$noiseFloor)) {
            return false;
        }
        CpuDetail this$cpuDetail = this.getCpuDetail();
        CpuDetail other$cpuDetail = other.getCpuDetail();
        if (this$cpuDetail == null ? other$cpuDetail != null : !this$cpuDetail.equals(other$cpuDetail)) {
            return false;
        }
        String this$uptime = this.getUptime();
        String other$uptime = other.getUptime();
        if (this$uptime == null ? other$uptime != null : !this$uptime.equals(other$uptime)) {
            return false;
        }
        List<Integer> this$powerModeArray = this.getPowerModeArray();
        List<Integer> other$powerModeArray = other.getPowerModeArray();
        return !(this$powerModeArray == null ? other$powerModeArray != null : !((Object)this$powerModeArray).equals(other$powerModeArray));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApDeviceInfoDTO;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $cpuUti = this.getCpuUti();
        result = result * 59 + ($cpuUti == null ? 43 : ((Object)$cpuUti).hashCode());
        Integer $memUti = this.getMemUti();
        result = result * 59 + ($memUti == null ? 43 : ((Object)$memUti).hashCode());
        Integer $loopBack = this.getLoopBack();
        result = result * 59 + ($loopBack == null ? 43 : ((Object)$loopBack).hashCode());
        Integer $powerMode = this.getPowerMode();
        result = result * 59 + ($powerMode == null ? 43 : ((Object)$powerMode).hashCode());
        Boolean $p2p = this.getP2p();
        result = result * 59 + ($p2p == null ? 43 : ((Object)$p2p).hashCode());
        List<Integer> $temp = this.getTemp();
        result = result * 59 + ($temp == null ? 43 : ((Object)$temp).hashCode());
        List<Integer> $noiseFloor = this.getNoiseFloor();
        result = result * 59 + ($noiseFloor == null ? 43 : ((Object)$noiseFloor).hashCode());
        CpuDetail $cpuDetail = this.getCpuDetail();
        result = result * 59 + ($cpuDetail == null ? 43 : $cpuDetail.hashCode());
        String $uptime = this.getUptime();
        result = result * 59 + ($uptime == null ? 43 : $uptime.hashCode());
        List<Integer> $powerModeArray = this.getPowerModeArray();
        result = result * 59 + ($powerModeArray == null ? 43 : ((Object)$powerModeArray).hashCode());
        return result;
    }

    @JsonPropertyOrder
    private static class CpuDetail {
        @JsonProperty(value="cpuNum")
        private Integer cpuNum;
        @JsonProperty(value="cpuUtiArray1")
        private Integer cpuUtiArray1;
        @JsonProperty(value="cpuUtiArray2")
        private Integer cpuUtiArray2;
        @JsonProperty(value="cpuUtiArray3")
        private Integer cpuUtiArray3;
        @JsonProperty(value="cpuUtiArray4")
        private Integer cpuUtiArray4;

        @Generated
        public Integer getCpuNum() {
            return this.cpuNum;
        }

        @Generated
        public Integer getCpuUtiArray1() {
            return this.cpuUtiArray1;
        }

        @Generated
        public Integer getCpuUtiArray2() {
            return this.cpuUtiArray2;
        }

        @Generated
        public Integer getCpuUtiArray3() {
            return this.cpuUtiArray3;
        }

        @Generated
        public Integer getCpuUtiArray4() {
            return this.cpuUtiArray4;
        }

        @JsonProperty(value="cpuNum")
        @Generated
        public CpuDetail setCpuNum(Integer cpuNum) {
            this.cpuNum = cpuNum;
            return this;
        }

        @JsonProperty(value="cpuUtiArray1")
        @Generated
        public CpuDetail setCpuUtiArray1(Integer cpuUtiArray1) {
            this.cpuUtiArray1 = cpuUtiArray1;
            return this;
        }

        @JsonProperty(value="cpuUtiArray2")
        @Generated
        public CpuDetail setCpuUtiArray2(Integer cpuUtiArray2) {
            this.cpuUtiArray2 = cpuUtiArray2;
            return this;
        }

        @JsonProperty(value="cpuUtiArray3")
        @Generated
        public CpuDetail setCpuUtiArray3(Integer cpuUtiArray3) {
            this.cpuUtiArray3 = cpuUtiArray3;
            return this;
        }

        @JsonProperty(value="cpuUtiArray4")
        @Generated
        public CpuDetail setCpuUtiArray4(Integer cpuUtiArray4) {
            this.cpuUtiArray4 = cpuUtiArray4;
            return this;
        }

        @Generated
        public String toString() {
            return "ApDeviceInfoDTO.CpuDetail(super=" + super.toString() + ", cpuNum=" + this.getCpuNum() + ", cpuUtiArray1=" + this.getCpuUtiArray1() + ", cpuUtiArray2=" + this.getCpuUtiArray2() + ", cpuUtiArray3=" + this.getCpuUtiArray3() + ", cpuUtiArray4=" + this.getCpuUtiArray4() + ")";
        }

        @Generated
        public CpuDetail(Integer cpuNum, Integer cpuUtiArray1, Integer cpuUtiArray2, Integer cpuUtiArray3, Integer cpuUtiArray4) {
            this.cpuNum = cpuNum;
            this.cpuUtiArray1 = cpuUtiArray1;
            this.cpuUtiArray2 = cpuUtiArray2;
            this.cpuUtiArray3 = cpuUtiArray3;
            this.cpuUtiArray4 = cpuUtiArray4;
        }

        @Generated
        public CpuDetail() {
        }
    }
}

