/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.monitor.datatrack.buriedpoint.ap;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.device.manage.message.body.eap.EapInformBody;
import com.tplink.smb.omada.device.manage.message.inform.ap.connrec.ConnectRecord;
import com.tplink.smb.omada.monitor.datatrack.buriedpoint.DeviceBuriedPointInfoDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

@JsonPropertyOrder
public class ApConnRecInfoDTO
extends DeviceBuriedPointInfoDTO {
    @JsonProperty(value="ssidTbl")
    private List<SsidTableDTO> ssidTables;
    @JsonProperty(value="record")
    private List<ConnectionRecordInfoDTO> connRecInfos;

    public static ApConnRecInfoDTO fromInform(String siteId, String mac, EapInformBody informBody) {
        if (Objects.nonNull(informBody.getConnectRecord())) {
            ArrayList<ConnectionRecordInfoDTO> connectionRecordInfoDTOList = new ArrayList<ConnectionRecordInfoDTO>();
            ArrayList<SsidTableDTO> ssidTableDTOList = new ArrayList<SsidTableDTO>();
            ApConnRecInfoDTO apConnRecInfo = new ApConnRecInfoDTO();
            apConnRecInfo.setMac(mac);
            apConnRecInfo.setSiteId(siteId);
            ConnectRecord connectRecord = informBody.getConnectRecord();
            connectRecord.getSsidTable().forEach(ssidItem -> {
                SsidTableDTO ssidTableDTO = new SsidTableDTO();
                ssidTableDTO.setIndex(ssidItem.getIndex());
                ssidTableDTO.setSsid(ssidItem.getSsid());
                ssidTableDTOList.add(ssidTableDTO);
            });
            connectRecord.getConnectRecordStats().forEach(connectRecordStat -> {
                ConnectionRecordInfoDTO connectionRecordInfoDTO = new ConnectionRecordInfoDTO();
                connectionRecordInfoDTO.setClientMac(connectRecordStat.getMac());
                connectionRecordInfoDTO.setReAssocCnt(connectRecordStat.getReAssociationCnt());
                connectionRecordInfoDTO.setReAuthCnt(connectRecordStat.getReAuthenticationCnt());
                ArrayList<RecordItemDTO> recordItemDTOList = new ArrayList<RecordItemDTO>();
                connectRecordStat.getItems().forEach(item -> {
                    RecordItemDTO recordItemDTO = new RecordItemDTO();
                    recordItemDTO.setTotalDur(item.getTotalDuration());
                    recordItemDTO.setStep(item.getStep());
                    recordItemDTO.setSsidIndex(item.getSsidIndex());
                    recordItemDTO.setRadioID(item.getRadioId());
                    ArrayList<ErrorItem> errorItemList = new ArrayList<ErrorItem>();
                    item.getErrorItems().forEach(connErrStepRecord -> {
                        ErrorItem errorItem = new ErrorItem();
                        errorItem.setDuration(connErrStepRecord.getDuration());
                        errorItem.setErrCode(connErrStepRecord.getErrorCode());
                        errorItem.setSrvDelay(connErrStepRecord.getServerDelay());
                        errorItem.setTime(connErrStepRecord.getTimestamp());
                        errorItemList.add(errorItem);
                    });
                    recordItemDTO.setErrorItem(errorItemList);
                    recordItemDTOList.add(recordItemDTO);
                });
                connectionRecordInfoDTO.setItems(recordItemDTOList);
                connectionRecordInfoDTOList.add(connectionRecordInfoDTO);
            });
            apConnRecInfo.setSsidTables(ssidTableDTOList);
            apConnRecInfo.setConnRecInfos(connectionRecordInfoDTOList);
            if (CollectionUtils.isEmpty(apConnRecInfo.connRecInfos)) {
                return null;
            }
            return apConnRecInfo;
        }
        return null;
    }

    @Generated
    public List<SsidTableDTO> getSsidTables() {
        return this.ssidTables;
    }

    @Generated
    public List<ConnectionRecordInfoDTO> getConnRecInfos() {
        return this.connRecInfos;
    }

    @JsonProperty(value="ssidTbl")
    @Generated
    public ApConnRecInfoDTO setSsidTables(List<SsidTableDTO> ssidTables) {
        this.ssidTables = ssidTables;
        return this;
    }

    @JsonProperty(value="record")
    @Generated
    public ApConnRecInfoDTO setConnRecInfos(List<ConnectionRecordInfoDTO> connRecInfos) {
        this.connRecInfos = connRecInfos;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "ApConnRecInfoDTO(super=" + super.toString() + ", ssidTables=" + this.getSsidTables() + ", connRecInfos=" + this.getConnRecInfos() + ")";
    }

    @Generated
    public ApConnRecInfoDTO(List<SsidTableDTO> ssidTables, List<ConnectionRecordInfoDTO> connRecInfos) {
        this.ssidTables = ssidTables;
        this.connRecInfos = connRecInfos;
    }

    @Generated
    public ApConnRecInfoDTO() {
    }

    @Override
    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof ApConnRecInfoDTO)) {
            return false;
        }
        ApConnRecInfoDTO other = (ApConnRecInfoDTO)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        List<SsidTableDTO> this$ssidTables = this.getSsidTables();
        List<SsidTableDTO> other$ssidTables = other.getSsidTables();
        if (this$ssidTables == null ? other$ssidTables != null : !((Object)this$ssidTables).equals(other$ssidTables)) {
            return false;
        }
        List<ConnectionRecordInfoDTO> this$connRecInfos = this.getConnRecInfos();
        List<ConnectionRecordInfoDTO> other$connRecInfos = other.getConnRecInfos();
        return !(this$connRecInfos == null ? other$connRecInfos != null : !((Object)this$connRecInfos).equals(other$connRecInfos));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApConnRecInfoDTO;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<SsidTableDTO> $ssidTables = this.getSsidTables();
        result = result * 59 + ($ssidTables == null ? 43 : ((Object)$ssidTables).hashCode());
        List<ConnectionRecordInfoDTO> $connRecInfos = this.getConnRecInfos();
        result = result * 59 + ($connRecInfos == null ? 43 : ((Object)$connRecInfos).hashCode());
        return result;
    }

    @JsonPropertyOrder
    private static class ConnectionRecordInfoDTO {
        @JsonProperty(value="mac")
        @a
        private String clientMac;
        @JsonProperty(value="reAssocCnt")
        private Integer reAssocCnt;
        @JsonProperty(value="reAuthCnt")
        private Integer reAuthCnt;
        @JsonProperty(value="items")
        private List<RecordItemDTO> items;

        @Generated
        public String getClientMac() {
            return this.clientMac;
        }

        @Generated
        public Integer getReAssocCnt() {
            return this.reAssocCnt;
        }

        @Generated
        public Integer getReAuthCnt() {
            return this.reAuthCnt;
        }

        @Generated
        public List<RecordItemDTO> getItems() {
            return this.items;
        }

        @JsonProperty(value="mac")
        @Generated
        public ConnectionRecordInfoDTO setClientMac(String clientMac) {
            this.clientMac = clientMac;
            return this;
        }

        @JsonProperty(value="reAssocCnt")
        @Generated
        public ConnectionRecordInfoDTO setReAssocCnt(Integer reAssocCnt) {
            this.reAssocCnt = reAssocCnt;
            return this;
        }

        @JsonProperty(value="reAuthCnt")
        @Generated
        public ConnectionRecordInfoDTO setReAuthCnt(Integer reAuthCnt) {
            this.reAuthCnt = reAuthCnt;
            return this;
        }

        @JsonProperty(value="items")
        @Generated
        public ConnectionRecordInfoDTO setItems(List<RecordItemDTO> items) {
            this.items = items;
            return this;
        }

        @Generated
        public String toString() {
            return "ApConnRecInfoDTO.ConnectionRecordInfoDTO(super=" + super.toString() + ", clientMac=" + this.getClientMac() + ", reAssocCnt=" + this.getReAssocCnt() + ", reAuthCnt=" + this.getReAuthCnt() + ", items=" + this.getItems() + ")";
        }

        @Generated
        public ConnectionRecordInfoDTO(String clientMac, Integer reAssocCnt, Integer reAuthCnt, List<RecordItemDTO> items) {
            this.clientMac = clientMac;
            this.reAssocCnt = reAssocCnt;
            this.reAuthCnt = reAuthCnt;
            this.items = items;
        }

        @Generated
        public ConnectionRecordInfoDTO() {
        }
    }

    @JsonPropertyOrder
    private static class RecordItemDTO {
        @JsonProperty(value="rid")
        private Integer radioID;
        @JsonProperty(value="ssidIndex")
        private Integer ssidIndex;
        @JsonProperty(value="totalDur")
        private Long totalDur;
        @JsonProperty(value="step")
        private Integer step;
        @JsonProperty(value="errItems")
        private List<ErrorItem> errorItem;

        @Generated
        public Integer getRadioID() {
            return this.radioID;
        }

        @Generated
        public Integer getSsidIndex() {
            return this.ssidIndex;
        }

        @Generated
        public Long getTotalDur() {
            return this.totalDur;
        }

        @Generated
        public Integer getStep() {
            return this.step;
        }

        @Generated
        public List<ErrorItem> getErrorItem() {
            return this.errorItem;
        }

        @JsonProperty(value="rid")
        @Generated
        public RecordItemDTO setRadioID(Integer radioID) {
            this.radioID = radioID;
            return this;
        }

        @JsonProperty(value="ssidIndex")
        @Generated
        public RecordItemDTO setSsidIndex(Integer ssidIndex) {
            this.ssidIndex = ssidIndex;
            return this;
        }

        @JsonProperty(value="totalDur")
        @Generated
        public RecordItemDTO setTotalDur(Long totalDur) {
            this.totalDur = totalDur;
            return this;
        }

        @JsonProperty(value="step")
        @Generated
        public RecordItemDTO setStep(Integer step) {
            this.step = step;
            return this;
        }

        @JsonProperty(value="errItems")
        @Generated
        public RecordItemDTO setErrorItem(List<ErrorItem> errorItem) {
            this.errorItem = errorItem;
            return this;
        }

        @Generated
        public String toString() {
            return "ApConnRecInfoDTO.RecordItemDTO(super=" + super.toString() + ", radioID=" + this.getRadioID() + ", ssidIndex=" + this.getSsidIndex() + ", totalDur=" + this.getTotalDur() + ", step=" + this.getStep() + ", errorItem=" + this.getErrorItem() + ")";
        }

        @Generated
        public RecordItemDTO(Integer radioID, Integer ssidIndex, Long totalDur, Integer step, List<ErrorItem> errorItem) {
            this.radioID = radioID;
            this.ssidIndex = ssidIndex;
            this.totalDur = totalDur;
            this.step = step;
            this.errorItem = errorItem;
        }

        @Generated
        public RecordItemDTO() {
        }
    }

    @JsonPropertyOrder
    private static class ErrorItem {
        @JsonProperty(value="errCode")
        private Long errCode;
        @JsonProperty(value="dur")
        private Integer duration;
        @JsonProperty(value="srvDelay")
        private Integer srvDelay;
        @JsonProperty(value="t")
        private Long time;

        @Generated
        public Long getErrCode() {
            return this.errCode;
        }

        @Generated
        public Integer getDuration() {
            return this.duration;
        }

        @Generated
        public Integer getSrvDelay() {
            return this.srvDelay;
        }

        @Generated
        public Long getTime() {
            return this.time;
        }

        @JsonProperty(value="errCode")
        @Generated
        public ErrorItem setErrCode(Long errCode) {
            this.errCode = errCode;
            return this;
        }

        @JsonProperty(value="dur")
        @Generated
        public ErrorItem setDuration(Integer duration) {
            this.duration = duration;
            return this;
        }

        @JsonProperty(value="srvDelay")
        @Generated
        public ErrorItem setSrvDelay(Integer srvDelay) {
            this.srvDelay = srvDelay;
            return this;
        }

        @JsonProperty(value="t")
        @Generated
        public ErrorItem setTime(Long time) {
            this.time = time;
            return this;
        }

        @Generated
        public String toString() {
            return "ApConnRecInfoDTO.ErrorItem(super=" + super.toString() + ", errCode=" + this.getErrCode() + ", duration=" + this.getDuration() + ", srvDelay=" + this.getSrvDelay() + ", time=" + this.getTime() + ")";
        }

        @Generated
        public ErrorItem(Long errCode, Integer duration, Integer srvDelay, Long time) {
            this.errCode = errCode;
            this.duration = duration;
            this.srvDelay = srvDelay;
            this.time = time;
        }

        @Generated
        public ErrorItem() {
        }
    }

    @JsonPropertyOrder
    private static class SsidTableDTO {
        @JsonProperty(value="index")
        private Integer index;
        @JsonProperty(value="ssid")
        private String ssid;

        @Generated
        public Integer getIndex() {
            return this.index;
        }

        @Generated
        public String getSsid() {
            return this.ssid;
        }

        @JsonProperty(value="index")
        @Generated
        public SsidTableDTO setIndex(Integer index) {
            this.index = index;
            return this;
        }

        @JsonProperty(value="ssid")
        @Generated
        public SsidTableDTO setSsid(String ssid) {
            this.ssid = ssid;
            return this;
        }

        @Generated
        public String toString() {
            return "ApConnRecInfoDTO.SsidTableDTO(super=" + super.toString() + ", index=" + this.getIndex() + ", ssid=" + this.getSsid() + ")";
        }

        @Generated
        public SsidTableDTO(Integer index, String ssid) {
            this.index = index;
            this.ssid = ssid;
        }

        @Generated
        public SsidTableDTO() {
        }
    }
}

