/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.schedule.common.mongo.impl;

import com.tplink.smb.component.schedule.common.ScheduleTaskRepository;
import com.tplink.smb.component.schedule.common.domain.ScheduleTaskDO;
import com.tplink.smb.component.schedule.common.domain.ScheduleTaskIdentityDO;
import com.tplink.smb.component.schedule.common.mongo.ScheduleTaskCrudRepository;
import com.tplink.smb.component.schedule.common.mongo.po.ScheduleTaskIdentity;
import com.tplink.smb.component.schedule.common.mongo.po.ScheduleTaskPO;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public class ScheduleTaskRepositoryImpl
implements ScheduleTaskRepository {
    private ScheduleTaskCrudRepository scheduleTaskCrudRepository;
    private MongoTemplate mongoTemplate;

    public Optional<ScheduleTaskDO> updateTimestamp(ScheduleTaskIdentityDO identity, Long timestamp) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)identity));
        return Optional.ofNullable(this.mongoTemplate.findAndModify(query, (UpdateDefinition)Update.update((String)"next_trigger_time", (Object)timestamp).set("timestamp", (Object)timestamp), new FindAndModifyOptions().returnNew(true), ScheduleTaskPO.class)).map(ScheduleTaskPO::toDO);
    }

    public void save(ScheduleTaskDO task) {
        this.scheduleTaskCrudRepository.save(ScheduleTaskPO.fromDO(task));
    }

    public void saveAll(List<ScheduleTaskDO> tasks) {
        List poList = tasks.stream().map(ScheduleTaskPO::fromDO).collect(Collectors.toList());
        this.scheduleTaskCrudRepository.saveAll(poList);
    }

    public void updateNextTriggerTimeBatch(List<ScheduleTaskDO> tasks) {
        if (tasks == null || tasks.isEmpty()) {
            return;
        }
        BulkOperations bulkOperations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, ScheduleTaskPO.class);
        tasks.forEach(task -> {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)task.getIdentity()).and("next_trigger_time").is((Object)task.getLastTriggerTime()));
            Update update = Update.update((String)"next_trigger_time", (Object)task.getNextTriggerTime()).set("last_trigger_time", (Object)task.getLastTriggerTime());
            bulkOperations.updateOne(query, update);
        });
        bulkOperations.execute();
    }

    public Optional<ScheduleTaskDO> findByIdentity(ScheduleTaskIdentityDO identity) {
        return this.scheduleTaskCrudRepository.findByIdentity(ScheduleTaskIdentity.fromDO(identity)).map(ScheduleTaskPO::toDO);
    }

    public List<ScheduleTaskDO> findByName(String name) {
        return this.scheduleTaskCrudRepository.findByIdentity_Name(name).stream().map(ScheduleTaskPO::toDO).collect(Collectors.toList());
    }

    public List<ScheduleTaskDO> findByHandlerName(String handlerName) {
        return this.scheduleTaskCrudRepository.findByHandlerName(handlerName).stream().map(ScheduleTaskPO::toDO).collect(Collectors.toList());
    }

    public List<ScheduleTaskDO> findAll() {
        return this.scheduleTaskCrudRepository.findAll().stream().map(ScheduleTaskPO::toDO).collect(Collectors.toList());
    }

    public void deleteByIdentity(ScheduleTaskIdentityDO identity) {
        this.scheduleTaskCrudRepository.deleteByIdentity(ScheduleTaskIdentity.fromDO(identity));
    }

    public List<ScheduleTaskDO> findByNextTriggerTimeBetween(Long start, Long end) {
        return this.scheduleTaskCrudRepository.findByNextTriggerTimeBetween(start, end).stream().map(ScheduleTaskPO::toDO).collect(Collectors.toList());
    }

    public void setScheduleTaskCrudRepository(ScheduleTaskCrudRepository scheduleTaskCrudRepository) {
        this.scheduleTaskCrudRepository = scheduleTaskCrudRepository;
    }

    public void setMongoTemplate(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }
}

