/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.global.common.vaild;

import com.tplink.smb.omada.global.common.obfuscate.KeepClass;
import com.tplink.smb.omada.global.common.vaild.NumberSet;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.ValidationException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.validator.constraints.Range;

@KeepClass
public class NumberSetValidator
implements ConstraintValidator<NumberSet, Object> {
    private Set<Integer> validValues;
    private Range[] ranges;

    public void initialize(NumberSet constraintAnnotation) {
        this.validValues = new HashSet<Integer>();
        for (int value : constraintAnnotation.value()) {
            this.validValues.add(value);
        }
        this.ranges = constraintAnnotation.ranges();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (value instanceof Integer) {
            return this.a((Integer)value);
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty() || ((Collection)value).stream().allMatch(v -> v instanceof Integer && this.a((Integer)v));
        }
        throw new ValidationException("Failed to validate value:[" + value + "] with NumberSetValidator, invalid type:[" + value.getClass() + "]. Expected to be Integer or a Collection of Integer");
    }

    private boolean a(Integer value) {
        return this.validValues.contains(value) || this.b(value);
    }

    private boolean b(Integer value) {
        if (this.ranges == null || this.ranges.length == 0) {
            return false;
        }
        for (Range range : this.ranges) {
            if (range.min() > (long)value.intValue() || range.max() < (long)value.intValue()) continue;
            return true;
        }
        return false;
    }
}

