/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.global.common.dto;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Range;

public class MailServerDTO {
    private String centralId;
    @NotNull(message="smtpEnable should not be null")
    private @NotNull(message="smtpEnable should not be null") Boolean smtpEnable;
    @Pattern(regexp="^[\\041-\\0176]{1,128}$")
    private @Pattern(regexp="^[\\041-\\0176]{1,128}$") String smtpServer;
    @Range(min=1L, max=65535L)
    private @Range(min=1L, max=65535L) Integer port;
    private Boolean sslEnable;
    private Boolean authEnable;
    @Pattern(regexp="^[\\041-\\0176]{1,128}$")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @Pattern(regexp="^[\\041-\\0176]{1,128}$") String username;
    @Pattern(regexp="^[\\041-\\0176]{1,128}$")
    @PII(strategy=PIIMaskStrategy.MASK)
    private @Pattern(regexp="^[\\041-\\0176]{1,128}$") String password;
    @Pattern(regexp="[-0-9a-zA-Z.+_]+@[-0-9a-zA-Z.+_]+\\.[a-zA-Z0-9]{2,}")
    private @Pattern(regexp="[-0-9a-zA-Z.+_]+@[-0-9a-zA-Z.+_]+\\.[a-zA-Z0-9]{2,}") String senderAddress;

    public boolean checkParam() {
        if (Boolean.TRUE.equals(this.getSmtpEnable())) {
            if (this.getPort() == null || this.getSslEnable() == null || this.getAuthEnable() == null) {
                return false;
            }
            if (this.getSmtpServer() == null) {
                return false;
            }
            return this.getAuthEnable() == false || this.getUsername() != null && this.getPassword() != null;
        }
        return true;
    }

    public static MailServerDTOBuilder builder() {
        return new MailServerDTOBuilder();
    }

    public String getCentralId() {
        return this.centralId;
    }

    public Boolean getSmtpEnable() {
        return this.smtpEnable;
    }

    public String getSmtpServer() {
        return this.smtpServer;
    }

    public Integer getPort() {
        return this.port;
    }

    public Boolean getSslEnable() {
        return this.sslEnable;
    }

    public Boolean getAuthEnable() {
        return this.authEnable;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSenderAddress() {
        return this.senderAddress;
    }

    public MailServerDTO setCentralId(String centralId) {
        this.centralId = centralId;
        return this;
    }

    public MailServerDTO setSmtpEnable(Boolean smtpEnable) {
        this.smtpEnable = smtpEnable;
        return this;
    }

    public MailServerDTO setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
        return this;
    }

    public MailServerDTO setPort(Integer port) {
        this.port = port;
        return this;
    }

    public MailServerDTO setSslEnable(Boolean sslEnable) {
        this.sslEnable = sslEnable;
        return this;
    }

    public MailServerDTO setAuthEnable(Boolean authEnable) {
        this.authEnable = authEnable;
        return this;
    }

    public MailServerDTO setUsername(String username) {
        this.username = username;
        return this;
    }

    public MailServerDTO setPassword(String password) {
        this.password = password;
        return this;
    }

    public MailServerDTO setSenderAddress(String senderAddress) {
        this.senderAddress = senderAddress;
        return this;
    }

    public String toString() {
        return "MailServerDTO(centralId=" + this.getCentralId() + ", smtpEnable=" + this.getSmtpEnable() + ", smtpServer=" + this.getSmtpServer() + ", port=" + this.getPort() + ", sslEnable=" + this.getSslEnable() + ", authEnable=" + this.getAuthEnable() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", senderAddress=" + this.getSenderAddress() + ")";
    }

    public MailServerDTO() {
    }

    public MailServerDTO(String centralId, Boolean smtpEnable, String smtpServer, Integer port, Boolean sslEnable, Boolean authEnable, String username, String password, String senderAddress) {
        this.centralId = centralId;
        this.smtpEnable = smtpEnable;
        this.smtpServer = smtpServer;
        this.port = port;
        this.sslEnable = sslEnable;
        this.authEnable = authEnable;
        this.username = username;
        this.password = password;
        this.senderAddress = senderAddress;
    }

    public static class MailServerDTOBuilder {
        private String centralId;
        private Boolean smtpEnable;
        private String smtpServer;
        private Integer port;
        private Boolean sslEnable;
        private Boolean authEnable;
        private String username;
        private String password;
        private String senderAddress;

        MailServerDTOBuilder() {
        }

        public MailServerDTOBuilder centralId(String centralId) {
            this.centralId = centralId;
            return this;
        }

        public MailServerDTOBuilder smtpEnable(Boolean smtpEnable) {
            this.smtpEnable = smtpEnable;
            return this;
        }

        public MailServerDTOBuilder smtpServer(String smtpServer) {
            this.smtpServer = smtpServer;
            return this;
        }

        public MailServerDTOBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        public MailServerDTOBuilder sslEnable(Boolean sslEnable) {
            this.sslEnable = sslEnable;
            return this;
        }

        public MailServerDTOBuilder authEnable(Boolean authEnable) {
            this.authEnable = authEnable;
            return this;
        }

        public MailServerDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public MailServerDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public MailServerDTOBuilder senderAddress(String senderAddress) {
            this.senderAddress = senderAddress;
            return this;
        }

        public MailServerDTO build() {
            return new MailServerDTO(this.centralId, this.smtpEnable, this.smtpServer, this.port, this.sslEnable, this.authEnable, this.username, this.password, this.senderAddress);
        }

        public String toString() {
            return "MailServerDTO.MailServerDTOBuilder(centralId=" + this.centralId + ", smtpEnable=" + this.smtpEnable + ", smtpServer=" + this.smtpServer + ", port=" + this.port + ", sslEnable=" + this.sslEnable + ", authEnable=" + this.authEnable + ", username=" + this.username + ", password=" + this.password + ", senderAddress=" + this.senderAddress + ")";
        }
    }
}

