/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.global.common.dto;

import com.tplink.smb.omada.global.common.util.b;
import com.tplink.smb.omada.global.common.util.j;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogDTO {
    private static final Logger log = LoggerFactory.getLogger(AuditLogDTO.class);
    private String mspId;
    private String centralId;
    private String omadacId;
    private String siteId;
    private String auditLogKey;
    private String operator;
    private Integer resource;
    private String ip;
    private Long time;
    private Integer resultCode;
    private String label;
    private String oldValue;
    private String newValue;
    private String[] params;
    private Integer settingType;

    public String toJson() {
        return b.a(this);
    }

    public Optional<Boolean> isRoot() {
        if (j.a(this.centralId) && j.a(this.siteId)) {
            log.warn("Invalid parameters for audit log,centralId:{},siteId:{}", (Object)this.centralId, (Object)this.siteId);
            return Optional.empty();
        }
        if (j.a(this.siteId)) {
            return Optional.ofNullable(Boolean.TRUE);
        }
        return Optional.ofNullable(Boolean.FALSE);
    }

    public Boolean check() {
        if (Objects.isNull(this.time) || j.a(this.operator) || Objects.isNull(this.resource) || j.a(this.centralId) || Objects.isNull(this.resultCode) || j.a(this.auditLogKey)) {
            log.warn("Illegal Audit Log DTO :{}", (Object)this.toString());
            return false;
        }
        return true;
    }

    public Boolean mspCheck() {
        if (j.a(this.mspId) || Objects.isNull(this.time) || j.a(this.operator) || Objects.isNull(this.resource) || j.a(this.ip) || Objects.isNull(this.resultCode)) {
            log.warn("Illegal Msp Audit Log DTO :{}", (Object)this.toString());
            return false;
        }
        return true;
    }

    public static AuditLogDTOBuilder builder() {
        return new AuditLogDTOBuilder();
    }

    public void setMspId(String mspId) {
        this.mspId = mspId;
    }

    public void setCentralId(String centralId) {
        this.centralId = centralId;
    }

    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public void setAuditLogKey(String auditLogKey) {
        this.auditLogKey = auditLogKey;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void setResource(Integer resource) {
        this.resource = resource;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setTime(Long time) {
        this.time = time;
    }

    public void setResultCode(Integer resultCode) {
        this.resultCode = resultCode;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public void setParams(String[] params) {
        this.params = params;
    }

    public void setSettingType(Integer settingType) {
        this.settingType = settingType;
    }

    public String getMspId() {
        return this.mspId;
    }

    public String getCentralId() {
        return this.centralId;
    }

    public String getOmadacId() {
        return this.omadacId;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public String getAuditLogKey() {
        return this.auditLogKey;
    }

    public String getOperator() {
        return this.operator;
    }

    public Integer getResource() {
        return this.resource;
    }

    public String getIp() {
        return this.ip;
    }

    public Long getTime() {
        return this.time;
    }

    public Integer getResultCode() {
        return this.resultCode;
    }

    public String getLabel() {
        return this.label;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public String[] getParams() {
        return this.params;
    }

    public Integer getSettingType() {
        return this.settingType;
    }

    public AuditLogDTO() {
    }

    public AuditLogDTO(String mspId, String centralId, String omadacId, String siteId, String auditLogKey, String operator, Integer resource, String ip, Long time, Integer resultCode, String label, String oldValue, String newValue, String[] params, Integer settingType) {
        this.mspId = mspId;
        this.centralId = centralId;
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.auditLogKey = auditLogKey;
        this.operator = operator;
        this.resource = resource;
        this.ip = ip;
        this.time = time;
        this.resultCode = resultCode;
        this.label = label;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.params = params;
        this.settingType = settingType;
    }

    public String toString() {
        return "AuditLogDTO(mspId=" + this.getMspId() + ", centralId=" + this.getCentralId() + ", omadacId=" + this.getOmadacId() + ", siteId=" + this.getSiteId() + ", auditLogKey=" + this.getAuditLogKey() + ", operator=" + this.getOperator() + ", resource=" + this.getResource() + ", ip=" + this.getIp() + ", time=" + this.getTime() + ", resultCode=" + this.getResultCode() + ", label=" + this.getLabel() + ", oldValue=" + this.getOldValue() + ", newValue=" + this.getNewValue() + ", params=" + Arrays.deepToString(this.getParams()) + ", settingType=" + this.getSettingType() + ")";
    }

    public static class AuditLogDTOBuilder {
        private String mspId;
        private String centralId;
        private String omadacId;
        private String siteId;
        private String auditLogKey;
        private String operator;
        private Integer resource;
        private String ip;
        private Long time;
        private Integer resultCode;
        private String label;
        private String oldValue;
        private String newValue;
        private String[] params;
        private Integer settingType;

        AuditLogDTOBuilder() {
        }

        public AuditLogDTOBuilder mspId(String mspId) {
            this.mspId = mspId;
            return this;
        }

        public AuditLogDTOBuilder centralId(String centralId) {
            this.centralId = centralId;
            return this;
        }

        public AuditLogDTOBuilder omadacId(String omadacId) {
            this.omadacId = omadacId;
            return this;
        }

        public AuditLogDTOBuilder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        public AuditLogDTOBuilder auditLogKey(String auditLogKey) {
            this.auditLogKey = auditLogKey;
            return this;
        }

        public AuditLogDTOBuilder operator(String operator) {
            this.operator = operator;
            return this;
        }

        public AuditLogDTOBuilder resource(Integer resource) {
            this.resource = resource;
            return this;
        }

        public AuditLogDTOBuilder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public AuditLogDTOBuilder time(Long time) {
            this.time = time;
            return this;
        }

        public AuditLogDTOBuilder resultCode(Integer resultCode) {
            this.resultCode = resultCode;
            return this;
        }

        public AuditLogDTOBuilder label(String label) {
            this.label = label;
            return this;
        }

        public AuditLogDTOBuilder oldValue(String oldValue) {
            this.oldValue = oldValue;
            return this;
        }

        public AuditLogDTOBuilder newValue(String newValue) {
            this.newValue = newValue;
            return this;
        }

        public AuditLogDTOBuilder params(String[] params) {
            this.params = params;
            return this;
        }

        public AuditLogDTOBuilder settingType(Integer settingType) {
            this.settingType = settingType;
            return this;
        }

        public AuditLogDTO build() {
            return new AuditLogDTO(this.mspId, this.centralId, this.omadacId, this.siteId, this.auditLogKey, this.operator, this.resource, this.ip, this.time, this.resultCode, this.label, this.oldValue, this.newValue, this.params, this.settingType);
        }

        public String toString() {
            return "AuditLogDTO.AuditLogDTOBuilder(mspId=" + this.mspId + ", centralId=" + this.centralId + ", omadacId=" + this.omadacId + ", siteId=" + this.siteId + ", auditLogKey=" + this.auditLogKey + ", operator=" + this.operator + ", resource=" + this.resource + ", ip=" + this.ip + ", time=" + this.time + ", resultCode=" + this.resultCode + ", label=" + this.label + ", oldValue=" + this.oldValue + ", newValue=" + this.newValue + ", params=" + Arrays.deepToString(this.params) + ", settingType=" + this.settingType + ")";
        }
    }
}

