/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.components.aaa.tacacs.common.packet.request;

import com.tplink.cdd.components.aaa.tacacs.common.TacacsPacketException;
import com.tplink.cdd.components.aaa.tacacs.common.packet.base.TacacsHeader;
import com.tplink.cdd.components.aaa.tacacs.common.packet.constant.RequestConstant;
import com.tplink.cdd.components.aaa.tacacs.common.packet.request.RequestPacket;
import java.nio.charset.StandardCharsets;

public class AuthenticationStart
extends RequestPacket {
    private RequestConstant.ActionEnum action;
    private byte privLvl;
    private RequestConstant.AuthenTypeEnum authenType;
    private RequestConstant.AuthenServiceEnum authenService;
    private String user;
    private String port;
    private String remAddr;
    private byte[] data;
    private static final int ACTION_OFFSET = 0;
    private static final int PRIV_LVL_OFFSET = 1;
    private static final int AUTH_TYPE_OFFSET = 2;
    private static final int AUTH_SERVICE_OFFSET = 3;
    private static final int USER_LEN_OFFSET = 4;
    private static final int PORT_LEN_OFFSET = 5;
    private static final int REM_ADDR_LEN_OFFSET = 6;
    private static final int DATA_LEN_OFFSET = 7;

    public AuthenticationStart(TacacsHeader tacacsHeader, byte[] body) throws TacacsPacketException {
        super(tacacsHeader);
        if (body.length < 8) {
            throw new TacacsPacketException("Corrupt packet or bad key");
        }
        byte userLen = body[4];
        byte portLen = body[5];
        byte remAddrLen = body[6];
        byte dataLen = body[7];
        int checkLen = 8 + userLen + portLen + remAddrLen + dataLen;
        if (checkLen != body.length) {
            throw new TacacsPacketException("Corrupt packet or bad key");
        }
        this.action = RequestConstant.ActionEnum.forCode(body[0]);
        this.privLvl = body[1];
        this.authenType = RequestConstant.AuthenTypeEnum.forCode(body[2]);
        this.authenService = RequestConstant.AuthenServiceEnum.forCode(body[3]);
        int offset = 8;
        this.user = userLen > 0 ? new String(body, offset, (int)userLen, StandardCharsets.UTF_8) : null;
        this.port = portLen > 0 ? new String(body, offset += userLen, (int)portLen, StandardCharsets.UTF_8) : null;
        this.remAddr = remAddrLen > 0 ? new String(body, offset += portLen, (int)remAddrLen, StandardCharsets.UTF_8) : null;
        offset += remAddrLen;
        this.data = new byte[dataLen];
        if (dataLen > 0) {
            System.arraycopy(body, offset, this.data, 0, this.data.length);
        }
    }

    public String getDataString() {
        return this.data == null ? "" : new String(this.data, StandardCharsets.UTF_8);
    }

    @Override
    public String toString() {
        return "AuthenticationStart{" + this.tacacsHeader + ", Body: [action=" + (Object)((Object)this.action) + ", privLvl=" + this.privLvl + ", authenType=" + (Object)((Object)this.authenType) + ", authenService=" + (Object)((Object)this.authenService) + ", user='" + this.user + '\'' + ", port='" + this.port + '\'' + ", remAddr='" + this.remAddr + '\'' + ", data='" + this.getDataString() + '\'' + " ]}";
    }

    public AuthenticationStart() {
    }

    public RequestConstant.ActionEnum getAction() {
        return this.action;
    }

    public byte getPrivLvl() {
        return this.privLvl;
    }

    public RequestConstant.AuthenTypeEnum getAuthenType() {
        return this.authenType;
    }

    public RequestConstant.AuthenServiceEnum getAuthenService() {
        return this.authenService;
    }

    public String getUser() {
        return this.user;
    }

    public String getPort() {
        return this.port;
    }

    public String getRemAddr() {
        return this.remAddr;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setAction(RequestConstant.ActionEnum action) {
        this.action = action;
    }

    public void setPrivLvl(byte privLvl) {
        this.privLvl = privLvl;
    }

    public void setAuthenType(RequestConstant.AuthenTypeEnum authenType) {
        this.authenType = authenType;
    }

    public void setAuthenService(RequestConstant.AuthenServiceEnum authenService) {
        this.authenService = authenService;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setRemAddr(String remAddr) {
        this.remAddr = remAddr;
    }

    public void setData(byte[] data) {
        this.data = data;
    }
}

