/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.components.aaa.tacacs.common.packet.request;

import com.tplink.cdd.components.aaa.tacacs.common.TacacsPacketException;
import com.tplink.cdd.components.aaa.tacacs.common.packet.base.TacacsHeader;
import com.tplink.cdd.components.aaa.tacacs.common.packet.request.RequestPacket;
import java.nio.charset.StandardCharsets;

public class AuthenticationContinue
extends RequestPacket {
    private byte flags;
    private String userMsg;
    private String data;
    private static final int USER_MSG_LEN_START_OFFSET = 0;
    private static final int USER_MSG_LEN_END_OFFSET = 1;
    private static final int DATA_LEN_START_OFFSET = 2;
    private static final int DATA_LEN_END_OFFSET = 3;
    private static final int FLAGS_OFFSET = 4;

    public AuthenticationContinue(TacacsHeader tacacsHeader, byte[] body) throws TacacsPacketException {
        super(tacacsHeader);
        int dataLen;
        if (body.length < 5) {
            throw new TacacsPacketException("Corrupt packet or bad key");
        }
        int userMsgLen = AuthenticationContinue.toInt(body[0], body[1]);
        int checkLen = 5 + userMsgLen + (dataLen = AuthenticationContinue.toInt(body[2], body[3]));
        if (checkLen != body.length) {
            throw new TacacsPacketException("Corrupt packet or bad key");
        }
        this.flags = body[4];
        this.userMsg = userMsgLen > 0 ? new String(body, 5, userMsgLen, StandardCharsets.UTF_8) : null;
        this.data = dataLen > 0 ? new String(body, 5 + userMsgLen, dataLen, StandardCharsets.UTF_8) : null;
    }

    public static int toInt(byte a, byte b) {
        return (a & 0xFF) << 8 | b & 0xFF;
    }

    @Override
    public String toString() {
        return "AuthenticationContinue{" + this.tacacsHeader + ", Body: [flags=" + this.flags + ", userMsg='" + this.userMsg + '\'' + ", data='" + this.data + '\'' + "]}";
    }

    public AuthenticationContinue() {
    }

    public byte getFlags() {
        return this.flags;
    }

    public String getUserMsg() {
        return this.userMsg;
    }

    public String getData() {
        return this.data;
    }

    public void setFlags(byte flags) {
        this.flags = flags;
    }

    public void setUserMsg(String userMsg) {
        this.userMsg = userMsg;
    }

    public void setData(String data) {
        this.data = data;
    }
}

