/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.components.aaa.tacacs.common.packet.reply;

import com.tplink.cdd.components.aaa.tacacs.common.packet.base.Argument;
import com.tplink.cdd.components.aaa.tacacs.common.packet.base.TacacsHeader;
import com.tplink.cdd.components.aaa.tacacs.common.packet.constant.ReplyConstant;
import com.tplink.cdd.components.aaa.tacacs.common.packet.reply.ReplyPacket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationReply
extends ReplyPacket {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationReply.class);
    private ReplyConstant.AuthorStatusEnum status;
    private Argument[] arguments;

    @Override
    public byte[] writeToBytes(String key) throws IOException, NoSuchAlgorithmException {
        byte[] dataBytes;
        byte[] serverMsgBytes = this.serverMsg == null ? new byte[]{} : this.serverMsg.getBytes(StandardCharsets.UTF_8);
        byte[] byArray = dataBytes = this.data == null ? new byte[]{} : this.data.getBytes(StandardCharsets.UTF_8);
        if (serverMsgBytes.length > 65535) {
            serverMsgBytes = Arrays.copyOfRange(serverMsgBytes, 0, 65535);
            log.warn("ServerMsg exceeded the maximum length of 65535 bytes, need to truncate, serverMsg: {}", (Object)this.serverMsg);
        }
        if (dataBytes.length > 65535) {
            dataBytes = Arrays.copyOfRange(dataBytes, 0, 65535);
            log.warn("Data exceeded the maximum length of 65535 bytes, need to truncate, data: {}", (Object)this.data);
        }
        if (this.arguments == null) {
            this.arguments = new Argument[0];
        }
        byte[][] argsBytes = new byte[Math.min(255, this.arguments.length)][];
        for (int i = 0; i < argsBytes.length; ++i) {
            argsBytes[i] = this.arguments[i].toString().getBytes(StandardCharsets.UTF_8);
            if (argsBytes[i].length <= 255) continue;
            log.warn("Arg exceeded the maximum length of 255 bytes, need to truncate, arg: {}.", (Object)this.arguments[i]);
            argsBytes[i] = Arrays.copyOfRange(argsBytes[i], 0, 255);
        }
        ByteArrayOutputStream body = new ByteArrayOutputStream();
        body.write(this.status.getCode());
        body.write(this.arguments.length);
        body.write(TacacsHeader.intToTwoBytes(serverMsgBytes.length));
        body.write(TacacsHeader.intToTwoBytes(dataBytes.length));
        for (byte[] aBytes : argsBytes) {
            body.write(aBytes.length);
        }
        body.write(serverMsgBytes);
        body.write(dataBytes);
        for (byte[] aBytes : argsBytes) {
            body.write(aBytes);
        }
        return this.tacacsHeader.writePacket(body.toByteArray(), key);
    }

    @Override
    public String toString() {
        return "AuthorizationReply{" + this.tacacsHeader + ", Body: [status=" + (Object)((Object)this.status) + ", arguments=" + Arrays.toString(this.arguments) + ", serverMsg='" + this.serverMsg + '\'' + ", data='" + this.data + '\'' + "]}";
    }

    public ReplyConstant.AuthorStatusEnum getStatus() {
        return this.status;
    }

    public Argument[] getArguments() {
        return this.arguments;
    }

    public void setStatus(ReplyConstant.AuthorStatusEnum status) {
        this.status = status;
    }

    public void setArguments(Argument[] arguments) {
        this.arguments = arguments;
    }
}

