/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.components.aaa.tacacs.common.packet.reply;

import com.tplink.cdd.components.aaa.tacacs.common.packet.base.TacacsHeader;
import com.tplink.cdd.components.aaa.tacacs.common.packet.constant.ReplyConstant;
import com.tplink.cdd.components.aaa.tacacs.common.packet.reply.ReplyPacket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationReply
extends ReplyPacket {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationReply.class);
    private ReplyConstant.AuthenStatusEnum status;
    private byte flags;

    @Override
    public byte[] writeToBytes(String key) throws IOException, NoSuchAlgorithmException {
        byte[] dataBytes;
        byte[] serverMsgBytes = this.serverMsg == null ? new byte[]{} : this.serverMsg.getBytes(StandardCharsets.UTF_8);
        byte[] byArray = dataBytes = this.data == null ? new byte[]{} : this.data.getBytes(StandardCharsets.UTF_8);
        if (serverMsgBytes.length > 65535) {
            serverMsgBytes = Arrays.copyOfRange(serverMsgBytes, 0, 65535);
            log.warn("ServerMsg exceeded the maximum length of 65535 bytes, need to truncate, serverMsg: {}", (Object)this.serverMsg);
        }
        if (dataBytes.length > 65535) {
            log.warn("Data exceeded the maximum length of 65535 bytes, need to truncate, data: {}.", (Object)this.data);
            dataBytes = Arrays.copyOfRange(dataBytes, 0, 65535);
        }
        ByteArrayOutputStream body = new ByteArrayOutputStream(6 + serverMsgBytes.length + dataBytes.length);
        body.write(this.status.getCode());
        body.write(this.flags);
        body.write(TacacsHeader.intToTwoBytes(serverMsgBytes.length));
        body.write(TacacsHeader.intToTwoBytes(dataBytes.length));
        body.write(serverMsgBytes);
        body.write(dataBytes);
        return this.tacacsHeader.writePacket(body.toByteArray(), key);
    }

    @Override
    public String toString() {
        return "AuthenticationReply{" + this.tacacsHeader + ", Body: [status=" + (Object)((Object)this.status) + ", flags=" + this.flags + ", serverMsg='" + this.serverMsg + '\'' + ", data='" + this.data + '\'' + "]}";
    }

    public ReplyConstant.AuthenStatusEnum getStatus() {
        return this.status;
    }

    public byte getFlags() {
        return this.flags;
    }

    public void setStatus(ReplyConstant.AuthenStatusEnum status) {
        this.status = status;
    }

    public void setFlags(byte flags) {
        this.flags = flags;
    }
}

