/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.cdd.components.aaa.tacacs.common.packet.base;

import com.tplink.cdd.components.aaa.tacacs.common.TacacsPacketException;
import com.tplink.cdd.components.aaa.tacacs.common.packet.constant.HeaderConstant;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class TacacsHeader {
    private final byte seqNum;
    private final byte flags;
    private final HeaderConstant.VersionEnum version;
    private final HeaderConstant.TypeEnum type;
    private final byte[] sessionId;
    private int bodyLength;
    private static final int VERSION_OFFSET = 0;
    private static final int TYPE_OFFSET = 1;
    private static final int SEQ_NUM_OFFSET = 2;
    private static final int FLAGS_OFFSET = 3;
    private static final int SESSION_ID_OFFSET = 4;
    private static final int SESSION_ID_LENGTH = 4;

    public TacacsHeader(byte seqNum, byte flags, HeaderConstant.VersionEnum version, HeaderConstant.TypeEnum type, byte[] sessionId) {
        this.seqNum = seqNum;
        this.flags = flags;
        this.version = version;
        this.type = type;
        this.sessionId = sessionId;
    }

    public TacacsHeader(byte[] headBytes) {
        this.version = HeaderConstant.VersionEnum.forCode(headBytes[0]);
        this.type = HeaderConstant.TypeEnum.forCode(headBytes[1]);
        this.seqNum = headBytes[2];
        this.flags = headBytes[3];
        this.sessionId = Arrays.copyOfRange(headBytes, 4, 8);
        this.bodyLength = TacacsHeader.bytesToInt(headBytes[8], headBytes[9], headBytes[10], headBytes[11]);
    }

    public int getSessionId() {
        return TacacsHeader.bytesToInt(this.sessionId[0], this.sessionId[1], this.sessionId[2], this.sessionId[3]);
    }

    public boolean hasFlag(HeaderConstant.FlagsEnum flag) {
        return (this.flags & flag.getCode()) != 0;
    }

    public TacacsHeader next() throws TacacsPacketException {
        if ((0xFF & this.seqNum) >= 255) {
            throw new TacacsPacketException("Session sequence number exhausted; try new session.");
        }
        return new TacacsHeader((byte)((0xFF & this.seqNum) + 1), this.flags, this.version, this.type, this.sessionId);
    }

    public byte[] obfuscateBody(byte[] data, byte[] key) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        int length = data.length;
        byte[] pseudoPad = new byte[length];
        md5.update(this.sessionId);
        md5.update(key);
        md5.update(this.version.getCode());
        md5.update(this.seqNum);
        byte[] digest = md5.digest();
        System.arraycopy(digest, 0, pseudoPad, 0, Math.min(digest.length, length));
        length -= digest.length;
        int pos = digest.length;
        while (length > 0) {
            md5.update(this.sessionId);
            md5.update(key);
            md5.update(this.version.getCode());
            md5.update(this.seqNum);
            md5.update(digest);
            digest = md5.digest();
            System.arraycopy(digest, 0, pseudoPad, pos, Math.min(digest.length, length));
            pos += digest.length;
            length -= digest.length;
        }
        byte[] encryptedData = new byte[data.length];
        for (int i = data.length - 1; i >= 0; --i) {
            encryptedData[i] = (byte)(data[i] & 0xFF ^ pseudoPad[i] & 0xFF);
        }
        return encryptedData;
    }

    public byte[] writePacket(byte[] body, String key) throws NoSuchAlgorithmException, IOException {
        int len = body.length;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(12 + len);
        bos.write(this.version.getCode());
        bos.write(this.type.getCode());
        bos.write(this.seqNum);
        bos.write(this.flags);
        bos.write(this.sessionId);
        bos.write(TacacsHeader.intToFourBytes(len));
        if (this.hasFlag(HeaderConstant.FlagsEnum.UNENCRYPTED)) {
            bos.write(body);
        } else {
            bos.write(this.obfuscateBody(body, key.getBytes(StandardCharsets.UTF_8)));
        }
        return bos.toByteArray();
    }

    public static byte[] intToFourBytes(int num) {
        return new byte[]{(byte)(num >>> 24 & 0xFF), (byte)(num >>> 16 & 0xFF), (byte)(num >>> 8 & 0xFF), (byte)(num & 0xFF)};
    }

    public static byte[] intToTwoBytes(int i) {
        return new byte[]{(byte)(i >>> 8 & 0xFF), (byte)(i & 0xFF)};
    }

    static int bytesToInt(byte a, byte b, byte c, byte d) {
        return (a & 0xFF) << 24 | (b & 0xFF) << 16 | (c & 0xFF) << 8 | d & 0xFF;
    }

    public String toString() {
        return "TacacsHeader: [seqNum=" + this.seqNum + ", flags=" + this.flags + ", version=" + (Object)((Object)this.version) + ", type=" + (Object)((Object)this.type) + ", sessionId=" + this.getSessionId() + ", bodyLength=" + this.bodyLength + ']';
    }

    public byte getSeqNum() {
        return this.seqNum;
    }

    public byte getFlags() {
        return this.flags;
    }

    public HeaderConstant.VersionEnum getVersion() {
        return this.version;
    }

    public HeaderConstant.TypeEnum getType() {
        return this.type;
    }

    public int getBodyLength() {
        return this.bodyLength;
    }

    public void setBodyLength(int bodyLength) {
        this.bodyLength = bodyLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TacacsHeader)) {
            return false;
        }
        TacacsHeader other = (TacacsHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSeqNum() != other.getSeqNum()) {
            return false;
        }
        if (this.getFlags() != other.getFlags()) {
            return false;
        }
        if (this.getBodyLength() != other.getBodyLength()) {
            return false;
        }
        HeaderConstant.VersionEnum this$version = this.getVersion();
        HeaderConstant.VersionEnum other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)((Object)this$version)).equals((Object)other$version)) {
            return false;
        }
        HeaderConstant.TypeEnum this$type = this.getType();
        HeaderConstant.TypeEnum other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        return this.getSessionId() == other.getSessionId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TacacsHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSeqNum();
        result = result * 59 + this.getFlags();
        result = result * 59 + this.getBodyLength();
        HeaderConstant.VersionEnum $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)((Object)$version)).hashCode());
        HeaderConstant.TypeEnum $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        result = result * 59 + this.getSessionId();
        return result;
    }
}

