/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.e;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.tplink.smb.component.schedule.api.ScheduleCenter;
import com.tplink.smb.component.schedule.api.ScheduleTask;
import com.tplink.smb.component.schedule.api.ScheduledEvent;
import com.tplink.smb.component.schedule.api.handler.ScheduledEventHandler;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.omadac.config.b;
import com.tplink.smb.omada.maintenance.e.d;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class c
implements ScheduledEventHandler {
    @Generated
    private static final Logger b = LoggerFactory.getLogger(c.class);
    public static final String a = "maintenance_db_log_roll";
    private static final int c = 1200000;
    private static final long d = 0x100000L;
    private static final String e = "mongod\\.log\\.\\d{4,}-\\d{2}-\\d{2}T\\d{2}-\\d{2}-\\d{2}";
    private static final Pattern f = Pattern.compile("mongod\\.log\\.\\d{4,}-\\d{2}-\\d{2}T\\d{2}-\\d{2}-\\d{2}");
    @Autowired
    private ScheduleCenter g;

    @PostConstruct
    public void a() {
        if (!OmadacType.q()) {
            return;
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>(), new ThreadFactoryBuilder().setNameFormat("db-log-roll-%s").build(), (r, executor) -> b.warn("db-log-roll thread pool reject task."));
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        this.g.registerEventHandler(a, (ScheduledEventHandler)this, (ExecutorService)threadPoolExecutor);
        this.g.saveTask(ScheduleTask.builder().withIdentity(a).withFixedRateTrigger(Integer.valueOf(1800000), Integer.valueOf(1200000)).build());
    }

    public void handle(ScheduledEvent scheduledEvent) {
        try {
            com.tplink.smb.omada.maintenance.e.c.b();
        }
        catch (Exception e2) {
            b.warn("Failed to run checkDbLogFile: " + e2.getMessage(), (Throwable)e2);
        }
    }

    private static void b() {
        b conf = com.tplink.smb.omada.common.omadac.config.c.a((String)"omada.properties");
        boolean useExternal = conf.b("mongo.external");
        if (useExternal) {
            return;
        }
        long sizeLimt = Long.parseLong(conf.a("eap.mongod.log.size.limit"));
        long rollingSize = Long.parseLong(conf.a("eap.mongod.log.rolling.size"));
        com.tplink.smb.omada.maintenance.e.c.a(rollingSize * 0x100000L);
        com.tplink.smb.omada.maintenance.e.c.b(sizeLimt * 0x100000L);
    }

    private static void a(long rollingSize) {
        String dbLogFilePath = System.getProperty("eap.home", ".") + File.separator + "logs" + File.separator + "mongod.log";
        File dbLogFile = new File(dbLogFilePath);
        if (dbLogFile.length() <= rollingSize) {
            return;
        }
        b.info("Rotates mongodb log file.");
        String uri = System.getProperty("eap.mongod.uri");
        try (MongoClient client = MongoClients.create((String)uri);){
            client.getDatabase("admin").runCommand((Bson)new BasicDBObject("logRotate", (Object)1));
        }
        catch (Exception e2) {
            b.error(e2.getMessage(), (Throwable)e2);
        }
    }

    private static void b(long sizeLimt) {
        String dbLogPath = System.getProperty("eap.home", ".") + File.separator + "logs";
        Path path = Paths.get(dbLogPath, new String[0]);
        List<Path> paths = null;
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            paths = stream.filter(p -> {
                if (!Files.isRegularFile(p, new LinkOption[0])) {
                    return false;
                }
                File file = p.toFile();
                Matcher matcher = f.matcher(file.getName());
                boolean matchResult = matcher.matches();
                b.debug("Match result of file({}) is {}.", (Object)file.getName(), (Object)matchResult);
                return matchResult;
            }).collect(Collectors.toList());
        }
        catch (IOException e2) {
            b.warn(e2.getMessage(), (Throwable)e2);
        }
        if (paths == null || paths.isEmpty()) {
            b.debug("There is no matched database log rolling file.");
            return;
        }
        List<File> files = com.tplink.smb.omada.maintenance.e.c.a(paths);
        long logTotalSize = 0L;
        for (File file : files) {
            logTotalSize += file.length();
        }
        long exceedSize = logTotalSize - sizeLimt;
        if (exceedSize <= 0L) {
            b.debug("Size limit of db log files is not exceeded.");
            return;
        }
        files.sort(new d());
        for (File file : files) {
            long fileLength = file.length();
            boolean deleteResult = file.delete();
            if (!deleteResult) continue;
            b.info("Db log file({}) is deleted successfully.", (Object)file.getName());
            if ((exceedSize -= fileLength) > 0L) continue;
            break;
        }
    }

    private static List<File> a(List<Path> paths) {
        ArrayList<File> files = new ArrayList<File>();
        for (Path path : paths) {
            files.add(path.toFile());
        }
        return files;
    }
}

