/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.maintenance.core.b.a.a.b;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tplink.smb.omada.backup.api.web.dto.a;
import com.tplink.smb.omada.backup.core.backup.autobackup.dto.AutoBackupFile;
import com.tplink.smb.omada.common.obfuscate.KeepMethod;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.OmadaClusterUniversalMethodResolveClient;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.OmadaClusterUniversalRequestDTO;
import com.tplink.smb.omada.maintenance.core.b.a.a.b.c;
import com.tplink.smb.omada.maintenance.core.b.a.a.b.d;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class b
implements com.tplink.smb.omada.backup.core.backup.autobackup.b {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(b.class);
    @Autowired
    @Lazy
    private OmadaClusterUniversalMethodResolveClient b;
    private static final String c = "%.2f";
    private static final long d = 1024L;
    private static final long e = 0x100000L;
    private static final long f = 0x40000000L;
    private static final int g = 50;
    private static Pattern h = Pattern.compile("^autobackup_(((7|30|60|90|180|365)days)|SettingsOnly|NoLimit)_[0-9]{4}((0[1-9])|(1[0-2]))((0[1-9])|((1|2)[0-9])|30|31)_(((0|1)[0-9])|(2[0-3]))(([0-5])([0-9]))\\.cfg$");
    private static Pattern i = Pattern.compile("^autobackup_(((7|30|60|90|180|365)days)|SettingsOnly|NoLimit)_\\d{13}\\.cfg$");
    private static Pattern j = Pattern.compile("^autobackup_[1-9]\\d?(\\.(0|[1-9]\\d?)){2}_(((7|30|60|90|180|365)days)|SettingsOnly|NoLimit)_\\([0-9]{4}-((0[1-9])|(1[0-2]))-((0[1-9])|((1|2)[0-9])|30|31)_(((0|1)[0-9])|(2[0-3]))-(([0-5])([0-9]))-(([0-5])([0-9]))_\\d{13}\\)\\.cfg$");
    private static Pattern k = Pattern.compile("^autobackup_[1-9]\\d?(\\.(0|[1-9]\\d?)){2}_(((7|30|60|90|180|365)days)|SettingsOnly|NoLimit)_[0-9]{4}-((0[1-9])|(1[0-2]))-((0[1-9])|((1|2)[0-9])|30|31)_(((0|1)[0-9])|(2[0-3]))-(([0-5])([0-9]))-(([0-5])([0-9]))_\\d{13}\\.cfg$");
    private static Pattern l = Pattern.compile("^autobackup_[1-9]\\d?(\\.(0|[1-9]\\d{0,2})){3}_(((7|30|60|90|180|365)days)|SettingsOnly|NoLimit)_[0-9]{4}-((0[1-9])|(1[0-2]))-((0[1-9])|((1|2)[0-9])|30|31)_(((0|1)[0-9])|(2[0-3]))-(([0-5])([0-9]))-(([0-5])([0-9]))_\\d{13}\\.cfg$");
    private static Pattern m = Pattern.compile("^autobackup_[1-9]\\d?(\\.(0|[1-9]\\d{0,2})){2,3}_[0-9]{4}-((0[1-9])|(1[0-2]))-((0[1-9])|((1|2)[0-9])|30|31)_(((0|1)[0-9])|(2[0-3]))-(([0-5])([0-9]))-(([0-5])([0-9]))_\\d{13}\\.cfg$");
    private static Pattern n = Pattern.compile("^autobackup_[1-9]\\d?(\\.(0|[1-9]\\d{0,2})){2,3}_[0-9]{4}-((0[1-9])|(1[0-2]))-((0[1-9])|((1|2)[0-9])|30|31)_(((0|1)[0-9])|(2[0-3]))-(([0-5])([0-9]))-(([0-5])([0-9]))_\\d{13}\\_(((7|30|60|90|180|365)days)|NoLimit)_data.zip$");

    public void a(String path, String defaultPath, int maxNumberOfFile, OmadacType.OmadacTypeEnum omadacType, long maxFileSize) {
        int order;
        List<AutoBackupFile> fileList = this.a(path);
        if (CollectionUtils.isEmpty(fileList)) {
            return;
        }
        for (order = 0; order <= 50 && fileList.size() > maxNumberOfFile; ++order) {
            this.a(fileList, path);
        }
        if (!omadacType.equals((Object)OmadacType.OmadacTypeEnum.OC300_V1) && !omadacType.equals((Object)OmadacType.OmadacTypeEnum.OC400_V1) && !omadacType.equals((Object)OmadacType.OmadacTypeEnum.C5300_V1) || !path.equals(defaultPath)) {
            return;
        }
        for (order = 0; order <= 50 && com.tplink.smb.omada.maintenance.core.b.a.a.b.b.b(fileList, path) > (double)maxFileSize; ++order) {
            this.a(fileList, path);
        }
    }

    private void a(List<AutoBackupFile> fileList, String path) {
        AutoBackupFile fileToDelete = fileList.stream().min(Comparator.comparing(AutoBackupFile::getBackupTime)).orElse(null);
        if (fileToDelete != null) {
            String autoBackupFilePath = path + File.separator + fileToDelete.getFileName();
            String nodeId = fileToDelete.getNodeId();
            if (com.tplink.smb.omada.common.util.system.a.b() && T.a((Object)nodeId) && !Objects.equals(nodeId, com.tplink.smb.omada.common.util.system.a.h())) {
                this.a(nodeId, autoBackupFilePath);
                fileList.remove(fileToDelete);
                return;
            }
            this.c(autoBackupFilePath);
            fileList.remove(fileToDelete);
        }
    }

    private void a(String nodeId, String autoBackupFilePath) {
        OmadaClusterUniversalRequestDTO requestDTO = new OmadaClusterUniversalRequestDTO(b.class, (TypeReference)new c(this), Boolean.valueOf(false), "doOtherClusterNodeDeleteAutoBackupFile", new Class[]{String.class}, new Object[]{autoBackupFilePath});
        OperationResponse response = this.b.resolveSpringBeanCall(nodeId, requestDTO);
        a.debug("request node:{} to notifyOtherClusterNodeDeleteAutoBackupFile , request is {}, response is {}", new Object[]{nodeId, requestDTO, response});
        if (!response.success() || response.getResult() == null || !((com.tplink.smb.omada.common.access.OperationResponse)response.getResult()).success()) {
            a.warn("request node:{} to notifyOtherClusterNodeDeleteAutoBackupFile fail", (Object)nodeId);
        }
    }

    @KeepMethod
    public com.tplink.smb.omada.common.access.OperationResponse<Object> doOtherClusterNodeDeleteAutoBackupFile(String autoBackupFilePath) {
        a.debug("doOtherClusterNodeDeleteAutoBackupFile, path:{},", (Object)autoBackupFilePath);
        this.c(autoBackupFilePath);
        return com.tplink.smb.omada.common.access.OperationResponse.SUCCESS;
    }

    private static double b(List<AutoBackupFile> fileList, String path) {
        long allFileSize = 0L;
        for (AutoBackupFile autoBackupFile : fileList) {
            File file = new File(path + File.separator + autoBackupFile.getFileName());
            if (!file.exists() || !file.isFile()) continue;
            allFileSize += file.length();
        }
        a.debug("auto backup allFileSize: {}", (Object)allFileSize);
        return allFileSize;
    }

    public List<AutoBackupFile> a(String path) {
        File autoBackupDir = new File(path);
        ArrayList<AutoBackupFile> finalFileList = new ArrayList<AutoBackupFile>();
        if (com.tplink.smb.omada.common.util.system.a.b()) {
            a.debug("getOtherClusterNodeAutoBackFileList start");
            this.a(path, finalFileList);
        }
        if (autoBackupDir.exists() && autoBackupDir.isDirectory()) {
            String[] fileNames = autoBackupDir.list();
            if (null == fileNames) {
                return finalFileList;
            }
            List<AutoBackupFile> fileList = this.a(Arrays.stream(fileNames).map(fileName -> new a(fileName, fileName)).collect(Collectors.toList()), path, true);
            finalFileList.addAll(fileList);
        }
        a.debug("path:{} get getAutoBackFileList is list:{},", (Object)path, finalFileList);
        return finalFileList;
    }

    private void a(String path, List<AutoBackupFile> fileList) {
        OmadaClusterUniversalRequestDTO requestDTO = new OmadaClusterUniversalRequestDTO(b.class, (TypeReference)new d(this), Boolean.valueOf(false), "doGetOtherClusterNodeAutoBackFileList", new Class[]{String.class}, new Object[]{path});
        for (String nodeId : com.tplink.smb.omada.common.util.system.c.a().keySet()) {
            if (Objects.equals(nodeId, com.tplink.smb.omada.common.util.system.a.h())) continue;
            OperationResponse response = this.b.resolveSpringBeanCall(nodeId, requestDTO);
            a.debug("request node:{} to getOtherClusterNodeAutoBackFileList , request is {}, response is {}", new Object[]{nodeId, requestDTO, response});
            if (!response.success() || response.getResult() == null) {
                a.warn("request node:{} to getOtherClusterNodeAutoBackFileList fail", (Object)nodeId);
                continue;
            }
            List list = (List)response.getResult();
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            fileList.addAll(list);
        }
    }

    @KeepMethod
    public List<AutoBackupFile> doGetOtherClusterNodeAutoBackFileList(String path) {
        a.debug("doGetOtherClusterNodeAutoBackFileList, path:{},", (Object)path);
        File autoBackupDir = new File(path);
        List<AutoBackupFile> fileList = new ArrayList<AutoBackupFile>();
        if (autoBackupDir.exists() && autoBackupDir.isDirectory()) {
            String[] fileNames = autoBackupDir.list();
            if (null == fileNames) {
                a.debug("path:{} get AutoBackFileList is null,", (Object)path);
                return fileList;
            }
            fileList = this.a(Arrays.stream(fileNames).map(fileName -> new a(fileName, fileName)).collect(Collectors.toList()), path, true);
        }
        a.debug("path:{} get doGetOtherClusterNodeAutoBackFileList is list:{},", (Object)path, fileList);
        return fileList;
    }

    public List<AutoBackupFile> b(String path) {
        File autoBackupDir = new File(path);
        List<AutoBackupFile> fileList = new ArrayList<AutoBackupFile>();
        if (autoBackupDir.exists() && autoBackupDir.isDirectory()) {
            String[] fileNames = autoBackupDir.list();
            if (null == fileNames) {
                return fileList;
            }
            fileList = this.b(Arrays.stream(fileNames).map(fileName -> new a(fileName, fileName)).collect(Collectors.toList()), path, true);
        }
        return fileList;
    }

    public List<AutoBackupFile> a(List<a> fileListTrees, String path, boolean localFile) {
        ArrayList<AutoBackupFile> fileList = new ArrayList<AutoBackupFile>();
        for (a fileTree : fileListTrees) {
            long length;
            String[] names;
            String fileName;
            String name = fileTree.a();
            if (T.a((String)name) || !h.matcher(fileName = (names = name.split("/"))[names.length - 1]).matches() && !i.matcher(fileName).matches() && !j.matcher(fileName).matches() && !k.matcher(fileName).matches() && !l.matcher(fileName).matches() && !m.matcher(fileName).matches() && !n.matcher(fileName).matches()) continue;
            a.debug("Filename {} is valid", (Object)fileName);
            AutoBackupFile autoBackupFile = new AutoBackupFile();
            if (localFile) {
                File file = new File(path + File.separator + fileName);
                length = file.length();
            } else {
                length = fileTree.e();
            }
            autoBackupFile.setFileName(fileName);
            autoBackupFile.setSize(this.a(length));
            autoBackupFile.setFileSize(Long.valueOf(length));
            autoBackupFile.setBackupTime(this.e(fileName));
            if (com.tplink.smb.omada.common.util.system.a.b() && localFile) {
                autoBackupFile.setNodeId(com.tplink.smb.omada.common.util.system.a.h());
                autoBackupFile.setNodeName(T.c((String)com.tplink.smb.omada.common.util.system.a.j()) ? com.tplink.smb.omada.common.util.system.a.h() : com.tplink.smb.omada.common.util.system.a.j());
            }
            fileList.add(autoBackupFile);
        }
        Collections.reverse(fileList);
        return fileList;
    }

    public List<AutoBackupFile> b(List<a> fileListTrees, String path, boolean localFile) {
        ArrayList<AutoBackupFile> fileList = new ArrayList<AutoBackupFile>();
        for (a fileTree : fileListTrees) {
            long length;
            String[] names;
            String fileName;
            String name = fileTree.a();
            if (T.a((String)name) || !(fileName = (names = name.split("/"))[names.length - 1]).startsWith("site_autobackup") || !fileName.endsWith(".cfg")) continue;
            a.debug("Filename {} is valid", (Object)fileName);
            AutoBackupFile autoBackupFile = new AutoBackupFile();
            if (localFile) {
                File file = new File(path + File.separator + fileName);
                length = file.length();
            } else {
                length = fileTree.e();
            }
            autoBackupFile.setFileName(fileName);
            autoBackupFile.setSize(com.tplink.smb.omada.maintenance.common.c.b.a((long)length));
            autoBackupFile.setFileSize(Long.valueOf(length));
            autoBackupFile.setBackupTime(this.d(fileName));
            fileList.add(autoBackupFile);
        }
        Collections.reverse(fileList);
        return fileList;
    }

    private Long d(String fileName) {
        String[] fileNameParts = fileName.split("_");
        String s1 = fileNameParts[fileNameParts.length - 1];
        int end = s1.lastIndexOf(".");
        return Long.parseLong(s1.substring(0, end));
    }

    public com.tplink.smb.omada.common.access.OperationResponse c(String autoBackupFile) {
        Path path = Paths.get(autoBackupFile, new String[0]);
        try {
            if (Files.deleteIfExists(path)) {
                a.info("Delete auto backup file {} succeed.", (Object)autoBackupFile);
            }
        }
        catch (IOException e2) {
            a.warn("Can not delete auto backup file {} ", (Object)autoBackupFile);
            a.warn(e2.getMessage(), (Throwable)e2);
            return com.tplink.smb.omada.common.access.OperationResponse.GENERAL_ERROR;
        }
        return com.tplink.smb.omada.common.access.OperationResponse.SUCCESS;
    }

    private String a(long length) {
        if (length < 1024L) {
            return length + " B";
        }
        if (length < 0x100000L) {
            double size = (double)length * 1.0 / 1024.0;
            return String.format(c, size) + " KB";
        }
        if (length < 0x40000000L) {
            double size = (double)length * 1.0 / 1048576.0;
            return String.format(c, size) + " MB";
        }
        double size = (double)length * 1.0 / 1.073741824E9;
        return String.format(c, size) + " GB";
    }

    private Long e(String fileName) {
        String nameWithoutSuffix = fileName.substring(0, fileName.lastIndexOf(46)).replaceAll("\\(", "").replaceAll("\\)", "");
        String[] fileNameParts = nameWithoutSuffix.split("_");
        Matcher matcher1 = Pattern.compile("^autobackup_(((7|30|60|90|180|365)days)|SettingsOnly|NoLimit)_[0-9]{4}((0[1-9])|(1[0-2]))((0[1-9])|((1|2)[0-9])|30|31)_(((0|1)[0-9])|(2[0-3]))(([0-5])([0-9]))\\.cfg$").matcher(fileName);
        Matcher matcher2 = Pattern.compile("^autobackup_(((7|30|60|90|180|365)days)|SettingsOnly|NoLimit)_\\d{13}\\.cfg$").matcher(fileName);
        Matcher matcher3 = Pattern.compile("^autobackup_[1-9]\\d?(\\.(0|[1-9]\\d?)){2}_(((7|30|60|90|180|365)days)|SettingsOnly|NoLimit)_\\([0-9]{4}-((0[1-9])|(1[0-2]))-((0[1-9])|((1|2)[0-9])|30|31)_(((0|1)[0-9])|(2[0-3]))-(([0-5])([0-9]))-(([0-5])([0-9]))_\\d{13}\\)\\.cfg$").matcher(fileName);
        Matcher matcher4 = Pattern.compile("^autobackup_[1-9]\\d?(\\.(0|[1-9]\\d?)){2}_(((7|30|60|90|180|365)days)|SettingsOnly|NoLimit)_[0-9]{4}-((0[1-9])|(1[0-2]))-((0[1-9])|((1|2)[0-9])|30|31)_(((0|1)[0-9])|(2[0-3]))-(([0-5])([0-9]))-(([0-5])([0-9]))_\\d{13}\\.cfg$").matcher(fileName);
        Matcher matcher6 = Pattern.compile("^autobackup_[1-9]\\d?(\\.(0|[1-9]\\d{0,2})){3}_(((7|30|60|90|180|365)days)|SettingsOnly|NoLimit)_[0-9]{4}-((0[1-9])|(1[0-2]))-((0[1-9])|((1|2)[0-9])|30|31)_(((0|1)[0-9])|(2[0-3]))-(([0-5])([0-9]))-(([0-5])([0-9]))_\\d{13}\\.cfg$").matcher(fileName);
        Matcher matcher7 = Pattern.compile("^autobackup_[1-9]\\d?(\\.(0|[1-9]\\d{0,2})){2,3}_[0-9]{4}-((0[1-9])|(1[0-2]))-((0[1-9])|((1|2)[0-9])|30|31)_(((0|1)[0-9])|(2[0-3]))-(([0-5])([0-9]))-(([0-5])([0-9]))_\\d{13}\\.cfg$").matcher(fileName);
        Matcher matcher8 = Pattern.compile("^autobackup_[1-9]\\d?(\\.(0|[1-9]\\d{0,2})){2,3}_[0-9]{4}-((0[1-9])|(1[0-2]))-((0[1-9])|((1|2)[0-9])|30|31)_(((0|1)[0-9])|(2[0-3]))-(([0-5])([0-9]))-(([0-5])([0-9]))_\\d{13}\\_(((7|30|60|90|180|365)days)|NoLimit)_data.zip$").matcher(fileName);
        if (matcher1.matches()) {
            String yyyyMMDD = fileNameParts[2];
            String hhmm = fileNameParts[3];
            String year = yyyyMMDD.substring(0, 4);
            String month = yyyyMMDD.substring(4, 6);
            String day = yyyyMMDD.substring(6, 8);
            String hour = hhmm.substring(0, 2);
            String minute = hhmm.substring(2, 4);
            String backupTime = month + "/" + day + "/" + year + " " + hour + ":" + minute;
            try {
                SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm", Locale.ROOT);
                return format.parse(backupTime).getTime();
            }
            catch (Exception e2) {
                a.error("Parse date format {} error", (Object)backupTime);
                a.error(e2.getMessage(), (Throwable)e2);
                return 0L;
            }
        }
        if (matcher2.matches()) {
            String time = fileNameParts[2];
            return Long.parseLong(time);
        }
        if (matcher3.matches()) {
            String time = fileNameParts[5];
            return Long.parseLong(time);
        }
        if (matcher4.matches()) {
            String time = fileNameParts[5];
            return Long.parseLong(time);
        }
        if (matcher6.matches()) {
            String time = fileNameParts[5];
            return Long.parseLong(time);
        }
        if (matcher7.matches()) {
            String time = fileNameParts[4];
            return Long.parseLong(time);
        }
        if (matcher8.matches()) {
            String time = fileNameParts[4];
            return Long.parseLong(time);
        }
        return 0L;
    }
}

