/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.api.dto.health.osw;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.anomaly.api.dto.health.osw.OswLatestHealthScoreDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OswPostHealthScoreDTO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OswPostHealthScoreDTO.class);
    @a
    private String mac;
    private List<OswPostHealthTimeScoreDTO> oswTimeScoreList;

    public List<OswPostHealthTimeScoreDTO> getEffectiveTimeScoreList(String omadacId, String siteId, Long currentTime, int lastCount) {
        Map<Long, OswPostHealthTimeScoreDTO> timeScoreMap = Optional.ofNullable(this.oswTimeScoreList).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).collect(Collectors.toMap(OswPostHealthTimeScoreDTO::getTimestamp, score -> score, (existing, replacement) -> existing));
        ArrayList<OswPostHealthTimeScoreDTO> effectiveTimeScoreList = new ArrayList<OswPostHealthTimeScoreDTO>(lastCount);
        for (int i2 = 0; i2 < lastCount; ++i2) {
            Long timePoint = currentTime - (long)((i2 + 1) * 600);
            OswPostHealthTimeScoreDTO scoreDTO = timeScoreMap.get(timePoint);
            if (scoreDTO != null) {
                effectiveTimeScoreList.add(scoreDTO);
                continue;
            }
            effectiveTimeScoreList.add(OswPostHealthTimeScoreDTO.createNoDataDTO(timePoint));
        }
        com.tplink.smb.omada.anomaly.api.e.a.a(log, "OswPostHealthScoreDTO.getEffectiveTimeScoreList, omadacId {}, siteId {},  source time scores is {}, effective time scores after fill zero is {}", omadacId, siteId, this.oswTimeScoreList, effectiveTimeScoreList);
        return effectiveTimeScoreList;
    }

    public OswPostHealthScoreDTO(String mac, Long time, OswLatestHealthScoreDTO latestHealthScoreDTO) {
        this.mac = mac;
        OswPostHealthTimeScoreDTO timeScoreDTO = OswPostHealthTimeScoreDTO.createNoDataDTO(time);
        if (Objects.nonNull(latestHealthScoreDTO)) {
            timeScoreDTO.setCpuUtilScore(latestHealthScoreDTO.getCpuUtilScore());
            timeScoreDTO.setMemUtilScore(latestHealthScoreDTO.getMemUtilScore());
            timeScoreDTO.setTemperatureScore(latestHealthScoreDTO.getTemperatureScore());
            timeScoreDTO.setPortPktsLossScore(latestHealthScoreDTO.getPortPktsLossScore());
            timeScoreDTO.setErrorFrameUtilScore(latestHealthScoreDTO.getErrorFrameUtilScore());
        }
        ArrayList<OswPostHealthTimeScoreDTO> timeScoreDTOList = new ArrayList<OswPostHealthTimeScoreDTO>();
        timeScoreDTOList.add(timeScoreDTO);
        this.oswTimeScoreList = timeScoreDTOList;
    }

    public void merge(Long time, OswLatestHealthScoreDTO latestHealthScoreDTO) {
        OswPostHealthTimeScoreDTO toBeAddedScoreDTO = OswPostHealthTimeScoreDTO.createNoDataDTO(time);
        if (Objects.nonNull(latestHealthScoreDTO)) {
            toBeAddedScoreDTO = new OswPostHealthTimeScoreDTO(time, latestHealthScoreDTO.getCpuUtilScore(), latestHealthScoreDTO.getMemUtilScore(), latestHealthScoreDTO.getTemperatureScore(), latestHealthScoreDTO.getPortPktsLossScore(), latestHealthScoreDTO.getErrorFrameUtilScore());
        }
        if (Objects.isNull(this.oswTimeScoreList)) {
            this.oswTimeScoreList = new ArrayList<OswPostHealthTimeScoreDTO>();
        }
        this.oswTimeScoreList.add(toBeAddedScoreDTO);
        long expireThreshold = time - 3600L;
        this.oswTimeScoreList.removeIf(timeScore -> timeScore.getTimestamp() < expireThreshold);
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public List<OswPostHealthTimeScoreDTO> getOswTimeScoreList() {
        return this.oswTimeScoreList;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setOswTimeScoreList(List<OswPostHealthTimeScoreDTO> oswTimeScoreList) {
        this.oswTimeScoreList = oswTimeScoreList;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof OswPostHealthScoreDTO)) {
            return false;
        }
        OswPostHealthScoreDTO other = (OswPostHealthScoreDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$mac = this.getMac();
        String other$mac = other.getMac();
        if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
            return false;
        }
        List<OswPostHealthTimeScoreDTO> this$oswTimeScoreList = this.getOswTimeScoreList();
        List<OswPostHealthTimeScoreDTO> other$oswTimeScoreList = other.getOswTimeScoreList();
        return !(this$oswTimeScoreList == null ? other$oswTimeScoreList != null : !((Object)this$oswTimeScoreList).equals(other$oswTimeScoreList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OswPostHealthScoreDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
        List<OswPostHealthTimeScoreDTO> $oswTimeScoreList = this.getOswTimeScoreList();
        result = result * 59 + ($oswTimeScoreList == null ? 43 : ((Object)$oswTimeScoreList).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OswPostHealthScoreDTO(mac=" + this.getMac() + ", oswTimeScoreList=" + this.getOswTimeScoreList() + ")";
    }

    @Generated
    public OswPostHealthScoreDTO() {
    }

    public static class OswPostHealthTimeScoreDTO {
        private Long timestamp;
        private Integer cpuUtilScore;
        private Integer memUtilScore;
        private Integer temperatureScore;
        private Integer portPktsLossScore;
        private Integer errorFrameUtilScore;

        public static OswPostHealthTimeScoreDTO createNoDataDTO(Long time) {
            return new OswPostHealthTimeScoreDTO(time, 0, 0, 0, 0, 0);
        }

        @Generated
        public Long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public Integer getCpuUtilScore() {
            return this.cpuUtilScore;
        }

        @Generated
        public Integer getMemUtilScore() {
            return this.memUtilScore;
        }

        @Generated
        public Integer getTemperatureScore() {
            return this.temperatureScore;
        }

        @Generated
        public Integer getPortPktsLossScore() {
            return this.portPktsLossScore;
        }

        @Generated
        public Integer getErrorFrameUtilScore() {
            return this.errorFrameUtilScore;
        }

        @Generated
        public void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        @Generated
        public void setCpuUtilScore(Integer cpuUtilScore) {
            this.cpuUtilScore = cpuUtilScore;
        }

        @Generated
        public void setMemUtilScore(Integer memUtilScore) {
            this.memUtilScore = memUtilScore;
        }

        @Generated
        public void setTemperatureScore(Integer temperatureScore) {
            this.temperatureScore = temperatureScore;
        }

        @Generated
        public void setPortPktsLossScore(Integer portPktsLossScore) {
            this.portPktsLossScore = portPktsLossScore;
        }

        @Generated
        public void setErrorFrameUtilScore(Integer errorFrameUtilScore) {
            this.errorFrameUtilScore = errorFrameUtilScore;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof OswPostHealthTimeScoreDTO)) {
                return false;
            }
            OswPostHealthTimeScoreDTO other = (OswPostHealthTimeScoreDTO)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$timestamp = this.getTimestamp();
            Long other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                return false;
            }
            Integer this$cpuUtilScore = this.getCpuUtilScore();
            Integer other$cpuUtilScore = other.getCpuUtilScore();
            if (this$cpuUtilScore == null ? other$cpuUtilScore != null : !((Object)this$cpuUtilScore).equals(other$cpuUtilScore)) {
                return false;
            }
            Integer this$memUtilScore = this.getMemUtilScore();
            Integer other$memUtilScore = other.getMemUtilScore();
            if (this$memUtilScore == null ? other$memUtilScore != null : !((Object)this$memUtilScore).equals(other$memUtilScore)) {
                return false;
            }
            Integer this$temperatureScore = this.getTemperatureScore();
            Integer other$temperatureScore = other.getTemperatureScore();
            if (this$temperatureScore == null ? other$temperatureScore != null : !((Object)this$temperatureScore).equals(other$temperatureScore)) {
                return false;
            }
            Integer this$portPktsLossScore = this.getPortPktsLossScore();
            Integer other$portPktsLossScore = other.getPortPktsLossScore();
            if (this$portPktsLossScore == null ? other$portPktsLossScore != null : !((Object)this$portPktsLossScore).equals(other$portPktsLossScore)) {
                return false;
            }
            Integer this$errorFrameUtilScore = this.getErrorFrameUtilScore();
            Integer other$errorFrameUtilScore = other.getErrorFrameUtilScore();
            return !(this$errorFrameUtilScore == null ? other$errorFrameUtilScore != null : !((Object)this$errorFrameUtilScore).equals(other$errorFrameUtilScore));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OswPostHealthTimeScoreDTO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            Integer $cpuUtilScore = this.getCpuUtilScore();
            result = result * 59 + ($cpuUtilScore == null ? 43 : ((Object)$cpuUtilScore).hashCode());
            Integer $memUtilScore = this.getMemUtilScore();
            result = result * 59 + ($memUtilScore == null ? 43 : ((Object)$memUtilScore).hashCode());
            Integer $temperatureScore = this.getTemperatureScore();
            result = result * 59 + ($temperatureScore == null ? 43 : ((Object)$temperatureScore).hashCode());
            Integer $portPktsLossScore = this.getPortPktsLossScore();
            result = result * 59 + ($portPktsLossScore == null ? 43 : ((Object)$portPktsLossScore).hashCode());
            Integer $errorFrameUtilScore = this.getErrorFrameUtilScore();
            result = result * 59 + ($errorFrameUtilScore == null ? 43 : ((Object)$errorFrameUtilScore).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "OswPostHealthScoreDTO.OswPostHealthTimeScoreDTO(timestamp=" + this.getTimestamp() + ", cpuUtilScore=" + this.getCpuUtilScore() + ", memUtilScore=" + this.getMemUtilScore() + ", temperatureScore=" + this.getTemperatureScore() + ", portPktsLossScore=" + this.getPortPktsLossScore() + ", errorFrameUtilScore=" + this.getErrorFrameUtilScore() + ")";
        }

        @Generated
        public OswPostHealthTimeScoreDTO() {
        }

        @Generated
        public OswPostHealthTimeScoreDTO(Long timestamp, Integer cpuUtilScore, Integer memUtilScore, Integer temperatureScore, Integer portPktsLossScore, Integer errorFrameUtilScore) {
            this.timestamp = timestamp;
            this.cpuUtilScore = cpuUtilScore;
            this.memUtilScore = memUtilScore;
            this.temperatureScore = temperatureScore;
            this.portPktsLossScore = portPktsLossScore;
            this.errorFrameUtilScore = errorFrameUtilScore;
        }
    }
}

