/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.api.dto.health.osw;

import com.google.common.collect.Lists;
import com.tplink.smb.omada.anomaly.api.dto.health.BaseHealthDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.osw.OswHealthDeviceInfoDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.osw.a;
import com.tplink.smb.omada.anomaly.api.dto.health.osw.b;
import com.tplink.smb.omada.common.util.I;
import com.tplink.smb.omada.device.manage.message.inform.osw.InformOswPort;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswPortStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class OswHealthDTO
extends BaseHealthDTO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OswHealthDTO.class);
    private Map<Long, a> oswHealthDataMap;
    private Set<Integer> topologyPorts;
    private Map<Integer, b> portDataMap;

    public OswHealthDTO(String omadacId, String siteId, String mac, Long timestamp) {
        super(omadacId, siteId, mac, timestamp);
        this.oswHealthDataMap = new ConcurrentHashMap<Long, a>();
        this.portDataMap = new ConcurrentHashMap<Integer, b>();
        this.topologyPorts = new HashSet<Integer>();
    }

    public void merge(OswHealthDeviceInfoDTO oswInformDeviceInfo, InformOswPort informOswPort, Long timestamp) {
        this.mergeDeviceInfo(oswInformDeviceInfo, timestamp);
        this.mergePortInfo(informOswPort, timestamp);
    }

    private void mergeDeviceInfo(OswHealthDeviceInfoDTO oswInformDeviceInfo, Long timestamp) {
        if (Objects.isNull(oswInformDeviceInfo)) {
            return;
        }
        if (oswInformDeviceInfo.getCpuUtil() == null && oswInformDeviceInfo.getMemUtil() == null && CollectionUtils.isEmpty(oswInformDeviceInfo.getDevTemp())) {
            return;
        }
        a oswHealthData = new a();
        oswHealthData.a(timestamp);
        if (Objects.nonNull(oswInformDeviceInfo.getCpuUtil())) {
            oswHealthData.a(oswInformDeviceInfo.getCpuUtil());
        }
        if (Objects.nonNull(oswInformDeviceInfo.getMemUtil())) {
            oswHealthData.b(oswInformDeviceInfo.getMemUtil());
        }
        if (!CollectionUtils.isEmpty(oswInformDeviceInfo.getDevTemp())) {
            oswHealthData.a(oswInformDeviceInfo.getDevTemp());
        }
        this.oswHealthDataMap.put(timestamp, oswHealthData);
    }

    private void mergePortInfo(InformOswPort informOswPort, long timestamp) {
        if (Objects.isNull(informOswPort)) {
            log.debug("port inform is not exist");
            return;
        }
        List ports = informOswPort.getPorts();
        if (CollectionUtils.isEmpty((Collection)ports)) {
            log.debug("port inform is not exist");
            return;
        }
        for (OswPortStatus port : ports) {
            Integer dropPktsRate;
            long dropPkts;
            int portId = port.getPort();
            int status = port.getStatus();
            long errPkts = I.a((Long)port.getRxErrorPkts()) + I.a((Long)port.getTxErrorPkts());
            long l2 = dropPkts = Objects.isNull(port.getTxDropPkts()) ? 0L : port.getTxDropPkts();
            if (Objects.equals(status, 1)) {
                this.topologyPorts.add(port.getPort());
            }
            if (this.portDataMap.containsKey(portId)) {
                b oswHealthPortData = this.portDataMap.get(portId);
                dropPktsRate = this.calculateDropPacketRates(port.getTxDropPkts(), port.getTxPkts());
                Integer errPktsRate = this.calculateErrorFrameRates(port.getTxPkts(), port.getRxPkts(), port.getTxErrorPkts(), port.getRxErrorPkts());
                this.mergeLossPkts(timestamp, dropPkts, dropPktsRate, errPktsRate, oswHealthPortData);
                this.mergeLinkError(timestamp, status, errPkts, oswHealthPortData);
                continue;
            }
            ArrayList<Integer> dropPktsRates = new ArrayList<Integer>();
            dropPktsRate = this.calculateDropPacketRates(port.getTxDropPkts(), port.getTxPkts());
            if (dropPktsRate != null) {
                dropPktsRates.add(dropPktsRate);
            }
            ArrayList<Integer> errorFrameRates = new ArrayList<Integer>();
            Integer errPktsRate = this.calculateErrorFrameRates(port.getTxPkts(), port.getRxPkts(), port.getTxErrorPkts(), port.getRxErrorPkts());
            if (errPktsRate != null) {
                errorFrameRates.add(errPktsRate);
            }
            this.portDataMap.put(portId, new b(status, dropPkts, errPkts, dropPktsRates, errorFrameRates));
        }
    }

    private void mergeLinkError(long timestamp, int status, long errPkts, b oswHealthPortData) {
        if (Boolean.FALSE.equals(oswHealthPortData.e()) && !Objects.equals(errPkts, oswHealthPortData.d()) && !Objects.equals(0, errPkts)) {
            oswHealthPortData.b(true);
        }
        if (this.getTimestamp() < timestamp) {
            oswHealthPortData.b(errPkts);
            if (Objects.equals(oswHealthPortData.a(), 1) && Objects.equals(status, 0)) {
                oswHealthPortData.b(true);
            }
            oswHealthPortData.a(status);
        }
    }

    private void mergeLossPkts(long timestamp, long dropPkts, Integer dropPktsRate, Integer errPktsRate, b oswHealthPortData) {
        if (Boolean.FALSE.equals(oswHealthPortData.c()) && !Objects.equals(dropPkts, oswHealthPortData.b()) && !Objects.equals(0, dropPkts)) {
            oswHealthPortData.a(true);
        }
        if (this.getTimestamp() < timestamp) {
            oswHealthPortData.a(dropPkts);
            if (dropPktsRate != null) {
                oswHealthPortData.a(Lists.newArrayList((Object[])new Integer[]{dropPktsRate}));
            }
            if (errPktsRate != null) {
                oswHealthPortData.b(Lists.newArrayList((Object[])new Integer[]{errPktsRate}));
            }
        }
    }

    private Integer calculateDropPacketRates(Long txDP, Long txP) {
        if (Objects.isNull(txDP) || Objects.isNull(txP) || Objects.equals(txP, 0L)) {
            return null;
        }
        return Math.round((float)txDP.longValue() / (float)txP.longValue() * 100.0f);
    }

    private Integer calculateErrorFrameRates(Long txP, Long rxP, Long txEP, Long rxEP) {
        if (rxEP == null && txEP == null) {
            return null;
        }
        return Math.round((this.calculateTxErrorRates(txP, txEP).floatValue() + this.calculateRxErrorRates(rxP, rxEP).floatValue()) / 2.0f * 100.0f);
    }

    private Float calculateTxErrorRates(Long txP, Long txEP) {
        if (Objects.isNull(txP) || Objects.isNull(txEP) || Objects.equals(txP, 0L)) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf((float)txEP.longValue() / (float)txP.longValue());
    }

    private Float calculateRxErrorRates(Long rxP, Long rxEP) {
        if (Objects.isNull(rxP) || Objects.isNull(rxEP) || Objects.equals(rxP, 0L)) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf((float)rxEP.longValue() / (float)rxP.longValue());
    }

    public void clear() {
        this.oswHealthDataMap.clear();
    }

    @Override
    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof OswHealthDTO)) {
            return false;
        }
        OswHealthDTO other = (OswHealthDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Map<Long, a> this$oswHealthDataMap = this.getOswHealthDataMap();
        Map<Long, a> other$oswHealthDataMap = other.getOswHealthDataMap();
        if (this$oswHealthDataMap == null ? other$oswHealthDataMap != null : !((Object)this$oswHealthDataMap).equals(other$oswHealthDataMap)) {
            return false;
        }
        Set<Integer> this$topologyPorts = this.getTopologyPorts();
        Set<Integer> other$topologyPorts = other.getTopologyPorts();
        if (this$topologyPorts == null ? other$topologyPorts != null : !((Object)this$topologyPorts).equals(other$topologyPorts)) {
            return false;
        }
        Map<Integer, b> this$portDataMap = this.getPortDataMap();
        Map<Integer, b> other$portDataMap = other.getPortDataMap();
        return !(this$portDataMap == null ? other$portDataMap != null : !((Object)this$portDataMap).equals(other$portDataMap));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OswHealthDTO;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<Long, a> $oswHealthDataMap = this.getOswHealthDataMap();
        result = result * 59 + ($oswHealthDataMap == null ? 43 : ((Object)$oswHealthDataMap).hashCode());
        Set<Integer> $topologyPorts = this.getTopologyPorts();
        result = result * 59 + ($topologyPorts == null ? 43 : ((Object)$topologyPorts).hashCode());
        Map<Integer, b> $portDataMap = this.getPortDataMap();
        result = result * 59 + ($portDataMap == null ? 43 : ((Object)$portDataMap).hashCode());
        return result;
    }

    @Generated
    public Map<Long, a> getOswHealthDataMap() {
        return this.oswHealthDataMap;
    }

    @Generated
    public Set<Integer> getTopologyPorts() {
        return this.topologyPorts;
    }

    @Generated
    public Map<Integer, b> getPortDataMap() {
        return this.portDataMap;
    }

    @Generated
    public void setOswHealthDataMap(Map<Long, a> oswHealthDataMap) {
        this.oswHealthDataMap = oswHealthDataMap;
    }

    @Generated
    public void setTopologyPorts(Set<Integer> topologyPorts) {
        this.topologyPorts = topologyPorts;
    }

    @Generated
    public void setPortDataMap(Map<Integer, b> portDataMap) {
        this.portDataMap = portDataMap;
    }

    @Generated
    public OswHealthDTO() {
    }

    @Generated
    public OswHealthDTO(Map<Long, a> oswHealthDataMap, Set<Integer> topologyPorts, Map<Integer, b> portDataMap) {
        this.oswHealthDataMap = oswHealthDataMap;
        this.topologyPorts = topologyPorts;
        this.portDataMap = portDataMap;
    }

    @Override
    @Generated
    public String toString() {
        return "OswHealthDTO(super=" + super.toString() + ", oswHealthDataMap=" + this.getOswHealthDataMap() + ", topologyPorts=" + this.getTopologyPorts() + ", portDataMap=" + this.getPortDataMap() + ")";
    }
}

