/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.api.dto.health.osg.wan;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.b;
import com.tplink.smb.omada.common.constant.o;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.device.manage.message.body.osg.OsgInformBody;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformOsgPort;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformOsgPortTraffic;
import com.tplink.smb.omada.device.manage.message.inform.osg.OsgInformDeviceInfo;
import com.tplink.smb.omada.device.manage.message.inform.osg.OsgPortStatus;
import com.tplink.smb.omada.device.manage.message.inform.osg.OsgPortTraffic;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class WanHealthDTO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WanHealthDTO.class);
    private String omadacId;
    private String siteId;
    @a
    private String mac;
    private long timestamp;
    private long upSeconds;
    private long markTime;
    private Map<Integer, Integer> osgPortMode;
    private Map<Integer, Integer> portStatusMap;
    private Map<Integer, b> wanDataMap;
    private Map<Integer, com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.a> periodWanDataMap;

    public WanHealthDTO(String omadacId, String siteId, String mac, long timestamp, long markTime, Map<Integer, Integer> osgPortMode) {
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.mac = mac;
        this.timestamp = timestamp;
        this.markTime = markTime;
        this.osgPortMode = osgPortMode;
        this.portStatusMap = new HashMap<Integer, Integer>(8);
        this.wanDataMap = new HashMap<Integer, b>(8);
        this.periodWanDataMap = new HashMap<Integer, com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.a>(8);
    }

    public void merge(OsgInformBody informBody, Long timestamp, String omadacId, String mac) {
        this.timestamp = timestamp;
        this.osgPortMode.forEach((port, mode) -> {
            if (!this.portStatusMap.containsKey(port) && Objects.equals(mode, o.l)) {
                this.portStatusMap.put((Integer)port, 5);
            }
        });
        com.tplink.smb.omada.anomaly.api.e.a.a(log, "WanHealthDTO.merge,omadaId {}, siteId {}, mac {},  portStatusMap is {}", omadacId, this.siteId, mac, this.portStatusMap);
        boolean rebooted = this.mergeDeviceInfo(informBody.getDeviceInfo());
        this.mergePortInfo(informBody.getPortInfo(), timestamp, omadacId, mac);
        this.mergeTrafficStat(informBody.getTrafficStat(), rebooted, timestamp);
    }

    private boolean mergeDeviceInfo(OsgInformDeviceInfo deviceInfo) {
        boolean rebooted = false;
        if (Objects.nonNull(deviceInfo)) {
            long startTime = T.k((String)deviceInfo.getUpTime()) * 1000L;
            if (this.upSeconds != 0L && this.upSeconds > startTime) {
                log.debug("osg rebooted mac: {} upSeconds {} upTime: {}", new Object[]{this.mac, this.upSeconds, startTime});
                rebooted = true;
            }
            this.upSeconds = startTime;
        }
        return rebooted;
    }

    private void mergePortInfo(InformOsgPort portInfo, Long timestamp, String omadacId, String mac) {
        if (Objects.isNull(portInfo)) {
            return;
        }
        List portStatusList = portInfo.getPortStatusList();
        if (CollectionUtils.isEmpty((Collection)portStatusList)) {
            return;
        }
        if (CollectionUtils.isEmpty(this.osgPortMode)) {
            return;
        }
        if (CollectionUtils.isEmpty(this.periodWanDataMap)) {
            this.periodWanDataMap = new HashMap<Integer, com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.a>(8);
        }
        for (OsgPortStatus portStatus : portStatusList) {
            Integer port = portStatus.getPort();
            com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.a periodWanData = this.periodWanDataMap.getOrDefault(port, new com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.a(port));
            b realTimeWanData = this.wanDataMap.getOrDefault(port, new b(port));
            periodWanData.a(portStatus.getName());
            if (this.checkWanOffline(port, portStatus)) {
                this.portStatusMap.put(port, 4);
            }
            if (Objects.equals(this.osgPortMode.get(port), o.m) && portStatus.getInternetState().equals(1) && portStatus.getLatency() != 0) {
                log.debug("omadacId: {}, mac: {}, portStatus(port = {}, ,latency={}) set online", new Object[]{omadacId, mac, port, portStatus.getLatency()});
                this.portStatusMap.put(port, 6);
                if (Objects.nonNull(portStatus.getLatency())) {
                    realTimeWanData.d().put(timestamp, portStatus.getLatency());
                    this.wanDataMap.put(port, realTimeWanData);
                }
            }
            this.periodWanDataMap.put(port, periodWanData);
        }
    }

    private void mergeTrafficStat(InformOsgPortTraffic trafficStat, boolean rebooted, Long timestamp) {
        if (Objects.isNull(trafficStat)) {
            return;
        }
        List portTrafficList = trafficStat.getPortTrafficList();
        if (CollectionUtils.isEmpty((Collection)portTrafficList)) {
            return;
        }
        if (Objects.isNull(this.osgPortMode)) {
            return;
        }
        for (OsgPortTraffic portTraffic : portTrafficList) {
            Integer port = portTraffic.getPort();
            b oldData = this.wanDataMap.get(port);
            b newData = b.a(oldData, portTraffic, timestamp);
            this.wanDataMap.put(port, newData);
            com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.a periodWanData = this.periodWanDataMap.getOrDefault(port, new com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.a(port));
            periodWanData.a(oldData, newData, rebooted);
            this.periodWanDataMap.put(port, periodWanData);
        }
    }

    private boolean checkWanOffline(Integer port, OsgPortStatus portStatus) {
        if (Objects.equals(this.osgPortMode.get(port), o.m) && !Objects.equals(this.portStatusMap.get(port), 6)) {
            return portStatus.getLatency() == 0 || Objects.equals(portStatus.getInternetState(), 0) && Objects.equals(portStatus.getInternetV6(), 0);
        }
        return false;
    }

    public void clear() {
        this.portStatusMap.clear();
        this.periodWanDataMap.clear();
        this.wanDataMap.clear();
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public long getUpSeconds() {
        return this.upSeconds;
    }

    @Generated
    public long getMarkTime() {
        return this.markTime;
    }

    @Generated
    public Map<Integer, Integer> getOsgPortMode() {
        return this.osgPortMode;
    }

    @Generated
    public Map<Integer, Integer> getPortStatusMap() {
        return this.portStatusMap;
    }

    @Generated
    public Map<Integer, b> getWanDataMap() {
        return this.wanDataMap;
    }

    @Generated
    public Map<Integer, com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.a> getPeriodWanDataMap() {
        return this.periodWanDataMap;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setUpSeconds(long upSeconds) {
        this.upSeconds = upSeconds;
    }

    @Generated
    public void setMarkTime(long markTime) {
        this.markTime = markTime;
    }

    @Generated
    public void setOsgPortMode(Map<Integer, Integer> osgPortMode) {
        this.osgPortMode = osgPortMode;
    }

    @Generated
    public void setPortStatusMap(Map<Integer, Integer> portStatusMap) {
        this.portStatusMap = portStatusMap;
    }

    @Generated
    public void setWanDataMap(Map<Integer, b> wanDataMap) {
        this.wanDataMap = wanDataMap;
    }

    @Generated
    public void setPeriodWanDataMap(Map<Integer, com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.a> periodWanDataMap) {
        this.periodWanDataMap = periodWanDataMap;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof WanHealthDTO)) {
            return false;
        }
        WanHealthDTO other = (WanHealthDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getUpSeconds() != other.getUpSeconds()) {
            return false;
        }
        if (this.getMarkTime() != other.getMarkTime()) {
            return false;
        }
        String this$omadacId = this.getOmadacId();
        String other$omadacId = other.getOmadacId();
        if (this$omadacId == null ? other$omadacId != null : !this$omadacId.equals(other$omadacId)) {
            return false;
        }
        String this$siteId = this.getSiteId();
        String other$siteId = other.getSiteId();
        if (this$siteId == null ? other$siteId != null : !this$siteId.equals(other$siteId)) {
            return false;
        }
        String this$mac = this.getMac();
        String other$mac = other.getMac();
        if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
            return false;
        }
        Map<Integer, Integer> this$osgPortMode = this.getOsgPortMode();
        Map<Integer, Integer> other$osgPortMode = other.getOsgPortMode();
        if (this$osgPortMode == null ? other$osgPortMode != null : !((Object)this$osgPortMode).equals(other$osgPortMode)) {
            return false;
        }
        Map<Integer, Integer> this$portStatusMap = this.getPortStatusMap();
        Map<Integer, Integer> other$portStatusMap = other.getPortStatusMap();
        if (this$portStatusMap == null ? other$portStatusMap != null : !((Object)this$portStatusMap).equals(other$portStatusMap)) {
            return false;
        }
        Map<Integer, b> this$wanDataMap = this.getWanDataMap();
        Map<Integer, b> other$wanDataMap = other.getWanDataMap();
        if (this$wanDataMap == null ? other$wanDataMap != null : !((Object)this$wanDataMap).equals(other$wanDataMap)) {
            return false;
        }
        Map<Integer, com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.a> this$periodWanDataMap = this.getPeriodWanDataMap();
        Map<Integer, com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.a> other$periodWanDataMap = other.getPeriodWanDataMap();
        return !(this$periodWanDataMap == null ? other$periodWanDataMap != null : !((Object)this$periodWanDataMap).equals(other$periodWanDataMap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WanHealthDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        long $upSeconds = this.getUpSeconds();
        result = result * 59 + (int)($upSeconds >>> 32 ^ $upSeconds);
        long $markTime = this.getMarkTime();
        result = result * 59 + (int)($markTime >>> 32 ^ $markTime);
        String $omadacId = this.getOmadacId();
        result = result * 59 + ($omadacId == null ? 43 : $omadacId.hashCode());
        String $siteId = this.getSiteId();
        result = result * 59 + ($siteId == null ? 43 : $siteId.hashCode());
        String $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
        Map<Integer, Integer> $osgPortMode = this.getOsgPortMode();
        result = result * 59 + ($osgPortMode == null ? 43 : ((Object)$osgPortMode).hashCode());
        Map<Integer, Integer> $portStatusMap = this.getPortStatusMap();
        result = result * 59 + ($portStatusMap == null ? 43 : ((Object)$portStatusMap).hashCode());
        Map<Integer, b> $wanDataMap = this.getWanDataMap();
        result = result * 59 + ($wanDataMap == null ? 43 : ((Object)$wanDataMap).hashCode());
        Map<Integer, com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.a> $periodWanDataMap = this.getPeriodWanDataMap();
        result = result * 59 + ($periodWanDataMap == null ? 43 : ((Object)$periodWanDataMap).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WanHealthDTO(omadacId=" + this.getOmadacId() + ", siteId=" + this.getSiteId() + ", mac=" + this.getMac() + ", timestamp=" + this.getTimestamp() + ", upSeconds=" + this.getUpSeconds() + ", markTime=" + this.getMarkTime() + ", osgPortMode=" + this.getOsgPortMode() + ", portStatusMap=" + this.getPortStatusMap() + ", wanDataMap=" + this.getWanDataMap() + ", periodWanDataMap=" + this.getPeriodWanDataMap() + ")";
    }

    @Generated
    public WanHealthDTO(String omadacId, String siteId, String mac, long timestamp, long upSeconds, long markTime, Map<Integer, Integer> osgPortMode, Map<Integer, Integer> portStatusMap, Map<Integer, b> wanDataMap, Map<Integer, com.tplink.smb.omada.anomaly.api.dto.health.osg.wan.a> periodWanDataMap) {
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.mac = mac;
        this.timestamp = timestamp;
        this.upSeconds = upSeconds;
        this.markTime = markTime;
        this.osgPortMode = osgPortMode;
        this.portStatusMap = portStatusMap;
        this.wanDataMap = wanDataMap;
        this.periodWanDataMap = periodWanDataMap;
    }

    @Generated
    public WanHealthDTO() {
    }
}

