/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.api.dto.health.osg;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.anomaly.api.dto.health.osg.OsgLatestHealthScoreDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgPostHealthScoreDTO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OsgPostHealthScoreDTO.class);
    @a
    private String mac;
    private List<OsgPostHealthTimeScoreDTO> osgTimeScoreList;

    public List<OsgPostHealthTimeScoreDTO> getEffectiveTimeScoreList(String omadacId, String siteId, Long currentTime, int lastCount) {
        Map<Long, OsgPostHealthTimeScoreDTO> timeScoreMap = Optional.ofNullable(this.osgTimeScoreList).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).collect(Collectors.toMap(OsgPostHealthTimeScoreDTO::getTimestamp, score -> score, (existing, replacement) -> existing));
        ArrayList<OsgPostHealthTimeScoreDTO> effectiveTimeScoreList = new ArrayList<OsgPostHealthTimeScoreDTO>(lastCount);
        for (int i2 = 0; i2 < lastCount; ++i2) {
            Long timePoint = currentTime - (long)((i2 + 1) * 600);
            OsgPostHealthTimeScoreDTO scoreDTO = timeScoreMap.get(timePoint);
            if (scoreDTO != null) {
                effectiveTimeScoreList.add(scoreDTO);
                continue;
            }
            effectiveTimeScoreList.add(OsgPostHealthTimeScoreDTO.createNoDataDTO(timePoint));
        }
        com.tplink.smb.omada.anomaly.api.e.a.a(log, "OsgPostHealthScoreDTO.getEffectiveTimeScoreList, omadacId {}, siteId {},  source time scores is {}, effective time scores after fill zero is {}", omadacId, siteId, this.osgTimeScoreList, effectiveTimeScoreList);
        return effectiveTimeScoreList;
    }

    public OsgPostHealthScoreDTO(String mac, Long time, OsgLatestHealthScoreDTO latestHealthScoreDTO) {
        this.mac = mac;
        OsgPostHealthTimeScoreDTO timeScoreDTO = OsgPostHealthTimeScoreDTO.createNoDataDTO(time);
        if (Objects.nonNull(latestHealthScoreDTO)) {
            timeScoreDTO.setCpuUtilScore(latestHealthScoreDTO.getCpuUtilScore());
            timeScoreDTO.setMemUtilScore(latestHealthScoreDTO.getMemUtilScore());
            timeScoreDTO.setTemperatureScore(latestHealthScoreDTO.getTemperatureScore());
            timeScoreDTO.setChannelUtilScore(latestHealthScoreDTO.getChannelUtilScore());
            timeScoreDTO.setTransmissionQualityScore(latestHealthScoreDTO.getTransmissionQualityScore());
        }
        ArrayList<OsgPostHealthTimeScoreDTO> timeScoreDTOList = new ArrayList<OsgPostHealthTimeScoreDTO>();
        timeScoreDTOList.add(timeScoreDTO);
        this.osgTimeScoreList = timeScoreDTOList;
    }

    public void merge(Long time, OsgLatestHealthScoreDTO latestHealthScoreDTO) {
        OsgPostHealthTimeScoreDTO toBeAddedScoreDTO = OsgPostHealthTimeScoreDTO.createNoDataDTO(time);
        if (Objects.nonNull(latestHealthScoreDTO)) {
            toBeAddedScoreDTO = new OsgPostHealthTimeScoreDTO(time, latestHealthScoreDTO.getCpuUtilScore(), latestHealthScoreDTO.getMemUtilScore(), latestHealthScoreDTO.getTemperatureScore(), latestHealthScoreDTO.getChannelUtilScore(), latestHealthScoreDTO.getTransmissionQualityScore());
        }
        if (Objects.isNull(this.osgTimeScoreList)) {
            this.osgTimeScoreList = new ArrayList<OsgPostHealthTimeScoreDTO>();
        }
        this.osgTimeScoreList.add(toBeAddedScoreDTO);
        long expireThreshold = time - 3600L;
        this.osgTimeScoreList.removeIf(timeScore -> timeScore.getTimestamp() < expireThreshold);
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public List<OsgPostHealthTimeScoreDTO> getOsgTimeScoreList() {
        return this.osgTimeScoreList;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setOsgTimeScoreList(List<OsgPostHealthTimeScoreDTO> osgTimeScoreList) {
        this.osgTimeScoreList = osgTimeScoreList;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof OsgPostHealthScoreDTO)) {
            return false;
        }
        OsgPostHealthScoreDTO other = (OsgPostHealthScoreDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$mac = this.getMac();
        String other$mac = other.getMac();
        if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
            return false;
        }
        List<OsgPostHealthTimeScoreDTO> this$osgTimeScoreList = this.getOsgTimeScoreList();
        List<OsgPostHealthTimeScoreDTO> other$osgTimeScoreList = other.getOsgTimeScoreList();
        return !(this$osgTimeScoreList == null ? other$osgTimeScoreList != null : !((Object)this$osgTimeScoreList).equals(other$osgTimeScoreList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OsgPostHealthScoreDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
        List<OsgPostHealthTimeScoreDTO> $osgTimeScoreList = this.getOsgTimeScoreList();
        result = result * 59 + ($osgTimeScoreList == null ? 43 : ((Object)$osgTimeScoreList).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OsgPostHealthScoreDTO(mac=" + this.getMac() + ", osgTimeScoreList=" + this.getOsgTimeScoreList() + ")";
    }

    @Generated
    public OsgPostHealthScoreDTO() {
    }

    public static class OsgPostHealthTimeScoreDTO {
        private Long timestamp;
        private Integer cpuUtilScore;
        private Integer memUtilScore;
        private Integer temperatureScore;
        private Integer channelUtilScore;
        private Integer transmissionQualityScore;

        public static OsgPostHealthTimeScoreDTO createNoDataDTO(Long time) {
            return new OsgPostHealthTimeScoreDTO(time, 0, 0, 0, 0, 0);
        }

        @Generated
        public Long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public Integer getCpuUtilScore() {
            return this.cpuUtilScore;
        }

        @Generated
        public Integer getMemUtilScore() {
            return this.memUtilScore;
        }

        @Generated
        public Integer getTemperatureScore() {
            return this.temperatureScore;
        }

        @Generated
        public Integer getChannelUtilScore() {
            return this.channelUtilScore;
        }

        @Generated
        public Integer getTransmissionQualityScore() {
            return this.transmissionQualityScore;
        }

        @Generated
        public void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        @Generated
        public void setCpuUtilScore(Integer cpuUtilScore) {
            this.cpuUtilScore = cpuUtilScore;
        }

        @Generated
        public void setMemUtilScore(Integer memUtilScore) {
            this.memUtilScore = memUtilScore;
        }

        @Generated
        public void setTemperatureScore(Integer temperatureScore) {
            this.temperatureScore = temperatureScore;
        }

        @Generated
        public void setChannelUtilScore(Integer channelUtilScore) {
            this.channelUtilScore = channelUtilScore;
        }

        @Generated
        public void setTransmissionQualityScore(Integer transmissionQualityScore) {
            this.transmissionQualityScore = transmissionQualityScore;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof OsgPostHealthTimeScoreDTO)) {
                return false;
            }
            OsgPostHealthTimeScoreDTO other = (OsgPostHealthTimeScoreDTO)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$timestamp = this.getTimestamp();
            Long other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                return false;
            }
            Integer this$cpuUtilScore = this.getCpuUtilScore();
            Integer other$cpuUtilScore = other.getCpuUtilScore();
            if (this$cpuUtilScore == null ? other$cpuUtilScore != null : !((Object)this$cpuUtilScore).equals(other$cpuUtilScore)) {
                return false;
            }
            Integer this$memUtilScore = this.getMemUtilScore();
            Integer other$memUtilScore = other.getMemUtilScore();
            if (this$memUtilScore == null ? other$memUtilScore != null : !((Object)this$memUtilScore).equals(other$memUtilScore)) {
                return false;
            }
            Integer this$temperatureScore = this.getTemperatureScore();
            Integer other$temperatureScore = other.getTemperatureScore();
            if (this$temperatureScore == null ? other$temperatureScore != null : !((Object)this$temperatureScore).equals(other$temperatureScore)) {
                return false;
            }
            Integer this$channelUtilScore = this.getChannelUtilScore();
            Integer other$channelUtilScore = other.getChannelUtilScore();
            if (this$channelUtilScore == null ? other$channelUtilScore != null : !((Object)this$channelUtilScore).equals(other$channelUtilScore)) {
                return false;
            }
            Integer this$transmissionQualityScore = this.getTransmissionQualityScore();
            Integer other$transmissionQualityScore = other.getTransmissionQualityScore();
            return !(this$transmissionQualityScore == null ? other$transmissionQualityScore != null : !((Object)this$transmissionQualityScore).equals(other$transmissionQualityScore));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OsgPostHealthTimeScoreDTO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            Integer $cpuUtilScore = this.getCpuUtilScore();
            result = result * 59 + ($cpuUtilScore == null ? 43 : ((Object)$cpuUtilScore).hashCode());
            Integer $memUtilScore = this.getMemUtilScore();
            result = result * 59 + ($memUtilScore == null ? 43 : ((Object)$memUtilScore).hashCode());
            Integer $temperatureScore = this.getTemperatureScore();
            result = result * 59 + ($temperatureScore == null ? 43 : ((Object)$temperatureScore).hashCode());
            Integer $channelUtilScore = this.getChannelUtilScore();
            result = result * 59 + ($channelUtilScore == null ? 43 : ((Object)$channelUtilScore).hashCode());
            Integer $transmissionQualityScore = this.getTransmissionQualityScore();
            result = result * 59 + ($transmissionQualityScore == null ? 43 : ((Object)$transmissionQualityScore).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "OsgPostHealthScoreDTO.OsgPostHealthTimeScoreDTO(timestamp=" + this.getTimestamp() + ", cpuUtilScore=" + this.getCpuUtilScore() + ", memUtilScore=" + this.getMemUtilScore() + ", temperatureScore=" + this.getTemperatureScore() + ", channelUtilScore=" + this.getChannelUtilScore() + ", transmissionQualityScore=" + this.getTransmissionQualityScore() + ")";
        }

        @Generated
        public OsgPostHealthTimeScoreDTO() {
        }

        @Generated
        public OsgPostHealthTimeScoreDTO(Long timestamp, Integer cpuUtilScore, Integer memUtilScore, Integer temperatureScore, Integer channelUtilScore, Integer transmissionQualityScore) {
            this.timestamp = timestamp;
            this.cpuUtilScore = cpuUtilScore;
            this.memUtilScore = memUtilScore;
            this.temperatureScore = temperatureScore;
            this.channelUtilScore = channelUtilScore;
            this.transmissionQualityScore = transmissionQualityScore;
        }
    }
}

