/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.api.dto.health.osg;

import com.tplink.smb.omada.anomaly.api.dto.health.BaseHealthDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.osg.a;
import com.tplink.smb.omada.anomaly.api.dto.health.osg.b;
import com.tplink.smb.omada.common.constant.o;
import com.tplink.smb.omada.device.manage.message.body.osg.OsgInformBody;
import com.tplink.smb.omada.device.manage.message.inform.ap.TrafficStats;
import com.tplink.smb.omada.device.manage.message.inform.ap.WirelessInfo;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformOsgPort;
import com.tplink.smb.omada.device.manage.message.inform.osg.InformOsgPortTraffic;
import com.tplink.smb.omada.device.manage.message.inform.osg.OsgInformDeviceInfo;
import com.tplink.smb.omada.device.manage.message.inform.osg.OsgPortStatus;
import com.tplink.smb.omada.device.manage.message.inform.osg.OsgPortTraffic;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class OsgHealthDTO
extends BaseHealthDTO {
    private Set<Integer> usedPort;
    private Map<Integer, b> portDataMap;
    private Map<Long, a> osgHealthDataMap;

    public OsgHealthDTO(String omadacId, String siteId, String mac, long timestamp) {
        super(omadacId, siteId, mac, timestamp);
        this.portDataMap = new ConcurrentHashMap<Integer, b>();
        this.osgHealthDataMap = new ConcurrentHashMap<Long, a>();
        this.usedPort = new HashSet<Integer>();
    }

    public void merge(OsgInformBody osgInformBody, long pktTimestamp) {
        this.mergeDeviceInfo(osgInformBody.getDeviceInfo(), pktTimestamp);
        this.mergePortInfo(osgInformBody.getPortInfo(), pktTimestamp);
        this.mergePortTraffic(osgInformBody.getTrafficStat(), pktTimestamp);
        this.mergeWSetting(osgInformBody.getWSettings2G(), osgInformBody.getWSettings5G(), osgInformBody.getWSettings5G2(), pktTimestamp);
        this.mergeRadioTraffic(osgInformBody.getRadioTraffic2G(), osgInformBody.getRadioTraffic5G(), osgInformBody.getRadioTraffic5G2(), pktTimestamp);
        this.timestamp = pktTimestamp;
    }

    private void mergeRadioTraffic(TrafficStats radioTraffic2G, TrafficStats radioTraffic5G, TrafficStats radioTraffic5G2, long pktTimestamp) {
        if (Objects.isNull(radioTraffic2G) && Objects.isNull(radioTraffic5G) && Objects.isNull(radioTraffic5G2)) {
            return;
        }
        a healthData = this.osgHealthDataMap.computeIfAbsent(pktTimestamp, pkTime -> new a());
        this.mergeSingleRadioTraffic(radioTraffic2G, healthData, 1);
        this.mergeSingleRadioTraffic(radioTraffic5G, healthData, 2);
        this.mergeSingleRadioTraffic(radioTraffic5G2, healthData, 3);
    }

    private void mergeSingleRadioTraffic(TrafficStats radioTraffic, a healthData, int channel) {
        if (Objects.isNull(radioTraffic)) {
            return;
        }
        Integer retryRate = OsgHealthDTO.calculateTxRetryRate(radioTraffic.getTxPkts(), radioTraffic.getTxRetryPkts());
        Integer dropRate = OsgHealthDTO.calculateTxDropRate(radioTraffic.getTxPkts(), radioTraffic.getTxDropPkts());
        switch (channel) {
            case 1: {
                healthData.g(retryRate);
                healthData.j(dropRate);
                break;
            }
            case 2: {
                healthData.h(retryRate);
                healthData.k(dropRate);
                break;
            }
            case 3: {
                healthData.i(retryRate);
                healthData.l(dropRate);
                break;
            }
        }
    }

    private static Integer calculateTxRetryRate(Long txP, Long txRP) {
        if (Objects.isNull(txP) || Objects.isNull(txRP) || Objects.equals(txP, 0L) && !Objects.equals(txRP, 0L)) {
            return -1;
        }
        return Math.round((float)txRP.longValue() / (float)txP.longValue() * 100.0f);
    }

    private static Integer calculateTxDropRate(Long txP, Long txDP) {
        if (Objects.isNull(txP) || Objects.isNull(txDP) || Objects.equals(txP, 0L) && !Objects.equals(txDP, 0L)) {
            return -1;
        }
        return Math.round((float)txDP.longValue() / (float)txP.longValue() * 100.0f);
    }

    private void mergeWSetting(WirelessInfo wSettings2G, WirelessInfo wSettings5G, WirelessInfo wSettings5G2, long pktTimestamp) {
        if (Objects.isNull(wSettings2G) && Objects.isNull(wSettings5G) && Objects.isNull(wSettings5G2)) {
            return;
        }
        a healthData = this.osgHealthDataMap.computeIfAbsent(pktTimestamp, pkTime -> new a());
        this.mergeSingleWSetting(wSettings2G, healthData, 1);
        this.mergeSingleWSetting(wSettings5G, healthData, 2);
        this.mergeSingleWSetting(wSettings5G2, healthData, 3);
    }

    private void mergeSingleWSetting(WirelessInfo wSettings, a healthData, int channel) {
        if (wSettings == null) {
            return;
        }
        Integer chanUtil = wSettings.getInterUtil() != null && wSettings.getRxUtil() != null && wSettings.getTxUtil() != null ? Integer.valueOf(wSettings.getInterUtil() + wSettings.getRxUtil() + wSettings.getTxUtil()) : wSettings.getBusyUtil();
        switch (channel) {
            case 1: {
                healthData.d(chanUtil);
                break;
            }
            case 2: {
                healthData.e(chanUtil);
                break;
            }
            case 3: {
                healthData.f(chanUtil);
                break;
            }
        }
    }

    private void mergeDeviceInfo(OsgInformDeviceInfo deviceInfo, long pktTimestamp) {
        if (Objects.isNull(deviceInfo)) {
            return;
        }
        a osgHealthData = new a();
        if (Objects.nonNull(deviceInfo.getCpuUtil())) {
            osgHealthData.a(deviceInfo.getCpuUtil());
        }
        if (Objects.nonNull(deviceInfo.getMemUtil())) {
            osgHealthData.b(deviceInfo.getMemUtil());
        }
        if (Objects.nonNull(deviceInfo.getTemp())) {
            osgHealthData.c(deviceInfo.getTemp());
        }
        this.osgHealthDataMap.put(pktTimestamp, osgHealthData);
    }

    private void mergePortInfo(InformOsgPort osgPort, long pktTimestamp) {
        if (Objects.isNull(osgPort)) {
            return;
        }
        List portStatusList = osgPort.getPortStatusList();
        if (CollectionUtils.isEmpty((Collection)portStatusList)) {
            return;
        }
        for (OsgPortStatus osgPortStatus : portStatusList) {
            Integer port = osgPortStatus.getPort();
            b osgHealthPortData = this.portDataMap.getOrDefault(port, new b(port));
            Integer lastInternetState = osgHealthPortData.j();
            boolean wanMode = false;
            if (Objects.equals(osgHealthPortData.h(), o.m) && Objects.equals(osgPortStatus.getMode(), o.m)) {
                wanMode = true;
            }
            if (pktTimestamp >= this.timestamp) {
                osgHealthPortData.b(osgPortStatus.getMode());
                osgHealthPortData.c(osgPortStatus.getStatus());
                osgHealthPortData.d(osgPortStatus.getInternetState());
            } else {
                lastInternetState = osgPortStatus.getInternetState();
            }
            if (wanMode && Objects.equals(lastInternetState, 1) && Objects.equals(osgHealthPortData.j(), 0)) {
                osgHealthPortData.c(Boolean.TRUE);
            }
            this.portDataMap.put(port, osgHealthPortData);
            if (!Objects.equals(osgHealthPortData.i(), o.p)) continue;
            this.usedPort.add(port);
        }
    }

    private void mergePortTraffic(InformOsgPortTraffic trafficStat, long pktTimestamp) {
        if (Objects.isNull(trafficStat)) {
            return;
        }
        List portTrafficList = trafficStat.getPortTrafficList();
        if (CollectionUtils.isEmpty((Collection)portTrafficList)) {
            return;
        }
        for (OsgPortTraffic osgPortTraffic : portTrafficList) {
            if (Objects.isNull(osgPortTraffic.getLossPackets())) continue;
            Integer port = osgPortTraffic.getPort();
            b osgHealthPortData = this.portDataMap.get(port);
            osgHealthPortData = this.handlePktData(port, pktTimestamp, osgHealthPortData, osgPortTraffic);
            this.portDataMap.put(port, osgHealthPortData);
        }
    }

    private b handlePktData(Integer port, long pktTimestamp, b osgHealthPortData, OsgPortTraffic osgPortTraffic) {
        if (Objects.isNull(osgHealthPortData)) {
            osgHealthPortData = new b(port);
        }
        if (Objects.nonNull(osgHealthPortData.b()) && !Objects.equals(osgHealthPortData.b(), osgPortTraffic.getLossPackets()) && osgPortTraffic.getLossPackets() != 0L) {
            osgHealthPortData.a(Boolean.TRUE);
        }
        if (this.checkWanErrPkt(osgHealthPortData, osgPortTraffic) || this.checkLanErrPkt(osgHealthPortData, osgPortTraffic)) {
            osgHealthPortData.b(Boolean.TRUE);
        }
        if (pktTimestamp > this.timestamp) {
            osgHealthPortData.a(osgPortTraffic.getLossPackets());
            osgHealthPortData.c(osgPortTraffic.getTxErrorPackets());
            osgHealthPortData.d(osgPortTraffic.getRxErrorPackets());
            osgHealthPortData.b(osgPortTraffic.getErrorPackets());
        }
        return osgHealthPortData;
    }

    private boolean checkLanErrPkt(b osgHealthPortData, OsgPortTraffic osgPortTraffic) {
        return Objects.equals(osgHealthPortData.h(), o.n) && Objects.nonNull(osgHealthPortData.d()) && !Objects.equals(osgHealthPortData.d(), osgPortTraffic.getErrorPackets()) && osgPortTraffic.getErrorPackets() != 0L;
    }

    private boolean checkWanErrPkt(b osgHealthPortData, OsgPortTraffic osgPortTraffic) {
        return Objects.equals(osgHealthPortData.h(), o.m) && Objects.nonNull(osgHealthPortData.e()) && !Objects.equals(osgHealthPortData.e(), osgPortTraffic.getTxErrorPackets()) && osgPortTraffic.getTxErrorPackets() != 0L;
    }

    public void clear() {
        this.osgHealthDataMap.clear();
    }

    @Override
    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof OsgHealthDTO)) {
            return false;
        }
        OsgHealthDTO other = (OsgHealthDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Set<Integer> this$usedPort = this.getUsedPort();
        Set<Integer> other$usedPort = other.getUsedPort();
        if (this$usedPort == null ? other$usedPort != null : !((Object)this$usedPort).equals(other$usedPort)) {
            return false;
        }
        Map<Integer, b> this$portDataMap = this.getPortDataMap();
        Map<Integer, b> other$portDataMap = other.getPortDataMap();
        if (this$portDataMap == null ? other$portDataMap != null : !((Object)this$portDataMap).equals(other$portDataMap)) {
            return false;
        }
        Map<Long, a> this$osgHealthDataMap = this.getOsgHealthDataMap();
        Map<Long, a> other$osgHealthDataMap = other.getOsgHealthDataMap();
        return !(this$osgHealthDataMap == null ? other$osgHealthDataMap != null : !((Object)this$osgHealthDataMap).equals(other$osgHealthDataMap));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OsgHealthDTO;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Set<Integer> $usedPort = this.getUsedPort();
        result = result * 59 + ($usedPort == null ? 43 : ((Object)$usedPort).hashCode());
        Map<Integer, b> $portDataMap = this.getPortDataMap();
        result = result * 59 + ($portDataMap == null ? 43 : ((Object)$portDataMap).hashCode());
        Map<Long, a> $osgHealthDataMap = this.getOsgHealthDataMap();
        result = result * 59 + ($osgHealthDataMap == null ? 43 : ((Object)$osgHealthDataMap).hashCode());
        return result;
    }

    @Generated
    public Set<Integer> getUsedPort() {
        return this.usedPort;
    }

    @Generated
    public Map<Integer, b> getPortDataMap() {
        return this.portDataMap;
    }

    @Generated
    public Map<Long, a> getOsgHealthDataMap() {
        return this.osgHealthDataMap;
    }

    @Generated
    public void setUsedPort(Set<Integer> usedPort) {
        this.usedPort = usedPort;
    }

    @Generated
    public void setPortDataMap(Map<Integer, b> portDataMap) {
        this.portDataMap = portDataMap;
    }

    @Generated
    public void setOsgHealthDataMap(Map<Long, a> osgHealthDataMap) {
        this.osgHealthDataMap = osgHealthDataMap;
    }

    @Generated
    public OsgHealthDTO(Set<Integer> usedPort, Map<Integer, b> portDataMap, Map<Long, a> osgHealthDataMap) {
        this.usedPort = usedPort;
        this.portDataMap = portDataMap;
        this.osgHealthDataMap = osgHealthDataMap;
    }

    @Generated
    public OsgHealthDTO() {
    }

    @Override
    @Generated
    public String toString() {
        return "OsgHealthDTO(super=" + super.toString() + ", usedPort=" + this.getUsedPort() + ", portDataMap=" + this.getPortDataMap() + ", osgHealthDataMap=" + this.getOsgHealthDataMap() + ")";
    }
}

