/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.api.dto.health.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.anomaly.api.dto.health.client.ClientHealthScoreDTO;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class ClientHealthScoreAggrDTO {
    private String omadacId;
    private String siteId;
    private Long time;
    @a
    private String mac;
    private Boolean wireless;
    private String name;
    private String type;
    private Boolean manager;
    private Boolean guest;
    @a
    private String deviceMac;
    private String deviceName;
    private String deviceModel;
    private String deviceModelVersion;
    private String deviceType;
    private Integer score;
    private List<WirelessPropertyDTO> wirelessProperties;
    private List<WiredPropertyDTO> wiredProperties;

    public ClientHealthScoreDTO toClientHealthScoreDTO() {
        ClientHealthScoreDTO scoreDTO = new ClientHealthScoreDTO();
        scoreDTO.setOmadacId(this.omadacId);
        scoreDTO.setSiteId(this.siteId);
        scoreDTO.setTimestamp(this.time);
        scoreDTO.setMac(this.mac);
        scoreDTO.setName(this.name);
        scoreDTO.setScore(this.score);
        scoreDTO.setWireless(Boolean.TRUE.equals(this.wireless));
        scoreDTO.setManager(this.manager);
        scoreDTO.setType(this.type);
        scoreDTO.setGuest(this.guest);
        scoreDTO.setDeviceMac(this.deviceMac);
        scoreDTO.setDeviceType(this.deviceType);
        scoreDTO.setDeviceName(this.deviceName);
        scoreDTO.setDeviceModel(this.deviceModel);
        scoreDTO.setDeviceModelVersion(this.deviceModelVersion);
        if (Boolean.TRUE.equals(this.wireless)) {
            this.setHealthScoreWirelessProperty(scoreDTO);
        } else {
            this.setHealthScoreWiredProperty(scoreDTO);
        }
        return scoreDTO;
    }

    public ClientHealthScoreDTO toClientHealthV2ScoreDTO() {
        ClientHealthScoreDTO scoreDTO = new ClientHealthScoreDTO();
        scoreDTO.setOmadacId(this.omadacId);
        scoreDTO.setSiteId(this.siteId);
        scoreDTO.setTimestamp(this.time);
        scoreDTO.setMac(this.mac);
        scoreDTO.setScore(this.score);
        scoreDTO.setWireless(Boolean.TRUE.equals(this.wireless));
        return scoreDTO;
    }

    private void setHealthScoreWirelessProperty(ClientHealthScoreDTO scoreDTO) {
        if (CollectionUtils.isEmpty(this.wirelessProperties)) {
            return;
        }
        int totalCnt = 0;
        int totalConnectScore = 0;
        int totalRssiScore = 0;
        int totalSnrScore = 0;
        int totalDataRateScore = 0;
        int totalIssueScore = 0;
        Integer highestAnomalyLevel = null;
        int anomalyCount = 0;
        for (WirelessPropertyDTO dto : this.wirelessProperties) {
            ++totalCnt;
            totalConnectScore += dto.getConnectScore().intValue();
            totalRssiScore += dto.getRssiScore().intValue();
            totalSnrScore += dto.getSnrScore().intValue();
            totalDataRateScore += dto.getDataRateScore().intValue();
            totalIssueScore += dto.getIssueScore().intValue();
            anomalyCount += Objects.isNull(dto.getAnomalyCount()) ? 0 : dto.getAnomalyCount();
            if (Objects.isNull(highestAnomalyLevel)) {
                highestAnomalyLevel = dto.getHighestAnomalyLevel();
                continue;
            }
            if (!Objects.nonNull(dto.getHighestAnomalyLevel()) || dto.getHighestAnomalyLevel() >= highestAnomalyLevel) continue;
            highestAnomalyLevel = dto.getHighestAnomalyLevel();
        }
        if (totalCnt <= 0) {
            return;
        }
        scoreDTO.setWirelessScores(Math.round((float)totalConnectScore / (float)totalCnt), Math.round((float)totalRssiScore / (float)totalCnt), Math.round((float)totalSnrScore / (float)totalCnt), Math.round((float)totalDataRateScore / (float)totalCnt), Math.round((float)totalIssueScore / (float)totalCnt));
        scoreDTO.setHighestAnomalyLevel(highestAnomalyLevel);
        scoreDTO.setAnomalyCount(anomalyCount);
    }

    private void setHealthScoreWiredProperty(ClientHealthScoreDTO scoreDTO) {
        if (CollectionUtils.isEmpty(this.wiredProperties)) {
            return;
        }
        int totalCnt = 0;
        int totalConnectScore = 0;
        int totalLinkErrorScore = 0;
        for (WiredPropertyDTO dto : this.wiredProperties) {
            ++totalCnt;
            totalConnectScore += dto.getConnectScore().intValue();
            totalLinkErrorScore += dto.getLinkErrorScore().intValue();
        }
        if (totalCnt <= 0) {
            return;
        }
        scoreDTO.setWiredScores(Math.round((float)totalConnectScore / (float)totalCnt), Math.round((float)totalLinkErrorScore / (float)totalCnt));
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public Long getTime() {
        return this.time;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public Boolean getWireless() {
        return this.wireless;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Boolean getManager() {
        return this.manager;
    }

    @Generated
    public Boolean getGuest() {
        return this.guest;
    }

    @Generated
    public String getDeviceMac() {
        return this.deviceMac;
    }

    @Generated
    public String getDeviceName() {
        return this.deviceName;
    }

    @Generated
    public String getDeviceModel() {
        return this.deviceModel;
    }

    @Generated
    public String getDeviceModelVersion() {
        return this.deviceModelVersion;
    }

    @Generated
    public String getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public Integer getScore() {
        return this.score;
    }

    @Generated
    public List<WirelessPropertyDTO> getWirelessProperties() {
        return this.wirelessProperties;
    }

    @Generated
    public List<WiredPropertyDTO> getWiredProperties() {
        return this.wiredProperties;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @Generated
    public void setTime(Long time) {
        this.time = time;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setWireless(Boolean wireless) {
        this.wireless = wireless;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setManager(Boolean manager) {
        this.manager = manager;
    }

    @Generated
    public void setGuest(Boolean guest) {
        this.guest = guest;
    }

    @Generated
    public void setDeviceMac(String deviceMac) {
        this.deviceMac = deviceMac;
    }

    @Generated
    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    @Generated
    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    @Generated
    public void setDeviceModelVersion(String deviceModelVersion) {
        this.deviceModelVersion = deviceModelVersion;
    }

    @Generated
    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    @Generated
    public void setScore(Integer score) {
        this.score = score;
    }

    @Generated
    public void setWirelessProperties(List<WirelessPropertyDTO> wirelessProperties) {
        this.wirelessProperties = wirelessProperties;
    }

    @Generated
    public void setWiredProperties(List<WiredPropertyDTO> wiredProperties) {
        this.wiredProperties = wiredProperties;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof ClientHealthScoreAggrDTO)) {
            return false;
        }
        ClientHealthScoreAggrDTO other = (ClientHealthScoreAggrDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$time = this.getTime();
        Long other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        Boolean this$wireless = this.getWireless();
        Boolean other$wireless = other.getWireless();
        if (this$wireless == null ? other$wireless != null : !((Object)this$wireless).equals(other$wireless)) {
            return false;
        }
        Boolean this$manager = this.getManager();
        Boolean other$manager = other.getManager();
        if (this$manager == null ? other$manager != null : !((Object)this$manager).equals(other$manager)) {
            return false;
        }
        Boolean this$guest = this.getGuest();
        Boolean other$guest = other.getGuest();
        if (this$guest == null ? other$guest != null : !((Object)this$guest).equals(other$guest)) {
            return false;
        }
        Integer this$score = this.getScore();
        Integer other$score = other.getScore();
        if (this$score == null ? other$score != null : !((Object)this$score).equals(other$score)) {
            return false;
        }
        String this$omadacId = this.getOmadacId();
        String other$omadacId = other.getOmadacId();
        if (this$omadacId == null ? other$omadacId != null : !this$omadacId.equals(other$omadacId)) {
            return false;
        }
        String this$siteId = this.getSiteId();
        String other$siteId = other.getSiteId();
        if (this$siteId == null ? other$siteId != null : !this$siteId.equals(other$siteId)) {
            return false;
        }
        String this$mac = this.getMac();
        String other$mac = other.getMac();
        if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$deviceMac = this.getDeviceMac();
        String other$deviceMac = other.getDeviceMac();
        if (this$deviceMac == null ? other$deviceMac != null : !this$deviceMac.equals(other$deviceMac)) {
            return false;
        }
        String this$deviceName = this.getDeviceName();
        String other$deviceName = other.getDeviceName();
        if (this$deviceName == null ? other$deviceName != null : !this$deviceName.equals(other$deviceName)) {
            return false;
        }
        String this$deviceModel = this.getDeviceModel();
        String other$deviceModel = other.getDeviceModel();
        if (this$deviceModel == null ? other$deviceModel != null : !this$deviceModel.equals(other$deviceModel)) {
            return false;
        }
        String this$deviceModelVersion = this.getDeviceModelVersion();
        String other$deviceModelVersion = other.getDeviceModelVersion();
        if (this$deviceModelVersion == null ? other$deviceModelVersion != null : !this$deviceModelVersion.equals(other$deviceModelVersion)) {
            return false;
        }
        String this$deviceType = this.getDeviceType();
        String other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType)) {
            return false;
        }
        List<WirelessPropertyDTO> this$wirelessProperties = this.getWirelessProperties();
        List<WirelessPropertyDTO> other$wirelessProperties = other.getWirelessProperties();
        if (this$wirelessProperties == null ? other$wirelessProperties != null : !((Object)this$wirelessProperties).equals(other$wirelessProperties)) {
            return false;
        }
        List<WiredPropertyDTO> this$wiredProperties = this.getWiredProperties();
        List<WiredPropertyDTO> other$wiredProperties = other.getWiredProperties();
        return !(this$wiredProperties == null ? other$wiredProperties != null : !((Object)this$wiredProperties).equals(other$wiredProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientHealthScoreAggrDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        Boolean $wireless = this.getWireless();
        result = result * 59 + ($wireless == null ? 43 : ((Object)$wireless).hashCode());
        Boolean $manager = this.getManager();
        result = result * 59 + ($manager == null ? 43 : ((Object)$manager).hashCode());
        Boolean $guest = this.getGuest();
        result = result * 59 + ($guest == null ? 43 : ((Object)$guest).hashCode());
        Integer $score = this.getScore();
        result = result * 59 + ($score == null ? 43 : ((Object)$score).hashCode());
        String $omadacId = this.getOmadacId();
        result = result * 59 + ($omadacId == null ? 43 : $omadacId.hashCode());
        String $siteId = this.getSiteId();
        result = result * 59 + ($siteId == null ? 43 : $siteId.hashCode());
        String $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $deviceMac = this.getDeviceMac();
        result = result * 59 + ($deviceMac == null ? 43 : $deviceMac.hashCode());
        String $deviceName = this.getDeviceName();
        result = result * 59 + ($deviceName == null ? 43 : $deviceName.hashCode());
        String $deviceModel = this.getDeviceModel();
        result = result * 59 + ($deviceModel == null ? 43 : $deviceModel.hashCode());
        String $deviceModelVersion = this.getDeviceModelVersion();
        result = result * 59 + ($deviceModelVersion == null ? 43 : $deviceModelVersion.hashCode());
        String $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
        List<WirelessPropertyDTO> $wirelessProperties = this.getWirelessProperties();
        result = result * 59 + ($wirelessProperties == null ? 43 : ((Object)$wirelessProperties).hashCode());
        List<WiredPropertyDTO> $wiredProperties = this.getWiredProperties();
        result = result * 59 + ($wiredProperties == null ? 43 : ((Object)$wiredProperties).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClientHealthScoreAggrDTO(omadacId=" + this.getOmadacId() + ", siteId=" + this.getSiteId() + ", time=" + this.getTime() + ", mac=" + this.getMac() + ", wireless=" + this.getWireless() + ", name=" + this.getName() + ", type=" + this.getType() + ", manager=" + this.getManager() + ", guest=" + this.getGuest() + ", deviceMac=" + this.getDeviceMac() + ", deviceName=" + this.getDeviceName() + ", deviceModel=" + this.getDeviceModel() + ", deviceModelVersion=" + this.getDeviceModelVersion() + ", deviceType=" + this.getDeviceType() + ", score=" + this.getScore() + ", wirelessProperties=" + this.getWirelessProperties() + ", wiredProperties=" + this.getWiredProperties() + ")";
    }

    @Generated
    public ClientHealthScoreAggrDTO() {
    }

    static class WirelessPropertyDTO {
        private Integer connectScore;
        private Integer rssiScore;
        private Integer snrScore;
        private Integer dataRateScore;
        private Integer issueScore;
        private Integer highest_anomaly_level;
        private Integer anomaly_count;

        @JsonIgnore
        public Integer getHighestAnomalyLevel() {
            return this.highest_anomaly_level;
        }

        @JsonIgnore
        public Integer getAnomalyCount() {
            return this.anomaly_count;
        }

        @Generated
        public Integer getConnectScore() {
            return this.connectScore;
        }

        @Generated
        public Integer getRssiScore() {
            return this.rssiScore;
        }

        @Generated
        public Integer getSnrScore() {
            return this.snrScore;
        }

        @Generated
        public Integer getDataRateScore() {
            return this.dataRateScore;
        }

        @Generated
        public Integer getIssueScore() {
            return this.issueScore;
        }

        @Generated
        public Integer getHighest_anomaly_level() {
            return this.highest_anomaly_level;
        }

        @Generated
        public Integer getAnomaly_count() {
            return this.anomaly_count;
        }

        @Generated
        public void setConnectScore(Integer connectScore) {
            this.connectScore = connectScore;
        }

        @Generated
        public void setRssiScore(Integer rssiScore) {
            this.rssiScore = rssiScore;
        }

        @Generated
        public void setSnrScore(Integer snrScore) {
            this.snrScore = snrScore;
        }

        @Generated
        public void setDataRateScore(Integer dataRateScore) {
            this.dataRateScore = dataRateScore;
        }

        @Generated
        public void setIssueScore(Integer issueScore) {
            this.issueScore = issueScore;
        }

        @Generated
        public void setHighest_anomaly_level(Integer highest_anomaly_level) {
            this.highest_anomaly_level = highest_anomaly_level;
        }

        @Generated
        public void setAnomaly_count(Integer anomaly_count) {
            this.anomaly_count = anomaly_count;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof WirelessPropertyDTO)) {
                return false;
            }
            WirelessPropertyDTO other = (WirelessPropertyDTO)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$connectScore = this.getConnectScore();
            Integer other$connectScore = other.getConnectScore();
            if (this$connectScore == null ? other$connectScore != null : !((Object)this$connectScore).equals(other$connectScore)) {
                return false;
            }
            Integer this$rssiScore = this.getRssiScore();
            Integer other$rssiScore = other.getRssiScore();
            if (this$rssiScore == null ? other$rssiScore != null : !((Object)this$rssiScore).equals(other$rssiScore)) {
                return false;
            }
            Integer this$snrScore = this.getSnrScore();
            Integer other$snrScore = other.getSnrScore();
            if (this$snrScore == null ? other$snrScore != null : !((Object)this$snrScore).equals(other$snrScore)) {
                return false;
            }
            Integer this$dataRateScore = this.getDataRateScore();
            Integer other$dataRateScore = other.getDataRateScore();
            if (this$dataRateScore == null ? other$dataRateScore != null : !((Object)this$dataRateScore).equals(other$dataRateScore)) {
                return false;
            }
            Integer this$issueScore = this.getIssueScore();
            Integer other$issueScore = other.getIssueScore();
            if (this$issueScore == null ? other$issueScore != null : !((Object)this$issueScore).equals(other$issueScore)) {
                return false;
            }
            Integer this$highest_anomaly_level = this.getHighest_anomaly_level();
            Integer other$highest_anomaly_level = other.getHighest_anomaly_level();
            if (this$highest_anomaly_level == null ? other$highest_anomaly_level != null : !((Object)this$highest_anomaly_level).equals(other$highest_anomaly_level)) {
                return false;
            }
            Integer this$anomaly_count = this.getAnomaly_count();
            Integer other$anomaly_count = other.getAnomaly_count();
            return !(this$anomaly_count == null ? other$anomaly_count != null : !((Object)this$anomaly_count).equals(other$anomaly_count));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WirelessPropertyDTO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $connectScore = this.getConnectScore();
            result = result * 59 + ($connectScore == null ? 43 : ((Object)$connectScore).hashCode());
            Integer $rssiScore = this.getRssiScore();
            result = result * 59 + ($rssiScore == null ? 43 : ((Object)$rssiScore).hashCode());
            Integer $snrScore = this.getSnrScore();
            result = result * 59 + ($snrScore == null ? 43 : ((Object)$snrScore).hashCode());
            Integer $dataRateScore = this.getDataRateScore();
            result = result * 59 + ($dataRateScore == null ? 43 : ((Object)$dataRateScore).hashCode());
            Integer $issueScore = this.getIssueScore();
            result = result * 59 + ($issueScore == null ? 43 : ((Object)$issueScore).hashCode());
            Integer $highest_anomaly_level = this.getHighest_anomaly_level();
            result = result * 59 + ($highest_anomaly_level == null ? 43 : ((Object)$highest_anomaly_level).hashCode());
            Integer $anomaly_count = this.getAnomaly_count();
            result = result * 59 + ($anomaly_count == null ? 43 : ((Object)$anomaly_count).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClientHealthScoreAggrDTO.WirelessPropertyDTO(connectScore=" + this.getConnectScore() + ", rssiScore=" + this.getRssiScore() + ", snrScore=" + this.getSnrScore() + ", dataRateScore=" + this.getDataRateScore() + ", issueScore=" + this.getIssueScore() + ", highest_anomaly_level=" + this.getHighest_anomaly_level() + ", anomaly_count=" + this.getAnomaly_count() + ")";
        }

        @Generated
        public WirelessPropertyDTO() {
        }
    }

    static class WiredPropertyDTO {
        private Integer connectScore;
        private Integer linkErrorScore;

        @Generated
        public Integer getConnectScore() {
            return this.connectScore;
        }

        @Generated
        public Integer getLinkErrorScore() {
            return this.linkErrorScore;
        }

        @Generated
        public void setConnectScore(Integer connectScore) {
            this.connectScore = connectScore;
        }

        @Generated
        public void setLinkErrorScore(Integer linkErrorScore) {
            this.linkErrorScore = linkErrorScore;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof WiredPropertyDTO)) {
                return false;
            }
            WiredPropertyDTO other = (WiredPropertyDTO)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$connectScore = this.getConnectScore();
            Integer other$connectScore = other.getConnectScore();
            if (this$connectScore == null ? other$connectScore != null : !((Object)this$connectScore).equals(other$connectScore)) {
                return false;
            }
            Integer this$linkErrorScore = this.getLinkErrorScore();
            Integer other$linkErrorScore = other.getLinkErrorScore();
            return !(this$linkErrorScore == null ? other$linkErrorScore != null : !((Object)this$linkErrorScore).equals(other$linkErrorScore));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WiredPropertyDTO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $connectScore = this.getConnectScore();
            result = result * 59 + ($connectScore == null ? 43 : ((Object)$connectScore).hashCode());
            Integer $linkErrorScore = this.getLinkErrorScore();
            result = result * 59 + ($linkErrorScore == null ? 43 : ((Object)$linkErrorScore).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClientHealthScoreAggrDTO.WiredPropertyDTO(connectScore=" + this.getConnectScore() + ", linkErrorScore=" + this.getLinkErrorScore() + ")";
        }

        @Generated
        public WiredPropertyDTO() {
        }
    }
}

