/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.api.dto.health.client;

import com.tplink.smb.omada.anomaly.api.dto.health.client.ClientHealthAggregationDTO;
import lombok.Generated;

public class ClientHealthRateStatVO {
    private WiredRateStat wiredClients;
    private WirelessRateStat wirelessClients;
    private Long time;

    public ClientHealthRateStatVO() {
    }

    public ClientHealthRateStatVO(WiredRateStat wiredClients, WirelessRateStat wirelessClients, Long time) {
        this.wiredClients = wiredClients;
        this.wirelessClients = wirelessClients;
        this.time = time;
    }

    public ClientHealthRateStatVO(long time) {
        this.time = time;
    }

    public static ClientHealthRateStatVO fromDTO(ClientHealthAggregationDTO dto) {
        int totalWireless = dto.getWirelessGood() + dto.getWirelessFair() + dto.getWirelessPoor() + dto.getWirelessNoData();
        int totalWired = dto.getWiredGood() + dto.getWiredFair() + dto.getWiredPoor() + dto.getWiredNoData();
        WirelessRateStat wirelessRateStat = new WirelessRateStat(totalWireless, dto.getWirelessGood(), dto.getWirelessHighestAnomalyLevel(), dto.getWirelessAnomalyCount());
        WiredRateStat wiredRateStat = new WiredRateStat(totalWired, dto.getWiredGood());
        return new ClientHealthRateStatVO(wiredRateStat, wirelessRateStat, dto.getTime());
    }

    @Generated
    public WiredRateStat getWiredClients() {
        return this.wiredClients;
    }

    @Generated
    public WirelessRateStat getWirelessClients() {
        return this.wirelessClients;
    }

    @Generated
    public Long getTime() {
        return this.time;
    }

    @Generated
    public void setWiredClients(WiredRateStat wiredClients) {
        this.wiredClients = wiredClients;
    }

    @Generated
    public void setWirelessClients(WirelessRateStat wirelessClients) {
        this.wirelessClients = wirelessClients;
    }

    @Generated
    public void setTime(Long time) {
        this.time = time;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof ClientHealthRateStatVO)) {
            return false;
        }
        ClientHealthRateStatVO other = (ClientHealthRateStatVO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$time = this.getTime();
        Long other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        WiredRateStat this$wiredClients = this.getWiredClients();
        WiredRateStat other$wiredClients = other.getWiredClients();
        if (this$wiredClients == null ? other$wiredClients != null : !((Object)this$wiredClients).equals(other$wiredClients)) {
            return false;
        }
        WirelessRateStat this$wirelessClients = this.getWirelessClients();
        WirelessRateStat other$wirelessClients = other.getWirelessClients();
        return !(this$wirelessClients == null ? other$wirelessClients != null : !((Object)this$wirelessClients).equals(other$wirelessClients));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientHealthRateStatVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        WiredRateStat $wiredClients = this.getWiredClients();
        result = result * 59 + ($wiredClients == null ? 43 : ((Object)$wiredClients).hashCode());
        WirelessRateStat $wirelessClients = this.getWirelessClients();
        result = result * 59 + ($wirelessClients == null ? 43 : ((Object)$wirelessClients).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClientHealthRateStatVO(wiredClients=" + this.getWiredClients() + ", wirelessClients=" + this.getWirelessClients() + ", time=" + this.getTime() + ")";
    }

    public static class WiredRateStat {
        private Integer healthCount;
        private Integer healthRate;
        private Integer totalCount;

        public WiredRateStat() {
        }

        public WiredRateStat(int total, int health) {
            if (total > 0) {
                this.healthCount = health;
                this.healthRate = health * 100 / total;
                this.totalCount = total;
            } else {
                this.healthCount = 0;
                this.healthRate = 0;
                this.totalCount = 0;
            }
        }

        @Generated
        public Integer getHealthCount() {
            return this.healthCount;
        }

        @Generated
        public Integer getHealthRate() {
            return this.healthRate;
        }

        @Generated
        public Integer getTotalCount() {
            return this.totalCount;
        }

        @Generated
        public void setHealthCount(Integer healthCount) {
            this.healthCount = healthCount;
        }

        @Generated
        public void setHealthRate(Integer healthRate) {
            this.healthRate = healthRate;
        }

        @Generated
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof WiredRateStat)) {
                return false;
            }
            WiredRateStat other = (WiredRateStat)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$healthCount = this.getHealthCount();
            Integer other$healthCount = other.getHealthCount();
            if (this$healthCount == null ? other$healthCount != null : !((Object)this$healthCount).equals(other$healthCount)) {
                return false;
            }
            Integer this$healthRate = this.getHealthRate();
            Integer other$healthRate = other.getHealthRate();
            if (this$healthRate == null ? other$healthRate != null : !((Object)this$healthRate).equals(other$healthRate)) {
                return false;
            }
            Integer this$totalCount = this.getTotalCount();
            Integer other$totalCount = other.getTotalCount();
            return !(this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WiredRateStat;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $healthCount = this.getHealthCount();
            result = result * 59 + ($healthCount == null ? 43 : ((Object)$healthCount).hashCode());
            Integer $healthRate = this.getHealthRate();
            result = result * 59 + ($healthRate == null ? 43 : ((Object)$healthRate).hashCode());
            Integer $totalCount = this.getTotalCount();
            result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClientHealthRateStatVO.WiredRateStat(healthCount=" + this.getHealthCount() + ", healthRate=" + this.getHealthRate() + ", totalCount=" + this.getTotalCount() + ")";
        }
    }

    public static class WirelessRateStat {
        private Integer healthCount;
        private Integer healthRate;
        private Integer totalCount;
        private Integer highestAnomalyLevel;
        private Integer anomalyCount;

        public WirelessRateStat() {
        }

        public WirelessRateStat(int total, int health, Integer highestAnomalyLevel, Integer anomalyCount) {
            if (total > 0) {
                this.healthCount = health;
                this.healthRate = health * 100 / total;
                this.totalCount = total;
            } else {
                this.healthCount = 0;
                this.healthRate = 0;
                this.totalCount = 0;
            }
            this.highestAnomalyLevel = highestAnomalyLevel;
            this.anomalyCount = anomalyCount;
        }

        @Generated
        public Integer getHealthCount() {
            return this.healthCount;
        }

        @Generated
        public Integer getHealthRate() {
            return this.healthRate;
        }

        @Generated
        public Integer getTotalCount() {
            return this.totalCount;
        }

        @Generated
        public Integer getHighestAnomalyLevel() {
            return this.highestAnomalyLevel;
        }

        @Generated
        public Integer getAnomalyCount() {
            return this.anomalyCount;
        }

        @Generated
        public void setHealthCount(Integer healthCount) {
            this.healthCount = healthCount;
        }

        @Generated
        public void setHealthRate(Integer healthRate) {
            this.healthRate = healthRate;
        }

        @Generated
        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Generated
        public void setHighestAnomalyLevel(Integer highestAnomalyLevel) {
            this.highestAnomalyLevel = highestAnomalyLevel;
        }

        @Generated
        public void setAnomalyCount(Integer anomalyCount) {
            this.anomalyCount = anomalyCount;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof WirelessRateStat)) {
                return false;
            }
            WirelessRateStat other = (WirelessRateStat)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$healthCount = this.getHealthCount();
            Integer other$healthCount = other.getHealthCount();
            if (this$healthCount == null ? other$healthCount != null : !((Object)this$healthCount).equals(other$healthCount)) {
                return false;
            }
            Integer this$healthRate = this.getHealthRate();
            Integer other$healthRate = other.getHealthRate();
            if (this$healthRate == null ? other$healthRate != null : !((Object)this$healthRate).equals(other$healthRate)) {
                return false;
            }
            Integer this$totalCount = this.getTotalCount();
            Integer other$totalCount = other.getTotalCount();
            if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
                return false;
            }
            Integer this$highestAnomalyLevel = this.getHighestAnomalyLevel();
            Integer other$highestAnomalyLevel = other.getHighestAnomalyLevel();
            if (this$highestAnomalyLevel == null ? other$highestAnomalyLevel != null : !((Object)this$highestAnomalyLevel).equals(other$highestAnomalyLevel)) {
                return false;
            }
            Integer this$anomalyCount = this.getAnomalyCount();
            Integer other$anomalyCount = other.getAnomalyCount();
            return !(this$anomalyCount == null ? other$anomalyCount != null : !((Object)this$anomalyCount).equals(other$anomalyCount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WirelessRateStat;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $healthCount = this.getHealthCount();
            result = result * 59 + ($healthCount == null ? 43 : ((Object)$healthCount).hashCode());
            Integer $healthRate = this.getHealthRate();
            result = result * 59 + ($healthRate == null ? 43 : ((Object)$healthRate).hashCode());
            Integer $totalCount = this.getTotalCount();
            result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
            Integer $highestAnomalyLevel = this.getHighestAnomalyLevel();
            result = result * 59 + ($highestAnomalyLevel == null ? 43 : ((Object)$highestAnomalyLevel).hashCode());
            Integer $anomalyCount = this.getAnomalyCount();
            result = result * 59 + ($anomalyCount == null ? 43 : ((Object)$anomalyCount).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClientHealthRateStatVO.WirelessRateStat(healthCount=" + this.getHealthCount() + ", healthRate=" + this.getHealthRate() + ", totalCount=" + this.getTotalCount() + ", highestAnomalyLevel=" + this.getHighestAnomalyLevel() + ", anomalyCount=" + this.getAnomalyCount() + ")";
        }
    }
}

