/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.api.dto.health.ap;

import com.tplink.smb.omada.anomaly.api.dto.health.ap.DevicesHealthCount;
import java.util.Objects;
import lombok.Generated;

public class DevicesHealthStatusVO {
    private Integer healthCount;
    private Long time;
    private Integer totalCount;
    private Integer healthRate;
    private Integer gatewayHealth;
    private DevicesHealthCount switchHealth;
    private DevicesHealthCount eapHealth;
    private Integer highestAnomalyLevel;
    private Integer anomalyCount;

    public DevicesHealthStatusVO(Long time) {
        this.time = time;
    }

    public DevicesHealthStatusVO(Long time, Integer healthCount, Integer totalCount) {
        this.time = time;
        this.healthCount = healthCount;
        this.totalCount = totalCount;
    }

    public void addCount(Integer healthCount, Integer totalCount) {
        this.healthCount = this.healthCount + healthCount;
        this.totalCount = this.totalCount + totalCount;
    }

    public void calculateHealthRate() {
        if (Objects.isNull(this.totalCount) || Objects.isNull(this.healthCount)) {
            return;
        }
        if (!Objects.equals(this.totalCount, 0)) {
            this.healthRate = this.healthCount * 100 / this.totalCount;
        }
    }

    public void mergeAnomalyInfo(Integer highestAnomalyLevel, Integer anomalyCount) {
        if (Objects.nonNull(highestAnomalyLevel) && (Objects.isNull(this.highestAnomalyLevel) || this.highestAnomalyLevel > highestAnomalyLevel)) {
            this.highestAnomalyLevel = highestAnomalyLevel;
        }
        if (Objects.nonNull(anomalyCount)) {
            this.anomalyCount = Objects.isNull(this.anomalyCount) ? anomalyCount : Integer.valueOf(this.anomalyCount + anomalyCount);
        }
    }

    @Generated
    public Integer getHealthCount() {
        return this.healthCount;
    }

    @Generated
    public Long getTime() {
        return this.time;
    }

    @Generated
    public Integer getTotalCount() {
        return this.totalCount;
    }

    @Generated
    public Integer getHealthRate() {
        return this.healthRate;
    }

    @Generated
    public Integer getGatewayHealth() {
        return this.gatewayHealth;
    }

    @Generated
    public DevicesHealthCount getSwitchHealth() {
        return this.switchHealth;
    }

    @Generated
    public DevicesHealthCount getEapHealth() {
        return this.eapHealth;
    }

    @Generated
    public Integer getHighestAnomalyLevel() {
        return this.highestAnomalyLevel;
    }

    @Generated
    public Integer getAnomalyCount() {
        return this.anomalyCount;
    }

    @Generated
    public void setHealthCount(Integer healthCount) {
        this.healthCount = healthCount;
    }

    @Generated
    public void setTime(Long time) {
        this.time = time;
    }

    @Generated
    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    @Generated
    public void setHealthRate(Integer healthRate) {
        this.healthRate = healthRate;
    }

    @Generated
    public void setGatewayHealth(Integer gatewayHealth) {
        this.gatewayHealth = gatewayHealth;
    }

    @Generated
    public void setSwitchHealth(DevicesHealthCount switchHealth) {
        this.switchHealth = switchHealth;
    }

    @Generated
    public void setEapHealth(DevicesHealthCount eapHealth) {
        this.eapHealth = eapHealth;
    }

    @Generated
    public void setHighestAnomalyLevel(Integer highestAnomalyLevel) {
        this.highestAnomalyLevel = highestAnomalyLevel;
    }

    @Generated
    public void setAnomalyCount(Integer anomalyCount) {
        this.anomalyCount = anomalyCount;
    }

    @Generated
    public String toString() {
        return "DevicesHealthStatusVO(healthCount=" + this.getHealthCount() + ", time=" + this.getTime() + ", totalCount=" + this.getTotalCount() + ", healthRate=" + this.getHealthRate() + ", gatewayHealth=" + this.getGatewayHealth() + ", switchHealth=" + this.getSwitchHealth() + ", eapHealth=" + this.getEapHealth() + ", highestAnomalyLevel=" + this.getHighestAnomalyLevel() + ", anomalyCount=" + this.getAnomalyCount() + ")";
    }
}

