/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.api.dto.health.ap;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.anomaly.api.dto.health.ap.ApLatestHealthScoreDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApPostHealthScoreDTO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApPostHealthScoreDTO.class);
    @a
    private String mac;
    private List<ApPostHealthTimeScoreDTO> apTimeScoreList;

    public List<ApPostHealthTimeScoreDTO> getEffectiveTimeScoreList(String omadacId, String siteId, Long currentTime, int lastCount) {
        Map<Long, ApPostHealthTimeScoreDTO> timeScoreMap = Optional.ofNullable(this.apTimeScoreList).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).collect(Collectors.toMap(ApPostHealthTimeScoreDTO::getTimestamp, score -> score, (existing, replacement) -> existing));
        ArrayList<ApPostHealthTimeScoreDTO> effectiveTimeScoreList = new ArrayList<ApPostHealthTimeScoreDTO>(lastCount);
        for (int i2 = 0; i2 < lastCount; ++i2) {
            Long timePoint = currentTime - (long)((i2 + 1) * 600);
            ApPostHealthTimeScoreDTO scoreDTO = timeScoreMap.get(timePoint);
            if (scoreDTO != null) {
                effectiveTimeScoreList.add(scoreDTO);
                continue;
            }
            effectiveTimeScoreList.add(ApPostHealthTimeScoreDTO.createNoDataDTO(timePoint));
        }
        com.tplink.smb.omada.anomaly.api.e.a.a(log, "apPostHealthScoreDTO.getEffectiveTimeScoreList, omadacId {}, siteId {},  source time scores is {}, effective time scores after fill zero is {}", omadacId, siteId, this.apTimeScoreList, effectiveTimeScoreList);
        return effectiveTimeScoreList;
    }

    public ApPostHealthScoreDTO(String mac, Long time, ApLatestHealthScoreDTO latestHealthScoreDTO) {
        this.mac = mac;
        ApPostHealthTimeScoreDTO timeScoreDTO = ApPostHealthTimeScoreDTO.createNoDataDTO(time);
        if (Objects.nonNull(latestHealthScoreDTO)) {
            timeScoreDTO.setCpuUtilScore(latestHealthScoreDTO.getCpuUtilScore());
            timeScoreDTO.setMemUtilScore(latestHealthScoreDTO.getMemUtilScore());
            timeScoreDTO.setChannelUtilScore(latestHealthScoreDTO.getChannelUtilScore());
            timeScoreDTO.setInterUtilScore(latestHealthScoreDTO.getInterUtilScore());
            timeScoreDTO.setTransmissionQualityScore(latestHealthScoreDTO.getTransmissionQualityScore());
        }
        ArrayList<ApPostHealthTimeScoreDTO> timeScoreDTOList = new ArrayList<ApPostHealthTimeScoreDTO>();
        timeScoreDTOList.add(timeScoreDTO);
        this.apTimeScoreList = timeScoreDTOList;
    }

    public void merge(Long time, ApLatestHealthScoreDTO latestHealthScoreDTO) {
        ApPostHealthTimeScoreDTO toBeAddedScoreDTO = ApPostHealthTimeScoreDTO.createNoDataDTO(time);
        if (Objects.nonNull(latestHealthScoreDTO)) {
            toBeAddedScoreDTO = new ApPostHealthTimeScoreDTO(time, latestHealthScoreDTO.getCpuUtilScore(), latestHealthScoreDTO.getMemUtilScore(), latestHealthScoreDTO.getChannelUtilScore(), latestHealthScoreDTO.getInterUtilScore(), latestHealthScoreDTO.getTransmissionQualityScore());
        }
        if (Objects.isNull(this.apTimeScoreList)) {
            this.apTimeScoreList = new ArrayList<ApPostHealthTimeScoreDTO>();
        }
        this.apTimeScoreList.add(toBeAddedScoreDTO);
        long expireThreshold = time - 3600L;
        this.apTimeScoreList.removeIf(timeScore -> timeScore.getTimestamp() < expireThreshold);
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public List<ApPostHealthTimeScoreDTO> getApTimeScoreList() {
        return this.apTimeScoreList;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setApTimeScoreList(List<ApPostHealthTimeScoreDTO> apTimeScoreList) {
        this.apTimeScoreList = apTimeScoreList;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof ApPostHealthScoreDTO)) {
            return false;
        }
        ApPostHealthScoreDTO other = (ApPostHealthScoreDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$mac = this.getMac();
        String other$mac = other.getMac();
        if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
            return false;
        }
        List<ApPostHealthTimeScoreDTO> this$apTimeScoreList = this.getApTimeScoreList();
        List<ApPostHealthTimeScoreDTO> other$apTimeScoreList = other.getApTimeScoreList();
        return !(this$apTimeScoreList == null ? other$apTimeScoreList != null : !((Object)this$apTimeScoreList).equals(other$apTimeScoreList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApPostHealthScoreDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
        List<ApPostHealthTimeScoreDTO> $apTimeScoreList = this.getApTimeScoreList();
        result = result * 59 + ($apTimeScoreList == null ? 43 : ((Object)$apTimeScoreList).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ApPostHealthScoreDTO(mac=" + this.getMac() + ", apTimeScoreList=" + this.getApTimeScoreList() + ")";
    }

    @Generated
    public ApPostHealthScoreDTO() {
    }

    public static class ApPostHealthTimeScoreDTO {
        private Long timestamp;
        private Integer cpuUtilScore;
        private Integer memUtilScore;
        private Integer channelUtilScore;
        private Integer interUtilScore;
        private Integer transmissionQualityScore;

        public static ApPostHealthTimeScoreDTO createNoDataDTO(Long time) {
            return new ApPostHealthTimeScoreDTO(time, 0, 0, 0, 0, 0);
        }

        @Generated
        public Long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public Integer getCpuUtilScore() {
            return this.cpuUtilScore;
        }

        @Generated
        public Integer getMemUtilScore() {
            return this.memUtilScore;
        }

        @Generated
        public Integer getChannelUtilScore() {
            return this.channelUtilScore;
        }

        @Generated
        public Integer getInterUtilScore() {
            return this.interUtilScore;
        }

        @Generated
        public Integer getTransmissionQualityScore() {
            return this.transmissionQualityScore;
        }

        @Generated
        public void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        @Generated
        public void setCpuUtilScore(Integer cpuUtilScore) {
            this.cpuUtilScore = cpuUtilScore;
        }

        @Generated
        public void setMemUtilScore(Integer memUtilScore) {
            this.memUtilScore = memUtilScore;
        }

        @Generated
        public void setChannelUtilScore(Integer channelUtilScore) {
            this.channelUtilScore = channelUtilScore;
        }

        @Generated
        public void setInterUtilScore(Integer interUtilScore) {
            this.interUtilScore = interUtilScore;
        }

        @Generated
        public void setTransmissionQualityScore(Integer transmissionQualityScore) {
            this.transmissionQualityScore = transmissionQualityScore;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof ApPostHealthTimeScoreDTO)) {
                return false;
            }
            ApPostHealthTimeScoreDTO other = (ApPostHealthTimeScoreDTO)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$timestamp = this.getTimestamp();
            Long other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                return false;
            }
            Integer this$cpuUtilScore = this.getCpuUtilScore();
            Integer other$cpuUtilScore = other.getCpuUtilScore();
            if (this$cpuUtilScore == null ? other$cpuUtilScore != null : !((Object)this$cpuUtilScore).equals(other$cpuUtilScore)) {
                return false;
            }
            Integer this$memUtilScore = this.getMemUtilScore();
            Integer other$memUtilScore = other.getMemUtilScore();
            if (this$memUtilScore == null ? other$memUtilScore != null : !((Object)this$memUtilScore).equals(other$memUtilScore)) {
                return false;
            }
            Integer this$channelUtilScore = this.getChannelUtilScore();
            Integer other$channelUtilScore = other.getChannelUtilScore();
            if (this$channelUtilScore == null ? other$channelUtilScore != null : !((Object)this$channelUtilScore).equals(other$channelUtilScore)) {
                return false;
            }
            Integer this$interUtilScore = this.getInterUtilScore();
            Integer other$interUtilScore = other.getInterUtilScore();
            if (this$interUtilScore == null ? other$interUtilScore != null : !((Object)this$interUtilScore).equals(other$interUtilScore)) {
                return false;
            }
            Integer this$transmissionQualityScore = this.getTransmissionQualityScore();
            Integer other$transmissionQualityScore = other.getTransmissionQualityScore();
            return !(this$transmissionQualityScore == null ? other$transmissionQualityScore != null : !((Object)this$transmissionQualityScore).equals(other$transmissionQualityScore));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ApPostHealthTimeScoreDTO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            Integer $cpuUtilScore = this.getCpuUtilScore();
            result = result * 59 + ($cpuUtilScore == null ? 43 : ((Object)$cpuUtilScore).hashCode());
            Integer $memUtilScore = this.getMemUtilScore();
            result = result * 59 + ($memUtilScore == null ? 43 : ((Object)$memUtilScore).hashCode());
            Integer $channelUtilScore = this.getChannelUtilScore();
            result = result * 59 + ($channelUtilScore == null ? 43 : ((Object)$channelUtilScore).hashCode());
            Integer $interUtilScore = this.getInterUtilScore();
            result = result * 59 + ($interUtilScore == null ? 43 : ((Object)$interUtilScore).hashCode());
            Integer $transmissionQualityScore = this.getTransmissionQualityScore();
            result = result * 59 + ($transmissionQualityScore == null ? 43 : ((Object)$transmissionQualityScore).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ApPostHealthScoreDTO.ApPostHealthTimeScoreDTO(timestamp=" + this.getTimestamp() + ", cpuUtilScore=" + this.getCpuUtilScore() + ", memUtilScore=" + this.getMemUtilScore() + ", channelUtilScore=" + this.getChannelUtilScore() + ", interUtilScore=" + this.getInterUtilScore() + ", transmissionQualityScore=" + this.getTransmissionQualityScore() + ")";
        }

        @Generated
        public ApPostHealthTimeScoreDTO() {
        }

        @Generated
        public ApPostHealthTimeScoreDTO(Long timestamp, Integer cpuUtilScore, Integer memUtilScore, Integer channelUtilScore, Integer interUtilScore, Integer transmissionQualityScore) {
            this.timestamp = timestamp;
            this.cpuUtilScore = cpuUtilScore;
            this.memUtilScore = memUtilScore;
            this.channelUtilScore = channelUtilScore;
            this.interUtilScore = interUtilScore;
            this.transmissionQualityScore = transmissionQualityScore;
        }
    }
}

