/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.api.dto.health.ap;

import com.tplink.smb.omada.anomaly.api.dto.health.BaseHealthDTO;
import com.tplink.smb.omada.anomaly.api.dto.health.ap.a;
import com.tplink.smb.omada.device.manage.message.body.eap.EapInformBody;
import com.tplink.smb.omada.device.manage.message.inform.ap.WirelessInfo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApHealthDTO
extends BaseHealthDTO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApHealthDTO.class);
    private Map<Long, a> apHealthDataMap;

    public ApHealthDTO(String omadacId, String siteId, String mac, long timestamp) {
        super(omadacId, siteId, mac, timestamp);
        this.apHealthDataMap = new TreeMap<Long, a>();
    }

    public void merge(EapInformBody eapInformBody, long timestamp) {
        a apHealthData = new a();
        if (Objects.nonNull(eapInformBody.getDeviceInfo().getCpuUtil())) {
            apHealthData.a(eapInformBody.getDeviceInfo().getCpuUtil());
        } else {
            apHealthData.a(-1);
        }
        if (Objects.nonNull(eapInformBody.getDeviceInfo().getMemUtil())) {
            apHealthData.b(eapInformBody.getDeviceInfo().getMemUtil());
        } else {
            apHealthData.b(-1);
        }
        this.timestamp = timestamp;
        this.mergeWSetting(eapInformBody.getWSettings2G(), eapInformBody.getWSettings5G(), eapInformBody.getWSettings5G2(), null, apHealthData);
        List list = eapInformBody.getDeviceInfo().getNoiseFloor();
        if (Objects.isNull(list)) {
            apHealthData.k(0);
            apHealthData.l(0);
            apHealthData.m(0);
        } else {
            int noiseFloorSize = list.size();
            if (noiseFloorSize >= 1) {
                apHealthData.k((Integer)list.get(0));
            }
            if (noiseFloorSize >= 2) {
                apHealthData.l((Integer)list.get(1));
            }
            if (noiseFloorSize >= 3) {
                apHealthData.m((Integer)list.get(2));
            }
            if (noiseFloorSize >= 4) {
                apHealthData.f((Integer)list.get(3));
            }
        }
        this.apHealthDataMap.put(timestamp, apHealthData);
    }

    private void mergeWSetting(WirelessInfo wSettings2G, WirelessInfo wSettings5G, WirelessInfo wSettings5G2, WirelessInfo wSettings6G, a apHealthData) {
        if (wSettings2G != null) {
            int chanUtil2g;
            if (wSettings2G.getInterUtil() != null) {
                chanUtil2g = wSettings2G.getInterUtil() + wSettings2G.getRxUtil() + wSettings2G.getTxUtil();
                int interUtil2g = Objects.equals(chanUtil2g, 0) ? 0 : (int)Math.round((double)wSettings2G.getInterUtil().intValue() * 100.0 / (double)chanUtil2g);
                apHealthData.g(interUtil2g);
            } else {
                chanUtil2g = wSettings2G.getBusyUtil();
            }
            apHealthData.c(chanUtil2g);
        }
        if (wSettings5G != null) {
            int chanUtil5g;
            if (wSettings5G.getInterUtil() != null) {
                chanUtil5g = wSettings5G.getInterUtil() + wSettings5G.getRxUtil() + wSettings5G.getTxUtil();
                int interUtil5g = Objects.equals(chanUtil5g, 0) ? 0 : (int)Math.round((double)wSettings5G.getInterUtil().intValue() * 100.0 / (double)chanUtil5g);
                apHealthData.h(interUtil5g);
            } else {
                chanUtil5g = wSettings5G.getBusyUtil();
            }
            apHealthData.d(chanUtil5g);
        }
        if (wSettings5G2 != null) {
            int chanUtil5g2;
            if (wSettings5G2.getInterUtil() != null) {
                chanUtil5g2 = wSettings5G2.getInterUtil() + wSettings5G2.getRxUtil() + wSettings5G2.getTxUtil();
                int interUtil5g2 = Objects.equals(chanUtil5g2, 0) ? 0 : (int)Math.round((double)wSettings5G2.getInterUtil().intValue() * 100.0 / (double)chanUtil5g2);
                apHealthData.i(interUtil5g2);
            } else {
                chanUtil5g2 = wSettings5G2.getBusyUtil();
            }
            apHealthData.e(chanUtil5g2);
        }
        if (wSettings6G != null) {
            int chanUtil6g;
            if (wSettings6G.getInterUtil() != null) {
                chanUtil6g = wSettings6G.getInterUtil() + wSettings6G.getRxUtil() + wSettings6G.getTxUtil();
                int interUtil6g = Objects.equals(chanUtil6g, 0) ? 0 : (int)Math.round((double)wSettings6G.getInterUtil().intValue() * 100.0 / (double)chanUtil6g);
                apHealthData.j(interUtil6g);
            } else {
                chanUtil6g = wSettings6G.getBusyUtil();
            }
            apHealthData.f(chanUtil6g);
        }
    }

    public void clear() {
        this.apHealthDataMap.clear();
    }

    @Override
    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof ApHealthDTO)) {
            return false;
        }
        ApHealthDTO other = (ApHealthDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Map<Long, a> this$apHealthDataMap = this.getApHealthDataMap();
        Map<Long, a> other$apHealthDataMap = other.getApHealthDataMap();
        return !(this$apHealthDataMap == null ? other$apHealthDataMap != null : !((Object)this$apHealthDataMap).equals(other$apHealthDataMap));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApHealthDTO;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<Long, a> $apHealthDataMap = this.getApHealthDataMap();
        result = result * 59 + ($apHealthDataMap == null ? 43 : ((Object)$apHealthDataMap).hashCode());
        return result;
    }

    @Generated
    public Map<Long, a> getApHealthDataMap() {
        return this.apHealthDataMap;
    }

    @Generated
    public void setApHealthDataMap(Map<Long, a> apHealthDataMap) {
        this.apHealthDataMap = apHealthDataMap;
    }

    @Override
    @Generated
    public String toString() {
        return "ApHealthDTO(apHealthDataMap=" + this.getApHealthDataMap() + ")";
    }

    @Generated
    public ApHealthDTO(Map<Long, a> apHealthDataMap) {
        this.apHealthDataMap = apHealthDataMap;
    }

    @Generated
    public ApHealthDTO() {
    }
}

