/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.api.dto.health;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class ClientHealthSnapshotQueryDTO {
    private String omadacId;
    private String siteId;
    private Long time;
    private Boolean wireless;
    private Integer minScore;
    private Integer maxScore;
    List<Integer> sortIndexList;
    private int[] sortInfo;
    public static final int NO_SORT = 0;
    public static final int ASC = 1;
    public static final int DESC = 2;
    public static final int CLIENT_NAME_INDEX = 0;
    public static final int HEALTH_SCORE_INDEX = 1;
    public static final int AP_NAME_SCORE_INDEX = 2;
    public static final int SORT_INFO_LENGTH = 3;
    public static final String CLIENT_NAME = "clientName";
    public static final String HEALTH_SCORE = "healthScore";
    public static final String DEVICE_NAME = "deviceName";
    public static final String ASC_STR = "asc";
    public static final String DESC_STR = "desc";

    public ClientHealthSnapshotQueryDTO(String oamdacId, String siteId, Long time) {
        this.omadacId = oamdacId;
        this.siteId = siteId;
        this.time = time;
        this.sortIndexList = new ArrayList<Integer>();
        this.sortInfo = new int[]{0, 0, 0};
    }

    public ClientHealthSnapshotQueryDTO(String omadacId, String siteId, Long time, Boolean wireless) {
        this.omadacId = omadacId;
        this.siteId = siteId;
        this.time = time;
        this.wireless = wireless;
        this.sortIndexList = new ArrayList<Integer>();
        this.sortInfo = new int[]{0, 0, 0};
    }

    public ClientHealthSnapshotQueryDTO(String omadacId, String siteId, Long time, Boolean wireless, Integer minScore, Integer maxScore) {
        this(omadacId, siteId, time, wireless);
        this.minScore = minScore;
        this.maxScore = maxScore;
        this.sortIndexList = new ArrayList<Integer>();
        this.sortInfo = new int[]{0, 0, 0};
    }

    public void addSortInfo(String key, String direction) {
        Integer index = this.getIndex(key);
        if (Objects.nonNull(index)) {
            this.sortIndexList.add(index);
            this.sortInfo[index.intValue()] = this.getDirection(direction);
        }
    }

    private Integer getIndex(String key) {
        if (Objects.equals(CLIENT_NAME, key)) {
            return 0;
        }
        if (Objects.equals(HEALTH_SCORE, key)) {
            return 1;
        }
        if (Objects.equals(DEVICE_NAME, key)) {
            return 1;
        }
        return null;
    }

    private int getDirection(String direction) {
        if (Objects.equals(ASC_STR, direction)) {
            return 1;
        }
        if (Objects.equals(DESC_STR, direction)) {
            return 2;
        }
        return 0;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public Long getTime() {
        return this.time;
    }

    @Generated
    public Boolean getWireless() {
        return this.wireless;
    }

    @Generated
    public Integer getMinScore() {
        return this.minScore;
    }

    @Generated
    public Integer getMaxScore() {
        return this.maxScore;
    }

    @Generated
    public List<Integer> getSortIndexList() {
        return this.sortIndexList;
    }

    @Generated
    public int[] getSortInfo() {
        return this.sortInfo;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @Generated
    public void setTime(Long time) {
        this.time = time;
    }

    @Generated
    public void setWireless(Boolean wireless) {
        this.wireless = wireless;
    }

    @Generated
    public void setMinScore(Integer minScore) {
        this.minScore = minScore;
    }

    @Generated
    public void setMaxScore(Integer maxScore) {
        this.maxScore = maxScore;
    }

    @Generated
    public void setSortIndexList(List<Integer> sortIndexList) {
        this.sortIndexList = sortIndexList;
    }

    @Generated
    public void setSortInfo(int[] sortInfo) {
        this.sortInfo = sortInfo;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof ClientHealthSnapshotQueryDTO)) {
            return false;
        }
        ClientHealthSnapshotQueryDTO other = (ClientHealthSnapshotQueryDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$time = this.getTime();
        Long other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        Boolean this$wireless = this.getWireless();
        Boolean other$wireless = other.getWireless();
        if (this$wireless == null ? other$wireless != null : !((Object)this$wireless).equals(other$wireless)) {
            return false;
        }
        Integer this$minScore = this.getMinScore();
        Integer other$minScore = other.getMinScore();
        if (this$minScore == null ? other$minScore != null : !((Object)this$minScore).equals(other$minScore)) {
            return false;
        }
        Integer this$maxScore = this.getMaxScore();
        Integer other$maxScore = other.getMaxScore();
        if (this$maxScore == null ? other$maxScore != null : !((Object)this$maxScore).equals(other$maxScore)) {
            return false;
        }
        String this$omadacId = this.getOmadacId();
        String other$omadacId = other.getOmadacId();
        if (this$omadacId == null ? other$omadacId != null : !this$omadacId.equals(other$omadacId)) {
            return false;
        }
        String this$siteId = this.getSiteId();
        String other$siteId = other.getSiteId();
        if (this$siteId == null ? other$siteId != null : !this$siteId.equals(other$siteId)) {
            return false;
        }
        List<Integer> this$sortIndexList = this.getSortIndexList();
        List<Integer> other$sortIndexList = other.getSortIndexList();
        if (this$sortIndexList == null ? other$sortIndexList != null : !((Object)this$sortIndexList).equals(other$sortIndexList)) {
            return false;
        }
        return Arrays.equals(this.getSortInfo(), other.getSortInfo());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientHealthSnapshotQueryDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        Boolean $wireless = this.getWireless();
        result = result * 59 + ($wireless == null ? 43 : ((Object)$wireless).hashCode());
        Integer $minScore = this.getMinScore();
        result = result * 59 + ($minScore == null ? 43 : ((Object)$minScore).hashCode());
        Integer $maxScore = this.getMaxScore();
        result = result * 59 + ($maxScore == null ? 43 : ((Object)$maxScore).hashCode());
        String $omadacId = this.getOmadacId();
        result = result * 59 + ($omadacId == null ? 43 : $omadacId.hashCode());
        String $siteId = this.getSiteId();
        result = result * 59 + ($siteId == null ? 43 : $siteId.hashCode());
        List<Integer> $sortIndexList = this.getSortIndexList();
        result = result * 59 + ($sortIndexList == null ? 43 : ((Object)$sortIndexList).hashCode());
        result = result * 59 + Arrays.hashCode(this.getSortInfo());
        return result;
    }

    @Generated
    public String toString() {
        return "ClientHealthSnapshotQueryDTO(omadacId=" + this.getOmadacId() + ", siteId=" + this.getSiteId() + ", time=" + this.getTime() + ", wireless=" + this.getWireless() + ", minScore=" + this.getMinScore() + ", maxScore=" + this.getMaxScore() + ", sortIndexList=" + this.getSortIndexList() + ", sortInfo=" + Arrays.toString(this.getSortInfo()) + ")";
    }
}

