/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.api.dto.health;

import com.tplink.smb.omada.anomaly.api.b.r;
import java.util.Objects;
import lombok.Generated;

public abstract class BaseHealthAggregationDTO {
    String omadacId;
    String siteId;
    protected Integer goodCount;
    protected Integer fairCount;
    protected Integer poorCount;
    protected Integer nodataCount;
    protected Integer totalCount;
    private Integer highestAnomalyLevel;
    private Integer anomalyCount;
    protected Long timestamp;

    public BaseHealthAggregationDTO(Long timestamp) {
        this.goodCount = 0;
        this.fairCount = 0;
        this.poorCount = 0;
        this.nodataCount = 0;
        this.totalCount = 0;
        this.timestamp = timestamp;
    }

    public BaseHealthAggregationDTO(Integer goodCount, Integer fairCount, Integer poorCount, Integer nodataCount, Long timestamp) {
        this.goodCount = goodCount;
        this.fairCount = fairCount;
        this.poorCount = poorCount;
        this.nodataCount = nodataCount;
        this.totalCount = goodCount + fairCount + poorCount + nodataCount;
        this.timestamp = timestamp;
    }

    public void addCount(r healthScoreEnum, int count) {
        switch (healthScoreEnum) {
            case a: {
                this.goodCount = this.goodCount + count;
                break;
            }
            case b: {
                this.fairCount = this.fairCount + count;
                break;
            }
            case c: {
                this.poorCount = this.poorCount + count;
                break;
            }
            case d: {
                this.nodataCount = this.nodataCount + count;
                break;
            }
        }
    }

    public void mergeAnomalyInfo(Integer highestAnomalyLevel, Integer anomalyCount) {
        if (Objects.nonNull(highestAnomalyLevel) && (Objects.isNull(this.highestAnomalyLevel) || this.highestAnomalyLevel > highestAnomalyLevel)) {
            this.highestAnomalyLevel = highestAnomalyLevel;
        }
        if (Objects.nonNull(anomalyCount)) {
            this.anomalyCount = Objects.isNull(this.anomalyCount) ? anomalyCount : Integer.valueOf(this.anomalyCount + anomalyCount);
        }
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public Integer getGoodCount() {
        return this.goodCount;
    }

    @Generated
    public Integer getFairCount() {
        return this.fairCount;
    }

    @Generated
    public Integer getPoorCount() {
        return this.poorCount;
    }

    @Generated
    public Integer getNodataCount() {
        return this.nodataCount;
    }

    @Generated
    public Integer getTotalCount() {
        return this.totalCount;
    }

    @Generated
    public Integer getHighestAnomalyLevel() {
        return this.highestAnomalyLevel;
    }

    @Generated
    public Integer getAnomalyCount() {
        return this.anomalyCount;
    }

    @Generated
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @Generated
    public void setGoodCount(Integer goodCount) {
        this.goodCount = goodCount;
    }

    @Generated
    public void setFairCount(Integer fairCount) {
        this.fairCount = fairCount;
    }

    @Generated
    public void setPoorCount(Integer poorCount) {
        this.poorCount = poorCount;
    }

    @Generated
    public void setNodataCount(Integer nodataCount) {
        this.nodataCount = nodataCount;
    }

    @Generated
    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    @Generated
    public void setHighestAnomalyLevel(Integer highestAnomalyLevel) {
        this.highestAnomalyLevel = highestAnomalyLevel;
    }

    @Generated
    public void setAnomalyCount(Integer anomalyCount) {
        this.anomalyCount = anomalyCount;
    }

    @Generated
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof BaseHealthAggregationDTO)) {
            return false;
        }
        BaseHealthAggregationDTO other = (BaseHealthAggregationDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$goodCount = this.getGoodCount();
        Integer other$goodCount = other.getGoodCount();
        if (this$goodCount == null ? other$goodCount != null : !((Object)this$goodCount).equals(other$goodCount)) {
            return false;
        }
        Integer this$fairCount = this.getFairCount();
        Integer other$fairCount = other.getFairCount();
        if (this$fairCount == null ? other$fairCount != null : !((Object)this$fairCount).equals(other$fairCount)) {
            return false;
        }
        Integer this$poorCount = this.getPoorCount();
        Integer other$poorCount = other.getPoorCount();
        if (this$poorCount == null ? other$poorCount != null : !((Object)this$poorCount).equals(other$poorCount)) {
            return false;
        }
        Integer this$nodataCount = this.getNodataCount();
        Integer other$nodataCount = other.getNodataCount();
        if (this$nodataCount == null ? other$nodataCount != null : !((Object)this$nodataCount).equals(other$nodataCount)) {
            return false;
        }
        Integer this$totalCount = this.getTotalCount();
        Integer other$totalCount = other.getTotalCount();
        if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
            return false;
        }
        Integer this$highestAnomalyLevel = this.getHighestAnomalyLevel();
        Integer other$highestAnomalyLevel = other.getHighestAnomalyLevel();
        if (this$highestAnomalyLevel == null ? other$highestAnomalyLevel != null : !((Object)this$highestAnomalyLevel).equals(other$highestAnomalyLevel)) {
            return false;
        }
        Integer this$anomalyCount = this.getAnomalyCount();
        Integer other$anomalyCount = other.getAnomalyCount();
        if (this$anomalyCount == null ? other$anomalyCount != null : !((Object)this$anomalyCount).equals(other$anomalyCount)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$omadacId = this.getOmadacId();
        String other$omadacId = other.getOmadacId();
        if (this$omadacId == null ? other$omadacId != null : !this$omadacId.equals(other$omadacId)) {
            return false;
        }
        String this$siteId = this.getSiteId();
        String other$siteId = other.getSiteId();
        return !(this$siteId == null ? other$siteId != null : !this$siteId.equals(other$siteId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseHealthAggregationDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $goodCount = this.getGoodCount();
        result = result * 59 + ($goodCount == null ? 43 : ((Object)$goodCount).hashCode());
        Integer $fairCount = this.getFairCount();
        result = result * 59 + ($fairCount == null ? 43 : ((Object)$fairCount).hashCode());
        Integer $poorCount = this.getPoorCount();
        result = result * 59 + ($poorCount == null ? 43 : ((Object)$poorCount).hashCode());
        Integer $nodataCount = this.getNodataCount();
        result = result * 59 + ($nodataCount == null ? 43 : ((Object)$nodataCount).hashCode());
        Integer $totalCount = this.getTotalCount();
        result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
        Integer $highestAnomalyLevel = this.getHighestAnomalyLevel();
        result = result * 59 + ($highestAnomalyLevel == null ? 43 : ((Object)$highestAnomalyLevel).hashCode());
        Integer $anomalyCount = this.getAnomalyCount();
        result = result * 59 + ($anomalyCount == null ? 43 : ((Object)$anomalyCount).hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $omadacId = this.getOmadacId();
        result = result * 59 + ($omadacId == null ? 43 : $omadacId.hashCode());
        String $siteId = this.getSiteId();
        result = result * 59 + ($siteId == null ? 43 : $siteId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BaseHealthAggregationDTO(omadacId=" + this.getOmadacId() + ", siteId=" + this.getSiteId() + ", goodCount=" + this.getGoodCount() + ", fairCount=" + this.getFairCount() + ", poorCount=" + this.getPoorCount() + ", nodataCount=" + this.getNodataCount() + ", totalCount=" + this.getTotalCount() + ", highestAnomalyLevel=" + this.getHighestAnomalyLevel() + ", anomalyCount=" + this.getAnomalyCount() + ", timestamp=" + this.getTimestamp() + ")";
    }

    @Generated
    public BaseHealthAggregationDTO() {
    }
}

