/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.network;

import com.tplink.smb.omada.anomaly.api.dto.anomaly.osw.AbstractOswDataDTO;
import com.tplink.smb.omada.common.device.StandardOswPortIndex;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswIGMPInfo;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswIgmpErrorPktsEntry;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswInformMulticastInfo;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswMLDInfo;
import com.tplink.smb.omada.device.manage.message.inform.osw.OswMldErrorPktsEntry;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;

public class OswIllegalMulticastMessageDTO
extends AbstractOswDataDTO {
    private Long igmpErrPkts;
    private Long mldErrPkts;
    private Long timeStamp;

    public OswIllegalMulticastMessageDTO(OswInformMulticastInfo oswInformMulticastInfo, Long timeStamp) {
        if (Objects.isNull(oswInformMulticastInfo.getIgmp()) || Objects.isNull(oswInformMulticastInfo.getIgmp().getErrPktsTable())) {
            this.igmpErrPkts = 0L;
        } else {
            OswIgmpErrorPktsEntry oswIgmpErrorPktsEntry = oswInformMulticastInfo.getIgmp().getErrPktsTable();
            this.igmpErrPkts = oswIgmpErrorPktsEntry.getTotalErrorPkts();
        }
        if (Objects.isNull(oswInformMulticastInfo.getMld()) || Objects.isNull(oswInformMulticastInfo.getMld().getErrPktsTable())) {
            this.mldErrPkts = 0L;
        } else {
            OswMldErrorPktsEntry oswMldErrorPktsEntry = oswInformMulticastInfo.getMld().getErrPktsTable();
            this.mldErrPkts = oswMldErrorPktsEntry.getTotalErrorPkts();
        }
        this.timeStamp = timeStamp;
    }

    public OswIllegalMulticastMessageDTO(OswInformMulticastInfo oswInformMulticastInfo, Long timeStamp, @Nonnull Integer unit) {
        List portIgmpErrPkts = Optional.ofNullable(oswInformMulticastInfo.getIgmp()).map(OswIGMPInfo::getPorts).orElse(new ArrayList());
        List portMldErrPkts = Optional.ofNullable(oswInformMulticastInfo.getMld()).map(OswMLDInfo::getPorts).orElse(new ArrayList());
        AtomicLong igmpEpNum = new AtomicLong(0L);
        AtomicLong mldEpNum = new AtomicLong(0L);
        portIgmpErrPkts.forEach(entry -> {
            StandardOswPortIndex standardOswPortIndex = StandardOswPortIndex.resolveStandardPortIndex((Integer)entry.getPort(), (String)entry.getStandardPort());
            if (Objects.equals(unit, standardOswPortIndex.getUnit()) && Objects.nonNull(entry.getErrPktCnt())) {
                igmpEpNum.addAndGet(entry.getErrPktCnt().intValue());
            }
        });
        portMldErrPkts.forEach(entry -> {
            StandardOswPortIndex standardOswPortIndex = StandardOswPortIndex.resolveStandardPortIndex((Integer)entry.getPort(), (String)entry.getStandardPort());
            if (Objects.equals(unit, standardOswPortIndex.getUnit()) && Objects.nonNull(entry.getErrPktCnt())) {
                mldEpNum.addAndGet(entry.getErrPktCnt().intValue());
            }
        });
        this.igmpErrPkts = igmpEpNum.get();
        this.mldErrPkts = mldEpNum.get();
        this.timeStamp = timeStamp;
    }

    @Override
    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof OswIllegalMulticastMessageDTO)) {
            return false;
        }
        OswIllegalMulticastMessageDTO other = (OswIllegalMulticastMessageDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Long this$igmpErrPkts = this.getIgmpErrPkts();
        Long other$igmpErrPkts = other.getIgmpErrPkts();
        if (this$igmpErrPkts == null ? other$igmpErrPkts != null : !((Object)this$igmpErrPkts).equals(other$igmpErrPkts)) {
            return false;
        }
        Long this$mldErrPkts = this.getMldErrPkts();
        Long other$mldErrPkts = other.getMldErrPkts();
        if (this$mldErrPkts == null ? other$mldErrPkts != null : !((Object)this$mldErrPkts).equals(other$mldErrPkts)) {
            return false;
        }
        Long this$timeStamp = this.getTimeStamp();
        Long other$timeStamp = other.getTimeStamp();
        return !(this$timeStamp == null ? other$timeStamp != null : !((Object)this$timeStamp).equals(other$timeStamp));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OswIllegalMulticastMessageDTO;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $igmpErrPkts = this.getIgmpErrPkts();
        result = result * 59 + ($igmpErrPkts == null ? 43 : ((Object)$igmpErrPkts).hashCode());
        Long $mldErrPkts = this.getMldErrPkts();
        result = result * 59 + ($mldErrPkts == null ? 43 : ((Object)$mldErrPkts).hashCode());
        Long $timeStamp = this.getTimeStamp();
        result = result * 59 + ($timeStamp == null ? 43 : ((Object)$timeStamp).hashCode());
        return result;
    }

    @Generated
    public Long getIgmpErrPkts() {
        return this.igmpErrPkts;
    }

    @Generated
    public Long getMldErrPkts() {
        return this.mldErrPkts;
    }

    @Generated
    public Long getTimeStamp() {
        return this.timeStamp;
    }

    @Generated
    public void setIgmpErrPkts(Long igmpErrPkts) {
        this.igmpErrPkts = igmpErrPkts;
    }

    @Generated
    public void setMldErrPkts(Long mldErrPkts) {
        this.mldErrPkts = mldErrPkts;
    }

    @Generated
    public void setTimeStamp(Long timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    @Generated
    public String toString() {
        return "OswIllegalMulticastMessageDTO(igmpErrPkts=" + this.getIgmpErrPkts() + ", mldErrPkts=" + this.getMldErrPkts() + ", timeStamp=" + this.getTimeStamp() + ")";
    }

    @Generated
    public OswIllegalMulticastMessageDTO(Long igmpErrPkts, Long mldErrPkts, Long timeStamp) {
        this.igmpErrPkts = igmpErrPkts;
        this.mldErrPkts = mldErrPkts;
        this.timeStamp = timeStamp;
    }

    @Generated
    public OswIllegalMulticastMessageDTO() {
    }
}

