/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.api.dto.anomaly.eap.client;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.b.A;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.eap.AbstractApDataDTO;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.eap.client.ApClientAssociationRecordDTO;
import com.tplink.smb.omada.anomaly.api.dto.common.dto.ClientStatInfoDTO;
import com.tplink.smb.omada.device.manage.message.inform.ap.buriedpoint.RadioAccess;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class ApClientAssociationDTO
extends AbstractApDataDTO {
    private Long time;
    private Integer client2gNum;
    private Integer client5gNum;
    private Integer client5g2Num;
    private Integer client6gNum;
    private Integer access2gNum;
    private Integer access5gNum;
    private List<ClientStatInfoDTO> clientStatInfoList;
    private List<List<ApClientAssociationRecordDTO>> stepRecords;

    public ApClientAssociationDTO(long time) {
        this.time = time;
        this.client2gNum = 0;
        this.client5gNum = 0;
        this.client5g2Num = 0;
        this.client6gNum = 0;
        this.access2gNum = 0;
        this.access5gNum = 0;
        this.clientStatInfoList = new ArrayList<ClientStatInfoDTO>();
        this.stepRecords = new ArrayList<List<ApClientAssociationRecordDTO>>();
    }

    public ApClientAssociationDTO(List<ClientStatInfoDTO> clientStatInfoList, List<List<ApClientAssociationRecordDTO>> stepRecords, List<RadioAccess> radioAccessInfos, Long time) {
        this.clientStatInfoList = clientStatInfoList;
        this.stepRecords = stepRecords;
        this.time = time;
        this.calculateClientNum(clientStatInfoList);
        this.setRadioAccessNum(radioAccessInfos);
    }

    public void setRadioAccessNum(List<RadioAccess> radioAccessInfos) {
        this.access2gNum = 0;
        this.access5gNum = 0;
        for (RadioAccess radioAccessInfo : radioAccessInfos) {
            A radioEnum = A.a(radioAccessInfo.getRadioID());
            if (!Objects.nonNull((Object)radioEnum)) continue;
            switch (radioEnum) {
                case a: {
                    this.access2gNum = Optional.ofNullable(radioAccessInfo.getAuthNum()).orElse(0);
                    break;
                }
                case b: {
                    this.access5gNum = Optional.ofNullable(radioAccessInfo.getAuthNum()).orElse(0);
                    break;
                }
            }
        }
    }

    private void calculateClientNum(List<ClientStatInfoDTO> clientStatInfoList) {
        if (CollectionUtils.isEmpty(clientStatInfoList)) {
            this.client2gNum = 0;
            this.client5gNum = 0;
            this.client5g2Num = 0;
            this.client6gNum = 0;
            return;
        }
        int num2g = 0;
        int num5g = 0;
        int num5g2 = 0;
        int num6g = 0;
        for (ClientStatInfoDTO statInfoDTO : clientStatInfoList) {
            Integer radio = statInfoDTO.getFrequencyBand();
            A radioEnum = A.a(radio);
            if (!Objects.nonNull((Object)radioEnum)) continue;
            switch (radioEnum) {
                case a: {
                    ++num2g;
                    break;
                }
                case b: {
                    ++num5g;
                    break;
                }
                case c: {
                    ++num5g2;
                    break;
                }
                case d: {
                    ++num6g;
                    break;
                }
            }
        }
        this.client2gNum = num2g;
        this.client5gNum = num5g;
        this.client5g2Num = num5g2;
        this.client6gNum = num6g;
    }

    @Override
    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof ApClientAssociationDTO)) {
            return false;
        }
        ApClientAssociationDTO other = (ApClientAssociationDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Long this$time = this.getTime();
        Long other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        Integer this$client2gNum = this.getClient2gNum();
        Integer other$client2gNum = other.getClient2gNum();
        if (this$client2gNum == null ? other$client2gNum != null : !((Object)this$client2gNum).equals(other$client2gNum)) {
            return false;
        }
        Integer this$client5gNum = this.getClient5gNum();
        Integer other$client5gNum = other.getClient5gNum();
        if (this$client5gNum == null ? other$client5gNum != null : !((Object)this$client5gNum).equals(other$client5gNum)) {
            return false;
        }
        Integer this$client5g2Num = this.getClient5g2Num();
        Integer other$client5g2Num = other.getClient5g2Num();
        if (this$client5g2Num == null ? other$client5g2Num != null : !((Object)this$client5g2Num).equals(other$client5g2Num)) {
            return false;
        }
        Integer this$client6gNum = this.getClient6gNum();
        Integer other$client6gNum = other.getClient6gNum();
        if (this$client6gNum == null ? other$client6gNum != null : !((Object)this$client6gNum).equals(other$client6gNum)) {
            return false;
        }
        Integer this$access2gNum = this.getAccess2gNum();
        Integer other$access2gNum = other.getAccess2gNum();
        if (this$access2gNum == null ? other$access2gNum != null : !((Object)this$access2gNum).equals(other$access2gNum)) {
            return false;
        }
        Integer this$access5gNum = this.getAccess5gNum();
        Integer other$access5gNum = other.getAccess5gNum();
        if (this$access5gNum == null ? other$access5gNum != null : !((Object)this$access5gNum).equals(other$access5gNum)) {
            return false;
        }
        List<ClientStatInfoDTO> this$clientStatInfoList = this.getClientStatInfoList();
        List<ClientStatInfoDTO> other$clientStatInfoList = other.getClientStatInfoList();
        if (this$clientStatInfoList == null ? other$clientStatInfoList != null : !((Object)this$clientStatInfoList).equals(other$clientStatInfoList)) {
            return false;
        }
        List<List<ApClientAssociationRecordDTO>> this$stepRecords = this.getStepRecords();
        List<List<ApClientAssociationRecordDTO>> other$stepRecords = other.getStepRecords();
        return !(this$stepRecords == null ? other$stepRecords != null : !((Object)this$stepRecords).equals(other$stepRecords));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApClientAssociationDTO;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        Integer $client2gNum = this.getClient2gNum();
        result = result * 59 + ($client2gNum == null ? 43 : ((Object)$client2gNum).hashCode());
        Integer $client5gNum = this.getClient5gNum();
        result = result * 59 + ($client5gNum == null ? 43 : ((Object)$client5gNum).hashCode());
        Integer $client5g2Num = this.getClient5g2Num();
        result = result * 59 + ($client5g2Num == null ? 43 : ((Object)$client5g2Num).hashCode());
        Integer $client6gNum = this.getClient6gNum();
        result = result * 59 + ($client6gNum == null ? 43 : ((Object)$client6gNum).hashCode());
        Integer $access2gNum = this.getAccess2gNum();
        result = result * 59 + ($access2gNum == null ? 43 : ((Object)$access2gNum).hashCode());
        Integer $access5gNum = this.getAccess5gNum();
        result = result * 59 + ($access5gNum == null ? 43 : ((Object)$access5gNum).hashCode());
        List<ClientStatInfoDTO> $clientStatInfoList = this.getClientStatInfoList();
        result = result * 59 + ($clientStatInfoList == null ? 43 : ((Object)$clientStatInfoList).hashCode());
        List<List<ApClientAssociationRecordDTO>> $stepRecords = this.getStepRecords();
        result = result * 59 + ($stepRecords == null ? 43 : ((Object)$stepRecords).hashCode());
        return result;
    }

    @Generated
    public Long getTime() {
        return this.time;
    }

    @Generated
    public Integer getClient2gNum() {
        return this.client2gNum;
    }

    @Generated
    public Integer getClient5gNum() {
        return this.client5gNum;
    }

    @Generated
    public Integer getClient5g2Num() {
        return this.client5g2Num;
    }

    @Generated
    public Integer getClient6gNum() {
        return this.client6gNum;
    }

    @Generated
    public Integer getAccess2gNum() {
        return this.access2gNum;
    }

    @Generated
    public Integer getAccess5gNum() {
        return this.access5gNum;
    }

    @Generated
    public List<ClientStatInfoDTO> getClientStatInfoList() {
        return this.clientStatInfoList;
    }

    @Generated
    public List<List<ApClientAssociationRecordDTO>> getStepRecords() {
        return this.stepRecords;
    }

    @Generated
    public void setTime(Long time) {
        this.time = time;
    }

    @Generated
    public void setClient2gNum(Integer client2gNum) {
        this.client2gNum = client2gNum;
    }

    @Generated
    public void setClient5gNum(Integer client5gNum) {
        this.client5gNum = client5gNum;
    }

    @Generated
    public void setClient5g2Num(Integer client5g2Num) {
        this.client5g2Num = client5g2Num;
    }

    @Generated
    public void setClient6gNum(Integer client6gNum) {
        this.client6gNum = client6gNum;
    }

    @Generated
    public void setAccess2gNum(Integer access2gNum) {
        this.access2gNum = access2gNum;
    }

    @Generated
    public void setAccess5gNum(Integer access5gNum) {
        this.access5gNum = access5gNum;
    }

    @Generated
    public void setClientStatInfoList(List<ClientStatInfoDTO> clientStatInfoList) {
        this.clientStatInfoList = clientStatInfoList;
    }

    @Generated
    public void setStepRecords(List<List<ApClientAssociationRecordDTO>> stepRecords) {
        this.stepRecords = stepRecords;
    }

    @Override
    @Generated
    public String toString() {
        return "ApClientAssociationDTO(time=" + this.getTime() + ", client2gNum=" + this.getClient2gNum() + ", client5gNum=" + this.getClient5gNum() + ", client5g2Num=" + this.getClient5g2Num() + ", client6gNum=" + this.getClient6gNum() + ", access2gNum=" + this.getAccess2gNum() + ", access5gNum=" + this.getAccess5gNum() + ", clientStatInfoList=" + this.getClientStatInfoList() + ", stepRecords=" + this.getStepRecords() + ")";
    }

    @Generated
    public ApClientAssociationDTO(Long time, Integer client2gNum, Integer client5gNum, Integer client5g2Num, Integer client6gNum, Integer access2gNum, Integer access5gNum, List<ClientStatInfoDTO> clientStatInfoList, List<List<ApClientAssociationRecordDTO>> stepRecords) {
        this.time = time;
        this.client2gNum = client2gNum;
        this.client5gNum = client5gNum;
        this.client5g2Num = client5g2Num;
        this.client6gNum = client6gNum;
        this.access2gNum = access2gNum;
        this.access5gNum = access5gNum;
        this.clientStatInfoList = clientStatInfoList;
        this.stepRecords = stepRecords;
    }

    @Generated
    public ApClientAssociationDTO() {
    }
}

