/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.anomaly.api.dto.anomaly.eap.cause;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.anomaly.api.b.A;
import com.tplink.smb.omada.anomaly.api.common.a;
import com.tplink.smb.omada.anomaly.api.dto.anomaly.eap.AbstractApDataDTO;
import com.tplink.smb.omada.device.manage.message.body.eap.EapInformBody;
import com.tplink.smb.omada.device.manage.message.inform.ap.WirelessInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public class EnvironmentRelatedDTO
extends AbstractApDataDTO {
    private Long timeStamp;
    private Map<A, Integer> channelUtilMap;
    private Map<A, Integer> surroundDeviceNumMap;

    public EnvironmentRelatedDTO(EapInformBody eapInformBody, long timeStamp) {
        this.timeStamp = timeStamp;
        WirelessInfo wSetting2g = eapInformBody.getWSettings2G();
        WirelessInfo wSetting5g = eapInformBody.getWSettings5G();
        WirelessInfo wSetting5g2 = eapInformBody.getWSettings5G2();
        WirelessInfo wSetting6g = eapInformBody.getWSettings6G();
        if (Objects.isNull(wSetting2g) && Objects.isNull(wSetting5g) && Objects.isNull(wSetting5g2) && Objects.isNull(wSetting6g)) {
            return;
        }
        this.channelUtilMap = a.a(wSetting2g, wSetting5g, wSetting5g2, wSetting6g);
        this.surroundDeviceNumMap = new HashMap<A, Integer>();
        if (CollectionUtils.isNotEmpty((Collection)eapInformBody.getRadioAccess())) {
            eapInformBody.getRadioAccess().forEach(radioAccessInfo -> {
                A radioEnum = A.a(radioAccessInfo.getRadioID());
                if (Objects.nonNull((Object)radioEnum) && Objects.nonNull(radioAccessInfo.getDeviceNum())) {
                    this.surroundDeviceNumMap.putIfAbsent(radioEnum, radioAccessInfo.getDeviceNum());
                }
            });
        }
    }

    public boolean validate() {
        return Objects.nonNull(this.timeStamp) && (CollectionUtils.isNotEmptyMap(this.channelUtilMap) || CollectionUtils.isNotEmptyMap(this.surroundDeviceNumMap));
    }

    @Generated
    public Long getTimeStamp() {
        return this.timeStamp;
    }

    @Generated
    public Map<A, Integer> getChannelUtilMap() {
        return this.channelUtilMap;
    }

    @Generated
    public Map<A, Integer> getSurroundDeviceNumMap() {
        return this.surroundDeviceNumMap;
    }

    @Generated
    public void setTimeStamp(Long timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Generated
    public void setChannelUtilMap(Map<A, Integer> channelUtilMap) {
        this.channelUtilMap = channelUtilMap;
    }

    @Generated
    public void setSurroundDeviceNumMap(Map<A, Integer> surroundDeviceNumMap) {
        this.surroundDeviceNumMap = surroundDeviceNumMap;
    }

    @Override
    @Generated
    public String toString() {
        return "EnvironmentRelatedDTO(timeStamp=" + this.getTimeStamp() + ", channelUtilMap=" + this.getChannelUtilMap() + ", surroundDeviceNumMap=" + this.getSurroundDeviceNumMap() + ")";
    }

    @Generated
    public EnvironmentRelatedDTO(Long timeStamp, Map<A, Integer> channelUtilMap, Map<A, Integer> surroundDeviceNumMap) {
        this.timeStamp = timeStamp;
        this.channelUtilMap = channelUtilMap;
        this.surroundDeviceNumMap = surroundDeviceNumMap;
    }

    @Generated
    public EnvironmentRelatedDTO() {
    }

    @Override
    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof EnvironmentRelatedDTO)) {
            return false;
        }
        EnvironmentRelatedDTO other = (EnvironmentRelatedDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Long this$timeStamp = this.getTimeStamp();
        Long other$timeStamp = other.getTimeStamp();
        if (this$timeStamp == null ? other$timeStamp != null : !((Object)this$timeStamp).equals(other$timeStamp)) {
            return false;
        }
        Map<A, Integer> this$channelUtilMap = this.getChannelUtilMap();
        Map<A, Integer> other$channelUtilMap = other.getChannelUtilMap();
        if (this$channelUtilMap == null ? other$channelUtilMap != null : !((Object)this$channelUtilMap).equals(other$channelUtilMap)) {
            return false;
        }
        Map<A, Integer> this$surroundDeviceNumMap = this.getSurroundDeviceNumMap();
        Map<A, Integer> other$surroundDeviceNumMap = other.getSurroundDeviceNumMap();
        return !(this$surroundDeviceNumMap == null ? other$surroundDeviceNumMap != null : !((Object)this$surroundDeviceNumMap).equals(other$surroundDeviceNumMap));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EnvironmentRelatedDTO;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $timeStamp = this.getTimeStamp();
        result = result * 59 + ($timeStamp == null ? 43 : ((Object)$timeStamp).hashCode());
        Map<A, Integer> $channelUtilMap = this.getChannelUtilMap();
        result = result * 59 + ($channelUtilMap == null ? 43 : ((Object)$channelUtilMap).hashCode());
        Map<A, Integer> $surroundDeviceNumMap = this.getSurroundDeviceNumMap();
        result = result * 59 + ($surroundDeviceNumMap == null ? 43 : ((Object)$surroundDeviceNumMap).hashCode());
        return result;
    }
}

