/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.dpi.domain;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.client.dpi.api.internal.dto.cache.ApplicationDetailDTO;
import com.tplink.smb.omada.client.dpi.api.internal.dto.cache.CategoryDetailDTO;
import com.tplink.smb.omada.client.dpi.api.internal.dto.cache.SiteApplicationInfoDTO;
import com.tplink.smb.omada.client.dpi.domain.b;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.manager.dpi.api.internal.dto.ApplicationControlInternalResultDTO;
import com.tplink.smb.omada.manager.dpi.api.internal.dto.ApplicationControlQueryDTO;
import com.tplink.smb.omada.manager.dpi.api.internal.service.a;
import com.tplink.smb.omada.manager.dpi.api.web.dto.FamilyVO;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class c {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(c.class);
    @Autowired
    private b b;
    @Autowired
    private a c;

    public SiteApplicationInfoDTO a(String omadacId, String siteId) {
        SiteApplicationInfoDTO siteApplicationInfoDTO = this.c(omadacId, siteId);
        a.debug("Get SiteApplicationInfo of omadacId : {} siteId : {} : {}", new Object[]{omadacId, siteId, siteApplicationInfoDTO});
        return siteApplicationInfoDTO;
    }

    public void b(String omadacId, String siteId) {
        SiteApplicationInfoDTO siteApplicationInfoDTO = this.c(omadacId, siteId);
        a.debug("update SiteApplicationInfo of omadacId : {} siteId : {} : {}", new Object[]{omadacId, siteId, siteApplicationInfoDTO});
        this.b.a(omadacId, siteId, siteApplicationInfoDTO);
    }

    private SiteApplicationInfoDTO c(String omadacId, String siteId) {
        try {
            ApplicationControlQueryDTO applicationControlQueryDTO = new ApplicationControlQueryDTO();
            applicationControlQueryDTO.setOmadacId(omadacId);
            applicationControlQueryDTO.setSiteId(siteId);
            OperationResponse operationResponse = this.c.a(applicationControlQueryDTO);
            if (Objects.isNull(operationResponse) || !operationResponse.success() || Objects.isNull(operationResponse.getResult())) {
                a.debug("fail to get site applicationInfo from manager, omadacId : {} siteId : {}", (Object)omadacId, (Object)siteId);
                return new SiteApplicationInfoDTO();
            }
            ApplicationControlInternalResultDTO resultDTO = (ApplicationControlInternalResultDTO)operationResponse.getResult();
            if (CollectionUtils.isEmpty((Collection)resultDTO.getFamilyVOList()) || CollectionUtils.isEmpty((Collection)resultDTO.getApplicationVOList())) {
                int categorySize = CollectionUtils.isEmpty((Collection)resultDTO.getFamilyVOList()) ? 0 : resultDTO.getFamilyVOList().size();
                int applicationSize = CollectionUtils.isEmpty((Collection)resultDTO.getApplicationVOList()) ? 0 : resultDTO.getApplicationVOList().size();
                a.debug("get unexpected site application from manager categorySize : {} applicationSize : {} , omdacId : {} siteId : {}", new Object[]{categorySize, applicationSize, omadacId, siteId});
            }
            return this.a(resultDTO);
        }
        catch (Exception e2) {
            a.info("fail to get site application info from manager , omadacId : {} siteId : {} , {}", new Object[]{omadacId, siteId, e2.getMessage(), e2});
            return null;
        }
    }

    private SiteApplicationInfoDTO a(@Nonnull ApplicationControlInternalResultDTO resultDTO) {
        SiteApplicationInfoDTO siteApplicationInfoDTO = new SiteApplicationInfoDTO();
        Map categoryDetailList = Optional.ofNullable(resultDTO.getFamilyVOList()).orElse(Collections.emptyList()).stream().map(vo -> new CategoryDetailDTO(vo.getFamilyId(), vo.getFamily(), vo.getDescription())).filter(dto -> Objects.nonNull(dto.getFamilyId())).collect(Collectors.toMap(CategoryDetailDTO::getFamilyId, v -> v, (v1, v2) -> v2, HashMap::new));
        Map applicationDetailList = Optional.ofNullable(resultDTO.getApplicationVOList()).orElse(Collections.emptyList()).stream().map(vo -> new ApplicationDetailDTO(vo.getApplicationId(), vo.getApplication(), vo.getDescription(), (Integer)Optional.ofNullable(vo.getFamily()).map(FamilyVO::getFamilyId).orElse(null), Collections.emptyList())).filter(dto -> Objects.nonNull(dto.getApplicationId())).collect(Collectors.toMap(ApplicationDetailDTO::getApplicationId, v -> v, (v1, v2) -> v2, HashMap::new));
        siteApplicationInfoDTO.setCategoryDetailMap(categoryDetailList);
        siteApplicationInfoDTO.setApplicationDetailMap(applicationDetailList);
        return siteApplicationInfoDTO;
    }
}

