/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.dpi.api.web.dto.openapi;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.client.dpi.api.web.dto.openapi.ApplicationBasicInfoOpenApiVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;

@Schema(name="ClientTrafficWithApplications")
public class ClientTrafficOpenApiVO {
    @Schema(name="type", description="The type of the client.")
    private String type;
    @Schema(name="manager", description="Whether the client is managed by the controller..")
    private Boolean manager;
    @Schema(name="clientName", description="The name of the client.")
    private String clientName;
    @Schema(name="mac", description="The mac of the client.")
    @a
    private String mac;
    @Schema(name="traffic", description="The total amount of traffic used by the client.")
    private Long traffic;
    @Schema(name="trafficPercent", description="The percentage of traffic used by the client.")
    private Double trafficPercent;
    @Schema(name="upload", description="The upload traffic used by the client.")
    private Long upload;
    @Schema(name="trafficPercent", description="The percentage of upload traffic used by the client.")
    private Double uploadPercent;
    @Schema(name="download", description="The download traffic used by the client.")
    private Long download;
    @Schema(name="trafficPercent", description="The percentage of download traffic used by the client.")
    private Double downloadPercent;
    @Schema(name="totalApplications", description="The number of applications using by the client.")
    private Integer totalApplications;
    @Schema(name="applicationList", description="The applications info using by the client.")
    private List<ApplicationBasicInfoOpenApiVO> applications;

    public ClientTrafficOpenApiVO(String mac) {
        this.mac = mac;
        this.traffic = 0L;
        this.upload = 0L;
        this.download = 0L;
        this.totalApplications = 0;
        this.applications = new ArrayList<ApplicationBasicInfoOpenApiVO>();
    }

    public void addApplication(@NonNull Long up, @NonNull Long down, @NonNull Long traffic, @NonNull Integer applicationId) {
        if (up == null) {
            throw new NullPointerException("up is marked non-null but is null");
        }
        if (down == null) {
            throw new NullPointerException("down is marked non-null but is null");
        }
        if (traffic == null) {
            throw new NullPointerException("traffic is marked non-null but is null");
        }
        if (applicationId == null) {
            throw new NullPointerException("applicationId is marked non-null but is null");
        }
        this.initValueIfNull();
        this.upload = this.upload + up;
        this.download = this.download + down;
        this.traffic = this.traffic + traffic;
        this.totalApplications = this.totalApplications + 1;
        this.applications.add(new ApplicationBasicInfoOpenApiVO(applicationId));
    }

    private void initValueIfNull() {
        if (Objects.isNull(this.traffic)) {
            this.traffic = 0L;
        }
        if (Objects.isNull(this.upload)) {
            this.upload = 0L;
        }
        if (Objects.isNull(this.download)) {
            this.download = 0L;
        }
        if (Objects.isNull(this.totalApplications)) {
            this.totalApplications = 0;
        }
    }

    @Generated
    public static ClientTrafficOpenApiVOBuilder builder() {
        return new ClientTrafficOpenApiVOBuilder();
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Boolean getManager() {
        return this.manager;
    }

    @Generated
    public String getClientName() {
        return this.clientName;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public Long getTraffic() {
        return this.traffic;
    }

    @Generated
    public Double getTrafficPercent() {
        return this.trafficPercent;
    }

    @Generated
    public Long getUpload() {
        return this.upload;
    }

    @Generated
    public Double getUploadPercent() {
        return this.uploadPercent;
    }

    @Generated
    public Long getDownload() {
        return this.download;
    }

    @Generated
    public Double getDownloadPercent() {
        return this.downloadPercent;
    }

    @Generated
    public Integer getTotalApplications() {
        return this.totalApplications;
    }

    @Generated
    public List<ApplicationBasicInfoOpenApiVO> getApplications() {
        return this.applications;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setManager(Boolean manager) {
        this.manager = manager;
    }

    @Generated
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setTraffic(Long traffic) {
        this.traffic = traffic;
    }

    @Generated
    public void setTrafficPercent(Double trafficPercent) {
        this.trafficPercent = trafficPercent;
    }

    @Generated
    public void setUpload(Long upload) {
        this.upload = upload;
    }

    @Generated
    public void setUploadPercent(Double uploadPercent) {
        this.uploadPercent = uploadPercent;
    }

    @Generated
    public void setDownload(Long download) {
        this.download = download;
    }

    @Generated
    public void setDownloadPercent(Double downloadPercent) {
        this.downloadPercent = downloadPercent;
    }

    @Generated
    public void setTotalApplications(Integer totalApplications) {
        this.totalApplications = totalApplications;
    }

    @Generated
    public void setApplications(List<ApplicationBasicInfoOpenApiVO> applications) {
        this.applications = applications;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientTrafficOpenApiVO)) {
            return false;
        }
        ClientTrafficOpenApiVO other = (ClientTrafficOpenApiVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$manager = this.getManager();
        Boolean other$manager = other.getManager();
        if (this$manager == null ? other$manager != null : !((Object)this$manager).equals(other$manager)) {
            return false;
        }
        Long this$traffic = this.getTraffic();
        Long other$traffic = other.getTraffic();
        if (this$traffic == null ? other$traffic != null : !((Object)this$traffic).equals(other$traffic)) {
            return false;
        }
        Double this$trafficPercent = this.getTrafficPercent();
        Double other$trafficPercent = other.getTrafficPercent();
        if (this$trafficPercent == null ? other$trafficPercent != null : !((Object)this$trafficPercent).equals(other$trafficPercent)) {
            return false;
        }
        Long this$upload = this.getUpload();
        Long other$upload = other.getUpload();
        if (this$upload == null ? other$upload != null : !((Object)this$upload).equals(other$upload)) {
            return false;
        }
        Double this$uploadPercent = this.getUploadPercent();
        Double other$uploadPercent = other.getUploadPercent();
        if (this$uploadPercent == null ? other$uploadPercent != null : !((Object)this$uploadPercent).equals(other$uploadPercent)) {
            return false;
        }
        Long this$download = this.getDownload();
        Long other$download = other.getDownload();
        if (this$download == null ? other$download != null : !((Object)this$download).equals(other$download)) {
            return false;
        }
        Double this$downloadPercent = this.getDownloadPercent();
        Double other$downloadPercent = other.getDownloadPercent();
        if (this$downloadPercent == null ? other$downloadPercent != null : !((Object)this$downloadPercent).equals(other$downloadPercent)) {
            return false;
        }
        Integer this$totalApplications = this.getTotalApplications();
        Integer other$totalApplications = other.getTotalApplications();
        if (this$totalApplications == null ? other$totalApplications != null : !((Object)this$totalApplications).equals(other$totalApplications)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        String this$mac = this.getMac();
        String other$mac = other.getMac();
        if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
            return false;
        }
        List<ApplicationBasicInfoOpenApiVO> this$applications = this.getApplications();
        List<ApplicationBasicInfoOpenApiVO> other$applications = other.getApplications();
        return !(this$applications == null ? other$applications != null : !((Object)this$applications).equals(other$applications));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientTrafficOpenApiVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $manager = this.getManager();
        result = result * 59 + ($manager == null ? 43 : ((Object)$manager).hashCode());
        Long $traffic = this.getTraffic();
        result = result * 59 + ($traffic == null ? 43 : ((Object)$traffic).hashCode());
        Double $trafficPercent = this.getTrafficPercent();
        result = result * 59 + ($trafficPercent == null ? 43 : ((Object)$trafficPercent).hashCode());
        Long $upload = this.getUpload();
        result = result * 59 + ($upload == null ? 43 : ((Object)$upload).hashCode());
        Double $uploadPercent = this.getUploadPercent();
        result = result * 59 + ($uploadPercent == null ? 43 : ((Object)$uploadPercent).hashCode());
        Long $download = this.getDownload();
        result = result * 59 + ($download == null ? 43 : ((Object)$download).hashCode());
        Double $downloadPercent = this.getDownloadPercent();
        result = result * 59 + ($downloadPercent == null ? 43 : ((Object)$downloadPercent).hashCode());
        Integer $totalApplications = this.getTotalApplications();
        result = result * 59 + ($totalApplications == null ? 43 : ((Object)$totalApplications).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        String $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
        List<ApplicationBasicInfoOpenApiVO> $applications = this.getApplications();
        result = result * 59 + ($applications == null ? 43 : ((Object)$applications).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClientTrafficOpenApiVO(type=" + this.getType() + ", manager=" + this.getManager() + ", clientName=" + this.getClientName() + ", mac=" + this.getMac() + ", traffic=" + this.getTraffic() + ", trafficPercent=" + this.getTrafficPercent() + ", upload=" + this.getUpload() + ", uploadPercent=" + this.getUploadPercent() + ", download=" + this.getDownload() + ", downloadPercent=" + this.getDownloadPercent() + ", totalApplications=" + this.getTotalApplications() + ", applications=" + this.getApplications() + ")";
    }

    @Generated
    public ClientTrafficOpenApiVO() {
    }

    @Generated
    public ClientTrafficOpenApiVO(String type, Boolean manager, String clientName, String mac, Long traffic, Double trafficPercent, Long upload, Double uploadPercent, Long download, Double downloadPercent, Integer totalApplications, List<ApplicationBasicInfoOpenApiVO> applications) {
        this.type = type;
        this.manager = manager;
        this.clientName = clientName;
        this.mac = mac;
        this.traffic = traffic;
        this.trafficPercent = trafficPercent;
        this.upload = upload;
        this.uploadPercent = uploadPercent;
        this.download = download;
        this.downloadPercent = downloadPercent;
        this.totalApplications = totalApplications;
        this.applications = applications;
    }

    @Generated
    public static class ClientTrafficOpenApiVOBuilder {
        @Generated
        private String type;
        @Generated
        private Boolean manager;
        @Generated
        private String clientName;
        @Generated
        private String mac;
        @Generated
        private Long traffic;
        @Generated
        private Double trafficPercent;
        @Generated
        private Long upload;
        @Generated
        private Double uploadPercent;
        @Generated
        private Long download;
        @Generated
        private Double downloadPercent;
        @Generated
        private Integer totalApplications;
        @Generated
        private List<ApplicationBasicInfoOpenApiVO> applications;

        @Generated
        ClientTrafficOpenApiVOBuilder() {
        }

        @Generated
        public ClientTrafficOpenApiVOBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public ClientTrafficOpenApiVOBuilder manager(Boolean manager) {
            this.manager = manager;
            return this;
        }

        @Generated
        public ClientTrafficOpenApiVOBuilder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        @Generated
        public ClientTrafficOpenApiVOBuilder mac(String mac) {
            this.mac = mac;
            return this;
        }

        @Generated
        public ClientTrafficOpenApiVOBuilder traffic(Long traffic) {
            this.traffic = traffic;
            return this;
        }

        @Generated
        public ClientTrafficOpenApiVOBuilder trafficPercent(Double trafficPercent) {
            this.trafficPercent = trafficPercent;
            return this;
        }

        @Generated
        public ClientTrafficOpenApiVOBuilder upload(Long upload) {
            this.upload = upload;
            return this;
        }

        @Generated
        public ClientTrafficOpenApiVOBuilder uploadPercent(Double uploadPercent) {
            this.uploadPercent = uploadPercent;
            return this;
        }

        @Generated
        public ClientTrafficOpenApiVOBuilder download(Long download) {
            this.download = download;
            return this;
        }

        @Generated
        public ClientTrafficOpenApiVOBuilder downloadPercent(Double downloadPercent) {
            this.downloadPercent = downloadPercent;
            return this;
        }

        @Generated
        public ClientTrafficOpenApiVOBuilder totalApplications(Integer totalApplications) {
            this.totalApplications = totalApplications;
            return this;
        }

        @Generated
        public ClientTrafficOpenApiVOBuilder applications(List<ApplicationBasicInfoOpenApiVO> applications) {
            this.applications = applications;
            return this;
        }

        @Generated
        public ClientTrafficOpenApiVO build() {
            return new ClientTrafficOpenApiVO(this.type, this.manager, this.clientName, this.mac, this.traffic, this.trafficPercent, this.upload, this.uploadPercent, this.download, this.downloadPercent, this.totalApplications, this.applications);
        }

        @Generated
        public String toString() {
            return "ClientTrafficOpenApiVO.ClientTrafficOpenApiVOBuilder(type=" + this.type + ", manager=" + this.manager + ", clientName=" + this.clientName + ", mac=" + this.mac + ", traffic=" + this.traffic + ", trafficPercent=" + this.trafficPercent + ", upload=" + this.upload + ", uploadPercent=" + this.uploadPercent + ", download=" + this.download + ", downloadPercent=" + this.downloadPercent + ", totalApplications=" + this.totalApplications + ", applications=" + this.applications + ")";
        }
    }
}

