/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.dpi.api.web.dto.openapi;

import com.tplink.smb.omada.client.dpi.api.web.dto.openapi.ApplicationTrafficOpenApiVO;
import com.tplink.smb.omada.client.dpi.api.web.dto.openapi.ClientTrafficOpenApiVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;

@Schema(name="CategoryTraffic")
public class CategoryTrafficOpenApiVO {
    @Schema(name="familyId", description="The id of the category.")
    private Integer familyId;
    @Schema(name="familyName", description="The name of the category.")
    private String familyName;
    @Schema(name="traffic", description="The total amount of traffic used by the category.")
    private Long traffic;
    @Schema(name="upload", description="The upload traffic used by the category.")
    private Long upload;
    @Schema(name="download", description="The download traffic used by the category.")
    private Long download;
    @Schema(name="trafficPercent", description="The percentage of traffic used by the category.")
    private Double trafficPercent;
    @Schema(name="totalApplications", description="The number of applications used in this category.")
    private Integer totalApplications;
    @Schema(name="applications", description="The applications used in this category.")
    private List<ApplicationTrafficOpenApiVO> applications;
    @Schema(name="totalClients", description="The number of clients using the app in this category.")
    private Integer totalClients;
    @Schema(name="clients", description="The clients using the app in this category.")
    private List<ClientTrafficOpenApiVO> clients;

    public CategoryTrafficOpenApiVO(Integer familyId, String familyName) {
        this.familyId = familyId;
        this.familyName = familyName;
        this.traffic = 0L;
        this.upload = 0L;
        this.download = 0L;
        this.totalApplications = 0;
        this.applications = new ArrayList<ApplicationTrafficOpenApiVO>();
        this.totalClients = 0;
        this.clients = new ArrayList<ClientTrafficOpenApiVO>();
    }

    public void addTrafficAndApplicationStat(@NonNull Long traffic, @NonNull Integer applicationId, @NonNull String applicationName, String description, @NonNull Integer clientsCount) {
        if (traffic == null) {
            throw new NullPointerException("traffic is marked non-null but is null");
        }
        if (applicationId == null) {
            throw new NullPointerException("applicationId is marked non-null but is null");
        }
        if (applicationName == null) {
            throw new NullPointerException("applicationName is marked non-null but is null");
        }
        if (clientsCount == null) {
            throw new NullPointerException("clientsCount is marked non-null but is null");
        }
        this.initValueIfNull();
        this.traffic = this.traffic + traffic;
        this.totalApplications = this.totalApplications + 1;
        this.applications.add(new ApplicationTrafficOpenApiVO(applicationName, description, applicationId, traffic, clientsCount));
    }

    public void addClientStat(@NonNull ClientTrafficOpenApiVO clientTrafficOpenApiVO) {
        if (clientTrafficOpenApiVO == null) {
            throw new NullPointerException("clientTrafficOpenApiVO is marked non-null but is null");
        }
        this.initValueIfNull();
        this.totalClients = this.totalClients + 1;
        this.clients.add(clientTrafficOpenApiVO);
    }

    public void addUpload(@NonNull Long upload) {
        if (upload == null) {
            throw new NullPointerException("upload is marked non-null but is null");
        }
        this.initValueIfNull();
        this.upload = this.upload + upload;
    }

    public void addDownload(@NonNull Long download) {
        if (download == null) {
            throw new NullPointerException("download is marked non-null but is null");
        }
        this.initValueIfNull();
        this.download = this.download + download;
    }

    private void initValueIfNull() {
        if (Objects.isNull(this.traffic)) {
            this.traffic = 0L;
        }
        if (Objects.isNull(this.upload)) {
            this.upload = 0L;
        }
        if (Objects.isNull(this.download)) {
            this.download = 0L;
        }
        if (Objects.isNull(this.totalApplications)) {
            this.totalApplications = 0;
        }
        if (Objects.isNull(this.totalClients)) {
            this.totalClients = 0;
        }
    }

    @Generated
    public Integer getFamilyId() {
        return this.familyId;
    }

    @Generated
    public String getFamilyName() {
        return this.familyName;
    }

    @Generated
    public Long getTraffic() {
        return this.traffic;
    }

    @Generated
    public Long getUpload() {
        return this.upload;
    }

    @Generated
    public Long getDownload() {
        return this.download;
    }

    @Generated
    public Double getTrafficPercent() {
        return this.trafficPercent;
    }

    @Generated
    public Integer getTotalApplications() {
        return this.totalApplications;
    }

    @Generated
    public List<ApplicationTrafficOpenApiVO> getApplications() {
        return this.applications;
    }

    @Generated
    public Integer getTotalClients() {
        return this.totalClients;
    }

    @Generated
    public List<ClientTrafficOpenApiVO> getClients() {
        return this.clients;
    }

    @Generated
    public void setFamilyId(Integer familyId) {
        this.familyId = familyId;
    }

    @Generated
    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    @Generated
    public void setTraffic(Long traffic) {
        this.traffic = traffic;
    }

    @Generated
    public void setUpload(Long upload) {
        this.upload = upload;
    }

    @Generated
    public void setDownload(Long download) {
        this.download = download;
    }

    @Generated
    public void setTrafficPercent(Double trafficPercent) {
        this.trafficPercent = trafficPercent;
    }

    @Generated
    public void setTotalApplications(Integer totalApplications) {
        this.totalApplications = totalApplications;
    }

    @Generated
    public void setApplications(List<ApplicationTrafficOpenApiVO> applications) {
        this.applications = applications;
    }

    @Generated
    public void setTotalClients(Integer totalClients) {
        this.totalClients = totalClients;
    }

    @Generated
    public void setClients(List<ClientTrafficOpenApiVO> clients) {
        this.clients = clients;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CategoryTrafficOpenApiVO)) {
            return false;
        }
        CategoryTrafficOpenApiVO other = (CategoryTrafficOpenApiVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$familyId = this.getFamilyId();
        Integer other$familyId = other.getFamilyId();
        if (this$familyId == null ? other$familyId != null : !((Object)this$familyId).equals(other$familyId)) {
            return false;
        }
        Long this$traffic = this.getTraffic();
        Long other$traffic = other.getTraffic();
        if (this$traffic == null ? other$traffic != null : !((Object)this$traffic).equals(other$traffic)) {
            return false;
        }
        Long this$upload = this.getUpload();
        Long other$upload = other.getUpload();
        if (this$upload == null ? other$upload != null : !((Object)this$upload).equals(other$upload)) {
            return false;
        }
        Long this$download = this.getDownload();
        Long other$download = other.getDownload();
        if (this$download == null ? other$download != null : !((Object)this$download).equals(other$download)) {
            return false;
        }
        Double this$trafficPercent = this.getTrafficPercent();
        Double other$trafficPercent = other.getTrafficPercent();
        if (this$trafficPercent == null ? other$trafficPercent != null : !((Object)this$trafficPercent).equals(other$trafficPercent)) {
            return false;
        }
        Integer this$totalApplications = this.getTotalApplications();
        Integer other$totalApplications = other.getTotalApplications();
        if (this$totalApplications == null ? other$totalApplications != null : !((Object)this$totalApplications).equals(other$totalApplications)) {
            return false;
        }
        Integer this$totalClients = this.getTotalClients();
        Integer other$totalClients = other.getTotalClients();
        if (this$totalClients == null ? other$totalClients != null : !((Object)this$totalClients).equals(other$totalClients)) {
            return false;
        }
        String this$familyName = this.getFamilyName();
        String other$familyName = other.getFamilyName();
        if (this$familyName == null ? other$familyName != null : !this$familyName.equals(other$familyName)) {
            return false;
        }
        List<ApplicationTrafficOpenApiVO> this$applications = this.getApplications();
        List<ApplicationTrafficOpenApiVO> other$applications = other.getApplications();
        if (this$applications == null ? other$applications != null : !((Object)this$applications).equals(other$applications)) {
            return false;
        }
        List<ClientTrafficOpenApiVO> this$clients = this.getClients();
        List<ClientTrafficOpenApiVO> other$clients = other.getClients();
        return !(this$clients == null ? other$clients != null : !((Object)this$clients).equals(other$clients));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CategoryTrafficOpenApiVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $familyId = this.getFamilyId();
        result = result * 59 + ($familyId == null ? 43 : ((Object)$familyId).hashCode());
        Long $traffic = this.getTraffic();
        result = result * 59 + ($traffic == null ? 43 : ((Object)$traffic).hashCode());
        Long $upload = this.getUpload();
        result = result * 59 + ($upload == null ? 43 : ((Object)$upload).hashCode());
        Long $download = this.getDownload();
        result = result * 59 + ($download == null ? 43 : ((Object)$download).hashCode());
        Double $trafficPercent = this.getTrafficPercent();
        result = result * 59 + ($trafficPercent == null ? 43 : ((Object)$trafficPercent).hashCode());
        Integer $totalApplications = this.getTotalApplications();
        result = result * 59 + ($totalApplications == null ? 43 : ((Object)$totalApplications).hashCode());
        Integer $totalClients = this.getTotalClients();
        result = result * 59 + ($totalClients == null ? 43 : ((Object)$totalClients).hashCode());
        String $familyName = this.getFamilyName();
        result = result * 59 + ($familyName == null ? 43 : $familyName.hashCode());
        List<ApplicationTrafficOpenApiVO> $applications = this.getApplications();
        result = result * 59 + ($applications == null ? 43 : ((Object)$applications).hashCode());
        List<ClientTrafficOpenApiVO> $clients = this.getClients();
        result = result * 59 + ($clients == null ? 43 : ((Object)$clients).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CategoryTrafficOpenApiVO(familyId=" + this.getFamilyId() + ", familyName=" + this.getFamilyName() + ", traffic=" + this.getTraffic() + ", upload=" + this.getUpload() + ", download=" + this.getDownload() + ", trafficPercent=" + this.getTrafficPercent() + ", totalApplications=" + this.getTotalApplications() + ", applications=" + this.getApplications() + ", totalClients=" + this.getTotalClients() + ", clients=" + this.getClients() + ")";
    }

    @Generated
    public CategoryTrafficOpenApiVO() {
    }

    @Generated
    public CategoryTrafficOpenApiVO(Integer familyId, String familyName, Long traffic, Long upload, Long download, Double trafficPercent, Integer totalApplications, List<ApplicationTrafficOpenApiVO> applications, Integer totalClients, List<ClientTrafficOpenApiVO> clients) {
        this.familyId = familyId;
        this.familyName = familyName;
        this.traffic = traffic;
        this.upload = upload;
        this.download = download;
        this.trafficPercent = trafficPercent;
        this.totalApplications = totalApplications;
        this.applications = applications;
        this.totalClients = totalClients;
        this.clients = clients;
    }
}

