/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.dpi.api.internal.dto.cache;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.client.dpi.api.internal.a.b;
import com.tplink.smb.omada.client.dpi.api.internal.a.d;
import com.tplink.smb.omada.client.dpi.api.internal.dto.DpiApplicationStatDTO;
import com.tplink.smb.omada.client.dpi.api.internal.dto.DpiBaseParamInfoDTO;
import com.tplink.smb.omada.client.dpi.api.internal.dto.DpiClientInfoDTO;
import com.tplink.smb.omada.client.dpi.api.internal.dto.DpiClientStatDTO;
import com.tplink.smb.omada.client.dpi.api.internal.dto.TrafficDTO;
import com.tplink.smb.omada.client.dpi.api.internal.dto.cache.ApplicationBlockStatItemDTO;
import com.tplink.smb.omada.client.dpi.api.internal.dto.cache.ApplicationDetailDTO;
import com.tplink.smb.omada.client.dpi.api.internal.dto.cache.CategoryDetailDTO;
import com.tplink.smb.omada.client.dpi.api.internal.dto.cache.ClientTrafficStatEntryDTO;
import com.tplink.smb.omada.client.dpi.api.internal.dto.cache.ClientTrafficStatItemDTO;
import com.tplink.smb.omada.client.dpi.api.internal.dto.cache.PeriodTrafficStatAggregateDTO;
import com.tplink.smb.omada.client.dpi.api.internal.dto.cache.SiteApplicationInfoDTO;
import com.tplink.smb.omada.client.dpi.api.internal.dto.cache.TagDetailDTO;
import com.tplink.smb.omada.client.dpi.api.web.dto.ApplicationDetailVO;
import com.tplink.smb.omada.client.dpi.api.web.dto.CategoryDetailVO;
import com.tplink.smb.omada.client.dpi.api.web.dto.TagDetailVO;
import com.tplink.smb.omada.common.util.g;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class a {
    @Generated
    private static final Logger c = LoggerFactory.getLogger(a.class);
    public static final String a = ":";
    public static final int b = 1000;

    public static List<ClientTrafficStatItemDTO> a(String oamdacId, String siteId, String deviceMac, Map<String, DpiClientInfoDTO> ipClientInfoMap, List<ClientTrafficStatEntryDTO> clientTrafficStatList) {
        ArrayList<ClientTrafficStatItemDTO> resultList = new ArrayList<ClientTrafficStatItemDTO>();
        if (CollectionUtils.isEmpty(clientTrafficStatList)) {
            return resultList;
        }
        clientTrafficStatList.forEach(stat -> {
            String ip = stat.getIp();
            DpiClientInfoDTO dpiClientInfoDTO = (DpiClientInfoDTO)ipClientInfoMap.get(ip);
            if (Objects.isNull(dpiClientInfoDTO)) {
                c.debug("skip handle ip : {} for cannot get client image", (Object)ip);
                return;
            }
            ClientTrafficStatItemDTO item = ClientTrafficStatItemDTO.buildDefault(dpiClientInfoDTO.getMac(), dpiClientInfoDTO.getName(), dpiClientInfoDTO.getType(), stat.getIp(), stat.getApplicationId());
            item.setTraffic(stat.getUp(), stat.getDown(), stat.getUpPackets(), stat.getDownPackets());
            resultList.add(item);
        });
        c.debug("get dpi client stat of omadacId {} siteId {} deviceMac: {} size : {}", new Object[]{oamdacId, siteId, deviceMac, resultList.size()});
        return resultList;
    }

    public static List<PeriodTrafficStatAggregateDTO> a(PeriodTrafficStatAggregateDTO trafficStatAggregateDTO) {
        if (Objects.isNull(trafficStatAggregateDTO)) {
            return Collections.emptyList();
        }
        List clientTrafficStats = Optional.ofNullable(trafficStatAggregateDTO.getClientTrafficStats()).orElse(Collections.emptyList());
        List<ApplicationBlockStatItemDTO> applicationBlockStats = Optional.ofNullable(trafficStatAggregateDTO.getApplicationBlockStats()).orElse(Collections.emptyList());
        List splitList = com.tplink.smb.omada.client.dpi.api.internal.dto.cache.a.a(clientTrafficStats, clientTrafficStats.size(), 1000);
        if (CollectionUtils.isEmpty(splitList)) {
            return Collections.singletonList(new PeriodTrafficStatAggregateDTO(Collections.emptyList(), applicationBlockStats));
        }
        ArrayList<PeriodTrafficStatAggregateDTO> resultList = new ArrayList<PeriodTrafficStatAggregateDTO>();
        resultList.add(new PeriodTrafficStatAggregateDTO(splitList.get(0), applicationBlockStats));
        for (int i2 = 1; i2 < splitList.size(); ++i2) {
            resultList.add(new PeriodTrafficStatAggregateDTO(splitList.get(i2)));
        }
        return resultList;
    }

    public static void a(SiteApplicationInfoDTO siteApplicationInfoDTO, Map<Integer, DpiApplicationStatDTO> dpiApplicationStatMap, Map<String, DpiClientStatDTO> dpiClientStatMap, List<PeriodTrafficStatAggregateDTO> trafficStats, String omadacId, String siteId, long statSecond) {
        if (CollectionUtils.isEmpty(trafficStats)) {
            return;
        }
        Map<Integer, CategoryDetailDTO> categoryDetailMap = siteApplicationInfoDTO.getCategoryDetailMap();
        Map<Integer, ApplicationDetailDTO> applicationDetailMap = siteApplicationInfoDTO.getApplicationDetailMap();
        ArrayList<ClientTrafficStatItemDTO> clientTrafficStatItems = new ArrayList<ClientTrafficStatItemDTO>();
        ArrayList<ApplicationBlockStatItemDTO> applicationBlockStatItems = new ArrayList<ApplicationBlockStatItemDTO>();
        com.tplink.smb.omada.client.dpi.api.internal.dto.cache.a.a(trafficStats, clientTrafficStatItems, applicationBlockStatItems);
        clientTrafficStatItems.forEach(stat -> {
            Integer applicationId = stat.getApplicationId();
            ApplicationDetailDTO applicationDetailDTO = null;
            CategoryDetailDTO categoryDetailDTO = null;
            try {
                applicationDetailDTO = (ApplicationDetailDTO)applicationDetailMap.get(applicationId);
                categoryDetailDTO = (CategoryDetailDTO)categoryDetailMap.get(applicationDetailDTO.getFamilyId());
            }
            catch (Exception e2) {
                c.warn("fail to handle applicationId : {}", (Object)applicationId);
                return;
            }
            if (Objects.isNull(categoryDetailDTO)) {
                c.warn("unknown family id of application id : {}", (Object)applicationId);
                return;
            }
            Integer familyId = categoryDetailDTO.getFamilyId();
            DpiApplicationStatDTO dpiApplicationStatDTO = dpiApplicationStatMap.computeIfAbsent(applicationId, id -> DpiApplicationStatDTO.buildDefault(omadacId, siteId, statSecond, applicationId, familyId));
            String clientMac = stat.getClientMac();
            String type = stat.getType();
            DpiClientStatDTO dpiClientStatDTO = dpiClientStatMap.computeIfAbsent(clientMac, mac -> DpiClientStatDTO.buildDefault(omadacId, siteId, statSecond, clientMac, type, stat.getIp()));
            Long up = stat.getUp();
            Long down = stat.getDown();
            Long upPacket = stat.getUpPackets();
            Long downPacket = stat.getDownPackets();
            dpiApplicationStatDTO.addTrafficStat(clientMac, up, down, upPacket, downPacket);
            if (!g.c()) {
                dpiClientStatDTO.addStat(familyId, applicationId, up, down, upPacket, downPacket);
            }
        });
        applicationBlockStatItems.forEach(stat -> {
            Integer applicationId = stat.getApplicationId();
            ApplicationDetailDTO applicationDetailDTO = null;
            CategoryDetailDTO categoryDetailDTO = null;
            try {
                applicationDetailDTO = (ApplicationDetailDTO)applicationDetailMap.get(applicationId);
                categoryDetailDTO = (CategoryDetailDTO)categoryDetailMap.get(applicationDetailDTO.getFamilyId());
            }
            catch (Exception e2) {
                c.warn("fail to handle applicationId : {}", (Object)applicationId);
                return;
            }
            Integer familyId = categoryDetailDTO.getFamilyId();
            DpiApplicationStatDTO applicationBlockStat = dpiApplicationStatMap.computeIfAbsent(applicationId, id -> DpiApplicationStatDTO.buildDefault(omadacId, siteId, statSecond, applicationId, familyId));
            applicationBlockStat.addBlockStat(stat.getBlockCount());
        });
    }

    public static void a(SiteApplicationInfoDTO siteApplicationInfoDTO, Map<Integer, DpiApplicationStatDTO> dpiApplicationStatMap, Map<String, DpiClientStatDTO> dpiClientStatMap, d dpiTrafficNotifyContent, Map<String, DpiClientInfoDTO> ipClientInfoMap, DpiBaseParamInfoDTO paramInfoDTO) {
        String omadacId = paramInfoDTO.getOmadacId();
        String siteId = paramInfoDTO.getSiteId();
        long statSecond = paramInfoDTO.getTime();
        Map<Integer, CategoryDetailDTO> categoryDetailMap = siteApplicationInfoDTO.getCategoryDetailMap();
        Map<Integer, ApplicationDetailDTO> applicationDetailMap = siteApplicationInfoDTO.getApplicationDetailMap();
        List<b> clientTrafficStatItems = Optional.ofNullable(dpiTrafficNotifyContent.a()).orElse(Collections.emptyList());
        List<com.tplink.smb.omada.client.dpi.api.internal.a.a> applicationBlockStatItems = Optional.ofNullable(dpiTrafficNotifyContent.b()).orElse(Collections.emptyList());
        clientTrafficStatItems.forEach(stat -> {
            Integer applicationId = stat.b();
            ApplicationDetailDTO applicationDetailDTO = null;
            CategoryDetailDTO categoryDetailDTO = null;
            DpiClientInfoDTO dpiClientInfoDTO = null;
            try {
                applicationDetailDTO = (ApplicationDetailDTO)applicationDetailMap.get(applicationId);
                categoryDetailDTO = (CategoryDetailDTO)categoryDetailMap.get(applicationDetailDTO.getFamilyId());
                if (!g.c()) {
                    dpiClientInfoDTO = (DpiClientInfoDTO)ipClientInfoMap.get(stat.a());
                }
            }
            catch (Exception e2) {
                c.warn("fail to handle applicationId : {}", (Object)applicationId);
                return;
            }
            if (!g.c() && Objects.isNull(dpiClientInfoDTO)) {
                c.debug("skip handle ip : {} for cannot get client info", (Object)stat.a());
                return;
            }
            if (Objects.isNull(categoryDetailDTO)) {
                c.warn("unknown family id of application id : {}", (Object)applicationId);
                return;
            }
            Integer familyId = categoryDetailDTO.getFamilyId();
            DpiApplicationStatDTO dpiApplicationStatDTO = dpiApplicationStatMap.computeIfAbsent(applicationId, id -> DpiApplicationStatDTO.buildDefault(omadacId, siteId, statSecond, applicationId, familyId));
            Long up = Optional.ofNullable(stat.c()).orElse(0L);
            Long down = Optional.ofNullable(stat.d()).orElse(0L);
            Long upPacket = Optional.ofNullable(stat.e()).orElse(0L);
            Long downPacket = Optional.ofNullable(stat.f()).orElse(0L);
            if (!g.c()) {
                dpiClientInfoDTO = (DpiClientInfoDTO)ipClientInfoMap.get(stat.a());
                if (!Objects.isNull(dpiClientInfoDTO)) {
                    String clientMac = dpiClientInfoDTO.getMac();
                    String type = dpiClientInfoDTO.getType();
                    DpiClientStatDTO dpiClientStatDTO = dpiClientStatMap.computeIfAbsent(clientMac, mac -> DpiClientStatDTO.buildDefault(omadacId, siteId, statSecond, clientMac, type, stat.a()));
                    dpiApplicationStatDTO.addTrafficStat(clientMac, up, down, upPacket, downPacket);
                    dpiClientStatDTO.addStat(familyId, applicationId, up, down, upPacket, downPacket);
                }
            } else {
                dpiApplicationStatDTO.addTrafficStat(null, up, down, upPacket, downPacket);
            }
        });
        applicationBlockStatItems.forEach(stat -> {
            Integer applicationId = stat.a();
            ApplicationDetailDTO applicationDetailDTO = null;
            CategoryDetailDTO categoryDetailDTO = null;
            try {
                applicationDetailDTO = (ApplicationDetailDTO)applicationDetailMap.get(applicationId);
                categoryDetailDTO = (CategoryDetailDTO)categoryDetailMap.get(applicationDetailDTO.getFamilyId());
            }
            catch (Exception e2) {
                c.warn("fail to handle applicationId : {}", (Object)applicationId);
                return;
            }
            Integer familyId = categoryDetailDTO.getFamilyId();
            DpiApplicationStatDTO applicationBlockStat = dpiApplicationStatMap.computeIfAbsent(applicationId, id -> DpiApplicationStatDTO.buildDefault(omadacId, siteId, statSecond, applicationId, familyId));
            applicationBlockStat.addBlockStat(stat.b());
        });
    }

    public static void a(Map<Integer, DpiApplicationStatDTO> dpiApplicationStatMap, Map<String, DpiClientStatDTO> dpiClientStatMap, List<DpiApplicationStatDTO> dbAppStatList, List<DpiClientStatDTO> dbClientStatList) {
        if (!CollectionUtils.isEmptyMap(dpiApplicationStatMap) && !CollectionUtils.isEmpty(dbAppStatList)) {
            dbAppStatList.forEach(statDTO -> {
                Integer appId = statDTO.getApplicationId();
                DpiApplicationStatDTO notifyObj = (DpiApplicationStatDTO)dpiApplicationStatMap.get(appId);
                if (Objects.isNull(notifyObj)) {
                    return;
                }
                notifyObj.setId(statDTO.getId());
                notifyObj.mergeAnotherOneNormally((DpiApplicationStatDTO)statDTO, false);
            });
        }
        if (!CollectionUtils.isEmptyMap(dpiClientStatMap) && !CollectionUtils.isEmpty(dbClientStatList)) {
            dbClientStatList.forEach(statDTO -> {
                String clientMac = statDTO.getMac();
                DpiClientStatDTO notifyObj = (DpiClientStatDTO)dpiClientStatMap.get(clientMac);
                if (Objects.isNull(notifyObj)) {
                    return;
                }
                notifyObj.setId(statDTO.getId());
                notifyObj.mergeAnotherOneNormally((DpiClientStatDTO)statDTO, false);
            });
        }
    }

    public static Long a(@Nonnull Long startSec) {
        return startSec / 3600L * 3600L + 1L;
    }

    public static Long b(@Nonnull Long endSec) {
        return (endSec / 3600L + 1L) * 3600L + 1L;
    }

    private static void a(List<PeriodTrafficStatAggregateDTO> trafficStats, List<ClientTrafficStatItemDTO> clientTrafficStatItems, List<ApplicationBlockStatItemDTO> applicationBlockStatItems) {
        if (CollectionUtils.isEmpty(trafficStats)) {
            return;
        }
        for (PeriodTrafficStatAggregateDTO aggregateDTO : trafficStats) {
            List tmpClientTraffics = Optional.ofNullable(aggregateDTO.getClientTrafficStats()).orElse(Collections.emptyList());
            List tmpApplicationTraffics = Optional.ofNullable(aggregateDTO.getApplicationBlockStats()).orElse(Collections.emptyList());
            clientTrafficStatItems.addAll(tmpClientTraffics);
            applicationBlockStatItems.addAll(tmpApplicationTraffics);
        }
    }

    public static <T> List<List<T>> a(Collection<T> collection, int maxSize, int splitSize) {
        if (CollectionUtils.isEmpty(collection)) {
            return Collections.emptyList();
        }
        return ((Stream)Stream.iterate(0, f2 -> f2 + 1).limit(maxSize).parallel()).map(a2 -> collection.parallelStream().skip((long)a2.intValue() * (long)splitSize).limit(splitSize).collect(Collectors.toList())).filter(b2 -> !b2.isEmpty()).collect(Collectors.toList());
    }

    public static <T> Map<T, TrafficDTO> a(List<Map<T, TrafficDTO>> trafficMapList) {
        HashMap<T, TrafficDTO> resultTrafficMap = new HashMap<T, TrafficDTO>();
        if (CollectionUtils.isEmpty(trafficMapList)) {
            return resultTrafficMap;
        }
        for (Map<T, TrafficDTO> subMap : trafficMapList) {
            if (CollectionUtils.isEmptyMap(subMap)) continue;
            for (Map.Entry<T, TrafficDTO> entry : subMap.entrySet()) {
                T key = entry.getKey();
                TrafficDTO value = entry.getValue();
                TrafficDTO oldValue = (TrafficDTO)resultTrafficMap.get(key);
                if (Objects.isNull(oldValue)) {
                    resultTrafficMap.put(key, value);
                    continue;
                }
                oldValue.merge(value);
            }
        }
        return resultTrafficMap;
    }

    public static Set<String> b(List<Set<String>> allSets) {
        HashSet<String> resultSet = new HashSet<String>();
        if (CollectionUtils.isEmpty(allSets)) {
            return resultSet;
        }
        for (Set<String> subSet : allSets) {
            if (CollectionUtils.isEmpty(subSet)) continue;
            resultSet.addAll(subSet);
        }
        return resultSet;
    }

    public static String a(String omadacId, String siteId) {
        return omadacId + a + siteId;
    }

    public static <T> T a(T value, T defaultValue) {
        return Objects.nonNull(value) ? value : defaultValue;
    }

    public static Long a(Long v1, Long v2) {
        long tempValue = 0L;
        if (Objects.nonNull(v1)) {
            tempValue += v1.longValue();
        }
        if (Objects.nonNull(v2)) {
            tempValue += v2.longValue();
        }
        return tempValue;
    }

    public static Integer a(Integer v1, Integer v2) {
        int tempValue = 0;
        if (Objects.nonNull(v1)) {
            tempValue += v1.intValue();
        }
        if (Objects.nonNull(v2)) {
            tempValue += v2.intValue();
        }
        return tempValue;
    }

    public static Long b(Long v1, Long v2) {
        if (Objects.isNull(v1)) {
            return v2;
        }
        if (Objects.isNull(v2)) {
            return v1;
        }
        return Math.max(v1, v2);
    }

    public static Integer c(Long molecule, Long denominator) {
        if (Objects.isNull(molecule) || Objects.isNull(denominator) || molecule == 0L) {
            return 0;
        }
        if (molecule >= denominator) {
            return 100;
        }
        double doubleResult = (double)molecule.longValue() * 1.0 / (double)denominator.longValue();
        return (int)Math.round(doubleResult * 100.0);
    }

    public static Map<Integer, TrafficDTO> a(Map<Integer, ApplicationDetailDTO> applicationDetailMap, Map<Integer, TrafficDTO> applicationTraffics) {
        HashMap<Integer, TrafficDTO> allCategoryTraffics = new HashMap<Integer, TrafficDTO>();
        for (Map.Entry<Integer, TrafficDTO> trafficDTOEntry : applicationTraffics.entrySet()) {
            Integer appId = trafficDTOEntry.getKey();
            ApplicationDetailDTO applicationDetailDTO = applicationDetailMap.get(appId);
            if (Objects.isNull(applicationDetailDTO)) continue;
            Integer familyId = applicationDetailDTO.getFamilyId();
            TrafficDTO trafficDTO = trafficDTOEntry.getValue();
            TrafficDTO categoryTrafficStat = allCategoryTraffics.computeIfAbsent(familyId, id -> TrafficDTO.buildDefault());
            categoryTrafficStat.addStat(trafficDTO.getUp(), trafficDTO.getDown(), trafficDTO.getUpPacket(), trafficDTO.getDownPacket());
        }
        return allCategoryTraffics;
    }

    public static ApplicationDetailVO a(Map<Integer, CategoryDetailDTO> categoryDetailMap, Map<Integer, TagDetailDTO> tagDetailMap, ApplicationDetailDTO dto) {
        if (Objects.isNull(dto)) {
            return null;
        }
        ApplicationDetailVO vo = new ApplicationDetailVO();
        vo.setApplicationId(dto.getApplicationId());
        vo.setApplicationName(dto.getApplicationName());
        vo.setDescription(dto.getDescription());
        vo.setFamily(com.tplink.smb.omada.client.dpi.api.internal.dto.cache.a.a(categoryDetailMap.get(dto.getFamilyId())));
        vo.setTagList(Optional.ofNullable(dto.getTags()).orElse(Collections.emptyList()).stream().map(tagId -> com.tplink.smb.omada.client.dpi.api.internal.dto.cache.a.a((TagDetailDTO)tagDetailMap.get(tagId))).filter(Objects::nonNull).collect(Collectors.toList()));
        return vo;
    }

    public static CategoryDetailVO a(CategoryDetailDTO dto) {
        if (Objects.isNull(dto)) {
            return null;
        }
        CategoryDetailVO vo = new CategoryDetailVO();
        vo.setFamilyId(dto.getFamilyId());
        vo.setFamilyName(dto.getFamilyName());
        vo.setDescription(dto.getDescription());
        return vo;
    }

    public static TagDetailVO a(TagDetailDTO dto) {
        if (Objects.isNull(dto)) {
            return null;
        }
        TagDetailVO vo = new TagDetailVO();
        vo.setTagId(dto.getTagId());
        vo.setTagName(dto.getTagName());
        vo.setDescription(dto.getDescription());
        return vo;
    }

    @Generated
    private a() {
    }
}

