/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.dpi.api.internal.dto;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.client.dpi.api.internal.dto.TrafficDTO;
import com.tplink.smb.omada.client.dpi.api.internal.dto.cache.a;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public class DpiClientStatDTO {
    private String id;
    private String omadacId;
    private String siteId;
    @PII(strategy=PIIMaskStrategy.HASH)
    private String ip;
    @PII(strategy=PIIMaskStrategy.ENCRYPT)
    @com.tplink.smb.omada.a.a
    private String mac;
    private String name;
    private String type;
    private Long time;
    private Long up;
    private Long down;
    private Long traffic;
    private Long upPacket;
    private Long downPacket;
    private Long totalPacket;
    private Map<Integer, TrafficDTO> applicationTraffics;
    private Map<Integer, TrafficDTO> categoryTraffics;
    private List<Map<Integer, TrafficDTO>> allApplicationTraffics;
    private List<Map<Integer, TrafficDTO>> allCategoryTraffics;

    public void mergeOtherWithSameClientMac(DpiClientStatDTO other) {
        if (Objects.isNull(other) || !Objects.equals(this.getMac(), other.getMac())) {
            return;
        }
        if (other.getTime() > this.getTime()) {
            this.name = other.getName();
            this.type = other.type;
            this.time = other.time;
            this.ip = other.ip;
        }
        this.setUp(a.a(this.getUp(), other.getUp()));
        this.setDown(a.a(this.getDown(), other.getDown()));
        this.setTraffic(a.a(this.getUp(), this.getDown()));
        this.setUpPacket(a.a(this.getUpPacket(), other.getUpPacket()));
        this.setDownPacket(a.a(this.getDownPacket(), other.getDownPacket()));
        this.setTotalPacket(a.a(this.getUpPacket(), this.getDownPacket()));
        ArrayList<Map<Integer, TrafficDTO>> mergedAllApplications = new ArrayList<Map<Integer, TrafficDTO>>();
        if (!CollectionUtils.isEmpty(this.allApplicationTraffics)) {
            mergedAllApplications.addAll(this.allApplicationTraffics);
        }
        if (!CollectionUtils.isEmpty(other.allApplicationTraffics)) {
            mergedAllApplications.addAll(other.allApplicationTraffics);
        }
        this.setAllApplicationTraffics(mergedAllApplications);
    }

    public void mergeAnotherOneNormally(DpiClientStatDTO other, boolean old) {
        if (Objects.isNull(other) || !Objects.equals(this.getMac(), other.getMac())) {
            return;
        }
        if (!old) {
            this.name = other.getName();
            this.type = other.type;
            this.time = other.time;
            this.ip = other.ip;
        }
        this.setUp(a.a(this.getUp(), other.getUp()));
        this.setDown(a.a(this.getDown(), other.getDown()));
        this.setTraffic(a.a(this.getTraffic(), other.getTraffic()));
        this.setUpPacket(a.a(this.getUpPacket(), other.getUpPacket()));
        this.setDownPacket(a.a(this.getDownPacket(), other.getDownPacket()));
        this.setTotalPacket(a.a(this.getTotalPacket(), other.getTotalPacket()));
        ArrayList mergedAllApplications = new ArrayList();
        if (!CollectionUtils.isEmptyMap(this.getApplicationTraffics())) {
            mergedAllApplications.add(this.getApplicationTraffics());
        }
        if (!CollectionUtils.isEmptyMap(other.getApplicationTraffics())) {
            mergedAllApplications.add(other.getApplicationTraffics());
        }
        this.setApplicationTraffics(a.a(mergedAllApplications));
        ArrayList mergedAllCategories = new ArrayList();
        if (!CollectionUtils.isEmptyMap(this.getCategoryTraffics())) {
            mergedAllCategories.add(this.getCategoryTraffics());
        }
        if (!CollectionUtils.isEmptyMap(other.getCategoryTraffics())) {
            mergedAllCategories.add(other.getCategoryTraffics());
        }
        this.setCategoryTraffics(a.a(mergedAllCategories));
    }

    public void initCounters() {
        this.up = 0L;
        this.down = 0L;
        this.traffic = 0L;
        this.downPacket = 0L;
        this.upPacket = 0L;
        this.totalPacket = 0L;
        this.applicationTraffics = new HashMap<Integer, TrafficDTO>();
        this.categoryTraffics = new HashMap<Integer, TrafficDTO>();
    }

    public void addStat(Integer familyId, Integer applicationId, Long up, Long down, Long upPacket, Long downPacket) {
        this.up = this.up + up;
        this.down = this.down + down;
        this.traffic = this.traffic + (up + down);
        this.upPacket = this.upPacket + upPacket;
        this.downPacket = this.downPacket + downPacket;
        this.totalPacket = this.totalPacket + (upPacket + downPacket);
        TrafficDTO applicationTrafficStat = this.applicationTraffics.computeIfAbsent(applicationId, id -> TrafficDTO.buildDefault());
        applicationTrafficStat.addStat(up, down, upPacket, downPacket);
    }

    public void updateInfo(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public static DpiClientStatDTO buildDefault(String omadacId, String siteId, Long time, String mac, String type, String ip) {
        DpiClientStatDTO dto = new DpiClientStatDTO();
        dto.setOmadacId(omadacId);
        dto.setSiteId(siteId);
        dto.setTime(time);
        dto.setMac(mac);
        dto.setType(type);
        dto.setIp(ip);
        dto.initCounters();
        return dto;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Long getTime() {
        return this.time;
    }

    @Generated
    public Long getUp() {
        return this.up;
    }

    @Generated
    public Long getDown() {
        return this.down;
    }

    @Generated
    public Long getTraffic() {
        return this.traffic;
    }

    @Generated
    public Long getUpPacket() {
        return this.upPacket;
    }

    @Generated
    public Long getDownPacket() {
        return this.downPacket;
    }

    @Generated
    public Long getTotalPacket() {
        return this.totalPacket;
    }

    @Generated
    public Map<Integer, TrafficDTO> getApplicationTraffics() {
        return this.applicationTraffics;
    }

    @Generated
    public Map<Integer, TrafficDTO> getCategoryTraffics() {
        return this.categoryTraffics;
    }

    @Generated
    public List<Map<Integer, TrafficDTO>> getAllApplicationTraffics() {
        return this.allApplicationTraffics;
    }

    @Generated
    public List<Map<Integer, TrafficDTO>> getAllCategoryTraffics() {
        return this.allCategoryTraffics;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setTime(Long time) {
        this.time = time;
    }

    @Generated
    public void setUp(Long up) {
        this.up = up;
    }

    @Generated
    public void setDown(Long down) {
        this.down = down;
    }

    @Generated
    public void setTraffic(Long traffic) {
        this.traffic = traffic;
    }

    @Generated
    public void setUpPacket(Long upPacket) {
        this.upPacket = upPacket;
    }

    @Generated
    public void setDownPacket(Long downPacket) {
        this.downPacket = downPacket;
    }

    @Generated
    public void setTotalPacket(Long totalPacket) {
        this.totalPacket = totalPacket;
    }

    @Generated
    public void setApplicationTraffics(Map<Integer, TrafficDTO> applicationTraffics) {
        this.applicationTraffics = applicationTraffics;
    }

    @Generated
    public void setCategoryTraffics(Map<Integer, TrafficDTO> categoryTraffics) {
        this.categoryTraffics = categoryTraffics;
    }

    @Generated
    public void setAllApplicationTraffics(List<Map<Integer, TrafficDTO>> allApplicationTraffics) {
        this.allApplicationTraffics = allApplicationTraffics;
    }

    @Generated
    public void setAllCategoryTraffics(List<Map<Integer, TrafficDTO>> allCategoryTraffics) {
        this.allCategoryTraffics = allCategoryTraffics;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DpiClientStatDTO)) {
            return false;
        }
        DpiClientStatDTO other = (DpiClientStatDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$time = this.getTime();
        Long other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        Long this$up = this.getUp();
        Long other$up = other.getUp();
        if (this$up == null ? other$up != null : !((Object)this$up).equals(other$up)) {
            return false;
        }
        Long this$down = this.getDown();
        Long other$down = other.getDown();
        if (this$down == null ? other$down != null : !((Object)this$down).equals(other$down)) {
            return false;
        }
        Long this$traffic = this.getTraffic();
        Long other$traffic = other.getTraffic();
        if (this$traffic == null ? other$traffic != null : !((Object)this$traffic).equals(other$traffic)) {
            return false;
        }
        Long this$upPacket = this.getUpPacket();
        Long other$upPacket = other.getUpPacket();
        if (this$upPacket == null ? other$upPacket != null : !((Object)this$upPacket).equals(other$upPacket)) {
            return false;
        }
        Long this$downPacket = this.getDownPacket();
        Long other$downPacket = other.getDownPacket();
        if (this$downPacket == null ? other$downPacket != null : !((Object)this$downPacket).equals(other$downPacket)) {
            return false;
        }
        Long this$totalPacket = this.getTotalPacket();
        Long other$totalPacket = other.getTotalPacket();
        if (this$totalPacket == null ? other$totalPacket != null : !((Object)this$totalPacket).equals(other$totalPacket)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$omadacId = this.getOmadacId();
        String other$omadacId = other.getOmadacId();
        if (this$omadacId == null ? other$omadacId != null : !this$omadacId.equals(other$omadacId)) {
            return false;
        }
        String this$siteId = this.getSiteId();
        String other$siteId = other.getSiteId();
        if (this$siteId == null ? other$siteId != null : !this$siteId.equals(other$siteId)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$mac = this.getMac();
        String other$mac = other.getMac();
        if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<Integer, TrafficDTO> this$applicationTraffics = this.getApplicationTraffics();
        Map<Integer, TrafficDTO> other$applicationTraffics = other.getApplicationTraffics();
        if (this$applicationTraffics == null ? other$applicationTraffics != null : !((Object)this$applicationTraffics).equals(other$applicationTraffics)) {
            return false;
        }
        Map<Integer, TrafficDTO> this$categoryTraffics = this.getCategoryTraffics();
        Map<Integer, TrafficDTO> other$categoryTraffics = other.getCategoryTraffics();
        if (this$categoryTraffics == null ? other$categoryTraffics != null : !((Object)this$categoryTraffics).equals(other$categoryTraffics)) {
            return false;
        }
        List<Map<Integer, TrafficDTO>> this$allApplicationTraffics = this.getAllApplicationTraffics();
        List<Map<Integer, TrafficDTO>> other$allApplicationTraffics = other.getAllApplicationTraffics();
        if (this$allApplicationTraffics == null ? other$allApplicationTraffics != null : !((Object)this$allApplicationTraffics).equals(other$allApplicationTraffics)) {
            return false;
        }
        List<Map<Integer, TrafficDTO>> this$allCategoryTraffics = this.getAllCategoryTraffics();
        List<Map<Integer, TrafficDTO>> other$allCategoryTraffics = other.getAllCategoryTraffics();
        return !(this$allCategoryTraffics == null ? other$allCategoryTraffics != null : !((Object)this$allCategoryTraffics).equals(other$allCategoryTraffics));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DpiClientStatDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        Long $up = this.getUp();
        result = result * 59 + ($up == null ? 43 : ((Object)$up).hashCode());
        Long $down = this.getDown();
        result = result * 59 + ($down == null ? 43 : ((Object)$down).hashCode());
        Long $traffic = this.getTraffic();
        result = result * 59 + ($traffic == null ? 43 : ((Object)$traffic).hashCode());
        Long $upPacket = this.getUpPacket();
        result = result * 59 + ($upPacket == null ? 43 : ((Object)$upPacket).hashCode());
        Long $downPacket = this.getDownPacket();
        result = result * 59 + ($downPacket == null ? 43 : ((Object)$downPacket).hashCode());
        Long $totalPacket = this.getTotalPacket();
        result = result * 59 + ($totalPacket == null ? 43 : ((Object)$totalPacket).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $omadacId = this.getOmadacId();
        result = result * 59 + ($omadacId == null ? 43 : $omadacId.hashCode());
        String $siteId = this.getSiteId();
        result = result * 59 + ($siteId == null ? 43 : $siteId.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Map<Integer, TrafficDTO> $applicationTraffics = this.getApplicationTraffics();
        result = result * 59 + ($applicationTraffics == null ? 43 : ((Object)$applicationTraffics).hashCode());
        Map<Integer, TrafficDTO> $categoryTraffics = this.getCategoryTraffics();
        result = result * 59 + ($categoryTraffics == null ? 43 : ((Object)$categoryTraffics).hashCode());
        List<Map<Integer, TrafficDTO>> $allApplicationTraffics = this.getAllApplicationTraffics();
        result = result * 59 + ($allApplicationTraffics == null ? 43 : ((Object)$allApplicationTraffics).hashCode());
        List<Map<Integer, TrafficDTO>> $allCategoryTraffics = this.getAllCategoryTraffics();
        result = result * 59 + ($allCategoryTraffics == null ? 43 : ((Object)$allCategoryTraffics).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DpiClientStatDTO(id=" + this.getId() + ", omadacId=" + this.getOmadacId() + ", siteId=" + this.getSiteId() + ", ip=" + this.getIp() + ", mac=" + this.getMac() + ", name=" + this.getName() + ", type=" + this.getType() + ", time=" + this.getTime() + ", up=" + this.getUp() + ", down=" + this.getDown() + ", traffic=" + this.getTraffic() + ", upPacket=" + this.getUpPacket() + ", downPacket=" + this.getDownPacket() + ", totalPacket=" + this.getTotalPacket() + ", applicationTraffics=" + this.getApplicationTraffics() + ", categoryTraffics=" + this.getCategoryTraffics() + ", allApplicationTraffics=" + this.getAllApplicationTraffics() + ", allCategoryTraffics=" + this.getAllCategoryTraffics() + ")";
    }

    @Generated
    public DpiClientStatDTO() {
    }
}

