/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.client.dpi.api.internal.dto;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.client.dpi.api.internal.dto.TrafficDTO;
import com.tplink.smb.omada.client.dpi.api.internal.dto.cache.a;
import com.tplink.smb.omada.common.util.g;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

public class DpiApplicationStatDTO {
    private String id;
    private String omadacId;
    private String siteId;
    private String name;
    private Integer applicationId;
    private String familyName;
    private Integer familyId;
    private Long time;
    private Long up;
    private Long down;
    private Long traffic;
    private Long upPacket;
    private Long downPacket;
    private Long totalPacket;
    private Long block;
    private Map<String, TrafficDTO> clientTraffics;
    private Set<String> clients;
    private List<Set<String>> allClients;
    private List<Map<String, TrafficDTO>> allClientTraffics;

    public void mergeOtherWithSameApplicationId(DpiApplicationStatDTO other) {
        if (Objects.isNull(other) || !Objects.equals(this.applicationId, other.applicationId)) {
            return;
        }
        if (other.getTime() > this.getTime()) {
            this.name = other.getName();
            this.familyId = other.familyId;
            this.familyName = other.familyName;
            this.time = other.time;
        }
        this.setUp(a.a(this.getUp(), other.getUp()));
        this.setDown(a.a(this.getDown(), other.getDown()));
        this.setTraffic(a.a(this.getTraffic(), other.getTraffic()));
        this.setUpPacket(a.a(this.getUpPacket(), other.getUpPacket()));
        this.setDownPacket(a.a(this.getDownPacket(), other.getDownPacket()));
        this.setTotalPacket(a.a(this.getTotalPacket(), other.getTotalPacket()));
        this.setBlock(a.a(this.getBlock(), other.getBlock()));
        HashSet<String> macs = new HashSet<String>();
        if (!CollectionUtils.isEmpty(this.allClients)) {
            for (Set<String> subList : this.allClients) {
                macs.addAll(subList);
            }
        }
        if (!CollectionUtils.isEmpty(other.getAllClients())) {
            for (Set<String> subList : other.allClients) {
                macs.addAll(subList);
            }
        }
        this.allClients = Collections.singletonList(macs);
        ArrayList<Map<String, TrafficDTO>> mergedAllClientTraffics = new ArrayList<Map<String, TrafficDTO>>();
        if (!CollectionUtils.isEmpty(this.allClientTraffics)) {
            mergedAllClientTraffics.addAll(this.allClientTraffics);
        }
        if (!CollectionUtils.isEmpty(other.allClientTraffics)) {
            mergedAllClientTraffics.addAll(other.allClientTraffics);
        }
        this.setAllClientTraffics(mergedAllClientTraffics);
    }

    public void mergeAnotherOneNormally(DpiApplicationStatDTO other, boolean old) {
        if (Objects.isNull(other) || !Objects.equals(this.applicationId, other.applicationId)) {
            return;
        }
        if (!old) {
            this.name = other.getName();
            this.familyId = other.familyId;
            this.familyName = other.familyName;
            this.time = other.time;
        }
        this.setUp(a.a(this.getUp(), other.getUp()));
        this.setDown(a.a(this.getDown(), other.getDown()));
        this.setTraffic(a.a(this.getTraffic(), other.getTraffic()));
        this.setUpPacket(a.a(this.getUpPacket(), other.getUpPacket()));
        this.setDownPacket(a.a(this.getDownPacket(), other.getDownPacket()));
        this.setTotalPacket(a.a(this.getTotalPacket(), other.getTotalPacket()));
        this.setBlock(a.a(this.getBlock(), other.getBlock()));
        HashSet<String> macs = new HashSet<String>();
        if (!CollectionUtils.isEmpty(this.getClients())) {
            macs.addAll(this.getClients());
        }
        if (!CollectionUtils.isEmpty(other.getClients())) {
            macs.addAll(other.getClients());
        }
        this.setClients(macs);
        ArrayList mergedAllClientTraffics = new ArrayList();
        if (!CollectionUtils.isEmptyMap(this.getClientTraffics())) {
            mergedAllClientTraffics.add(this.getClientTraffics());
        }
        if (!CollectionUtils.isEmptyMap(other.getClientTraffics())) {
            mergedAllClientTraffics.add(other.getClientTraffics());
        }
        this.setClientTraffics(a.a(mergedAllClientTraffics));
    }

    public void initCounters() {
        this.up = 0L;
        this.down = 0L;
        this.traffic = 0L;
        this.downPacket = 0L;
        this.upPacket = 0L;
        this.totalPacket = 0L;
        this.block = 0L;
        this.clients = new HashSet<String>();
        this.clientTraffics = new HashMap<String, TrafficDTO>();
    }

    public void addTrafficStat(String clientMac, Long up, Long down, Long upPacket, Long downPacket) {
        this.up = this.up + up;
        this.down = this.down + down;
        this.traffic = this.traffic + (up + down);
        this.upPacket = this.upPacket + upPacket;
        this.downPacket = this.downPacket + downPacket;
        this.totalPacket = this.totalPacket + (upPacket + downPacket);
        if (!g.c()) {
            TrafficDTO clientTrafficStat = this.clientTraffics.computeIfAbsent(clientMac, id -> TrafficDTO.buildDefaultWithMac(clientMac));
            clientTrafficStat.addStat(up, down, upPacket, downPacket);
        }
    }

    public void addBlockStat(Integer block) {
        this.block = this.block + (long)block.intValue();
    }

    public static DpiApplicationStatDTO buildDefault(String omadacId, String siteId, Long time, Integer applicationId, Integer familyId) {
        DpiApplicationStatDTO dto = new DpiApplicationStatDTO();
        dto.setOmadacId(omadacId);
        dto.setSiteId(siteId);
        dto.setTime(time);
        dto.setApplicationId(applicationId);
        dto.setFamilyId(familyId);
        dto.initCounters();
        return dto;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getOmadacId() {
        return this.omadacId;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getApplicationId() {
        return this.applicationId;
    }

    @Generated
    public String getFamilyName() {
        return this.familyName;
    }

    @Generated
    public Integer getFamilyId() {
        return this.familyId;
    }

    @Generated
    public Long getTime() {
        return this.time;
    }

    @Generated
    public Long getUp() {
        return this.up;
    }

    @Generated
    public Long getDown() {
        return this.down;
    }

    @Generated
    public Long getTraffic() {
        return this.traffic;
    }

    @Generated
    public Long getUpPacket() {
        return this.upPacket;
    }

    @Generated
    public Long getDownPacket() {
        return this.downPacket;
    }

    @Generated
    public Long getTotalPacket() {
        return this.totalPacket;
    }

    @Generated
    public Long getBlock() {
        return this.block;
    }

    @Generated
    public Map<String, TrafficDTO> getClientTraffics() {
        return this.clientTraffics;
    }

    @Generated
    public Set<String> getClients() {
        return this.clients;
    }

    @Generated
    public List<Set<String>> getAllClients() {
        return this.allClients;
    }

    @Generated
    public List<Map<String, TrafficDTO>> getAllClientTraffics() {
        return this.allClientTraffics;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setOmadacId(String omadacId) {
        this.omadacId = omadacId;
    }

    @Generated
    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setApplicationId(Integer applicationId) {
        this.applicationId = applicationId;
    }

    @Generated
    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    @Generated
    public void setFamilyId(Integer familyId) {
        this.familyId = familyId;
    }

    @Generated
    public void setTime(Long time) {
        this.time = time;
    }

    @Generated
    public void setUp(Long up) {
        this.up = up;
    }

    @Generated
    public void setDown(Long down) {
        this.down = down;
    }

    @Generated
    public void setTraffic(Long traffic) {
        this.traffic = traffic;
    }

    @Generated
    public void setUpPacket(Long upPacket) {
        this.upPacket = upPacket;
    }

    @Generated
    public void setDownPacket(Long downPacket) {
        this.downPacket = downPacket;
    }

    @Generated
    public void setTotalPacket(Long totalPacket) {
        this.totalPacket = totalPacket;
    }

    @Generated
    public void setBlock(Long block) {
        this.block = block;
    }

    @Generated
    public void setClientTraffics(Map<String, TrafficDTO> clientTraffics) {
        this.clientTraffics = clientTraffics;
    }

    @Generated
    public void setClients(Set<String> clients) {
        this.clients = clients;
    }

    @Generated
    public void setAllClients(List<Set<String>> allClients) {
        this.allClients = allClients;
    }

    @Generated
    public void setAllClientTraffics(List<Map<String, TrafficDTO>> allClientTraffics) {
        this.allClientTraffics = allClientTraffics;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DpiApplicationStatDTO)) {
            return false;
        }
        DpiApplicationStatDTO other = (DpiApplicationStatDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$applicationId = this.getApplicationId();
        Integer other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !((Object)this$applicationId).equals(other$applicationId)) {
            return false;
        }
        Integer this$familyId = this.getFamilyId();
        Integer other$familyId = other.getFamilyId();
        if (this$familyId == null ? other$familyId != null : !((Object)this$familyId).equals(other$familyId)) {
            return false;
        }
        Long this$time = this.getTime();
        Long other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        Long this$up = this.getUp();
        Long other$up = other.getUp();
        if (this$up == null ? other$up != null : !((Object)this$up).equals(other$up)) {
            return false;
        }
        Long this$down = this.getDown();
        Long other$down = other.getDown();
        if (this$down == null ? other$down != null : !((Object)this$down).equals(other$down)) {
            return false;
        }
        Long this$traffic = this.getTraffic();
        Long other$traffic = other.getTraffic();
        if (this$traffic == null ? other$traffic != null : !((Object)this$traffic).equals(other$traffic)) {
            return false;
        }
        Long this$upPacket = this.getUpPacket();
        Long other$upPacket = other.getUpPacket();
        if (this$upPacket == null ? other$upPacket != null : !((Object)this$upPacket).equals(other$upPacket)) {
            return false;
        }
        Long this$downPacket = this.getDownPacket();
        Long other$downPacket = other.getDownPacket();
        if (this$downPacket == null ? other$downPacket != null : !((Object)this$downPacket).equals(other$downPacket)) {
            return false;
        }
        Long this$totalPacket = this.getTotalPacket();
        Long other$totalPacket = other.getTotalPacket();
        if (this$totalPacket == null ? other$totalPacket != null : !((Object)this$totalPacket).equals(other$totalPacket)) {
            return false;
        }
        Long this$block = this.getBlock();
        Long other$block = other.getBlock();
        if (this$block == null ? other$block != null : !((Object)this$block).equals(other$block)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$omadacId = this.getOmadacId();
        String other$omadacId = other.getOmadacId();
        if (this$omadacId == null ? other$omadacId != null : !this$omadacId.equals(other$omadacId)) {
            return false;
        }
        String this$siteId = this.getSiteId();
        String other$siteId = other.getSiteId();
        if (this$siteId == null ? other$siteId != null : !this$siteId.equals(other$siteId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$familyName = this.getFamilyName();
        String other$familyName = other.getFamilyName();
        if (this$familyName == null ? other$familyName != null : !this$familyName.equals(other$familyName)) {
            return false;
        }
        Map<String, TrafficDTO> this$clientTraffics = this.getClientTraffics();
        Map<String, TrafficDTO> other$clientTraffics = other.getClientTraffics();
        if (this$clientTraffics == null ? other$clientTraffics != null : !((Object)this$clientTraffics).equals(other$clientTraffics)) {
            return false;
        }
        Set<String> this$clients = this.getClients();
        Set<String> other$clients = other.getClients();
        if (this$clients == null ? other$clients != null : !((Object)this$clients).equals(other$clients)) {
            return false;
        }
        List<Set<String>> this$allClients = this.getAllClients();
        List<Set<String>> other$allClients = other.getAllClients();
        if (this$allClients == null ? other$allClients != null : !((Object)this$allClients).equals(other$allClients)) {
            return false;
        }
        List<Map<String, TrafficDTO>> this$allClientTraffics = this.getAllClientTraffics();
        List<Map<String, TrafficDTO>> other$allClientTraffics = other.getAllClientTraffics();
        return !(this$allClientTraffics == null ? other$allClientTraffics != null : !((Object)this$allClientTraffics).equals(other$allClientTraffics));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DpiApplicationStatDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : ((Object)$applicationId).hashCode());
        Integer $familyId = this.getFamilyId();
        result = result * 59 + ($familyId == null ? 43 : ((Object)$familyId).hashCode());
        Long $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        Long $up = this.getUp();
        result = result * 59 + ($up == null ? 43 : ((Object)$up).hashCode());
        Long $down = this.getDown();
        result = result * 59 + ($down == null ? 43 : ((Object)$down).hashCode());
        Long $traffic = this.getTraffic();
        result = result * 59 + ($traffic == null ? 43 : ((Object)$traffic).hashCode());
        Long $upPacket = this.getUpPacket();
        result = result * 59 + ($upPacket == null ? 43 : ((Object)$upPacket).hashCode());
        Long $downPacket = this.getDownPacket();
        result = result * 59 + ($downPacket == null ? 43 : ((Object)$downPacket).hashCode());
        Long $totalPacket = this.getTotalPacket();
        result = result * 59 + ($totalPacket == null ? 43 : ((Object)$totalPacket).hashCode());
        Long $block = this.getBlock();
        result = result * 59 + ($block == null ? 43 : ((Object)$block).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $omadacId = this.getOmadacId();
        result = result * 59 + ($omadacId == null ? 43 : $omadacId.hashCode());
        String $siteId = this.getSiteId();
        result = result * 59 + ($siteId == null ? 43 : $siteId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $familyName = this.getFamilyName();
        result = result * 59 + ($familyName == null ? 43 : $familyName.hashCode());
        Map<String, TrafficDTO> $clientTraffics = this.getClientTraffics();
        result = result * 59 + ($clientTraffics == null ? 43 : ((Object)$clientTraffics).hashCode());
        Set<String> $clients = this.getClients();
        result = result * 59 + ($clients == null ? 43 : ((Object)$clients).hashCode());
        List<Set<String>> $allClients = this.getAllClients();
        result = result * 59 + ($allClients == null ? 43 : ((Object)$allClients).hashCode());
        List<Map<String, TrafficDTO>> $allClientTraffics = this.getAllClientTraffics();
        result = result * 59 + ($allClientTraffics == null ? 43 : ((Object)$allClientTraffics).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DpiApplicationStatDTO(id=" + this.getId() + ", omadacId=" + this.getOmadacId() + ", siteId=" + this.getSiteId() + ", name=" + this.getName() + ", applicationId=" + this.getApplicationId() + ", familyName=" + this.getFamilyName() + ", familyId=" + this.getFamilyId() + ", time=" + this.getTime() + ", up=" + this.getUp() + ", down=" + this.getDown() + ", traffic=" + this.getTraffic() + ", upPacket=" + this.getUpPacket() + ", downPacket=" + this.getDownPacket() + ", totalPacket=" + this.getTotalPacket() + ", block=" + this.getBlock() + ", clientTraffics=" + this.getClientTraffics() + ", clients=" + this.getClients() + ", allClients=" + this.getAllClients() + ", allClientTraffics=" + this.getAllClientTraffics() + ")";
    }

    @Generated
    public DpiApplicationStatDTO() {
    }
}

